--// migracja przerobka bazy BAZYL.
-- Migration SQL that makes the change goes here.

DROP TABLE IF EXISTS DAWKA_LEK;
DROP TABLE IF EXISTS LEK;
DROP TABLE IF EXISTS LEK_POSTAC;
DROP TABLE IF EXISTS RECEPTA_LEK;
DROP TABLE IF EXISTS LEK_REALIZACJA;

DROP INDEX IF EXISTS MG_LEK_UNIKALNY_KOD_BAZYL;
DROP INDEX IF EXISTS LK_LEK_UNIKALNY_KOD_BAZYL;
DROP INDEX IF EXISTS LK_NAZWA_LEKU;
DROP INDEX IF EXISTS LK_OPAKOWANIE_LEKU;
DROP INDEX IF EXISTS LK_OPAKOWANIE_LEKU_BAZYL;

DROP VIEW IF EXISTS REALIZACJA_UMOW_APTEKA;
DROP VIEW IF EXISTS RECEPTY_NIEZREALIZOWANE;

CREATE TABLE LEK (
    ID IDENTITY NOT NULL,
    NAZWA VARCHAR(120) NOT NULL,
    OPAKOWANIE_JEDNOSTKA_POJEMNOSCI VARCHAR(50) NOT NULL,
    POSTAC VARCHAR(32) NOT NULL,
    CONSTRAINT LEK_pk PRIMARY KEY (ID)
);

CREATE TABLE DAWKA_LEK (
    DAWKOWANIE_ID BIGINT(10) NOT NULL,
    PORA_ID BIGINT(10) NOT NULL,
    LEK_ID BIGINT(10) NOT NULL,
    CZY_RECEPTA BOOLEAN,
    DAWKA DECIMAL(10,2),
    CONSTRAINT DAWKA_LEK_pk PRIMARY KEY (DAWKOWANIE_ID, PORA_ID, LEK_ID)
);

CREATE TABLE LEK_POSTAC (
    KOD_BAZYL BIGINT(10) NOT NULL,
    LEK_ID BIGINT(10) NOT NULL,
    DAWKA VARCHAR(42),
    OPAKOWANIE_ILOSC DECIMAL(10,2) NOT NULL,
    OPAKOWANIE_OPIS_BAZYL VARCHAR(42) NOT NULL,
    CONSTRAINT LEK_POSTAC_pk PRIMARY KEY (KOD_BAZYL)
);

CREATE TABLE LEK_REALIZACJA (
    REALIZACJA_RECEPTA_ID BIGINT(10) NOT NULL,
    KOD_BAZYL BIGINT(10) NOT NULL,
    LICZBA_OPAKOWAN INTEGER NOT NULL,
    CONSTRAINT LEK_REALIZACJA_pk PRIMARY KEY (REALIZACJA_RECEPTA_ID, KOD_BAZYL)
);

CREATE TABLE RECEPTA_LEK (
    RECEPTA_ID BIGINT(10) NOT NULL,
    LEK_ID BIGINT(10) NOT NULL,
    CONSTRAINT RECEPTA_LEK_pk PRIMARY KEY (RECEPTA_ID, LEK_ID)
);

ALTER TABLE DAWKA_LEK ADD CONSTRAINT PORA_DNIA_DAWKA_LEK_fk
FOREIGN KEY (PORA_ID)
REFERENCES PORA_DNIA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE DAWKA_LEK ADD CONSTRAINT DAWKOWANIE_DAWKA_LEK_fk
FOREIGN KEY (DAWKOWANIE_ID)
REFERENCES DAWKOWANIE (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE RECEPTA_LEK ADD CONSTRAINT RECEPTA_RECEPTA_LEK_fk
FOREIGN KEY (RECEPTA_ID)
REFERENCES RECEPTA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE RECEPTA_LEK ADD CONSTRAINT LEK_RECEPTA_LEK_fk
FOREIGN KEY (LEK_ID)
REFERENCES LEK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE LEK_REALIZACJA ADD CONSTRAINT REALIZACJA_RECEPTA_LEK_REALIZACJA_fk
FOREIGN KEY (REALIZACJA_RECEPTA_ID)
REFERENCES REALIZACJA_RECEPTA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE LEK_REALIZACJA ADD CONSTRAINT LEK_POSTAC_LEK_REALIZACJA_fk
FOREIGN KEY (KOD_BAZYL)
REFERENCES LEK_POSTAC (KOD_BAZYL)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE LEK_POSTAC ADD CONSTRAINT LEK_LEK_POSTAC_fk
FOREIGN KEY (LEK_ID)
REFERENCES LEK (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE DAWKA_LEK ADD CONSTRAINT LEK_DAWKA_LEK_fk
FOREIGN KEY (LEK_ID)
REFERENCES LEK (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE UNIQUE INDEX LK_LEK_UNIKALNY_KOD_BAZYL
    ON LEK_POSTAC (KOD_BAZYL);
    
CREATE UNIQUE INDEX LK_NAZWA_LEKU
  ON LEK(NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC);

CREATE INDEX LK_OPAKOWANIE_LEKU
  ON LEK_POSTAC(OPAKOWANIE_ILOSC);
  
CREATE INDEX LK_OPAKOWANIE_LEKU_BAZYL
  ON LEK_POSTAC(OPAKOWANIE_OPIS_BAZYL);
  
CREATE VIEW REALIZACJA_UMOW_APTEKA AS
	SELECT ua.*, COALESCE(SUM(r.KWOTA), '0.00') as KWOTA_WYKORZYSTANA
	FROM UMOWA_APTEKA ua
		LEFT OUTER JOIN REALIZACJA_RECEPTA r ON ua.ID = r.UMOWA_ID
	GROUP BY ua.ID;

CREATE VIEW RECEPTY_NIEZREALIZOWANE AS
	SELECT ewDps.OSOBA_ID, r.*
	FROM RECEPTA r
		JOIN EWIDENCJA_DPS ewDps ON r.EWIDENCJA_DPS_ID = ewDps.ID
		LEFT OUTER JOIN REALIZACJA_RECEPTA real ON r.ID = real.RECEPTA_ID
	WHERE
		real.ID IS NULL;

--//@UNDO
-- SQL to undo the change goes here.

