--// raporty na podstawie informacji dodatkowej.
-- Migration SQL that makes the change goes here.

ALTER TABLE INFORMACJA_DODATKOWA ADD TYP VARCHAR(50);

ALTER TABLE INFORMACJA_DODATKOWA_POLE ADD JEDNOSTKA_MIARY VARCHAR(50);

-- poprawki w triggerach
DELETE FROM QRTZ_TRIGGERS WHERE JOB_NAME = 'WypisywanieReceptNaLekiMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
DELETE FROM QRTZ_JOB_LISTENERS WHERE JOB_NAME = 'WypisywanieReceptNaLekiMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';
DELETE FROM QRTZ_JOB_DETAILS WHERE JOB_NAME = 'WypisywanieReceptNaLekiMieszkaniec' AND JOB_GROUP = 'PRZYPOMINACZE';

INSERT INTO QRTZ_JOB_DETAILS(JOB_NAME, JOB_GROUP, DESCRIPTION,
    JOB_CLASS_NAME, IS_DURABLE, IS_VOLATILE, IS_STATEFUL, REQUESTS_RECOVERY, JOB_DATA, HIDDEN)
  VALUES('WypisywanieReceptNaLekiMieszkaniec', 'PRZYPOMINACZE', 'Aktualizuje dane nt. zbliżającego się terminu końca leków (wydawanych na recepty) w magazynie dla mieszkańca',
    'pl.topteam.dps.timeTask.przypominacze.WypisanieReceptNaLekiMieszkaniec', 'FALSE', 'FALSE', 'FALSE', 'FALSE', '', true);
INSERT INTO QRTZ_JOB_LISTENERS(JOB_NAME, JOB_GROUP, JOB_LISTENER)
  VALUES ('WypisywanieReceptNaLekiMieszkaniec', 'PRZYPOMINACZE', 'pl.topteam.dps.timeTask.listener.TemporaryTableListener');

 -- przenoszenie danych z OSOBA_INFORMACJA_DODATKOWA do INFORMACJA_DODATKOWA_WPIS
ALTER TABLE OSOBA_INFORMACJA_DODATKOWA RENAME TO INFORMACJA_DODATKOWA_WPIS;
CREATE TABLE OSOBA_INFORMACJA_DODATKOWA (
    INFORMACJA_DODATKOWA_WPIS_ID BIGINT(10) NOT NULL,
    EWIDENCJA_ID BIGINT(10),
    OSOBA_ID BIGINT(10),
    CONSTRAINT OSOBA_INFORMACJA_DODATKOWA_pk PRIMARY KEY (INFORMACJA_DODATKOWA_WPIS_ID)
);
ALTER TABLE INFORMACJA_DODATKOWA_WPIS DROP CONSTRAINT IF EXISTS EWIDENCJA_DPS_OSOBA_INFORMACJA_DODATKOWA_fk;
ALTER TABLE OSOBA_INFORMACJA_DODATKOWA ADD CONSTRAINT EWIDENCJA_DPS_OSOBA_INFORMACJA_DODATKOWA_fk
	FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE OSOBA_INFORMACJA_DODATKOWA DROP CONSTRAINT IF EXISTS INFORMACJA_DODATKOWA_WPIS_OSOBA_INFORMACJA_DODATKOWA_fk;
ALTER TABLE OSOBA_INFORMACJA_DODATKOWA ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_OSOBA_INFORMACJA_DODATKOWA_fk
	FOREIGN KEY (INFORMACJA_DODATKOWA_WPIS_ID)
	REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
INSERT INTO OSOBA_INFORMACJA_DODATKOWA (INFORMACJA_DODATKOWA_WPIS_ID, EWIDENCJA_ID)
	SELECT ID, EWIDENCJA_ID FROM INFORMACJA_DODATKOWA_WPIS;
ALTER TABLE INFORMACJA_DODATKOWA_WPIS DROP COLUMN EWIDENCJA_ID;
ALTER TABLE INFORMACJA_DODATKOWA_POLE_WPIS ALTER OSOBA_INFORMACJA_ID RENAME TO INFORMACJA_WPIS_ID;
ALTER TABLE INFORMACJA_DODATKOWA_POLE_WPIS DROP CONSTRAINT IF EXISTS OSOBA_INFORMACJA_DODATKOWA_INFORMACJA_DODATKOWA_POLE_WPIS_fk;
ALTER TABLE INFORMACJA_DODATKOWA_POLE_WPIS ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_INFORMACJA_DODATKOWA_POLE_WPIS_fk
	FOREIGN KEY (INFORMACJA_WPIS_ID)
	REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;
ALTER TABLE OSOBA_INFORMACJA_DODATKOWA ADD CONSTRAINT OSOBA_OSOBA_INFORMACJA_DODATKOWA_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
DROP TRIGGER IF EXISTS AINS_OSOBA_INFORMACJA_DODATKOWA;
DROP TRIGGER IF EXISTS ADEL_OSOBA_INFORMACJA_DODATKOWA;
CREATE TRIGGER AINS_INFORMACJA_DODATKOWA_WPIS AFTER INSERT ON INFORMACJA_DODATKOWA_WPIS FOR EACH ROW CALL "org.h2.trigger.AfterInformacjaWpisInsert";
CREATE TRIGGER ADEL_INFORMACJA_DODATKOWA_WPIS AFTER DELETE ON INFORMACJA_DODATKOWA_WPIS FOR EACH ROW CALL "org.h2.trigger.AfterInformacjaWpisDelete";


-- POMIAR GLIKEMII
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
VALUES ('__pomiar_z_glikemii', 'DEFINICJA_ZABLOKOWANA', FALSE, 'POMIAR_GLIKEMII');
	-- data pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_GLIKEMII' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- wynik pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_GLIKEMII' LIMIT 1),
	'MILIGRAM_DECYLITR', 2, 'wynik', 'LICZBA_D', TRUE, null);
	
-- POMIAR ALKOMATEM
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
VALUES ('__pomiar_alkomatem', 'DEFINICJA_ZABLOKOWANA', FALSE, 'POMIAR_ALKOMATEM');
	-- data pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- wynik pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1),
	'PROMIL', 2, 'wynik', 'LICZBA_D', TRUE, null);
	-- uwagi
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_ALKOMATEM' LIMIT 1),
	null, 3, 'uwagi', 'TEKST_DLUGI', FALSE, null);

-- POBRANIE KRWI
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
VALUES ('__pobranie_krwi', 'DEFINICJA_ZABLOKOWANA', FALSE, 'POBRANIE_KRWI');
	-- data pobrania
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POBRANIE_KRWI' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);

-- POMIAR TEMPERATURY CIAŁA
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
VALUES ('__pomiar_temperatory_ciala', 'DEFINICJA_ZABLOKOWANA', FALSE, 'POMIAR_TEMPERATURY');
	-- data pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- godzina pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1),
	null, 2, 'godzina', 'LICZBA_I', TRUE, null);
	-- wynik pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_TEMPERATURY' LIMIT 1),
	'STOPIEN_CELSJUSZA', 3, 'wynik', 'LICZBA_D', TRUE, null);

-- POMIAR CIŚNIENIA TĘTNICZEGO
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
VALUES ('__pomiar_cisnienia_t', 'DEFINICJA_ZABLOKOWANA', FALSE, 'POMIAR_CISNIENIA');
	-- data pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- godzina pomiaru
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1),
	null, 2, 'godzina', 'LICZBA_I', TRUE, null);
	-- ciśnienie skurczowe
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1),
	'MILIMETR_HG', 3, 'skruczowe', 'LICZBA_I', TRUE, null);
	-- ciśnienie rozkurczowe
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'POMIAR_CISNIENIA' LIMIT 1),
	'MILIMETR_HG', 4, 'rozkruczowe', 'LICZBA_I', TRUE, null);

-- INTERWENCJA ORGANÓW ŚCIGANIA
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_ORGANU_SCIGANIA');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES (
	(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_ORGANU_SCIGANIA' LIMIT 1), 1, 'policja', '001');
INSERT INTO SLOWO (SLOWNIK_ID, KOLEJNOSC, WART_STRING, KOD) VALUES (
	(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_ORGANU_SCIGANIA' LIMIT 1), 1, 'straż miejska', '002');
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
	VALUES ('__interwencja_org_scigania', 'DEFINICJA_ZABLOKOWANA', FALSE, 'INTERWENCJA_ORG_SCIGANIA');
	-- data interwencji
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_ORG_SCIGANIA' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- organ ścigania
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_ORG_SCIGANIA' LIMIT 1),
	null, 2, STRINGDECODE('organ \u015Bcigania'), 'SLOWNIK', TRUE, 'KOD_ORGANU_SCIGANIA');

-- INTERWENCJA POGOTOWIA RATUNKOWEGO
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
	VALUES ('__interwencja_pr', 'DEFINICJA_ZABLOKOWANA', FALSE, 'INTERWENCJA_POG_RAT');
	-- data interwencji
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- godzina
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1),
	null, 2, 'godzina', 'LICZBA_I', FALSE, null);
	-- opis
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'INTERWENCJA_POG_RAT' LIMIT 1),
	null, 3, 'opis', 'TEKST_DLUGI', FALSE, null);

-- CZAS PRACY LAMPY UV
INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
	VALUES ('__czas_pracy_lampy_uv', 'DEFINICJA_ZABLOKOWANA', FALSE, 'CZAS_PRACY_LAMPY_UV');
	-- data
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1),
	null, 1, 'data', 'DATA', TRUE, null);
	-- minuty
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1),
	null, 2, 'minuty', 'LICZBA_I', TRUE, null);
	-- oznaczenie lampy
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1),
	null, 3, 'lampa (ozn.)', 'TEKST_KROTKI', FALSE, null);
	-- opis
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
	JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'CZAS_PRACY_LAMPY_UV' LIMIT 1),
	null, 4, 'opis', 'TEKST_DLUGI', FALSE, null);


--//@UNDO
-- SQL to undo the change goes here.

