--// rozliczanie odplatnosci.
-- Migration SQL that makes the change goes here.


-- poprawka w widoku decyzji o odpłatności
DROP VIEW IF EXISTS AKTUALNE_DECYZJE_ALIMENTACYJNE_ODPLATNOSCI;
CREATE VIEW AKTUALNE_DECYZJE_ALIMENTACYJNE_ODPLATNOSCI AS
	SELECT odpl.*
	FROM DECYZJA_O_ODPLATNOSCI odpl
		LEFT OUTER JOIN DECYZJA_O_ODPLATNOSCI tmpDec ON odpl.MIESZKANIEC_ID = tmpDec.MIESZKANIEC_ID
			AND (
				odpl.CZLONEK_RODZ_ID = tmpDec.CZLONEK_RODZ_ID
				OR
				(odpl.CZLONEK_RODZ_ID IS NULL AND tmpDec.CZLONEK_RODZ_ID IS NULL)
			)
			AND coalesce(odpl.OBOWIAZUJE_OD, odpl.DATA_WYDANIA) < coalesce(tmpDec.OBOWIAZUJE_OD, tmpDec.DATA_WYDANIA)
	WHERE
		tmpDec.ID IS NULL;

ALTER TABLE INSTYTUCJA_DOPLACAJACA ADD EMERYTALNO_RENTOWA BOOLEAN;

ALTER TABLE ODPLATNOSC ADD STATUS VARCHAR(50);
UPDATE ODPLATNOSC SET STATUS = 'NOWA' WHERE STATUS IS NULL;
ALTER TABLE ODPLATNOSC ALTER STATUS SET NOT NULL;

CREATE TABLE WPLATA (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    MIESZKANIEC_ID BIGINT(10) NOT NULL,
    OSOBA_ID BIGINT(10),
    DATA_WPLATY DATE NOT NULL,
    KWOTA DECIMAL(10,2) NOT NULL,
    MIESIAC INTEGER NOT NULL,
    ROK INTEGER NOT NULL,
    CONSTRAINT WPLATA_pk PRIMARY KEY (ID)
);

CREATE TABLE PLATNOSC (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10) NOT NULL,
    DATA_OBLICZENIA DATE NOT NULL,
    MIESIAC INTEGER NOT NULL,
    ROK INTEGER NOT NULL,
    CONSTRAINT PLATNOSC_pk PRIMARY KEY (ID)
);

CREATE TABLE PLATNOSC_SKLADNIK (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    PLATNOSC_ID BIGINT(10) NOT NULL,
    OSOBA_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    CONSTRAINT PLATNOSC_SKLADNIK_pk PRIMARY KEY (ID)
);

CREATE TABLE PLATNOSC_PODSTAWA (
    PLATNOSC_ID BIGINT(10) NOT NULL,
    ODPLATNOSC_ID BIGINT(10) NOT NULL,
    CONSTRAINT PLATNOSC_PODSTAWA_pk PRIMARY KEY (PLATNOSC_ID, ODPLATNOSC_ID)
);

ALTER TABLE PLATNOSC_SKLADNIK ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_PLATNOSC_SKLADNIK_fk
FOREIGN KEY (INSTYTUCJA_ID)
REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE WPLATA ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_WPLATA_fk
FOREIGN KEY (INSTYTUCJA_ID)
REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE PLATNOSC_SKLADNIK ADD CONSTRAINT OSOBA_PLATNOSC_OSOBA_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE PLATNOSC ADD CONSTRAINT OSOBA_PLATNOSC_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE WPLATA ADD CONSTRAINT OSOBA_WPLATA_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE WPLATA ADD CONSTRAINT MIESZKANIEC_WPLATA_fk
FOREIGN KEY (MIESZKANIEC_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE PLATNOSC_PODSTAWA ADD CONSTRAINT PLATNOSC_PLATNOSC_PODSTAWA_fk
FOREIGN KEY (PLATNOSC_ID)
REFERENCES PLATNOSC (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE PLATNOSC_SKLADNIK ADD CONSTRAINT PLATNOSC_PLATNOSC_OSOBA_fk
FOREIGN KEY (PLATNOSC_ID)
REFERENCES PLATNOSC (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE PLATNOSC_PODSTAWA ADD CONSTRAINT ODPLATNOSC_PLATNOSC_PODSTAWA_fk
FOREIGN KEY (ODPLATNOSC_ID)
REFERENCES ODPLATNOSC (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

CREATE UNIQUE INDEX PL_UNIKALNA_OSOBA_MIESIAC
    ON PLATNOSC(OSOBA_ID, ROK, MIESIAC);
    
CREATE TRIGGER AINS_PLATNOSC_PODSTAWA AFTER INSERT ON PLATNOSC_PODSTAWA FOR EACH ROW CALL "org.h2.trigger.AfterPlatnoscPodstawaInsert";
CREATE TRIGGER ADEL_PLATNOSC_PODSTAWA AFTER DELETE ON PLATNOSC_PODSTAWA FOR EACH ROW CALL "org.h2.trigger.AfterPlatnoscPodstawaDelete";

DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';

--//@UNDO
-- SQL to undo the change goes here.

