--// migracja skale oceny pacjenta.
-- Migration SQL that makes the change goes here.

CREATE TABLE KRYTERIUM_OCENY (
                ID IDENTITY NOT NULL,
                TEKST VARCHAR(200) NOT NULL,
                TYP VARCHAR(50) NOT NULL,
                CONSTRAINT KRYTERIUM_OCENY_pk PRIMARY KEY (ID)
);

CREATE TABLE KRYTERIUM_OPCJA (
                ID IDENTITY NOT NULL,
                KRYTERIUM_OCENY_ID BIGINT(10) NOT NULL,
                PUNKTY INTEGER NOT NULL,
                TEKST VARCHAR(200) NOT NULL,
                CONSTRAINT KRYTERIUM_OPCJA_pk PRIMARY KEY (ID)
);

CREATE TABLE SKALA_OCENY_OSOBY (
                ID IDENTITY NOT NULL,
                NAZWA VARCHAR(100) NOT NULL,
                OPIS LONGVARCHAR,
                TYP VARCHAR(50) NOT NULL,
                CONSTRAINT SKALA_OCENY_OSOBY_pk PRIMARY KEY (ID)
);

CREATE TABLE OCENA_OSOBY (
                ID IDENTITY NOT NULL,
                OSOBA_ID BIGINT(10) NOT NULL,
                SKALA_OCENY_ID BIGINT(10) NOT NULL,
                DATA DATE NOT NULL,
                CONSTRAINT OCENA_OSOBY_pk PRIMARY KEY (ID)
);

CREATE TABLE KWALIFIKACJA_PIELEGNIARSKA (
                ID IDENTITY NOT NULL,
                OCENA_ID BIGINT(10) NOT NULL,
                DATA DATE NOT NULL,
                OPIEKA_DLUGOTERMINOWA BOOLEAN,
                CONSTRAINT KWALIFIKACJA_PIELEGNIARSKA_pk PRIMARY KEY (ID)
);

CREATE TABLE KWALIFIKACJA_OS_WYMAGA (
                KWALIFIKACJA_ID BIGINT(10) NOT NULL,
                SLOWO_ID BIGINT(10) NOT NULL,
                CONSTRAINT KWALIFIKACJA_OS_WYMAGA_pk PRIMARY KEY (KWALIFIKACJA_ID, SLOWO_ID)
);

CREATE TABLE OCENA_KRYTERIUM (
                OCENA_OSOBA_SKALA_ID BIGINT(10) NOT NULL,
                KRYTERIUM_OPCJA_ID BIGINT(10) NOT NULL,
                CONSTRAINT OCENA_KRYTERIUM_pk PRIMARY KEY (OCENA_OSOBA_SKALA_ID, KRYTERIUM_OPCJA_ID)
);

CREATE TABLE SKALA_KRYTERIUM_OCENY (
                SKALA_ID BIGINT(10) NOT NULL,
                KRYTERIUM_ID BIGINT(10) NOT NULL,
                CONSTRAINT SKALA_KRYTERIUM_OCENY_pk PRIMARY KEY (SKALA_ID, KRYTERIUM_ID)
);

ALTER TABLE KWALIFIKACJA_OS_WYMAGA ADD CONSTRAINT SLOWO_KWALIFIKACJA_OS_WYMAGA_fk
FOREIGN KEY (SLOWO_ID)
REFERENCES SLOWO (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE OCENA_OSOBY ADD CONSTRAINT OSOBA_OCENA_OSOBA_SKALA_fk
FOREIGN KEY (OSOBA_ID)
REFERENCES OSOBA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SKALA_KRYTERIUM_OCENY ADD CONSTRAINT MIESZKANIEC_KRYTERIUM_SKALA_KRYTERIUM_OCENY_fk
FOREIGN KEY (KRYTERIUM_ID)
REFERENCES KRYTERIUM_OCENY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE KRYTERIUM_OPCJA ADD CONSTRAINT KRYTERIUM_OCENY_KRYTERIUM_OPCJA_fk
FOREIGN KEY (KRYTERIUM_OCENY_ID)
REFERENCES KRYTERIUM_OCENY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE OCENA_KRYTERIUM ADD CONSTRAINT KRYTERIUM_OPCJA_OCENA_KRYTERIUM_fk
FOREIGN KEY (KRYTERIUM_OPCJA_ID)
REFERENCES KRYTERIUM_OPCJA (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE SKALA_KRYTERIUM_OCENY ADD CONSTRAINT SKALA_PUNKTOWA_SKALA_KRYTERIUM_OCENY_fk
FOREIGN KEY (SKALA_ID)
REFERENCES SKALA_OCENY_OSOBY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE OCENA_OSOBY ADD CONSTRAINT SKALA_OCENY_OSOBY_OCENA_OSOBA_SKALA_fk
FOREIGN KEY (SKALA_OCENY_ID)
REFERENCES SKALA_OCENY_OSOBY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE OCENA_KRYTERIUM ADD CONSTRAINT OCENA_OSOBA_SKALA_OCENA_KRYTERIUM_fk
FOREIGN KEY (OCENA_OSOBA_SKALA_ID)
REFERENCES OCENA_OSOBY (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;

ALTER TABLE KWALIFIKACJA_PIELEGNIARSKA ADD CONSTRAINT OCENA_OSOBY_KWALIFIKACJA_PIELEGNIARSKA_fk
FOREIGN KEY (OCENA_ID)
REFERENCES OCENA_OSOBY (ID)
ON DELETE NO ACTION
ON UPDATE NO ACTION;

ALTER TABLE KWALIFIKACJA_OS_WYMAGA ADD CONSTRAINT KWALIFIKACJA_PIELEGNIARSKA_KWALIFIKACJA_OS_WYMAGA_fk
FOREIGN KEY (KWALIFIKACJA_ID)
REFERENCES KWALIFIKACJA_PIELEGNIARSKA (ID)
ON DELETE CASCADE
ON UPDATE NO ACTION;


INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_NIEDOMAGANIA_MIESZKANCA');

--//@UNDO
-- SQL to undo the change goes here.

