--// migracja zalecenia lekarskie.
-- Migration SQL that makes the change goes here.

CREATE TABLE POLE_PRACOWNIK (
    ID BIGINT(7) NOT NULL,
    WARTOSC BIGINT(10) NOT NULL,
    CONSTRAINT POLE_PRACOWNIK_pk PRIMARY KEY (ID)
);
ALTER TABLE POLE_PRACOWNIK ADD CONSTRAINT PRACOWNIK_POLE_PRACOWNIK_fk
	FOREIGN KEY (WARTOSC)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE POLE_PRACOWNIK ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_PRACOWNIK_fk
	FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_CHARAKTERU_WIZYTY_LEKARZA');
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_POWODU_WIZYTY_LEKARZA');

INSERT INTO INFORMACJA_DODATKOWA (NAZWA, STATUS, POJEDYNCZY_WPIS, TYP)
  VALUES ('__zalecenie_lekarskie', 'DEFINICJA_ZABLOKOWANA', FALSE, 'ZALECENIE_LEKARSKIE');
  -- data
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ZALECENIE_LEKARSKIE' LIMIT 1),
  null, 1, 'data', 'DATA', TRUE, null);
  -- lekarz
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ZALECENIE_LEKARSKIE' LIMIT 1),
  null, 2, 'lekarz', 'PRACOWNIK', TRUE, null);
  -- charakter wizyty
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ZALECENIE_LEKARSKIE' LIMIT 1),
  null, 3, 'charakter wizyty', 'SLOWNIK', FALSE, 'KOD_CHARAKTERU_WIZYTY_LEKARZA');
  -- powód
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ZALECENIE_LEKARSKIE' LIMIT 1),
  null, 4, 'powód wizyty', 'SLOWNIK', FALSE, 'KOD_POWODU_WIZYTY_LEKARZA');
  -- opis
INSERT INTO INFORMACJA_DODATKOWA_POLE (INFORMACJA_DODATKOWA_ID,
  JEDNOSTKA_MIARY, KOLEJNOSC, NAZWA, TYP, WYMAGANE, NAZWA_SLOWNIKA)
VALUES ((SELECT i.ID FROM INFORMACJA_DODATKOWA i WHERE i.TYP = 'ZALECENIE_LEKARSKIE' LIMIT 1),
  null, 5, 'opis', 'TEKST_DLUGI', TRUE, null);


--//@UNDO
-- SQL to undo the change goes here.

