--// migracja poprawek recept cd.
-- Migration SQL that makes the change goes here.

-- tabelka przechowująca faktury za leki
CREATE TABLE FAKTURA (
    ID IDENTITY NOT NULL,
    OSOBA_ID BIGINT(10),
    PRACOWNIK_WPROWADZIL BIGINT(10) NOT NULL,
    UMOWA_APTEKA_KWOTA_ID BIGINT(10),
    DATA_WYSTAWIENIA DATE NOT NULL,
    DATA_WPROWADZENIA DATE NOT NULL,
    KWOTA_DOM DECIMAL(10,2) NOT NULL,
    KWOTA_M DECIMAL(10,2) NOT NULL,
    NR VARCHAR(50) NOT NULL,
-- dodatkowe pole by przechować informacje o fakturach, które powstały z realizacji
	REALIZACJA_RECEPTA_ID BIGINT(10)NOT NULL,
    CONSTRAINT FAKTURA_pk PRIMARY KEY (ID)
);

CREATE TABLE UMOWA_KWOTA (
    ID IDENTITY NOT NULL,
    SLOWO_ID BIGINT(10) NOT NULL,
    UMOWA_ID BIGINT(10) NOT NULL,
    KWOTA DECIMAL(10,2),
    CONSTRAINT UMOWA_KWOTA_pk PRIMARY KEY (ID)
);

ALTER TABLE UMOWA_KWOTA ADD CONSTRAINT SLOWO_UMOWA_KWOTA_fk
	FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE UMOWA_KWOTA ADD CONSTRAINT UMOWA_APTEKA_UMOWA_KWOTA_fk
	FOREIGN KEY (UMOWA_ID)
	REFERENCES UMOWA_APTEKA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE FAKTURA ADD CONSTRAINT UMOWA_KWOTA_FAKTURA_fk
	FOREIGN KEY (UMOWA_APTEKA_KWOTA_ID)
	REFERENCES UMOWA_KWOTA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE FAKTURA ADD CONSTRAINT PRACOWNIK_FAKTURA_fk
	FOREIGN KEY (PRACOWNIK_WPROWADZIL)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
ALTER TABLE FAKTURA ADD CONSTRAINT OSOBA_FAKTURA_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- transformacja umów z apteką
INSERT INTO SLOWNIK(NAZWA) VALUES('KOD_RODZAJU_KWOTY_UMOWA_APTEKA');
INSERT INTO SLOWO (SLOWNIK_ID, WART_STRING, KOD, KOLEJNOSC)
	VALUES ((SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_RODZAJU_KWOTY_UMOWA_APTEKA'), STRINGDECODE('kwota g\u0142\u00F3wna'), '001', 1);
	
INSERT INTO UMOWA_KWOTA(SLOWO_ID, UMOWA_ID)
	SELECT
		(SELECT s.ID FROM SLOWO s
			WHERE
				s.SLOWNIK_ID = (SELECT sl.ID FROM SLOWNIK sl WHERE sl.NAZWA = 'KOD_RODZAJU_KWOTY_UMOWA_APTEKA')
				AND s.KOD = '001') as SLOWO_ID,
		u.ID as UMOWA_ID
	FROM UMOWA_APTEKA u;
	
-- przenoszenie kwot realizacji recept do faktur
INSERT INTO FAKTURA(OSOBA_ID, PRACOWNIK_WPROWADZIL, UMOWA_APTEKA_KWOTA_ID, DATA_WYSTAWIENIA,
      DATA_WPROWADZENIA, KWOTA_DOM, KWOTA_M, NR, REALIZACJA_RECEPTA_ID)
    SELECT  ewDps.OSOBA_ID,
      (SELECT PRACOWNIK_ID
      		FROM DZIENNIK 
      		WHERE OBIEKT_ID = rr.ID
      			AND TYP_OPERACJI IN ('REAL_RECEPTY_DODAWANIE_IND', 'REAL_RECEPTY_DODAWANIE_SZ') LIMIT 1) as PRACOWNIK_WPROWADZIL,
      (SELECT uk.ID
      		FROM UMOWA_KWOTA uk
      		WHERE uk.UMOWA_ID = rr.UMOWA_ID
      			AND uk.SLOWO_ID = (SELECT s.ID
      									FROM SLOWO s
										WHERE	s.SLOWNIK_ID = (SELECT sl.ID FROM SLOWNIK sl WHERE sl.NAZWA = 'KOD_RODZAJU_KWOTY_UMOWA_APTEKA')
											AND s.KOD = '001')) as UMOWA_APTEKA_KWOTA_ID,
      rr.DATA_REALIZACJI as DATA_WYSTAWIENIA,
      '2011-08-11' as DATA_WPROWADZENIA,
      rr.KWOTA_DOM,
      rr.KWOTA_M,
      coalesce(rr.NR, '') as NR,
      rr.ID as REALIZACJA_RECEPTA_ID
    FROM REALIZACJA_RECEPTA rr
      JOIN RECEPTA r ON rr.RECEPTA_ID = r.ID
      JOIN EWIDENCJA_DPS ewDps ON r.EWIDENCJA_DPS_ID = ewDps.ID;
      
-- zmiana w realizacji recept
DROP VIEW RECEPTY_NIEZREALIZOWANE;
DROP VIEW REALIZACJA_UMOW_APTEKA;

ALTER TABLE REALIZACJA_RECEPTA ADD EWIDENCJA_DPS_ID BIGINT(10);
ALTER TABLE REALIZACJA_RECEPTA ADD CONSTRAINT EWIDENCJA_DPS_REALIZACJA_RECEPTA_fk
	FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

UPDATE REALIZACJA_RECEPTA rr SET rr.EWIDENCJA_DPS_ID = (SELECT r.EWIDENCJA_DPS_ID FROM RECEPTA r WHERE rr.RECEPTA_ID = r.ID);
ALTER TABLE REALIZACJA_RECEPTA ALTER COLUMN EWIDENCJA_DPS_ID SET NOT NULL;

ALTER TABLE REALIZACJA_RECEPTA DROP CONSTRAINT RECEPTA_FAKTURA_RECEPTA_fk;
ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN RECEPTA_ID;

ALTER TABLE REALIZACJA_RECEPTA DROP CONSTRAINT UMOWA_APTEKA_FAKTURA_RECEPTA_fk;
ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN UMOWA_ID;

ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN DATA_REALIZACJI;
ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN KWOTA_DOM;
ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN KWOTA_M;
ALTER TABLE REALIZACJA_RECEPTA DROP COLUMN NR;

-- kolumna data może być już NULLem
ALTER TABLE REALIZACJA_RECEPTA ALTER COLUMN DATA SET NULL;

-- uzupełnianie realizacji recept o podpięte faktury
ALTER TABLE REALIZACJA_RECEPTA ADD FAKTURA_ID BIGINT(10);
ALTER TABLE REALIZACJA_RECEPTA ADD CONSTRAINT FAKTURA_REALIZACJA_RECEPTA_fk
	FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
UPDATE REALIZACJA_RECEPTA rr SET rr.FAKTURA_ID = (SELECT f.ID FROM FAKTURA f WHERE f.REALIZACJA_RECEPTA_ID = rr.ID);
ALTER TABLE FAKTURA DROP COLUMN REALIZACJA_RECEPTA_ID;

-- uzupełnianie tabelki LEK_REALIZACJA
ALTER TABLE LEK_REALIZACJA ADD DATA DATE;

-- inne
ALTER TABLE RECEPTA DROP COLUMN STATUS;

-- widok dla realizowanych umów z apteką
CREATE VIEW REALIZACJA_UMOW_APTEKA AS
	SELECT uk.*, COALESCE(SUM(f.KWOTA_DOM), '0.00') as KWOTA_WYKORZYSTANA
	FROM UMOWA_KWOTA uk
		LEFT OUTER JOIN FAKTURA f ON uk.ID = f.UMOWA_APTEKA_KWOTA_ID
	GROUP BY uk.ID;

--//@UNDO
-- SQL to undo the change goes here.

