--// migracja pracownik PK w IPWM.
-- Migration SQL that makes the change goes here.

-- słownika pracowników pierwszego kontaktu
INSERT INTO SLOWNIK(NAZWA) VALUES ('KOD_PRACOWNIKA_PK');

-- uzupełnianie wpisów pracowników
INSERT INTO SLOWO(SLOWNIK_ID, WART_STRING, KOD)
	SELECT
		(SELECT ID FROM SLOWNIK WHERE NAZWA = 'KOD_PRACOWNIKA_PK') as SLOWNIK_ID,
		tmpPK.NAZWISKO_IMIE as WART_STRING,
		LPAD(CAST(ROWNUM() as VARCHAR), 3, '0') as KOD
	FROM (
		SELECT
			DISTINCT
			p.ID as PRACOWNIK_ID,
			CONCAT(p.NAZWISKO, ' ', p.IMIE) as NAZWISKO_IMIE
		FROM PRACOWNIK p
			JOIN PLAN_WSPARCIA_MIESZKANCA pl ON p.ID = pl.PRACOWNIK_PWK_ID
	) as tmpPK;


ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD PRACOWNIK_PK_ID BIGINT(10);
ALTER TABLE PLAN_WSPARCIA_MIESZKANCA ADD CONSTRAINT SLOWO_PLAN_WSPARCIA_MIESZKANCA_fk
	FOREIGN KEY (PRACOWNIK_PK_ID)
	REFERENCES SLOWO (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

-- łączenie pracowników z planami
UPDATE PLAN_WSPARCIA_MIESZKANCA pl
	SET pl.PRACOWNIK_PK_ID = (
		SELECT sl.ID
		FROM SLOWO sl
		WHERE
			sl.WART_STRING = (SELECT CONCAT(p.NAZWISKO, ' ', p.IMIE) FROM PRACOWNIK p WHERE p.ID = pl.PRACOWNIK_PWK_ID)
	);
		
ALTER TABLE PLAN_WSPARCIA_MIESZKANCA DROP CONSTRAINT PRACOWNIK_PLAN_WSPARCIA_MIESZKANCA_fk;
ALTER TABLE PLAN_WSPARCIA_MIESZKANCA DROP COLUMN PRACOWNIK_PWK_ID;

--//@UNDO
-- SQL to undo the change goes here.

