--// migracja dzienny pobyt cd.
-- Migration SQL that makes the change goes here.

CREATE UNIQUE INDEX SWDZ_UNIKALNA_KWOTA_SW
    ON SWIADCZENIE_ODPLATNOSC(SWIADCZENIE_ID, DATA);

-- dni wolne dla podpowiadanych świadczeń
CREATE TABLE SWIADCZENIE_DZIEN_WOLNY (
    SWIADCZENIE_ID BIGINT(10) NOT NULL,
    DATA DATE NOT NULL,
    CONSTRAINT SWIADCZENIE_DZIEN_WOLNY_pk PRIMARY KEY (SWIADCZENIE_ID, DATA)
);

ALTER TABLE SWIADCZENIE_DZIEN_WOLNY ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_DZIEN_WOLNY_fk
	FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
-- rozliczenie
ALTER TABLE ROZLICZENIE ADD DATA_WYKONANIA DATE;
UPDATE ROZLICZENIE r SET r.DATA_WYKONANIA = r.DATA WHERE r.DATA_WYKONANIA IS NULL;
ALTER TABLE ROZLICZENIE ALTER COLUMN DATA_WYKONANIA SET NOT NULL;

ALTER TABLE ROZLICZENIE ADD PRACOWNIK_WYKONAL_ID BIGINT(10);
UPDATE ROZLICZENIE r SET r.PRACOWNIK_WYKONAL_ID = (SELECT ID FROM PRACOWNIK p WHERE p.LOGIN = 'start' LIMIT 1) WHERE r.PRACOWNIK_WYKONAL_ID IS NULL;
ALTER TABLE ROZLICZENIE ALTER COLUMN PRACOWNIK_WYKONAL_ID SET NOT NULL;

-- decyzja swiadczenie
ALTER TABLE DECYZJA_SWIADCZENIE ALTER COLUMN ILOSC_LIMIT SET NULL;

ALTER TABLE DECYZJA_SWIADCZENIE ALTER COLUMN OKRES_ILOSC_LIMIT RENAME TO OKRES_ILOSC_LIMIT_TEMP;
ALTER TABLE DECYZJA_SWIADCZENIE ADD OKRES_ILOSC_LIMIT DECIMAL(10,2);
UPDATE DECYZJA_SWIADCZENIE dcs SET dcs.OKRES_ILOSC_LIMIT = CAST(COALESCE(dcs.OKRES_ILOSC_LIMIT_TEMP, 0.0) as DECIMAL(10, 2));
ALTER TABLE DECYZJA_SWIADCZENIE ALTER COLUMN OKRES_ILOSC_LIMIT SET NOT NULL;
ALTER TABLE DECYZJA_SWIADCZENIE DROP COLUMN OKRES_ILOSC_LIMIT_TEMP;

-- rekompilacja widoków
DROP VIEW IF EXISTS MIESZKANCY;
CREATE VIEW MIESZKANCY AS
	SELECT os.*, ew.id as EWIDENCJA_ID, ew.DATA_OD, ew.DATA_DO, ew.NUMER_EWIDENCYJNY
	FROM OSOBA os
    	JOIN EWIDENCJA_DPS ew ON os.id = ew.osoba_id
			AND ew.TYP = 'MIESZKANIEC';

--//@UNDO
-- SQL to undo the change goes here.

