--// migracja poprawki dowodow osobistych.
-- Migration SQL that makes the change goes here.

ALTER TABLE DOWOD_OSOBISTY ALTER COLUMN DATA_WYDANIA SET NULL;

-- wprowadzenie dodatkowej daty po to by rozróżniać kolejność wprowadzania
ALTER TABLE DOWOD_OSOBISTY ADD DATA_WPROWADZENIA DATE;
UPDATE DOWOD_OSOBISTY d
	SET d.DATA_WPROWADZENIA = (
		SELECT dz.DATA
		FROM DZIENNIK dz 
		WHERE
			dz.OBIEKT_ID = d.ID
			AND dz.TYP_OPERACJI = 'DWD_OS_DODAWANIE_AKTUALIZACJA'
		ORDER BY dz.DATA
		LIMIT 1
	);
UPDATE DOWOD_OSOBISTY d SET d.DATA_WPROWADZENIA = CURRENT_DATE() WHERE d.DATA_WPROWADZENIA IS NULL;
ALTER TABLE DOWOD_OSOBISTY ALTER COLUMN DATA_WPROWADZENIA SET NOT NULL;

-- rekompilacja widoków
DROP VIEW IF EXISTS AKTUALNE_DOWODY_OSOB;
CREATE VIEW AKTUALNE_DOWODY_OSOB AS
	SELECT dOs.*
	FROM DOWOD_OSOBISTY dOs
	     LEFT OUTER JOIN DOWOD_OSOBISTY tmpDow ON dOs.OSOBA_ID = tmpDow.OSOBA_ID
	     	AND dOs.DATA_WYDANIA < tmpDow.DATA_WYDANIA
	WHERE
		tmpDow.ID IS NULL;


--//@UNDO
-- SQL to undo the change goes here.

