--// migracja wydruki przelewow.
-- Migration SQL that makes the change goes here.

ALTER TABLE DPS_JEDNOSTKA ADD KRS VARCHAR(10);

CREATE TABLE PRZELEW_DRUK (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    MIESZKANIEC_ID BIGINT(10) NOT NULL,
    OSOBA_ID BIGINT(10),
    KWOTA DECIMAL(10,2) NOT NULL,
    MIESIAC INTEGER NOT NULL,
    ROK INTEGER NOT NULL,
    TYTULEM VARCHAR(100) NOT NULL,
    CONSTRAINT PRZELEW_DRUK_pk PRIMARY KEY (ID)
);

ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT MIESZKANIEC_PRZELEW_DRUK_fk
	FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT OSOBA_PRZELEW_DRUK_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
	
ALTER TABLE PRZELEW_DRUK ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_PRZELEW_DRUK_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


-- autonumeracje dla druków przelewów
INSERT INTO AUTONUMER(TYP, FORMAT, WARTOSC) VALUES ('PRZELEW_DRUK_UUID', '_', 1);
INSERT INTO AUTONUMER(TYP, FORMAT, WARTOSC) VALUES ('PRZELEW_DRUK_TYTULEM', '${przelewDruk.rok}/${nr}', 1);

-- informacje o wersjach
DELETE FROM PRACOWNIK_PARAMETR p WHERE p.TYP = 'INFO_WERSJA_APLIKACJI';


--//@UNDO
-- SQL to undo the change goes here.

