--// odswiezanie widokow
-- Migration SQL that makes the change goes here.

DROP VIEW IF EXISTS AKTUALNE_WPISY_EWIDENCJI_OSOB;
CREATE VIEW AKTUALNE_WPISY_EWIDENCJI_OSOB AS
	SELECT ew.*
	FROM EWIDENCJA_DPS ew
		LEFT OUTER JOIN EWIDENCJA_DPS nEw ON nEw.EWID_POPRZEDNI_WPIS_ID = ew.ID
	WHERE nEw.ID IS NULL;

DROP VIEW IF EXISTS AKTUALNE_DOWODY_OSOB;
CREATE VIEW AKTUALNE_DOWODY_OSOB AS
	SELECT dOs.*
	FROM DOWOD_OSOBISTY dOs
	     LEFT OUTER JOIN DOWOD_OSOBISTY tmpDow ON dOs.OSOBA_ID = tmpDow.OSOBA_ID
	     	AND dOs.DATA_WYDANIA < tmpDow.DATA_WYDANIA
	WHERE
		tmpDow.ID IS NULL;
		
DROP VIEW IF EXISTS AKTUALNE_DECYZJE_ALIMENTACYJNE_ODPLATNOSCI;
CREATE VIEW AKTUALNE_DECYZJE_ALIMENTACYJNE_ODPLATNOSCI AS
	SELECT odpl.*
	FROM DECYZJA_O_ODPLATNOSCI odpl
		LEFT OUTER JOIN DECYZJA_O_ODPLATNOSCI tmpDec ON odpl.MIESZKANIEC_ID = tmpDec.MIESZKANIEC_ID
			AND (
				odpl.CZLONEK_RODZ_ID = tmpDec.CZLONEK_RODZ_ID
				OR
				(odpl.CZLONEK_RODZ_ID IS NULL AND tmpDec.CZLONEK_RODZ_ID IS NULL)
			)
			AND coalesce(odpl.OBOWIAZUJE_OD, odpl.DATA_WYDANIA) < coalesce(tmpDec.OBOWIAZUJE_OD, tmpDec.DATA_WYDANIA)
	WHERE
		tmpDec.ID IS NULL;

DROP VIEW IF EXISTS AKTUALNE_ADRESY_OSOB;
CREATE VIEW AKTUALNE_ADRESY_OSOB AS
	SELECT adr.*, osAdr.OSOBA_ID
	FROM ADRES adr
		JOIN OSOBA_ADRES osAdr ON adr.ID = osAdr.ADRES_ID
		LEFT OUTER JOIN ADRES tmpAdr ON tmpAdr.ID = osAdr.ADRES_ID
			AND adr.ID < tmpAdr.ID
			AND adr.TYP = tmpAdr.TYP
	WHERE
		tmpAdr.ID IS NULL;
		
DROP VIEW IF EXISTS AKTUALNE_POKOJE_MIESZKANCOW;
CREATE VIEW AKTUALNE_POKOJE_MIESZKANCOW AS
	SELECT ewDps.OSOBA_ID as MIESZKANIEC_ID, ewPok.*
	FROM EWIDENCJA_DPS ewDps
		JOIN EWIDENCJA_POKOJE ewPok ON ewDps.ID = ewPok.EWIDENCJA_DPS_ID
			AND ewDps.TYP = 'MIESZKANIEC' AND ewDps.DATA_DO IS NULL -- tylko widok pokoi aktualnych mieszkańców DPS
		LEFT OUTER JOIN EWIDENCJA_POKOJE nEwPok ON ewPok.ID = nEwPok.POPRZEDNI_POKOJ_ID
	WHERE
		nEwPok.ID IS NULL;

DROP VIEW IF EXISTS AKTUALNE_DAWKI_LEKOW;
CREATE VIEW AKTUALNE_DAWKI_LEKOW AS
	SELECT ewDps.OSOBA_ID, d.*
		FROM AKTUALNE_WPISY_EWIDENCJI_OSOB ewDps
			JOIN DAWKOWANIE d ON d.EWIDENCJA_DPS_ID = ewDps.ID
				AND d.DATA_OD <= CURRENT_DATE()
			LEFT OUTER JOIN DAWKOWANIE najD ON najD.EWIDENCJA_DPS_ID = ewDps.ID
				AND najD.POPRZEDNIE_DAWKOWANIE_ID = d.ID
	WHERE
		najD.ID IS NULL;

DROP VIEW IF EXISTS CZLONKOWIE_RODZIN;
CREATE VIEW CZLONKOWIE_RODZIN AS
	SELECT
		DISTINCT os.ID as OS1_ID, osr.KOD_STOPNIA_POKREWIENSTWA as KOD_POKREWIENTWA_OS1, osr.TYP as TYP_OS1, osr.DATA_OD as DATA_OD_OS1, osr.DATA_DO as DATA_DO_OS1,
		osr.RODZINA_ID, osr.ZOBOWIAZANY_ALIMENTACJA as OS1_ZOBOWIAZANY_ALIMENTACJA, osr.ZWOLNIONY_ALIMENTACJA as OS1_ZWOLNIONY_ALIMENTACJA,
		osCzlr.ID as OS2_ID, osrR.KOD_STOPNIA_POKREWIENSTWA as KOD_POKREWIENTWA_OS2, osrR.TYP as TYP_OS2, osrR.DATA_OD as DATA_OD_OS2, osrR.DATA_DO as DATA_DO_OS2,
		osrR.ZOBOWIAZANY_ALIMENTACJA as OS2_ZOBOWIAZANY_ALIMENTACJA, osrR.ZWOLNIONY_ALIMENTACJA as OS2_ZWOLNIONY_ALIMENTACJA
	FROM osoba os
		JOIN osoba_rodzina osr ON os.ID = osr.OSOBA_ID
		JOIN osoba_rodzina osrR ON osr.RODZINA_ID = osrR.RODZINA_ID
		JOIN osoba osCzlr ON osrR.OSOBA_ID = osCzlr.ID;

-- określa osoby, które kiedyś i obecnie były/są mieszkańcami DPSu
DROP VIEW IF EXISTS MIESZKANCY;
CREATE VIEW MIESZKANCY AS
	SELECT os.*, ew.id as EWIDENCJA_ID, ew.DATA_OD, ew.DATA_DO, ew.NUMER_EWIDENCYJNY
	FROM OSOBA os
    	JOIN EWIDENCJA_DPS ew ON os.id = ew.osoba_id
			AND ew.TYP = 'MIESZKANIEC';

-- określa przypisania osób do rodzin mieszkańców (jedna osoba-członek rodziny może mieć kilka przypisań do różnych rodzin)
DROP VIEW IF EXISTS AKTUALNE_RODZINY_OSOB;
CREATE VIEW AKTUALNE_RODZINY_OSOB AS
	SELECT DISTINCT os.ID as OSOBA_ID, osr.RODZINA_ID
	FROM osoba os
		JOIN osoba_rodzina osr ON os.ID = osr.OSOBA_ID;

DROP VIEW IF EXISTS AKTUALNE_PRZYPISANIA_OSOBA_PRACOWNIK;
CREATE VIEW AKTUALNE_PRZYPISANIA_OSOBA_PRACOWNIK AS
	SELECT *
	FROM osoba_pracownik osP
	WHERE osP.DATA_ZMIANY IS NULL;

DROP VIEW IF EXISTS PRACOWNICY_AKTYWNI;
CREATE VIEW PRACOWNICY_AKTYWNI AS   
	SELECT pr.*
	FROM PRACOWNIK pr
	WHERE
        pr.CZY_PRACUJE = 1
        AND (pr.ZABLOKOWANE IS NULL OR pr.ZABLOKOWANE = FALSE)
        AND (pr.LICZBA_N_LOGOWAN < 3 OR pr.LICZBA_N_LOGOWAN IS NULL);

DROP VIEW IF EXISTS UPRAWNIENIE_PRACOWNIKA_KAT_USL_CZYNNOSC;
CREATE VIEW UPRAWNIENIE_PRACOWNIKA_KAT_USL_CZYNNOSC AS
	SELECT pr.ID as PRACOWNIK_ID, grUpr.GRUPA_ID, grUpr.TYP_UPRAWNIENIA, grUpr.CZYNNOSC_ID
	FROM PRACOWNIK pr
		JOIN GRUPA_UPRAWNIENIE_KAT_USLUG grUpr ON pr.GRUPA_ID = grUpr.GRUPA_ID;

DROP VIEW IF EXISTS PRACOWNIK_MIESZKANIEC_CZYNNOSCI;
CREATE VIEW PRACOWNIK_MIESZKANIEC_CZYNNOSCI AS
	SELECT pr.ID as PRACOWNIK_ID, wpisEwid.OSOBA_ID AS MIESZKANIEC_ID, grUpr.CZYNNOSC_ID, grUpr.TYP_UPRAWNIENIA, plan.DATA_OD, plan.DATA_DO
	FROM AKTUALNE_WPISY_EWIDENCJI_OSOB wpisEwid
		JOIN PLAN_WSPARCIA_MIESZKANCA plan ON wpisEwid.ID = plan.EWIDENCJA_ID
			AND wpisEwid.TYP = 'MIESZKANIEC'
		JOIN PLAN_WSPARCIA_CZYNNOSC planCz ON plan.ID = planCz.PLAN_ID
		JOIN GRUPA_UPRAWNIENIE_KAT_USLUG grUpr ON planCz.CZYNNOSC_ID = grUpr.CZYNNOSC_ID
		JOIN PRACOWNIK pr ON grUpr.GRUPA_ID = pr.GRUPA_ID;

DROP VIEW IF EXISTS REALIZACJA_UMOW_APTEKA;
CREATE VIEW REALIZACJA_UMOW_APTEKA AS
	SELECT uk.*, COALESCE(SUM(f.KWOTA_DOM), '0.00') as KWOTA_WYKORZYSTANA
	FROM UMOWA_KWOTA uk
		LEFT OUTER JOIN FAKTURA f ON uk.ID = f.UMOWA_APTEKA_KWOTA_ID
	GROUP BY uk.ID;

DROP VIEW IF EXISTS INFORMACJE_Z_PRZYPOMNIENIEM;
CREATE VIEW INFORMACJE_Z_PRZYPOMNIENIEM AS
	SELECT DISTINCT id.*
	FROM INFORMACJA_DODATKOWA id
		JOIN INFORMACJA_DODATKOWA_POLE idp ON id.ID = idp.INFORMACJA_DODATKOWA_ID
			AND idp.TYP = 'DATA_PRZYPOMNIENIA';

--//@UNDO
-- SQL to undo the change goes here.


