--// migracja poprawki triggerow.
-- Migration SQL that makes the change goes here.

-- USUWANIE STARYCH TRIGGERÓW (ścieżki klas się pozmieniały i dlatego wywalam wszystkie)
DROP TRIGGER IF EXISTS AINS_UPRAWNIENIE_CZYNNOSC;
DROP TRIGGER IF EXISTS ADEL_UPRAWNIENIE_CZYNNOSC;
DROP TRIGGER IF EXISTS ADEL_CZYNN_REALIZACJA;
DROP TRIGGER IF EXISTS ADEL_UWAGI_REALIZACJA;
DROP TRIGGER IF EXISTS AINS_INFORMACJA_DODATKOWA_WPIS;
DROP TRIGGER IF EXISTS ADEL_INFORMACJA_DODATKOWA_WPIS;
DROP TRIGGER IF EXISTS AINS_NALICZENIE_PODSTAWA;
DROP TRIGGER IF EXISTS ADEL_NALICZENIE_PODSTAWA;
DROP TRIGGER IF EXISTS AINS_NALICZENIE_POBYT;
DROP TRIGGER IF EXISTS ADEL_NALICZENIE_POBYT;

-- NOWE TRIGGERY

-- informacja dodatkowa
CREATE TRIGGER ADEL_INFORMACJA_DODATKOWA_WPIS AFTER
	DELETE ON INFORMACJA_DODATKOWA_WPIS FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.informacjaDodatkowa.AfterInformacjaWpisDelete";
CREATE TRIGGER AINS_INFORMACJA_DODATKOWA_WPIS AFTER
	INSERT ON INFORMACJA_DODATKOWA_WPIS FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.informacjaDodatkowa.AfterInformacjaWpisInsert";

-- katalog usług
CREATE TRIGGER ADEL_CZYNN_REALIZACJA AFTER
	DELETE ON CZYNNOSC_REALIZACJA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.katalogUslug.AfterCzynnoscRealizacjaDelete";
CREATE TRIGGER ADEL_UPRAWNIENIE_CZYNNOSC AFTER
	DELETE ON GRUPA_UPRAWNIENIE_KAT_USLUG FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.katalogUslug.AfterKatUslUprawnienieDelete";
CREATE TRIGGER AINS_UPRAWNIENIE_CZYNNOSC AFTER
	INSERT ON GRUPA_UPRAWNIENIE_KAT_USLUG FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.katalogUslug.AfterKatUslUprawnienieInsert";
CREATE TRIGGER ADEL_UWAGI_REALIZACJA AFTER
	DELETE ON UWAGI_REALIZACJA_PLANU FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.katalogUslug.AfterUwagiPlanRealizacjaDelete";

-- naliczanie opłat - pobyt
CREATE TRIGGER ADEL_NALICZENIE_POBYT AFTER
	DELETE ON NALICZENIE_POBYT FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczaniePobytDelete";
CREATE TRIGGER AINS_NALICZENIE_POBYT AFTER
	INSERT ON NALICZENIE_POBYT FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczaniePobytInsert";

-- usunięte ze względu na migracje starych baz danych
--CREATE TRIGGER ADEL_NALICZENIE_PODSTAWA AFTER
--	DELETE ON NALICZENIE_PODSTAWA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczeniePodstawaDelete";
--CREATE TRIGGER AINS_NALICZENIE_PODSTAWA AFTER
--	INSERT ON NALICZENIE_PODSTAWA FOR EACH ROW CALL "pl.topteam.dps.h2.trigger.naliczanieOplat.pobyt.AfterNaliczeniePodstawaInsert";


--//@UNDO
-- SQL to undo the change goes here.

