--// migracja zadluzenie winien ma.
-- Migration SQL that makes the change goes here.

CREATE TABLE ZESTAWIENIE_WINIEN_MA (
    ID IDENTITY NOT NULL,
    PRACOWNIK_ID BIGINT(10) NOT NULL,
    SZABLON_WYDRUKU_ID BIGINT(10),
    DATA_GENEROWANIA DATE NOT NULL,
    ROK INTEGER NOT NULL,
    MIESIAC INTEGER NOT NULL,
    CONSTRAINT ZESTAWIENIE_WINIEN_MA_pk PRIMARY KEY (ID)
);

CREATE TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA (
    ID IDENTITY NOT NULL,
    INSTYTUCJA_ID BIGINT(10),
    OSOBA_ID BIGINT(10),
    MIESZKANIEC_ID BIGINT(10) NOT NULL,
    POPRZEDNIA_POZYCJA_ID BIGINT(10),
    ZESTAWIENIE_ID BIGINT(10) NOT NULL,
    DATA_GENEROWANIA DATE NOT NULL,
    KWOTA_WINIEN_SK DECIMAL(10,2) NOT NULL,
    KWOTA_MA_SK DECIMAL(10,2) NOT NULL,
    KWOTA_ODPISY DECIMAL(10,2) NOT NULL,
    KWOTA_PRZYPISY DECIMAL(10,2) NOT NULL,
    KWOTA_WPLATY DECIMAL(10,2) NOT NULL,
    KWOTA_ZWROTY DECIMAL(10,2) NOT NULL,
    CONSTRAINT ZESTAWIENIE_WINIEN_MA_POZYCJA_pk PRIMARY KEY (ID)
);

-- Comment for table [ZESTAWIENIE_WINIEN_MA_POZYCJA]: wykaz przekazywany do księgowej w celu sprawdzenia poprawności rozliczania; zawsze tworzony jest na ostatni dzień miesiąca i uwzględniający tylko elementy rozliczenia wykonane w tym miesiącu;

-- Comment for column [KWOTA_WINIEN_SK]: saldo końcowe;

-- Comment for column [KWOTA_MA_SK]: saldo końcowe;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA ADD CONSTRAINT OSOBA_ZESTAWIENIE_WINIEN_MA_POZYCJA_fk
	FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA ADD CONSTRAINT MIESZKANIEC_ZESTAWIENIE_WINIEN_MA_POZYCJA_fk
	FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_ZESTAWIENIE_WINIEN_MA_POZYCJA_fk
	FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA ADD CONSTRAINT PRACOWNIK_ZESTAWIENIE_WINIEN_MA_fk
	FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA ADD CONSTRAINT SZABLON_WYDRUKU_ZESTAWIENIE_WINIEN_MA_fk
	FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA ADD CONSTRAINT ZADLUZENIE_WINIEN_MA_ZADLUZENIE_WINIEN_MA_POZYCJA_fk
	FOREIGN KEY (ZESTAWIENIE_ID)
	REFERENCES ZESTAWIENIE_WINIEN_MA (ID)
	ON DELETE CASCADE
	ON UPDATE NO ACTION;

ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA ADD CONSTRAINT ZESTAWIENIE_WINIEN_MA_POZYCJA_ZESTAWIENIE_WINIEN_MA_POZYCJA_fk
	FOREIGN KEY (POPRZEDNIA_POZYCJA_ID)
	REFERENCES ZESTAWIENIE_WINIEN_MA_POZYCJA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;


--//@UNDO
-- SQL to undo the change goes here.

