--// migracja rodzaj swiadczenia.
-- Migration SQL that makes the change goes here.

-- nowa oddzielna tabela słownikowa
CREATE TABLE RODZAJ_POB_SWIADCZENIA (
    ID IDENTITY NOT NULL,
    ODLICZENIE_POBYT_DZIEN_ZGONU VARCHAR(50) NOT NULL,
    ODLICZENIE_POBYT_PO_ZGON VARCHAR(50) NOT NULL,
    ODLICZENIE_POBYT_PRZED_ZGON VARCHAR(50) NOT NULL,
    ZWROT_WYPLATA_DZIEN_ZGONU VARCHAR(50) NOT NULL,
    ZWROT_WYPLATA_PO_ZGON VARCHAR(50) NOT NULL,
    ZWROT_WYPLATA_PRZED_ZGON VARCHAR(50) NOT NULL,
    KOD VARCHAR(15) NOT NULL,
    TEKST VARCHAR(50) NOT NULL,
    CONSTRAINT RODZAJ_POB_SWIADCZENIA_pk PRIMARY KEY (ID)
);
-- dane przeniesione ze słownika
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Emerytura', '667');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Renta', '668');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Zasiłek stały', '669');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Renta socjalna', '670');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Renta rodzinna', '671');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Renta rodzina + socjalna', '672');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('CALOSC', 'CALOSC', 'NIE_PODLEGA', 'CALOSC', 'CALOSC', 'NIE_PODLEGA', 'Zasiłek pielęgnacyjny', '673');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Alimenty', '674');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Umowa dzierżawy', '675');
INSERT INTO RODZAJ_POB_SWIADCZENIA(ZWROT_WYPLATA_DZIEN_ZGONU, ZWROT_WYPLATA_PO_ZGON, ZWROT_WYPLATA_PRZED_ZGON, ODLICZENIE_POBYT_DZIEN_ZGONU, ODLICZENIE_POBYT_PO_ZGON, ODLICZENIE_POBYT_PRZED_ZGON, TEKST, KOD)
	VALUES('PROPORCJONALNIE', 'PROPORCJONALNIE', 'PROPORCJONALNIE', 'NIE_PODLEGA', 'NIE_PODLEGA', 'NIE_PODLEGA', 'Doch. z gosp. rolnego', '676');

-- zmiany w pobieranych świadczeniach
ALTER TABLE POBIERANE_SWIADCZENIE DROP CONSTRAINT SLOWO_POBIERANE_SWIADCZENIE_fk;
ALTER TABLE POBIERANE_SWIADCZENIE ALTER COLUMN KOD_SWIADCZENIA_ID RENAME TO KOD_SWIADCZENIA_ID_OLD;
--	podpinanie do nowego słownika
ALTER TABLE POBIERANE_SWIADCZENIE ADD KOD_SWIADCZENIA_ID BIGINT(15);
ALTER TABLE POBIERANE_SWIADCZENIE ADD CONSTRAINT RODZAJ_POB_SWIADCZENIA_POBIERANE_SWIADCZENIE_fk
	FOREIGN KEY (KOD_SWIADCZENIA_ID)
	REFERENCES RODZAJ_POB_SWIADCZENIA (ID)
	ON DELETE NO ACTION
	ON UPDATE NO ACTION;
UPDATE POBIERANE_SWIADCZENIE ps
	SET ps.KOD_SWIADCZENIA_ID = (
		SELECT rps.ID
		FROM RODZAJ_POB_SWIADCZENIA rps
			JOIN SLOWO s ON s.ID = ps.KOD_SWIADCZENIA_ID_OLD
				AND rps.TEKST = s.WART_STRING
				
	);
ALTER TABLE POBIERANE_SWIADCZENIE ALTER COLUMN KOD_SWIADCZENIA_ID SET NOT NULL;
ALTER TABLE POBIERANE_SWIADCZENIE DROP COLUMN KOD_SWIADCZENIA_ID_OLD;

-- usuwanie słownika
DELETE FROM SLOWO s WHERE s.SLOWNIK_ID = (SELECT t.ID FROM SLOWNIK t WHERE t.NAZWA = 'KOD_RODZAJU_SWIADCZENIA');
DELETE FROM SLOWNIK s WHERE s.NAZWA = 'KOD_RODZAJU_SWIADCZENIA';

	
--//@UNDO
-- SQL to undo the change goes here.

