/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.insightech.er.db.impl.h2.H2DDLCreator;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.ddl.DDLTarget;
import org.insightech.er.editor.model.settings.Environment;
import org.insightech.er.editor.persistent.impl.XMLLoader;
import org.junit.Test;

public abstract class AbstractDDLExporterTest {
    protected Path diagramPath;
    protected Path exportFile;

    protected AbstractDDLExporterTest(Path diagramPath, Path exportFile) {
        this.diagramPath = diagramPath;
        this.exportFile = exportFile;
    }

    @Test
    public void exportSchema() throws Exception {
        Files.write((CharSequence)AbstractDDLExporterTest.createDDL(this.diagramPath), (File)this.exportFile.toFile(), (Charset)Charsets.UTF_8);
    }

    public static String createDDL(Path diagramPath) throws Exception {
        ERDiagram loadedDiagram = null;
        XMLLoader loader = new XMLLoader();
        try (FileInputStream fin = new FileInputStream(diagramPath.toFile());){
            loadedDiagram = loader.load((InputStream)fin);
        }
        H2DDLCreator ddlCreator = new H2DDLCreator(loadedDiagram, true);
        Environment environment = (Environment)loadedDiagram.getDiagramContents().getSettings().getEnvironmentSetting().getEnvironments().get(0);
        DDLTarget ddlTarget = new DDLTarget();
        ddlTarget.createComment = false;
        ddlTarget.dropTablespace = false;
        ddlTarget.dropSequence = false;
        ddlTarget.dropTrigger = false;
        ddlTarget.dropView = false;
        ddlTarget.dropIndex = false;
        ddlTarget.dropTable = false;
        ddlTarget.createTablespace = false;
        ddlTarget.createSequence = false;
        ddlTarget.createTrigger = false;
        ddlTarget.createView = false;
        ddlTarget.createIndex = false;
        ddlTarget.createTable = true;
        ddlTarget.createForeignKey = true;
        ddlTarget.createComment = true;
        ddlTarget.inlineTableComment = false;
        ddlTarget.inlineColumnComment = false;
        ddlTarget.commentValueDescription = false;
        ddlTarget.commentValueLogicalName = false;
        ddlTarget.commentValueLogicalNameDescription = false;
        ddlTarget.commentReplaceLineFeed = false;
        ddlCreator.init(environment, ddlTarget);
        return ddlCreator.getCreateDDL(loadedDiagram);
    }
}

