/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.AfterClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import pl.topteam.dps.db.generator.SQLExecutor;

public abstract class AbstractDatabaseCreationTest {
    protected static JdbcConnectionPool cp;
    protected Path skrypt;
    @Rule
    public TestRule failOnFirstException = new TestWatcher(){

        protected void failed(Throwable e, Description description) {
            super.failed(e, description);
            throw new RuntimeException(e);
        }
    };

    protected AbstractDatabaseCreationTest(Path skrypt) {
        this.skrypt = skrypt;
    }

    @AfterClass
    public static void shutdownConnectionPool() throws SQLException {
        if (cp != null) {
            cp.dispose();
        }
    }

    @Test
    public void createDatabase() throws SQLException, IOException {
        try (Connection conn = cp.getConnection();){
            SQLExecutor.executeSql(conn, this.skrypt.toAbsolutePath());
        }
    }

    protected static Path target() {
        return Paths.get("target", new String[0]);
    }
}

