/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLExecutor {
    private static Logger log = LoggerFactory.getLogger(SQLExecutor.class);

    public static void executeSql(Connection conn, Path skrypt) throws SQLException, IOException {
        SQLExecutor.executeSql(conn, skrypt.getFileName().toString(), Files.toString((File)skrypt.toFile(), (Charset)Charsets.UTF_8));
    }

    public static void executeSql(Connection conn, String skrypt, String sql) throws SQLException {
        int lWykonanychPolecen = 0;
        try (Statement sta = null;){
            sta = conn.createStatement();
            for (String s : sql.split(";\\s*\nend;|end;|;\n")) {
                if (!StringUtils.isNotEmpty((String)(s = s.trim()))) continue;
                if (s.toLowerCase().startsWith("execute block")) {
                    s = s + "; end;";
                }
                s = s.replace("^", ";");
                sta.execute(s);
                ++lWykonanychPolecen;
            }
            log.debug(String.format("%s : wykonano %s komend", skrypt, lWykonanychPolecen));
        }
    }
}

