/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator.dziennik;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import pl.topteam.dps.db.ScriptRepositoryUtils;
import pl.topteam.dps.db.generator.AbstractDatabaseCreationTest;

@RunWith(value=Parameterized.class)
public class CreateDatabaseTest
extends AbstractDatabaseCreationTest {
    public CreateDatabaseTest(Path skrypt) {
        super(skrypt);
    }

    private static Path database() {
        return CreateDatabaseTest.target().resolve("dziennik.h2.db");
    }

    @BeforeClass
    public static void setupNewDatabase() {
        File database = CreateDatabaseTest.database().toFile();
        if (database.exists()) {
            database.delete();
        }
        cp = JdbcConnectionPool.create((String)String.format("jdbc:h2:split:%s", CreateDatabaseTest.database().toString().replace(".h2.db", "")), (String)"sysdba", (String)"masterkey");
    }

    public static Collection<Path[]> schemaScripts() {
        return Arrays.asList({ScriptRepositoryUtils.dziennik_schema_extension().resolve("ustawienia.ddl")}, {ScriptRepositoryUtils.dziennik_schema().resolve("schema.ddl")}, {ScriptRepositoryUtils.dziennik_schema_extension().resolve("indeksy.ddl")});
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Path[]> parameters() {
        return CreateDatabaseTest.schemaScripts();
    }
}

