/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator.main;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import pl.topteam.dps.db.ScriptRepositoryUtils;
import pl.topteam.dps.db.generator.AbstractDatabaseCreationTest;

@RunWith(value=Parameterized.class)
public class CreateDatabaseTest
extends AbstractDatabaseCreationTest {
    public CreateDatabaseTest(Path skrypt) {
        super(skrypt);
    }

    private static Path database() {
        return CreateDatabaseTest.target().resolve("dps.h2.db").toAbsolutePath();
    }

    @BeforeClass
    public static void setupNewDatabase() {
        File database = CreateDatabaseTest.database().toFile();
        if (database.exists()) {
            database.delete();
        }
        cp = JdbcConnectionPool.create((String)("jdbc:h2:split:" + CreateDatabaseTest.database().toString().replace(".h2.db", "")), (String)"sysdba", (String)"masterkey");
    }

    public static Collection<Path[]> schemaScripts() {
        return Arrays.asList({ScriptRepositoryUtils.main_schema_extension().resolve("ustawienia.ddl")}, {ScriptRepositoryUtils.main_schema_extension().resolve("funkcje.ddl")}, {ScriptRepositoryUtils.main_schema().resolve("schema.ddl")}, {ScriptRepositoryUtils.main_schema_extension().resolve("triggery.ddl")}, {ScriptRepositoryUtils.main_schema_extension().resolve("indeksy.ddl")}, {ScriptRepositoryUtils.main_schema_extension().resolve("widoki.ddl")});
    }

    public static Collection<Path[]> dataScripts() {
        return Arrays.asList({ScriptRepositoryUtils.main_data().resolve("slowniki.sql")}, {ScriptRepositoryUtils.main_data().resolve("slowa_narzucone.sql")}, {ScriptRepositoryUtils.main_data().resolve("parametry_systemowe.sql")}, {ScriptRepositoryUtils.main_data().resolve("migracja_skrypty_nieuwzgledniane.sql")}, {ScriptRepositoryUtils.main_data().resolve("pracownik_startowy.sql")}, {ScriptRepositoryUtils.main_data().resolve("pracownik_startowy_uprawnienia.sql")}, {ScriptRepositoryUtils.main_data().resolve("quartz_data.sql")}, {ScriptRepositoryUtils.main_data().resolve("dane_poczatkowe.sql")});
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Path[]> parameters() {
        return new ImmutableList.Builder().addAll(CreateDatabaseTest.schemaScripts()).addAll(CreateDatabaseTest.dataScripts()).build();
    }
}

