/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.generator.main;

import com.google.common.collect.Ordering;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstMigrationTest {
    private static final Logger log = LoggerFactory.getLogger(FirstMigrationTest.class);
    private static Pattern SCRIPT_NAME_PATTERN = Pattern.compile("(\\d+)_(.*)\\.sql");
    private static SimpleDateFormat SCRIPT_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat OUT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Path SCRIPTS_PATH = Paths.get("db", "main", "schema-migration");
    private static Path GENERATED_FILE_PATH = Paths.get("db", "main", "data", "migracja_skrypty_nieuwzgledniane.sql");

    @Test
    public void createFirstMigrationScript() {
        Throwable throwable;
        File migrationFile = GENERATED_FILE_PATH.toFile();
        List scriptFiles = null;
        try {
            throwable = null;
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(SCRIPTS_PATH);){
                scriptFiles = Ordering.natural().sortedCopy(ds);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            throwable = null;
            try (FileWriter fileWriter = new FileWriter(migrationFile);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                bufferedWriter.write(String.format("-- skrypt wygenerowany automatycznie przez %s\n\n", this.getClass().getCanonicalName()));
                for (Path p : scriptFiles) {
                    Matcher m;
                    String script = p.getFileName().toString();
                    if (script.equals("bootstrap.sql") || !(m = SCRIPT_NAME_PATTERN.matcher(script)).matches()) continue;
                    log.debug(String.format("Migracja z pliku: %s", script));
                    bufferedWriter.write("INSERT INTO DATABASE_CHANGELOG(ID, APPLIED_AT, DESCRIPTION)");
                    bufferedWriter.newLine();
                    bufferedWriter.write(" VALUES ");
                    bufferedWriter.write(String.format("(%s, '%s', '%s%s');", m.group(1), OUT_DATE_FORMAT.format(SCRIPT_DATE_FORMAT.parse(m.group(1))), m.group(2).substring(0, 1).toUpperCase(), m.group(2).substring(1).replaceAll("_", " ")));
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

