/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.sql.DataSource;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectComparator;
import liquibase.structure.core.Column;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractSchemaCompareEngine {
    protected DatabaseObjectComparator dboComparator;
    private DataSource cpComparsion;
    private DataSource cpReference;
    private Predicate<Class<? extends DatabaseObject>> viewPredicate;

    @Before
    public void initialize() {
        this.dboComparator = new DatabaseObjectComparator();
        this.viewPredicate = new Predicate<Class<? extends DatabaseObject>>(){

            public boolean apply(Class<? extends DatabaseObject> t) {
                return t.isAssignableFrom(View.class);
            }
        };
    }

    @Before
    public void createDS() throws Exception {
        this.cpComparsion = this.createComparsionDS();
        Preconditions.checkNotNull((Object)this.cpComparsion);
        this.cpReference = this.createReferenceDS();
        Preconditions.checkNotNull((Object)this.cpReference);
    }

    protected DiffResult compareModels() throws SQLException, DatabaseException, LiquibaseException {
        DatabaseFactory dbf = DatabaseFactory.getInstance();
        Database referenceDatabase = dbf.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.cpReference.getConnection()));
        Database targetDatabase = dbf.findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(this.cpComparsion.getConnection()));
        SnapshotGeneratorFactory snapFactory = SnapshotGeneratorFactory.getInstance();
        DatabaseSnapshot referenceSnapshot = snapFactory.createSnapshot(referenceDatabase.getDefaultSchema(), referenceDatabase, new SnapshotControl(referenceDatabase));
        DatabaseSnapshot targetSnapshot = snapFactory.createSnapshot(targetDatabase.getDefaultSchema(), targetDatabase, new SnapshotControl(targetDatabase));
        CompareControl compareControl = new CompareControl(referenceSnapshot.getSnapshotControl().getTypesToInclude());
        return DiffGeneratorFactory.getInstance().compare(referenceSnapshot, targetSnapshot, compareControl);
    }

    @After
    public void shutdownConnectionPools() throws SQLException {
        if (this.cpComparsion != null) {
            if (this.cpComparsion instanceof JdbcConnectionPool) {
                ((JdbcConnectionPool)this.cpComparsion).dispose();
            }
            this.cpComparsion = null;
        }
        if (this.cpReference != null) {
            if (this.cpReference instanceof JdbcConnectionPool) {
                ((JdbcConnectionPool)this.cpReference).dispose();
            }
            this.cpReference = null;
        }
    }

    public abstract DataSource createComparsionDS() throws Exception;

    public abstract DataSource createReferenceDS() throws Exception;

    protected Set<? extends DatabaseObject> missingObjects(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        return diffResult.getMissingObjects(type, (Comparator)this.dboComparator);
    }

    protected Set<?> unexpectedObjects(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        return diffResult.getUnexpectedObjects(type, (Comparator)this.dboComparator);
    }

    protected Map<? extends DatabaseObject, ObjectDifferences> changedObjects(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        return diffResult.getChangedObjects(type, (Comparator)this.dboComparator);
    }

    protected boolean isView(Relation relation) {
        return this.viewPredicate.apply(relation.getClass());
    }

    protected List<Column> filterSetOfColumns(DiffResult diffResult, Set<?> columns) {
        final SortedSet missingTables = diffResult.getMissingObjects(Table.class, (Comparator)this.dboComparator);
        return FluentIterable.from(columns).transform((Function)new Function<Object, Column>(){

            public Column apply(Object o) {
                return (Column)o;
            }
        }).filter((Predicate)new Predicate<Column>(){

            public boolean apply(Column c) {
                Relation r = c.getRelation();
                return !missingTables.contains(r) && !AbstractSchemaCompareEngine.this.isView(r);
            }
        }).toList();
    }

    protected Map<Column, ObjectDifferences> filterSetOfColumns(DiffResult diffResult, Map<? extends DatabaseObject, ObjectDifferences> columns) {
        SortedSet missingTables = diffResult.getMissingObjects(Table.class, (Comparator)this.dboComparator);
        HashMap transformedMap = Maps.newHashMap();
        for (Map.Entry<? extends DatabaseObject, ObjectDifferences> entry : columns.entrySet()) {
            Column c = (Column)entry.getKey();
            Relation r = c.getRelation();
            if (missingTables.contains(r) || this.isView(r)) continue;
            transformedMap.put(c, entry.getValue());
        }
        return transformedMap;
    }
}

