/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Table;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.dps.db.migration.AbstractSchemaCompareEngine;

public abstract class AbstractSchemaCompareTest
extends AbstractSchemaCompareEngine {
    private static final Logger log = LoggerFactory.getLogger(AbstractSchemaCompareTest.class);
    private Predicate<Class<? extends DatabaseObject>> columnPredicate;
    private Predicate<Class<? extends DatabaseObject>> tablePredicate;
    private Predicate<Class<? extends DatabaseObject>> foreignKeyPredicate;

    @Override
    @Before
    public void initialize() {
        super.initialize();
        this.columnPredicate = new Predicate<Class<? extends DatabaseObject>>(){

            public boolean apply(Class<? extends DatabaseObject> t) {
                return t.isAssignableFrom(Column.class);
            }
        };
        this.tablePredicate = new Predicate<Class<? extends DatabaseObject>>(){

            public boolean apply(Class<? extends DatabaseObject> t) {
                return t.isAssignableFrom(Table.class);
            }
        };
        this.foreignKeyPredicate = new Predicate<Class<? extends DatabaseObject>>(){

            public boolean apply(Class<? extends DatabaseObject> t) {
                return t.isAssignableFrom(ForeignKey.class);
            }
        };
    }

    protected void printDiffReport(DiffResult diffResult) throws DatabaseException {
        log.info("Reference database: " + diffResult.getReferenceSnapshot().getDatabase());
        log.info("Comparison database: " + diffResult.getComparisonSnapshot().getDatabase());
        for (Class<? extends DatabaseObject> type : this.supportedChanges(diffResult)) {
            this.printMissing(diffResult, type);
            this.printUnexpected(diffResult, type);
            this.printChanged(diffResult, type);
        }
    }

    private List<Class<? extends DatabaseObject>> supportedChanges(DiffResult diffResult) {
        return FluentIterable.from((Iterable)diffResult.getCompareControl().getComparedTypes()).filter(Predicates.or((Predicate[])new Predicate[]{this.columnPredicate, this.foreignKeyPredicate, this.tablePredicate})).toSortedList((Comparator)new Comparator<Class<? extends DatabaseObject>>(){

            @Override
            public int compare(Class<? extends DatabaseObject> t1, Class<? extends DatabaseObject> t2) {
                return t1.getSimpleName().compareTo(t2.getSimpleName());
            }
        });
    }

    private String typeName(Class<? extends DatabaseObject> type) {
        return String.format("%s%s", type.getSimpleName().replaceAll("([A-Z])", " $1").trim(), "(s)");
    }

    private void printMissing(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        Set<? extends DatabaseObject> objects = this.missingObjects(diffResult, type);
        Optional changeType = FluentIterable.from(objects).first();
        if (changeType.isPresent()) {
            switch (changeType.orNull().getClass().getCanonicalName()) {
                case "liquibase.structure.core.Column": {
                    this.printMissingColumns(diffResult, objects);
                    break;
                }
                default: {
                    log.info(String.format("Missing %s:", this.typeName(type).toLowerCase()));
                    for (DatabaseObject databaseObject : objects) {
                        this.printSetObject(databaseObject);
                    }
                }
            }
        } else {
            log.info(String.format("Missing %s: none", this.typeName(type).toLowerCase()));
        }
    }

    private void printMissingColumns(DiffResult diffResult, Set<?> columns) {
        List<Column> _columns = this.filterSetOfColumns(diffResult, columns);
        log.info(String.format("Missing %s:%s", this.typeName(Column.class).toLowerCase(), _columns.isEmpty() ? " none" : ""));
        for (Column column : _columns) {
            this.printSetObject(column);
        }
    }

    private void printUnexpected(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        Set<?> objects = this.unexpectedObjects(diffResult, type);
        Optional changeType = FluentIterable.from(objects).first();
        if (changeType.isPresent()) {
            switch (changeType.orNull().getClass().getCanonicalName()) {
                case "liquibase.structure.core.Column": {
                    this.printUnexpectedColumns(diffResult, objects);
                    break;
                }
                default: {
                    log.info(String.format("Unexpected %s:", this.typeName(type).toLowerCase()));
                    for (Object object : objects) {
                        this.printSetObject(object);
                    }
                }
            }
        } else {
            log.info(String.format("Unexpected %s: none", this.typeName(type).toLowerCase()));
        }
    }

    private void printUnexpectedColumns(DiffResult diffResult, Set<?> columns) {
        List<Column> _columns = this.filterSetOfColumns(diffResult, columns);
        log.info(String.format("Unexpected %s:%s", this.typeName(Column.class).toLowerCase(), _columns.isEmpty() ? " none" : ""));
        for (Column column : _columns) {
            this.printSetObject(column);
        }
    }

    private void printChanged(DiffResult diffResult, Class<? extends DatabaseObject> type) {
        Map<? extends DatabaseObject, ObjectDifferences> objects = this.changedObjects(diffResult, type);
        Optional changeType = FluentIterable.from(objects.keySet()).first();
        if (changeType.isPresent()) {
            switch (changeType.orNull().getClass().getCanonicalName()) {
                case "liquibase.structure.core.Column": {
                    this.printChangedColumns(diffResult, objects);
                    break;
                }
                default: {
                    log.info(String.format("Changed %s:", this.typeName(type).toLowerCase()));
                    for (Map.Entry<? extends DatabaseObject, ObjectDifferences> object : objects.entrySet()) {
                        this.printSetObject(object);
                    }
                }
            }
        } else {
            log.info(String.format("Changed %s: none", this.typeName(type).toLowerCase()));
        }
    }

    private void printChangedColumns(DiffResult diffResult, Map<? extends DatabaseObject, ObjectDifferences> objects) {
        Map<Column, ObjectDifferences> _columns = this.filterSetOfColumns(diffResult, objects);
        log.info(String.format("Changed %s:%s", this.typeName(Column.class).toLowerCase(), _columns.isEmpty() ? " none" : ""));
        for (Map.Entry<? extends DatabaseObject, ObjectDifferences> object : objects.entrySet()) {
            this.printSetObject(object);
        }
    }

    private void printSetObject(Object object) {
        log.info(String.format("\t%s", object));
    }

    private void printSetObject(Map.Entry<? extends DatabaseObject, ObjectDifferences> object) {
        if (object.getValue().hasDifferences()) {
            log.info(String.format("\t%s", object.getKey()));
            for (Difference difference : object.getValue().getDifferences()) {
                log.info(String.format("\t   %s", difference.toString()));
            }
        }
    }
}

