/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DDLMappers {
    private static Splitter SQL_COMMAND_SPLITTER = Splitter.on((String)";").trimResults();
    private static Splitter STANDARD_SPLITTER = Splitter.on((Pattern)Pattern.compile("\r?\n"));
    private static Joiner STANDARD_JOINER = Joiner.on((String)"\n");
    private static final Pattern ALTER_TABLE_PATTERN = Pattern.compile("ALTER TABLE (.*?)\r?\n\t+ADD CONSTRAINT (.*?) FOREIGN KEY.*", 32);
    private static final Pattern CREATE_TABLE_PATTERN = Pattern.compile("CREATE TABLE (.*?)\r?\n.*", 32);

    public static Map<String, String> tables(String targetDDL) {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(DDLMappers.clearDDL(targetDDL)).filter((Predicate)new Predicate<String>(){

            public boolean apply(String ddl) {
                return CREATE_TABLE_PATTERN.matcher(ddl).matches();
            }
        }), (Function)new Function<String, String>(){

            public String apply(String ddl) {
                Matcher m = CREATE_TABLE_PATTERN.matcher(ddl);
                m.find();
                return m.group(1);
            }
        });
    }

    public static Map<String, String> foreignKeyContraints(String targetDDL) {
        return Maps.uniqueIndex((Iterable)FluentIterable.from(DDLMappers.clearDDL(targetDDL)).filter((Predicate)new Predicate<String>(){

            public boolean apply(String ddl) {
                return ALTER_TABLE_PATTERN.matcher(ddl).matches();
            }
        }), (Function)new Function<String, String>(){

            public String apply(String line) {
                Matcher m = ALTER_TABLE_PATTERN.matcher(line);
                m.find();
                return m.group(2);
            }
        });
    }

    private static Iterable<String> clearDDL(String targetDDL) {
        return SQL_COMMAND_SPLITTER.split((CharSequence)STANDARD_JOINER.join((Iterable)FluentIterable.from((Iterable)STANDARD_SPLITTER.split((CharSequence)targetDDL)).filter((Predicate)new Predicate<String>(){

            public boolean apply(String line) {
                return StringUtils.isNotEmpty((CharSequence)line) && !line.startsWith("/*");
            }
        })));
    }
}

