/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration.main;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import liquibase.diff.DiffResult;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.h2.jdbcx.JdbcConnectionPool;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.dps.db.ScriptRepositoryUtils;
import pl.topteam.dps.db.generator.AbstractDDLExporterTest;
import pl.topteam.dps.db.generator.SQLExecutor;
import pl.topteam.dps.db.migration.AbstractSchemaCompareEngine;
import pl.topteam.dps.db.migration.DDLMappers;

public class MigrationFileTest
extends AbstractSchemaCompareEngine {
    private static Logger log = LoggerFactory.getLogger(MigrationFileTest.class);
    private String targetDDL;

    @Override
    public DataSource createComparsionDS() throws Exception {
        JdbcConnectionPool cpComparsion = JdbcConnectionPool.create((String)"jdbc:h2:mem:schema_compare_db_old", (String)"sysdba", (String)"masterkey");
        try (Connection conn = cpComparsion.getConnection();){
            for (Path[] s : ImmutableList.of((Object)new Path[]{ScriptRepositoryUtils.main_schema_extension().resolve("ustawienia.ddl")}, (Object)new Path[]{ScriptRepositoryUtils.main_schema().resolve("schema.ddl")})) {
                SQLExecutor.executeSql(conn, s[0].toAbsolutePath());
            }
        }
        return cpComparsion;
    }

    @Override
    public DataSource createReferenceDS() throws Exception {
        JdbcConnectionPool cpReference = JdbcConnectionPool.create((String)"jdbc:h2:mem:schema_compare_db_new", (String)"sysdba", (String)"masterkey");
        try (Connection conn = cpReference.getConnection();){
            this.targetDDL = AbstractDDLExporterTest.createDDL(Paths.get("db", "main", "diagram.erm"));
            SQLExecutor.executeSql(conn, "main - new - database", this.targetDDL);
        }
        return cpReference;
    }

    @Test
    public void newMigrationFile() throws IOException, DatabaseException, SQLException, LiquibaseException {
        log.info("opis migracji: ");
        String opis = null;
        try (BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));){
            opis = bufferRead.readLine();
            opis = opis.replaceAll("\\s", "_");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isNotEmpty((CharSequence)opis)) {
            VelocityEngine ve = new VelocityEngine();
            Properties p = new Properties();
            p.setProperty("resource.loader", "class");
            p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            ve.init(p);
            Template t = ve.getTemplate("pl/topteam/dps/db/generator/templateMigrationScript.vm", Charsets.UTF_8.name());
            VelocityContext context = new VelocityContext();
            context.put("opis", (Object)opis);
            DiffResult diffResult = this.compareModels();
            log.info(this.targetDDL);
            context.put("missingTables", this.missingObjects(diffResult, Table.class));
            context.put("tablesDDL", DDLMappers.tables(this.targetDDL));
            context.put("missingColumns", this.filterSetOfColumns(diffResult, this.missingObjects(diffResult, Column.class)));
            context.put("missingForeignKeys", this.missingObjects(diffResult, ForeignKey.class));
            context.put("foreignKeysDDL", DDLMappers.foreignKeyContraints(this.targetDDL));
            context.put("changedTables", this.changedObjects(diffResult, Table.class));
            context.put("changedColumns", this.filterSetOfColumns(diffResult, this.changedObjects(diffResult, Column.class)));
            context.put("changedForeignKeys", this.changedObjects(diffResult, ForeignKey.class));
            context.put("unexpextedTables", this.unexpectedObjects(diffResult, Table.class));
            context.put("unexpextedColumns", this.filterSetOfColumns(diffResult, this.unexpectedObjects(diffResult, Column.class)));
            context.put("unexpextedForeignKeys", this.unexpectedObjects(diffResult, ForeignKey.class));
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            LocalDateTime localDateTime = LocalDateTime.now();
            DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHmss");
            String fileName = String.format("%s_migracja_%s.sql", dateFormatter.print((ReadablePartial)localDateTime), opis);
            Files.write((CharSequence)writer.toString(), (File)ScriptRepositoryUtils.main_schema_migration().resolve(fileName).toFile(), (Charset)Charsets.UTF_8);
            log.info(String.format("Utworzono plik: %s", fileName));
        } else {
            log.info("Nie podano opsu pliku. Spr\u00f3buj jeszcze raz");
        }
    }
}

