/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration.main;

import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Ordering;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.topteam.dps.db.ScriptRepositoryUtils;
import pl.topteam.dps.db.generator.SQLExecutor;

public class MigrationTest {
    private static Logger log = LoggerFactory.getLogger(MigrationTest.class);
    private static final String BACKUP_FILE_NAME = "kopiaBazyGlownej20120801.zip";
    private static final Path BACKUP_SCRIPT_PATH = ScriptRepositoryUtils.main_old_test().resolve("kopiaBazyGlownej20120801.zip");
    private static final String BACKUP_CLEAR_PASSWORD = "ttdps";
    private static Path SCRIPTS_PATH = Paths.get("db", "main", "schema-migration");
    @Rule
    public TemporaryFolder tmpWorkingDir = new TemporaryFolder();
    private File databaseFile;
    private List<Path> scriptFiles;

    @Before
    public void decryptZipDatabaseBackup() throws ZipException, IOException {
        ZipFile eZipFile = new ZipFile(BACKUP_SCRIPT_PATH.toFile());
        if (eZipFile.isEncrypted()) {
            eZipFile.setPassword(BACKUP_CLEAR_PASSWORD);
        }
        eZipFile.extractAll(this.tmpWorkingDir.getRoot().getAbsolutePath());
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(Paths.get(this.tmpWorkingDir.getRoot().getAbsolutePath(), new String[0]));){
            for (Path fp : ds) {
                this.databaseFile = fp.toFile();
            }
        }
        try {
            ds = Files.newDirectoryStream(SCRIPTS_PATH);
            var3_4 = null;
            try {
                this.scriptFiles = Ordering.natural().sortedCopy(ds);
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var3_4 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable x2) {
                            var3_4.addSuppressed(x2);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void podnoszenieStarejBazyDoAktualnejWersji() throws IOException, SQLException {
        JdbcConnectionPool cp = JdbcConnectionPool.create((String)String.format("jdbc:h2:file:%s;MVCC=TRUE", this.databaseFile.getAbsolutePath().replace(".h2.db", "")), (String)"sysdba", (String)"masterkey");
        Connection conn = cp.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT ID FROM DATABASE_CHANGELOG ORDER BY ID DESC LIMIT 1");
        final String lastExecutedScriptId = rs.next() ? rs.getString(1) : "";
        final Ordering naturalStringOrder = Ordering.natural();
        final Splitter scriptNameSplitter = Splitter.on((char)'_');
        Predicate<Path> nonExecutedScriptPredicate = new Predicate<Path>(){

            public boolean apply(Path script) {
                String scriptName = script.toFile().getName();
                if (!scriptName.equals("bootstrap.sql")) {
                    String id = (String)FluentIterable.from((Iterable)scriptNameSplitter.split((CharSequence)scriptName)).first().get();
                    return naturalStringOrder.compare((Object)id, (Object)lastExecutedScriptId) > 0;
                }
                return false;
            }
        };
        Path curr = null;
        Iterator i$ = FluentIterable.from(this.scriptFiles).filter((Predicate)nonExecutedScriptPredicate).iterator();
        while (i$.hasNext()) {
            Path s;
            curr = s = (Path)i$.next();
            try {
                SQLExecutor.executeSql(conn, curr);
                log.info(String.format("Executing %s ... done", curr.toFile().getName()));
            }
            catch (IOException | SQLException e) {
                log.info(String.format("Executing %s ... error", curr.toFile().getName()));
                throw e;
            }
        }
    }
}

