/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.migration.main;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.Ignore;
import org.junit.Test;
import pl.topteam.dps.db.generator.AbstractDDLExporterTest;
import pl.topteam.dps.db.generator.SQLExecutor;
import pl.topteam.dps.db.generator.main.CreateDatabaseTest;
import pl.topteam.dps.db.migration.AbstractSchemaCompareTest;

public class SchemaCompareTest
extends AbstractSchemaCompareTest {
    @Override
    public DataSource createComparsionDS() throws Exception {
        JdbcConnectionPool cpComparsion = JdbcConnectionPool.create((String)"jdbc:h2:mem:schema_compare_db_old", (String)"sysdba", (String)"masterkey");
        try (Connection conn = cpComparsion.getConnection();){
            for (Path[] s : CreateDatabaseTest.schemaScripts()) {
                SQLExecutor.executeSql(conn, s[0].toAbsolutePath());
            }
        }
        return cpComparsion;
    }

    @Override
    public DataSource createReferenceDS() throws Exception {
        JdbcConnectionPool cpReference = JdbcConnectionPool.create((String)"jdbc:h2:mem:schema_compare_db_new", (String)"sysdba", (String)"masterkey");
        try (Connection conn = cpReference.getConnection();){
            SQLExecutor.executeSql(conn, "main - new - database", AbstractDDLExporterTest.createDDL(Paths.get("db", "main", "diagram.erm")));
        }
        return cpReference;
    }

    @Test
    @Ignore(value="test tylko sprawdza wizualnie poprawno\u015b\u0107 dzia\u0142ania; automatyczne wywo\u0142anie jest niewskazane")
    public void test() throws SQLException, DatabaseException, LiquibaseException {
        this.printDiffReport(this.compareModels());
    }
}

