/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.dbeaver;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pl.topteam.dps.dps_wersje_migration.dbeaver.LayoutsTableRelationsTest;
import pl.topteam.dps.dps_wersje_migration.dbeaver.LayoutsTableTest;

public class LayoutERDDiagramGenTest {
    private static final Logger log = LoggerFactory.getLogger(LayoutERDDiagramGenTest.class);
    private Multimap<String, String> tableLayoutMap;
    private BiMap<String, String> tablesIdsMap;
    private List<LayoutsTableRelationsTest.EntityRelation> tablesRelations;

    @Before
    public void setupData() throws ParserConfigurationException, SAXException, IOException {
        Path dataPath = Paths.get("..", "dps-wersje", "db");
        LayoutsTableTest.SchemaScriptLineProcessor lineProcessor = new LayoutsTableTest.SchemaScriptLineProcessor();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dataPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return !entry.toFile().isDirectory();
            }
        });){
            for (Path p : ds) {
                String fileName = p.getFileName().toString();
                if (!fileName.startsWith("db_DPS") || !fileName.endsWith("architect")) continue;
                lineProcessor.setLayout(p.getFileName().toString());
                com.google.common.io.Files.readLines((File)p.toFile(), (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
            }
            this.tableLayoutMap = lineProcessor.getTableLayoutMap();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path ermDiagram = Paths.get("db", "main", "schema", "all.erd");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        LayoutsTableRelationsTest.ERDDiagramHandler eRDDiagramHandler = new LayoutsTableRelationsTest.ERDDiagramHandler();
        saxParser.parse(ermDiagram.toFile(), (DefaultHandler)eRDDiagramHandler);
        this.tablesRelations = eRDDiagramHandler.getTableRelations();
        this.tablesIdsMap = eRDDiagramHandler.getTableIdsMap();
    }

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void genCategoryTest() throws IOException {
        VelocityEngine ve = new VelocityEngine();
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        ve.init(p);
        Template t = ve.getTemplate("pl/topteam/dps/dps_wersje_migration/dbeaver/diagramTemplate.vm", Charsets.UTF_8.name());
        VelocityContext context = new VelocityContext();
        for (String layout : this.tableLayoutMap.keySet()) {
            final List tables = Ordering.natural().sortedCopy((Iterable)this.tableLayoutMap.get((Object)layout));
            context.put("tables", (Object)tables);
            context.put("tablesOldReverseIdsMap", (Object)this.tablesIdsMap.inverse());
            context.put("tablesNewIdsMap", (Object)Maps.toMap((Iterable)tables, (Function)new Function<String, Integer>(){

                public Integer apply(String t) {
                    return tables.indexOf(t);
                }
            }));
            ImmutableList tablesOldIds = FluentIterable.from((Iterable)tables).transform((Function)new Function<String, String>(){

                public String apply(String input) {
                    return (String)LayoutERDDiagramGenTest.this.tablesIdsMap.get((Object)input);
                }
            }).toList();
            ImmutableSet.Builder relations = new ImmutableSet.Builder();
            relations.addAll((Iterable)FluentIterable.from(this.tablesRelations).filter((Predicate)new Predicate<LayoutsTableRelationsTest.EntityRelation>((Collection)tablesOldIds){
                final /* synthetic */ Collection val$tablesOldIds;
                {
                    this.val$tablesOldIds = collection;
                }

                public boolean apply(LayoutsTableRelationsTest.EntityRelation enr) {
                    return this.val$tablesOldIds.contains(enr.getPkRef()) && this.val$tablesOldIds.contains(enr.getFkRef());
                }
            }));
            context.put("relations", (Object)relations.build());
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            com.google.common.io.Files.write((CharSequence)writer.toString(), (File)Paths.get("db", "main", "schema", String.format("%s.erd", layout)).toFile(), (Charset)Charsets.UTF_8);
            log.info(String.format("%s.erd", layout));
        }
    }
}

