/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.dbeaver;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LayoutsTableRelationsTest {
    private static final Logger log = LoggerFactory.getLogger(LayoutsTableRelationsTest.class);

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void printTableIDsTest() throws ParserConfigurationException, SAXException, IOException {
        Path ermDiagram = Paths.get("db", "main", "schema", "all.erd");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ERDDiagramHandler eRMDiagramHandler = new ERDDiagramHandler();
        saxParser.parse(ermDiagram.toFile(), (DefaultHandler)eRMDiagramHandler);
        BiMap<String, String> tableMap = eRMDiagramHandler.getTableIdsMap();
        TreeSet tableNames = new TreeSet(tableMap.keySet());
        log.info("IDs:");
        for (String table : tableNames) {
            log.info(String.format("%s : %s", table, tableMap.get((Object)table)));
        }
        Joiner lTableJoiner = Joiner.on((char)',').skipNulls();
        final BiMap tableInverseMap = tableMap.inverse();
        Multimap<String, EntityRelation> tableRelations = eRMDiagramHandler.getTableRelationsMap();
        log.info("RELATIONS:");
        for (String table : tableNames) {
            log.info(String.format("%s : %s", table, lTableJoiner.join((Iterable)FluentIterable.from((Iterable)tableRelations.get((Object)table)).transform((Function)new Function<EntityRelation, String>(){

                public String apply(EntityRelation relation) {
                    return (String)tableInverseMap.get((Object)relation.getFkRef());
                }
            }))));
        }
    }

    public static class EntityRelation
    implements Comparable<EntityRelation> {
        private String name;
        private String pkRef;
        private String fkRef;

        public EntityRelation(String name, String pkRef, String fkRef) {
            this.name = name;
            this.pkRef = pkRef;
            this.fkRef = fkRef;
        }

        public String getName() {
            return this.name;
        }

        public String getPkRef() {
            return this.pkRef;
        }

        public String getFkRef() {
            return this.fkRef;
        }

        @Override
        public int compareTo(EntityRelation o) {
            return this.name.compareTo(o.name);
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that == null) {
                return false;
            }
            if (this.getClass() != that.getClass()) {
                return false;
            }
            EntityRelation other = (EntityRelation)that;
            return (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName())) && (this.getPkRef() == null ? other.getPkRef() == null : this.getPkRef().equals(other.getPkRef())) && (this.getFkRef() == null ? other.getFkRef() == null : this.getFkRef().equals(other.getFkRef()));
        }
    }

    static class ERDDiagramHandler
    extends DefaultHandler {
        private ImmutableBiMap.Builder<String, String> tableIdsMapBuilder = new ImmutableBiMap.Builder();
        private ImmutableMultimap.Builder<String, EntityRelation> tableRelationsBuilder = new ImmutableMultimap.Builder();
        private ImmutableBiMap<String, String> tableIdsMap = null;
        private ImmutableBiMap<String, String> tableReverseIdMap = null;
        private ImmutableList.Builder<EntityRelation> tableRelations = new ImmutableList.Builder();
        private ImmutableMultimap<String, EntityRelation> tableRelationsMap = null;

        ERDDiagramHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "entity": {
                    this.tableIdsMapBuilder.put((Object)attributes.getValue("name"), (Object)attributes.getValue("id"));
                    break;
                }
                case "relation": {
                    EntityRelation enr = new EntityRelation(attributes.getValue("name"), attributes.getValue("pk-ref"), attributes.getValue("fk-ref"));
                    this.tableRelations.add((Object)enr);
                    this.tableRelationsBuilder.put(this.tableReverseIdMap.get((Object)attributes.getValue("pk-ref")), (Object)enr);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "entities": {
                    this.tableIdsMap = this.tableIdsMapBuilder.build();
                    this.tableReverseIdMap = this.tableIdsMap.inverse();
                    break;
                }
                case "relations": {
                    this.tableRelationsMap = this.tableRelationsBuilder.build();
                }
            }
        }

        public BiMap<String, String> getTableIdsMap() {
            return this.tableIdsMap;
        }

        public List<EntityRelation> getTableRelations() {
            return this.tableRelations.build();
        }

        public Multimap<String, EntityRelation> getTableRelationsMap() {
            return this.tableRelationsMap;
        }
    }
}

