/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.dbeaver;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutsTableTest {
    private static final Logger log = LoggerFactory.getLogger(LayoutsTableTest.class);
    private static Pattern TABLE_NAME_PATTERN = Pattern.compile("\\s*<table.*physicalName=\"(.+?)\" remarks.*");

    @Test
    @Ignore(value="wzorzec zaakceptowany")
    public void patternMatch() {
        String testLine = "<table id=\"TAB1\" populated=\"true\" UUID=\"bf1ee5bb-c6a2-4254-9357-1ce736659e38\" name=\"FAKTURA\" objectType=\"TABLE\" physicalName=\"FAKTURA\" remarks=\"\" >";
        Matcher m = TABLE_NAME_PATTERN.matcher(testLine);
        Assert.assertTrue((String)"Brak dopasowania wzorca", (boolean)m.matches());
        log.info(m.group(1).trim());
    }

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void printLayoutsTable() throws IOException {
        Path dataPath = Paths.get("..", "dps-wersje", "db");
        List scriptFiles = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dataPath);){
            scriptFiles = Ordering.natural().sortedCopy(ds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SchemaScriptLineProcessor lineProcessor = new SchemaScriptLineProcessor();
        for (Path p : scriptFiles) {
            String fileName = p.getFileName().toString();
            if (!fileName.startsWith("db_DPS") || !fileName.endsWith("architect")) continue;
            lineProcessor.setLayout(fileName);
            com.google.common.io.Files.readLines((File)p.toFile(), (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
        }
        Multimap<String, String> layoutMap = lineProcessor.getTableLayoutMap();
        TreeSet layouts = new TreeSet(layoutMap.keySet());
        Joiner lTableJoiner = Joiner.on((char)',').skipNulls();
        for (String l : layouts) {
            log.info(String.format("%s : %s", l, lTableJoiner.join((Iterable)layoutMap.get((Object)l))));
        }
    }

    static class SchemaScriptLineProcessor
    implements LineProcessor<Integer> {
        private int lTabel = 0;
        private Splitter lNameSplitter = Splitter.on((char)'.');
        private String layout = "";
        private ImmutableMultimap.Builder<String, String> mapBuilder = new ImmutableMultimap.Builder();

        SchemaScriptLineProcessor() {
        }

        public boolean processLine(String line) throws IOException {
            Matcher m = TABLE_NAME_PATTERN.matcher(line);
            if (m.matches()) {
                ++this.lTabel;
                this.mapBuilder.put((Object)this.layout, (Object)m.group(1).trim());
            }
            return true;
        }

        public Integer getResult() {
            return this.lTabel;
        }

        public void setLayout(String layout) {
            this.layout = ((String)FluentIterable.from((Iterable)this.lNameSplitter.split((CharSequence)layout)).first().get()).substring("db_DPS_".length());
        }

        public Multimap<String, String> getTableLayoutMap() {
            return this.mapBuilder.build();
        }
    }
}

