/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.erm;

import com.google.common.base.Charsets;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pl.topteam.dps.dps_wersje_migration.erm.DiagramERMLayoutsTableTest;
import pl.topteam.dps.dps_wersje_migration.erm.DiagramERMTableIdsTest;

public class DiagramERMCategoryGenTest {
    private static final Logger log = LoggerFactory.getLogger(DiagramERMCategoryGenTest.class);
    private Multimap<String, String> tableLayoutMap;
    private Map<String, String> tableIdsMap;

    @Before
    public void setupData() throws ParserConfigurationException, SAXException, IOException {
        Path dataPath = Paths.get("..", "dps-wersje", "db");
        List scriptFiles = null;
        try (DirectoryStream<Path> ds = null;){
            ds = Files.newDirectoryStream(dataPath);
            scriptFiles = Ordering.natural().sortedCopy(ds);
        }
        DiagramERMLayoutsTableTest.SchemaScriptLineProcessor lineProcessor = new DiagramERMLayoutsTableTest.SchemaScriptLineProcessor();
        for (Path p : scriptFiles) {
            String fileName = p.getFileName().toString();
            if (!fileName.startsWith("db_DPS") || fileName.contains("zalecenia_leka") || !fileName.endsWith("architect")) continue;
            lineProcessor.setLayout(fileName);
            com.google.common.io.Files.readLines((File)p.toFile(), (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
        }
        this.tableLayoutMap = lineProcessor.getTableLayoutMap();
        Path ermDiagram = Paths.get("db", "main", "diagram.erm");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        DiagramERMTableIdsTest.ERMDiagramHandler eRMDiagramHandler = new DiagramERMTableIdsTest.ERMDiagramHandler();
        saxParser.parse(ermDiagram.toFile(), (DefaultHandler)eRMDiagramHandler);
        this.tableIdsMap = eRMDiagramHandler.getTableIdsMap();
    }

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void genCategoryTest() {
        VelocityEngine ve = new VelocityEngine();
        Properties p = new Properties();
        p.setProperty("resource.loader", "class");
        p.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        ve.init(p);
        Template t = ve.getTemplate("pl/topteam/dps/dps_wersje_migration/erm/categoryTemplate.vm", Charsets.UTF_8.name());
        VelocityContext context = new VelocityContext();
        context.put("layoutNames", new TreeSet(this.tableLayoutMap.keySet()));
        context.put("tableLayoutMap", this.tableLayoutMap);
        context.put("tableIdsMap", this.tableIdsMap);
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        log.info(writer.toString());
    }
}

