/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.erm;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Ignore;
import org.junit.Test;

public class DiagramERMLayoutsTableTest {
    private static Pattern TABLE_NAME_PATTERN = Pattern.compile("\\s*<table id=\"(.+?)\".*name=\"(.+?)\".*");
    private static Pattern TABLE_LINKED_PATTERN = Pattern.compile("\\s*<table-pane table-ref=\"(.+?)\".*dashed=\"(.+?)\".*");

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void printLayoutsTable() throws IOException {
        Path dataPath = Paths.get("..", "dps-wersje", "db");
        List scriptFiles = null;
        try (DirectoryStream<Path> ds = null;){
            ds = Files.newDirectoryStream(dataPath);
            scriptFiles = Ordering.natural().sortedCopy(ds);
        }
        SchemaScriptLineProcessor lineProcessor = new SchemaScriptLineProcessor();
        for (Path p : scriptFiles) {
            String fileName = p.getFileName().toString();
            if (!fileName.startsWith("db_DPS") || !fileName.endsWith("architect")) continue;
            lineProcessor.setLayout(fileName);
            com.google.common.io.Files.readLines((File)p.toFile(), (Charset)Charsets.UTF_8, (LineProcessor)lineProcessor);
        }
        Multimap<String, String> layoutMap = lineProcessor.getTableLayoutMap();
        Multimap<String, String> linkedLayoutMap = lineProcessor.getLinkedTableLayoutMap();
        TreeSet layouts = new TreeSet(layoutMap.keySet());
        Joiner lTableJoiner = Joiner.on((char)',').skipNulls();
        for (String l : layouts) {
            System.out.println(String.format("%s:\n\tt: %s\n\tlinked: %s", l, lTableJoiner.join((Iterable)layoutMap.get((Object)l)), lTableJoiner.join((Iterable)linkedLayoutMap.get((Object)l))));
        }
    }

    static class SchemaScriptLineProcessor
    implements LineProcessor<Integer> {
        private int lTabel = 0;
        private Splitter lNameSplitter = Splitter.on((char)'.');
        private String layout = "";
        private Map<String, String> tableIDsCache = Maps.newHashMap();
        private HashMultimap<String, String> tableMap = HashMultimap.create();
        private HashMultimap<String, String> linkedTableMap = HashMultimap.create();

        SchemaScriptLineProcessor() {
        }

        public boolean processLine(String line) throws IOException {
            Matcher m = TABLE_NAME_PATTERN.matcher(line);
            if (m.matches()) {
                ++this.lTabel;
                String _tname = m.group(2).trim();
                this.tableIDsCache.put(m.group(1), _tname);
                this.tableMap.put((Object)this.layout, (Object)_tname);
            }
            if ((m = TABLE_LINKED_PATTERN.matcher(line)).matches() && m.group(2).equals("true")) {
                this.linkedTableMap.put((Object)this.layout, (Object)this.tableIDsCache.get(m.group(1)));
            }
            return true;
        }

        public Integer getResult() {
            return this.lTabel;
        }

        public void setLayout(String layout) {
            this.tableIDsCache.clear();
            this.layout = ((String)FluentIterable.from((Iterable)this.lNameSplitter.split((CharSequence)layout)).first().get()).substring("db_DPS_".length());
        }

        public Multimap<String, String> getTableLayoutMap() {
            return this.tableMap;
        }

        public Multimap<String, String> getLinkedTableLayoutMap() {
            return this.linkedTableMap;
        }
    }
}

