/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.erm;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DiagramERMTableIdsTest {
    private static final Logger log = LoggerFactory.getLogger(DiagramERMTableIdsTest.class);

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void printTableIDsTest() throws ParserConfigurationException, SAXException, IOException {
        Path ermDiagram = Paths.get("db", "main", "diagram.erm");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        ERMDiagramHandler eRMDiagramHandler = new ERMDiagramHandler();
        saxParser.parse(ermDiagram.toFile(), (DefaultHandler)eRMDiagramHandler);
        Map<String, String> tableMap = eRMDiagramHandler.getTableIdsMap();
        TreeSet<String> tableNames = new TreeSet<String>(tableMap.keySet());
        for (String table : tableNames) {
            log.info(String.format("%s : %s", table, tableMap.get(table)));
        }
    }

    static class ERMDiagramHandler
    extends DefaultHandler {
        boolean isTable = false;
        boolean isColumns = false;
        String tableID = null;
        String tablePName = null;
        String qName = null;
        private Map<String, String> tableIdsMap = Maps.newHashMap();

        ERMDiagramHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "table": {
                    this.isTable = true;
                    this.tableID = null;
                    this.tablePName = null;
                    break;
                }
                case "columns": {
                    this.isColumns = true;
                    break;
                }
                default: {
                    if (!this.isTable) break;
                    this.qName = qName;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (qName) {
                case "table": {
                    this.isTable = false;
                    break;
                }
                case "columns": {
                    this.isColumns = false;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String tekst = new String(ch, start, length);
            if (this.isTable && !this.isColumns && this.qName != null) {
                switch (this.qName) {
                    case "id": {
                        if (this.tableID != null) break;
                        this.tableID = tekst;
                        this.fillTableMap();
                        break;
                    }
                    case "physical_name": {
                        if (this.tablePName != null) break;
                        this.tablePName = tekst;
                        this.fillTableMap();
                    }
                }
            }
        }

        private void fillTableMap() {
            if (this.tableID != null && this.tablePName != null) {
                this.tableIdsMap.put(this.tablePName, this.tableID);
            }
        }

        public Map<String, String> getTableIdsMap() {
            return this.tableIdsMap;
        }
    }
}

