/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.dps_wersje_migration.erm;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLScriptTest {
    private static final Logger log = LoggerFactory.getLogger(SQLScriptTest.class);

    private static Path rename(Path filePath, String newName) throws IOException {
        return Files.move(filePath, filePath.resolveSibling(newName), new CopyOption[0]);
    }

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void renameDataScripts() throws IOException {
        Path dataPath = Paths.get("db", "main", "data");
        List scriptFiles = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dataPath);){
            scriptFiles = Ordering.natural().sortedCopy(ds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Path p : scriptFiles) {
            String fileName = p.getFileName().toString();
            if (!fileName.startsWith("DPS_")) continue;
            log.info(String.format("Renaming %s", p.toString()));
            SQLScriptTest.rename(p, fileName.replace("DPS_", ""));
        }
    }

    @Test
    @Ignore(value="migracja zosta\u0142a przeprowadzona")
    public void renameSchemaScripts() throws IOException {
        Path dataPath = Paths.get("db", "main", "schema");
        List scriptFiles = null;
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dataPath);){
            scriptFiles = Ordering.natural().sortedCopy(ds);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Path p : scriptFiles) {
            String fileName = p.getFileName().toString();
            if (!fileName.startsWith("DPS_tabele_")) continue;
            log.info(String.format("Renaming %s", p.toString()));
            SQLScriptTest.rename(p, fileName.replace("DPS_tabele_", ""));
        }
    }
}

