
/* Create Tables */

CREATE TABLE PUBLIC.BAZYL_LEK
(
	ID IDENTITY NOT NULL,
	DAWKA varchar(42),
	NAZWA varchar(120) NOT NULL,
	OPAKOWANIE_JEDNOSTKA_POJEMNOSCI varchar(50) NOT NULL,
	POSTAC varchar(32) NOT NULL,
	CONSTRAINT CONSTRAINT_C PRIMARY KEY (ID)
);


CREATE TABLE PUBLIC.BAZYL_LEK_POSTAC
(
	KOD_BAZYL bigint NOT NULL,
	LEK_ID bigint NOT NULL,
	PRODUCENT_ID bigint NOT NULL,
	DOP_OBROT_POLSKA boolean,
	OPAKOWANIE_ILOSC decimal(10,2) NOT NULL,
	OPAKOWANIE_OPIS_BAZYL varchar(42) NOT NULL,
	USUNIETY boolean DEFAULT 'FALSE' NOT NULL,
	WERSJA date NOT NULL,
	CONSTRAINT BAZYL_LEK_POSTAC_PK PRIMARY KEY (KOD_BAZYL)
);


CREATE TABLE PUBLIC.BAZYL_ODPLATNOSC
(
	KOD_BAZYL bigint NOT NULL,
	KOD_EAN13 bigint NOT NULL,
	ATC varchar(50),
	KATEGORIA_DOST varchar(50) NOT NULL,
	KOD_BIL bigint NOT NULL,
	WLR boolean,
	CONSTRAINT BAZYL_ODPLATNOSC_PK PRIMARY KEY (KOD_BAZYL)
);


CREATE TABLE PUBLIC.BAZYL_ODPLATNOSC_SKLADNIK
(
	ID IDENTITY NOT NULL,
	KOD_BAZYL bigint NOT NULL,
	UPRAWNIENIE varchar(50) NOT NULL,
	SPOSOB_OBLICZENIA varchar(50),
	CENA_DETAL decimal(10,2),
	CENA_LIMIT decimal(10,2),
	DOPL_PONAD_LIMIT decimal(10,2),
	DOPLATA_NFZ decimal(10,2),
	MAX_ZAPLATA decimal(10,2),
	DOKUMENT varchar(100),
	CONSTRAINT CONSTRAINT_5 PRIMARY KEY (ID)
);


CREATE TABLE PUBLIC.BAZYL_PRODUCENT
(
	ID bigint NOT NULL,
	NAZWA varchar(128) NOT NULL,
	CONSTRAINT BAZYL_PRODUCENT_PK PRIMARY KEY (ID)
);


CREATE TABLE PUBLIC.ICD_10
(
	KOD varchar(20) NOT NULL,
	NAZWA varchar(250) NOT NULL,
	OPIS longvarchar,
	CONSTRAINT ICD_10_PK PRIMARY KEY (KOD)
);


CREATE TABLE PUBLIC.WYROB_MEDYCZNY
(
	KOD varchar(20) NOT NULL,
	OPIS longvarchar,
	TYP varchar(50) NOT NULL,
	CONSTRAINT WYROB_MEDYCZNY_PK PRIMARY KEY (KOD)
);



/* Create Foreign Keys */

ALTER TABLE PUBLIC.BAZYL_LEK_POSTAC
	ADD CONSTRAINT BAZYL_LEK_NAZWA_BAZYL_LEK_POSTAC_FK FOREIGN KEY (LEK_ID)
	REFERENCES PUBLIC.BAZYL_LEK (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE PUBLIC.BAZYL_ODPLATNOSC
	ADD CONSTRAINT BAZYL_LEK_POSTAC_BAZYL_ODPLATNOSC_FK FOREIGN KEY (KOD_BAZYL)
	REFERENCES PUBLIC.BAZYL_LEK_POSTAC (KOD_BAZYL)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE PUBLIC.BAZYL_ODPLATNOSC_SKLADNIK
	ADD CONSTRAINT BAZYL_ODPLATNOSC_BAZYL_ODPLATNOSC_SKLADNIK_FK FOREIGN KEY (KOD_BAZYL)
	REFERENCES PUBLIC.BAZYL_ODPLATNOSC (KOD_BAZYL)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


ALTER TABLE PUBLIC.BAZYL_LEK_POSTAC
	ADD CONSTRAINT BAZYL_PRODUCENT_BAZYL_LEK_POSTAC_FK FOREIGN KEY (PRODUCENT_ID)
	REFERENCES PUBLIC.BAZYL_PRODUCENT (ID)
	ON UPDATE RESTRICT
	ON DELETE RESTRICT
;


