-- INDEKSY GŁÓWNYCH TABEL PROGRAMU

CREATE UNIQUE INDEX ATN_UNIKALNY_TYP
    ON AUTONUMER (typ);

CREATE UNIQUE INDEX D_OS_POJEDYNCZY_NA_DZIEN
    ON DOWOD_OSOBISTY (osoba_id,data_wydania);

CREATE UNIQUE INDEX GR_UNIKALNA_NAZWA
    ON GRUPA (nazwa);

CREATE UNIQUE INDEX GR_UPR_UNIKALNE_PRZYPISANIE
    ON GRUPA_UPRAWNIENIE (grupa_id,nazwa);
    
CREATE UNIQUE INDEX GR_OS_UNIKALNY_PESEL
    ON OSOBA (pesel);

CREATE INDEX POB_SW_OS_DATY
    ON POBIERANE_SWIADCZENIE (OSOBA_ID, DATA_ZMIANY, DATA_OD, DATA_DO);
    
CREATE UNIQUE INDEX PR_UNIKALNY_LOGIN
    ON PRACOWNIK (login);

CREATE UNIQUE INDEX PR_UNIKALNA_NAZWA_GRUPY
    ON GRUPA (nazwa);
    
CREATE UNIQUE INDEX PR_UNIKALNE_USTAWIENIA
    ON PRACOWNIK_PARAMETR (pracownik_id, typ, wartosc_s);
    
CREATE UNIQUE INDEX SL_UNIKALNY_KOD
    ON SLOWO (slownik_id,kod);

-- dla osoby można wprowadzić tylko jedną decyzję kierującą na dany dzień
CREATE UNIQUE INDEX PR_UNIKALNA_DEC_KIER_NA_DZIEN
    ON DECYZJA_KIERUJACA(OSOBA_ID, TYP, DATA_WYDANIA);
    
-- dla osoby można wydać tylko jedną decyzję wygaszającą (na niej będą wszystkie decyzje, które mają zostać wygaszone)
CREATE UNIQUE INDEX PR_JEDNA_DEC_WYGASZAJACA
    ON DECYZJA_WYGASZAJACA (osoba_id);
    
CREATE UNIQUE INDEX PR_JEDNA_REALIZACJA_PLANU_DZIEN
	ON PLAN_WSPARCIA_REALIZACJA (OSOBA_ID, PRACOWNIK_ID, DATA_REALIZACJI);
	
CREATE UNIQUE INDEX EW_UNIKALNY_ID_POKOJU
	ON DPS_JEDNOSTKA_POKOJ (BUDYNEK,PIETRO, NR);

CREATE INDEX SZW_TYP_WZORCA
    ON SZABLON_WYDRUKU (TYP_WZORCA);

CREATE UNIQUE INDEX PR_UNIKALNA_SPR_PODPOWIEDZ
    ON SPRAWOZDANIE_PODPOWIEDZ (typ);
    
CREATE UNIQUE INDEX PR_UNIKALNA_OSO_SPR_PODPOWIEDZ
    ON OSOBA_SPRAWOZDANIE (typ);
    
CREATE UNIQUE INDEX PR_UNIKALNY_NR_SPRAWOZDANIA
    ON SPRAWOZDANIE (typ, rok, kwartal, numer);
    
CREATE UNIQUE INDEX PR_UNIKALNA_NAZWA_INSTYTUCJA_DOPLACAJACA
    ON INSTYTUCJA_DOPLACAJACA (NAZWA);

CREATE UNIQUE INDEX PR_UNIKALNA_NAZWA_MIEJSCE_POBYTU
    ON MIEJSCE_POBYTU (NAZWA);
    
CREATE UNIQUE INDEX ASPR_UNIKALNY_RODZAJ_SPR
    ON ADRESAT_SPRAWOZDANIA (RODZAJ_SPRAWOZDANIA);
    
CREATE UNIQUE INDEX KB_IBAN_KONTA
	ON KONTO_BANKOWE(IBAN);

-- INDEKSY TABEL QUARTZa
create index idx_qrtz_j_req_recovery on qrtz_job_details(SCHED_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_j_grp on qrtz_job_details(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_t_j on qrtz_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_t_jg on qrtz_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_t_c on qrtz_triggers(SCHED_NAME,CALENDAR_NAME);
create index idx_qrtz_t_g on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP);
create index idx_qrtz_t_state on qrtz_triggers(SCHED_NAME,TRIGGER_STATE);
create index idx_qrtz_t_n_state on qrtz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_n_g_state on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_next_fire_time on qrtz_triggers(SCHED_NAME,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st on qrtz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_qrtz_t_nft_st_misfire_grp on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_ft_trig_inst_name on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME);
create index idx_qrtz_ft_inst_job_req_rcvry on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_ft_j_g on qrtz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_ft_jg on qrtz_fired_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_ft_t_g on qrtz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
create index idx_qrtz_ft_tg on qrtz_fired_triggers(SCHED_NAME,TRIGGER_GROUP);

-- INDEKSY TABEL LEKÓW
CREATE UNIQUE INDEX LK_LEK_UNIKALNY_KOD_BAZYL
    ON LEK_POSTAC (KOD_BAZYL);
    
CREATE UNIQUE INDEX LK_NAZWA_LEKU
  ON LEK(NAZWA, OPAKOWANIE_JEDNOSTKA_POJEMNOSCI, POSTAC, DAWKA);

CREATE INDEX LK_OPAKOWANIE_LEKU
	ON LEK_POSTAC(OPAKOWANIE_ILOSC);
	
CREATE INDEX LK_OPAKOWANIE_LEKU_BAZYL
	ON LEK_POSTAC(OPAKOWANIE_OPIS_BAZYL);


-- INDEKSY TABEL MAGAZYNU
CREATE INDEX MG_TYP_DATA_OPERACJI
    ON MAGAZYN_OPERACJA (MAGAZYN_ID, TYP, DATA);

-- INDEKSTY TABEL ŚWIADCZEŃ DZIENNYCH
CREATE UNIQUE INDEX SWDZ_UNIKALNA_KWOTA_SW
    ON SWIADCZENIE_ODPLATNOSC(SWIADCZENIE_ID, DATA);
    
-- INDEKSY TABEL ROZLICZANIA ODPŁATNOŚCI
CREATE UNIQUE INDEX NL_ZADLUZENIE_OS_MIESIAC
    ON ZADLUZENIE(OSOBA_ID, ROK, MIESIAC);

-- INDEKSY TABEL ODPLATNOSC_AKTUALIZACJA
CREATE UNIQUE INDEX OA_UNIKALNA_OSOBA
	ON ODPLATNOSC_AKTUALIZACJA(OSOBA_ID);
