
/* Create Tables */

CREATE TABLE ADRES
(
	ID IDENTITY NOT NULL,
	DATA_OD date,
	DATA_DO date,
	FAX varchar(20),
	GMINA varchar(150),
	KOD_POCZTOWY varchar(20),
	MIEJSCOWOSC varchar(150),
	NR_DOMU varchar(10),
	NR_LOKALU varchar(10),
	PANSTWO varchar(5),
	POCZTA varchar(150),
	POWIAT varchar(30),
	TELEFON varchar(20),
	TYP varchar(30) NOT NULL,
	ULICA varchar(150),
	WOJEWODZTWO varchar(15) NOT NULL,
	CONSTRAINT CONSTRAINT_3B PRIMARY KEY (ID)
);


CREATE TABLE ADRESAT_SPRAWOZDANIA
(
	ID IDENTITY NOT NULL,
	ADRES_ID bigint NOT NULL,
	KOD_KESO varchar(50),
	NAZWA varchar(200) NOT NULL,
	RODZAJ_SPRAWOZDANIA varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_E13 PRIMARY KEY (ID)
);


CREATE TABLE ARCHIWIZACJA_BAZY
(
	ID IDENTITY NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	URL varchar(200) NOT NULL,
	KOMPRESJA boolean,
	DATA_PRZEPROWADZENIA timestamp(3) NOT NULL,
	RODZAJ_BAZY_DANYCH varchar(50) NOT NULL,
	RODZAJ_OPERACJI varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_5 PRIMARY KEY (ID)
);


CREATE TABLE AUTONUMER
(
	TYP varchar(50) NOT NULL,
	FORMAT varchar(200),
	WARTOSC int NOT NULL,
	CONSTRAINT AUTONUMER_PK PRIMARY KEY (TYP)
);


CREATE TABLE CZYNNOSC_REALIZACJA
(
	CZYNNOSC_ID bigint NOT NULL,
	PLAN_WSPARCIA_REALIZACJA_ID bigint NOT NULL,
	CONSTRAINT CZYNNOSC_REALIZACJA_PK PRIMARY KEY (CZYNNOSC_ID)
);


CREATE TABLE DATABASE_CHANGELOG
(
	ID decimal(20,0) NOT NULL,
	APPLIED_AT varchar(25) NOT NULL,
	DESCRIPTION varchar(255) NOT NULL,
	CONSTRAINT DATABASE_CHANGELOG_PK PRIMARY KEY (ID)
);


CREATE TABLE DAWKA_LEK
(
	DAWKOWANIE_ID bigint NOT NULL,
	PORA_ID bigint NOT NULL,
	LEK_ID bigint NOT NULL,
	CZY_RECEPTA boolean,
	DAWKA decimal(10,2),
	CONSTRAINT DAWKA_LEK_PK PRIMARY KEY (DAWKOWANIE_ID, PORA_ID, LEK_ID)
);


CREATE TABLE DAWKA_PODANIE
(
	DAWKOWANIE_ID bigint NOT NULL,
	LEK_ID bigint NOT NULL,
	PORA_ID bigint NOT NULL,
	DATA date NOT NULL,
	DAWKA decimal(10,2) NOT NULL,
	CONSTRAINT DAWKA_PODANIE_PK PRIMARY KEY (DAWKOWANIE_ID, LEK_ID, PORA_ID)
);


CREATE TABLE DAWKOWANIE
(
	ID IDENTITY NOT NULL,
	POPRZEDNIE_DAWKOWANIE_ID bigint,
	EWIDENCJA_DPS_ID bigint NOT NULL,
	DATA_OD date NOT NULL,
	CONSTRAINT CONSTRAINT_E1 PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_DZ_O_ODPLATNOSCI
(
	ID IDENTITY NOT NULL,
	MIESZKANIEC_ID bigint NOT NULL,
	KTO_WYDAL_ID bigint NOT NULL,
	DATA_WYDANIA date NOT NULL,
	NR varchar(50) NOT NULL,
	OBOWIAZUJE_OD date,
	OBOWIAZUJE_DO date,
	CONSTRAINT CONSTRAINT_D48 PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_KIERUJACA
(
	ID IDENTITY NOT NULL,
	KTO_WYDAL_ID bigint,
	OSOBA_ID bigint NOT NULL,
	POSTANOWIENIE_SADU_ID bigint,
	DATA_DO date,
	DATA_WPLYWU date NOT NULL,
	DATA_WYDANIA date NOT NULL,
	NR varchar(50),
	WYDANA_NA_ZASADACH varchar(50) NOT NULL,
	PRIORYTET int DEFAULT 3 NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_AE PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_O_ODPLATNOSCI
(
	ID IDENTITY NOT NULL,
	CZLONEK_RODZ_ID bigint,
	DOCHOD_ID bigint,
	KTO_WYDAL_ID bigint NOT NULL,
	MIESZKANIEC_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	CALKOWITE_ZWOLNIENIE boolean,
	DATA_WYDANIA date NOT NULL,
	NR varchar(50) NOT NULL,
	KWOTA decimal(10,2),
	KWOTA_ZWOLNIONA decimal(10,2),
	OBOWIAZUJE_OD date,
	TYP varchar(30) NOT NULL,
	WAZNA_DO date,
	CONSTRAINT CONSTRAINT_9D PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_SWIADCZENIE
(
	DECYZJA_ID bigint NOT NULL,
	SWIADCZENIE_ID bigint NOT NULL,
	ILOSC_LIMIT decimal(10,2),
	OKRES_ILOSC_LIMIT decimal(10,2) NOT NULL,
	OKRES_LIMIT varchar(50) NOT NULL,
	PROCENT_ODPLATNOSC int DEFAULT 100 NOT NULL,
	CONSTRAINT DECYZJA_SWIADCZENIE_PK PRIMARY KEY (DECYZJA_ID, SWIADCZENIE_ID)
);


CREATE TABLE DECYZJA_UCHYLAJACA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	NR varchar(50) NOT NULL,
	DATA_WYDANIA date NOT NULL,
	DATA_UCHYLENIA date NOT NULL,
	CONSTRAINT CONSTRAINT_D4E PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_UMIESZCZAJACA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	KTO_WYDAL_ID bigint,
	NR varchar(50) NOT NULL,
	DATA_WPLYWU date,
	DATA_WYDANIA date NOT NULL,
	CONSTRAINT CONSTRAINT_FF PRIMARY KEY (ID)
);


CREATE TABLE DECYZJA_WYGASZAJACA
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	NR varchar(50) NOT NULL,
	DATA_WYDANIA date NOT NULL,
	DATA_WYGASZENIA date NOT NULL,
	CONSTRAINT CONSTRAINT_3A PRIMARY KEY (ID)
);


CREATE TABLE DIAGNOZA
(
	ID IDENTITY NOT NULL,
	SLOWO_ID bigint NOT NULL,
	STATUS varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_20 PRIMARY KEY (ID)
);


CREATE TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA
(
	GRUPA_OSOB_ID bigint NOT NULL,
	CZYNNOSC_ID bigint NOT NULL,
	CONSTRAINT DIAGNOZA_GR_OS_PLAN_WSPARCIA_PK PRIMARY KEY (GRUPA_OSOB_ID, CZYNNOSC_ID)
);


CREATE TABLE DIAGNOZA_GRUPA_OSOB
(
	ID IDENTITY NOT NULL,
	SKALA_OCENY_ID bigint NOT NULL,
	OZNACZENIE varchar(50) NOT NULL,
	OPIS longvarchar,
	ZAKRES_OD int,
	ZAKRES_DO int,
	CONSTRAINT CONSTRAINT_95 PRIMARY KEY (ID)
);


CREATE TABLE DIAGNOZA_INFORMACJA_DODATKOWA
(
	DIAGNOZA_ID bigint NOT NULL,
	INFORMACJA_ID bigint NOT NULL,
	KOLEJNOSC int,
	CONSTRAINT DIAGNOZA_INFORMACJA_DODATKOWA_PK PRIMARY KEY (DIAGNOZA_ID, INFORMACJA_ID)
);


CREATE TABLE DIAGNOZA_REAL_INFORMACJA
(
	INFORMACJA_ID bigint NOT NULL,
	DIAGNOZA_REAL_ID bigint NOT NULL,
	CONSTRAINT DIAGNOZA_REAL_INFORMACJA_PK PRIMARY KEY (INFORMACJA_ID, DIAGNOZA_REAL_ID)
);


CREATE TABLE DIAGNOZA_REAL_OCENA
(
	DIAGNOZA_REAL_ID bigint NOT NULL,
	OCENA_OSOBY_ID bigint NOT NULL,
	CONSTRAINT DIAGNOZA_REAL_OCENA_PK PRIMARY KEY (DIAGNOZA_REAL_ID, OCENA_OSOBY_ID)
);


CREATE TABLE DIAGNOZA_REALIZACJA
(
	ID IDENTITY NOT NULL,
	DIAGNOZA_ID bigint NOT NULL,
	EWIDENCJA_DPS_ID bigint NOT NULL,
	PRACOWNIK_WYKONAL_ID bigint NOT NULL,
	CZY_WSTEPNA boolean,
	DATA date NOT NULL,
	STATUS varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_A8 PRIMARY KEY (ID)
);


CREATE TABLE DIAGNOZA_SKALA_OCENY
(
	SKALA_OCENY_ID bigint NOT NULL,
	DIAGNOZA_ID bigint NOT NULL,
	KOLEJNOSC int,
	CONSTRAINT DIAGNOZA_SKALA_OCENY_PK PRIMARY KEY (SKALA_OCENY_ID, DIAGNOZA_ID)
);


CREATE TABLE DOCHOD
(
	ID IDENTITY NOT NULL,
	DATA_OD date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT CONSTRAINT_78 PRIMARY KEY (ID)
);


CREATE TABLE DOCHOD_SWIADCZENIE_SKLADNIK
(
	DOCHOD_ID bigint NOT NULL,
	SWIADCZENIE_ID bigint NOT NULL,
	CONSTRAINT DOCHOD_SWIADCZENIE_SKLADNIK_PK PRIMARY KEY (DOCHOD_ID, SWIADCZENIE_ID)
);


CREATE TABLE DOPLATA_LIMIT
(
	OSOBA_ID bigint NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT DOPLATA_LIMIT_PK PRIMARY KEY (OSOBA_ID)
);


CREATE TABLE DOWOD_OSOBISTY
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	WYDANY_PRZEZ_ID bigint,
	DATA_WAZNOSCI date,
	DATA_WPROWADZENIA date NOT NULL,
	DATA_WYDANIA date,
	SERIA_NR varchar(15) NOT NULL,
	CONSTRAINT CONSTRAINT_D PRIMARY KEY (ID)
);


CREATE TABLE DPS_JEDNOSTKA
(
	ID IDENTITY NOT NULL,
	ADRES_ID bigint,
	BRANCH varchar(50) NOT NULL,
	KOD_KESO varchar(50) NOT NULL,
	KOD_LOKALIZACJI varchar(50) NOT NULL,
	KRS varchar(10),
	LICENCJA_LOGIN varchar(20),
	LICENCJA_HASLO varchar(100),
	LICENCJA_KLUCZ varchar(1000),
	LICENCJA_NUMER varchar(20),
	LICENCJA_PAKIET varchar(50),
	NAZWA varchar(200),
	NAZWA_SKROCONA varchar(100),
	NIP varchar(10) NOT NULL,
	ORGAN_PROWADZACY varchar(50) NOT NULL,
	REGON varchar(9) NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_21 PRIMARY KEY (ID)
);


CREATE TABLE DPS_JEDNOSTKA_DANE
(
	ID IDENTITY NOT NULL,
	DPS_JEDNOSTKA_ID bigint NOT NULL,
	TYP varchar(50) NOT NULL,
	WARTOSC_S varchar(50),
	WARTOSC_I int,
	CONSTRAINT CONSTRAINT_6 PRIMARY KEY (ID)
);


CREATE TABLE DPS_JEDNOSTKA_KONTO_BANKOWE
(
	DPS_JEDNOSTKA_ID bigint NOT NULL,
	KONTO_ID bigint NOT NULL,
	CONSTRAINT DPS_JEDNOSTKA_KONTO_BANKOWE_PK PRIMARY KEY (DPS_JEDNOSTKA_ID, KONTO_ID)
);


CREATE TABLE DPS_JEDNOSTKA_POKOJ
(
	ID IDENTITY NOT NULL,
	DPS_JEDNOSTKA_ID bigint NOT NULL,
	BUDYNEK varchar(50),
	LICZBA_MIEJSC int NOT NULL,
	NR varchar(5),
	PIETRO int,
	CONSTRAINT CONSTRAINT_C PRIMARY KEY (ID)
);


CREATE TABLE DPS_JEDNOSTKA_PROFIL
(
	NUMER varchar(50) NOT NULL,
	DPS_JEDNOSTKA_ID bigint NOT NULL,
	RODZAJ varchar(50) NOT NULL,
	LICZBA_MIEJSC int,
	LICZBA_MIEJSC_K int,
	LICZBA_MIEJSC_M int,
	CONSTRAINT DPS_JEDNOSTKA_PROFIL_PK PRIMARY KEY (NUMER, DPS_JEDNOSTKA_ID)
);


CREATE TABLE EWIDENCJA_DPS
(
	ID IDENTITY NOT NULL,
	EWID_POPRZEDNI_WPIS_ID bigint,
	DOKAD_ODSZEDL_ID bigint,
	OSOBA_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	DATA_OD date NOT NULL,
	DATA_DO date,
	NUMER_EWIDENCYJNY varchar(25),
	STALE_ZAMELDOWANIE_DOM boolean,
	TYP varchar(30) NOT NULL,
	PROFIL_DOMU varchar(50),
	SKAD_PRZYSZEDL_ID bigint,
	DZIEN_PIERWSZY_ODPLATNY boolean,
	CONSTRAINT CONSTRAINT_36 PRIMARY KEY (ID)
);


CREATE TABLE EWIDENCJA_DPS_ZGON
(
	ID bigint NOT NULL,
	USC_ID bigint,
	MIEJSCE_ZGONU_ID bigint,
	ODPOWIEDZIALNY_ZA_POGRZEB_ID bigint,
	GODZINA int,
	MIEJSCE_POCHOWKU varchar(100),
	NR_AKT_ZGON varchar(25),
	STATUS varchar(50) NOT NULL,
	UWAGI longvarchar,
	SZABLON_WYDRUKU_ID bigint,
	CONSTRAINT EWIDENCJA_DPS_ZGON_PK PRIMARY KEY (ID)
);


CREATE TABLE EWIDENCJA_POKOJE
(
	ID IDENTITY NOT NULL,
	DPS_POKOJ_ID bigint NOT NULL,
	EWIDENCJA_DPS_ID bigint NOT NULL,
	POPRZEDNI_POKOJ_ID bigint,
	DATA_OD date NOT NULL,
	CONSTRAINT CONSTRAINT_E PRIMARY KEY (ID)
);


CREATE TABLE FORMAT_CSV
(
	ID IDENTITY NOT NULL,
	CHARSET varchar(50) NOT NULL,
	LINIA_OPISOW boolean,
	NAZWA varchar(50) NOT NULL,
	SEPARATOR_POLA varchar(1) NOT NULL,
	SEPARATOR_WIERSZA varchar(1) NOT NULL,
	CONSTRAINT CONSTRAINT_30 PRIMARY KEY (ID)
);


CREATE TABLE GRUPA
(
	ID IDENTITY NOT NULL,
	NAZWA varchar(30) NOT NULL,
	CONSTRAINT CONSTRAINT_4 PRIMARY KEY (ID)
);


CREATE TABLE GRUPA_UPRAWNIENIE
(
	GRUPA_ID bigint NOT NULL,
	NAZWA varchar(50) NOT NULL,
	CONSTRAINT PK_GRUPA_UPRAWNIENIE PRIMARY KEY (GRUPA_ID, NAZWA)
);


CREATE TABLE GRUPA_UPRAWNIENIE_KAT_USLUG
(
	CZYNNOSC_ID bigint NOT NULL,
	GRUPA_ID bigint NOT NULL,
	TYP_UPRAWNIENIA varchar(50) NOT NULL,
	CONSTRAINT GR_UPR_KAT_USL_PK PRIMARY KEY (CZYNNOSC_ID, GRUPA_ID, TYP_UPRAWNIENIA)
);


CREATE TABLE GRUPA_ZNAKOW
(
	POLITYKA_ID bigint NOT NULL,
	GRUPA_ZNAKOW varchar(50) NOT NULL,
	ZNAKI varchar(100),
	MIN_ZNAKOW int NOT NULL,
	CONSTRAINT GRUPA_ZNAKOW_PK PRIMARY KEY (POLITYKA_ID, GRUPA_ZNAKOW)
);


CREATE TABLE INFORMACJA_DODATKOWA
(
	ID IDENTITY NOT NULL,
	NAZWA varchar(100) NOT NULL,
	STATUS varchar(50) NOT NULL,
	POJEDYNCZY_WPIS boolean,
	TYP varchar(50),
	CONSTRAINT CONSTRAINT_8D PRIMARY KEY (ID)
);


CREATE TABLE INFORMACJA_DODATKOWA_POLE
(
	ID IDENTITY NOT NULL,
	INFORMACJA_DODATKOWA_ID bigint NOT NULL,
	JEDNOSTKA_MIARY varchar(50),
	KOLEJNOSC int NOT NULL,
	NAZWA varchar(30) NOT NULL,
	NAZWA_SLOWNIKA varchar(50),
	RODZAJ varchar(50),
	TYP varchar(50) NOT NULL,
	WYMAGANE boolean,
	CONSTRAINT CONSTRAINT_1D PRIMARY KEY (ID)
);


CREATE TABLE INFORMACJA_DODATKOWA_POLE_WPIS
(
	ID IDENTITY NOT NULL,
	INFORMACJA_WPIS_ID bigint NOT NULL,
	POLE_ID bigint NOT NULL,
	NIE_PRZYPOMINAJ boolean,
	CONSTRAINT CONSTRAINT_2B PRIMARY KEY (ID)
);


CREATE TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE
(
	ID IDENTITY NOT NULL,
	INFORMACJA_DODATKOWA_ID bigint NOT NULL,
	WARTOSC_TR bigint,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_F3 PRIMARY KEY (ID)
);


CREATE TABLE INFORMACJA_DODATKOWA_WPIS
(
	ID IDENTITY NOT NULL,
	INFORMACJA_DODATKOWA_ID bigint NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	DATA date NOT NULL,
	STATUS varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_1D8 PRIMARY KEY (ID)
);


CREATE TABLE INSTYTUCJA_DOPLACAJACA
(
	ID IDENTITY NOT NULL,
	ADRES_ID bigint,
	DOMYSLNA boolean,
	EMERYTALNO_RENTOWA boolean,
	NAZWA varchar(150) NOT NULL,
	CONSTRAINT CONSTRAINT_B PRIMARY KEY (ID)
);


CREATE TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE
(
	KONTO_ID bigint NOT NULL,
	INSTYTUCJA_ID bigint NOT NULL,
	CONSTRAINT INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_PK PRIMARY KEY (KONTO_ID, INSTYTUCJA_ID)
);


CREATE TABLE INSTYTUCJA_WPLATA
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint NOT NULL,
	DATA date NOT NULL,
	ROK int NOT NULL,
	MIESIAC int NOT NULL,
	CONSTRAINT CONSTRAINT_41 PRIMARY KEY (ID)
);


CREATE TABLE INSTYTUCJA_WPLATA_POZYCJA
(
	INSTYTUCJA_WPLATA_ID bigint NOT NULL,
	WPLATA_ID bigint NOT NULL,
	MIESZKANIEC_ID bigint NOT NULL,
	CONSTRAINT INSTYTUCJA_WPLATA_POZYCJA_PK PRIMARY KEY (INSTYTUCJA_WPLATA_ID, WPLATA_ID)
);


CREATE TABLE KAT_USL_CZYNNOSC
(
	ID IDENTITY NOT NULL,
	KATEGORIA_ID bigint NOT NULL,
	DATA_OD date,
	DATA_DO date,
	KOLEJNOSC int,
	NAZWA varchar(200) NOT NULL,
	OPIS longvarchar,
	CONSTRAINT CONSTRAINT_4A PRIMARY KEY (ID)
);


CREATE TABLE KAT_USL_KATEGORIA
(
	ID IDENTITY NOT NULL,
	NADKATEGORIA_ID bigint,
	KOLEJNOSC int,
	DATA_OD date,
	DATA_DO date,
	NAZWA varchar(200) NOT NULL,
	OPIS longvarchar,
	CONSTRAINT CONSTRAINT_65E PRIMARY KEY (ID)
);


CREATE TABLE KONTO_BANKOWE
(
	ID IDENTITY NOT NULL,
	IBAN varchar(26) NOT NULL,
	LICZNIK_UZYCIE int NOT NULL,
	LICZNIK_PRZYPISAN int NOT NULL,
	CONSTRAINT CONSTRAINT_2 PRIMARY KEY (ID)
);


CREATE TABLE KRYTERIUM_OCENY
(
	ID IDENTITY NOT NULL,
	TEKST varchar(200) NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_D4 PRIMARY KEY (ID)
);


CREATE TABLE KRYTERIUM_OPCJA
(
	ID IDENTITY NOT NULL,
	KRYTERIUM_OCENY_ID bigint NOT NULL,
	PUNKTY int NOT NULL,
	TEKST varchar(200) NOT NULL,
	CONSTRAINT CONSTRAINT_D47 PRIMARY KEY (ID)
);


CREATE TABLE KWALIFIKACJA_OS_WYMAGA
(
	KWALIFIKACJA_ID bigint NOT NULL,
	SLOWO_ID bigint NOT NULL,
	CONSTRAINT KWALIFIKACJA_OS_WYMAGA_PK PRIMARY KEY (KWALIFIKACJA_ID, SLOWO_ID)
);


CREATE TABLE KWALIFIKACJA_PIELEGNIARSKA
(
	ID IDENTITY NOT NULL,
	OCENA_ID bigint NOT NULL,
	DATA date NOT NULL,
	OPIEKA_DLUGOTERMINOWA boolean,
	CONSTRAINT CONSTRAINT_38 PRIMARY KEY (ID)
);


CREATE TABLE LEK
(
	ID IDENTITY NOT NULL,
	DAWKA varchar(42),
	NAZWA varchar(120) NOT NULL,
	OPAKOWANIE_JEDNOSTKA_POJEMNOSCI varchar(50) NOT NULL,
	POSTAC varchar(32) NOT NULL,
	CONSTRAINT CONSTRAINT_12 PRIMARY KEY (ID)
);


CREATE TABLE LEK_POSTAC
(
	KOD_BAZYL bigint NOT NULL,
	LEK_ID bigint NOT NULL,
	DOP_OBROT_POLSKA boolean,
	OPAKOWANIE_ILOSC decimal(10,2) NOT NULL,
	OPAKOWANIE_OPIS_BAZYL varchar(42) NOT NULL,
	CONSTRAINT LEK_POSTAC_PK PRIMARY KEY (KOD_BAZYL)
);


CREATE TABLE LEK_REALIZACJA
(
	REALIZACJA_RECEPTA_ID bigint NOT NULL,
	KOD_BAZYL bigint NOT NULL,
	NIEZREALIZOWANY boolean DEFAULT 'FALSE' NOT NULL,
	SLOWO_ID bigint,
	LICZBA_OPAKOWAN int NOT NULL,
	DATA date,
	CONSTRAINT LEK_REALIZACJA_PK PRIMARY KEY (REALIZACJA_RECEPTA_ID, KOD_BAZYL, NIEZREALIZOWANY)
);


CREATE TABLE MELDUNEK
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	DATA_OD date NOT NULL,
	DATA_DO date,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_65 PRIMARY KEY (ID)
);


CREATE TABLE MIEJSCE_POBYTU
(
	ID IDENTITY NOT NULL,
	ADRES_ID bigint,
	NAZWA varchar(150) NOT NULL,
	OPIEKA_ZDROWOTNA boolean,
	CONSTRAINT CONSTRAINT_3F PRIMARY KEY (ID)
);


CREATE TABLE NALICZENIE_POBYT
(
	ID IDENTITY NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	DATA_OBLICZENIA date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	DATA_KSIEGOWANIA date,
	DOLICZENIE_ID bigint,
	CONSTRAINT CONSTRAINT_84 PRIMARY KEY (ID)
);


CREATE TABLE NIEOBECNOSC
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	NIEOBECNOSC_INFORMACJA_ID bigint,
	RODZAJ_NIEOBECNOSCI_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	DATA_OD date NOT NULL,
	DATA_DO date NOT NULL,
	LICZBA_DNI int NOT NULL,
	LICZBA_DNI_ZWROT int,
	STATUS varchar(50) DEFAULT '''W_REALIZACJI''' NOT NULL,
	UWAGI longvarchar,
	CONSTRAINT CONSTRAINT_28 PRIMARY KEY (ID)
);


CREATE TABLE NIEOBECNOSC_INFORMACJA
(
	ID IDENTITY NOT NULL,
	DYZUR_POWROT_ID bigint,
	DYZUR_WYJAZD_ID bigint,
	EWIDENCJA_DPS_ID bigint NOT NULL,
	MIEJSCE_ID bigint NOT NULL,
	PRACOWNIK_PRZYJAL_ID bigint,
	PRACOWNIK_SKIEROWAL_ID bigint NOT NULL,
	PRACOWNIK_WPROWADZIL_ID bigint NOT NULL,
	DATA_POWROTU date,
	DATA_WYJAZDU date NOT NULL,
	CONSTRAINT CONSTRAINT_BC PRIMARY KEY (ID)
);


CREATE TABLE NOTA_ODPLATNOSC
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint,
	PRACOWNIK_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	DATA date NOT NULL,
	NR varchar(50) NOT NULL,
	TYP varchar(50) NOT NULL,
	SZABLON_WYDRUKU_2_ID bigint,
	STATUS varchar(50) NOT NULL,
	RODZAJ_ZADLUZENIA varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_EF PRIMARY KEY (ID)
);


CREATE TABLE NOTA_ODPLATNOSC_POZYCJA
(
	ID IDENTITY NOT NULL,
	NOTA_ID bigint NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	KONTO_ID bigint,
	STATUS varchar(50) NOT NULL,
	KWOTA_ODPISU decimal(10,2),
	CONSTRAINT CONSTRAINT_2C PRIMARY KEY (ID)
);


CREATE TABLE OCENA_KRYTERIUM
(
	OCENA_OSOBA_SKALA_ID bigint NOT NULL,
	KRYTERIUM_OPCJA_ID bigint NOT NULL,
	UWAGI longvarchar,
	CONSTRAINT OCENA_KRYTERIUM_PK PRIMARY KEY (OCENA_OSOBA_SKALA_ID, KRYTERIUM_OPCJA_ID)
);


CREATE TABLE OCENA_OSOBY
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	SKALA_OCENY_ID bigint NOT NULL,
	DATA date NOT NULL,
	CONSTRAINT CONSTRAINT_9 PRIMARY KEY (ID)
);


CREATE TABLE ODBIOR_ODPADOW
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	ODBIERAJACY_ID bigint NOT NULL,
	RODZAJ_MATERIALU_ID bigint,
	CONSTRAINT CONSTRAINT_B8 PRIMARY KEY (ID)
);


CREATE TABLE ODPIS_ZWROT
(
	ID IDENTITY NOT NULL,
	NIEOBECNOSC_ID bigint,
	KWOTA decimal(10,2) NOT NULL,
	LICZBA_DNI int,
	TYP varchar(50) NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	DATA date NOT NULL,
	ODPIS_ID bigint,
	DATA_KSIEGOWANIA date,
	CONSTRAINT CONSTRAINT_98 PRIMARY KEY (ID)
);


CREATE TABLE ODPLATNOSC
(
	ID IDENTITY NOT NULL,
	DECYZJA_KIERUJACA_ID bigint NOT NULL,
	DATA_OD date NOT NULL,
	EWIDENCJA_ZGON_ID bigint,
	CONSTRAINT CONSTRAINT_63 PRIMARY KEY (ID)
);


CREATE TABLE ODPLATNOSC_AKTUALIZACJA
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	DATA_OD date NOT NULL,
	CONSTRAINT CONSTRAINT_8A PRIMARY KEY (ID)
);


CREATE TABLE ODPLATNOSC_DECYZJA_SKLADNIK
(
	DECYZJA_O_ODPLATNOSCI_ID bigint NOT NULL,
	ODPLATNOSC_ID bigint NOT NULL,
	CONSTRAINT ODPLATNOSC_DECYZJA_SKLADNIK_PK PRIMARY KEY (DECYZJA_O_ODPLATNOSCI_ID, ODPLATNOSC_ID)
);


CREATE TABLE ODPLATNOSC_DOLICZENIE_POBYT
(
	ID IDENTITY NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	STATUS varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_47E PRIMARY KEY (ID)
);


CREATE TABLE ODPLATNOSC_SKLADNIK
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint,
	ODPLATNOSC_ID bigint NOT NULL,
	OSOBA_ID bigint,
	KWOTA decimal(10,2) NOT NULL,
	KWOTA_DZIEN decimal(10,2),
	CONSTRAINT CONSTRAINT_C1 PRIMARY KEY (ID)
);


CREATE TABLE ORZECZ_O_NIEPELNOSPRAW
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	DATA_ORZECZENIA date NOT NULL,
	NR varchar(50),
	OBOWIAZUJE_OD date NOT NULL,
	STOPIEN_NIEPELNOSPRAW varchar(15) NOT NULL,
	WAZNE_DO date,
	RODZAJ_ORZECZNICTWA varchar(50),
	WYDANE_PRZEZ_ID bigint,
	UWAGI longvarchar,
	BEZ_PRZYPOMNIENIA boolean,
	CONSTRAINT CONSTRAINT_46 PRIMARY KEY (ID)
);


CREATE TABLE OSOBA
(
	ID IDENTITY NOT NULL,
	STAN_CYWILNY_ID bigint,
	DATA_URODZENIA date,
	IMIE varchar(60) NOT NULL,
	IMIE_DRUGIE varchar(60),
	IMIE_MATKI varchar(60),
	IMIE_OJCA varchar(60),
	IMIE_WSPOLMALZONKA varchar(60),
	IMPORT_PROGRAM varchar(50),
	MIEJSCE_URODZENIA varchar(150),
	NAZWISKO varchar(70) NOT NULL,
	NAZWISKO_RODOWE varchar(70),
	NAZWISKO_RODOWE_MATKI varchar(70),
	NAZWISKO_WSPOLMALZONKA varchar(70),
	NIP varchar(10),
	PESEL varchar(11),
	PLEC varchar(15),
	TELEFON_KOM varchar(20),
	WYZNANIE_ID bigint,
	WYKSZTALCENIE_ID bigint,
	DATA_ZGONU date,
	CONSTRAINT CONSTRAINT_48 PRIMARY KEY (ID)
);


CREATE TABLE OSOBA_ADRES
(
	OSOBA_ID bigint NOT NULL,
	ADRES_ID bigint NOT NULL,
	CONSTRAINT OSOBA_ADRES_PK PRIMARY KEY (OSOBA_ID, ADRES_ID)
);


CREATE TABLE OSOBA_INFORMACJA_DODATKOWA
(
	INFORMACJA_DODATKOWA_WPIS_ID bigint NOT NULL,
	EWIDENCJA_ID bigint,
	OSOBA_ID bigint,
	CONSTRAINT OSOBA_INFORMACJA_DODATKOWA_PK PRIMARY KEY (INFORMACJA_DODATKOWA_WPIS_ID)
);


CREATE TABLE OSOBA_KONTO_BANKOWE
(
	KONTO_ID bigint NOT NULL,
	OSOBA_ID bigint NOT NULL,
	CONSTRAINT OSOBA_KONTO_BANKOWE_PK PRIMARY KEY (KONTO_ID, OSOBA_ID)
);


CREATE TABLE OSOBA_PARAMETR
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	TYP varchar(50) NOT NULL,
	WARTOSC_S varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_4B3 PRIMARY KEY (ID)
);


CREATE TABLE OSOBA_PRACOWNIK
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	PRACOWNIK_PRZYPISAL_ID bigint NOT NULL,
	PRACOWNIK_ZMIENIL_ID bigint,
	DATA_PRZYPISANIA timestamp(3) NOT NULL,
	DATA_ZMIANY timestamp(3),
	TYP_PRACOWNIKA varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_81 PRIMARY KEY (ID)
);


CREATE TABLE OSOBA_RODZINA
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	RODZINA_ID bigint NOT NULL,
	DATA_OD date,
	DATA_DO date,
	KOD_STOPNIA_POKREWIENSTWA varchar(15),
	TYP varchar(50),
	ZOBOWIAZANY_ALIMENTACJA boolean,
	ZWOLNIONY_ALIMENTACJA boolean,
	CONSTRAINT CONSTRAINT_B4 PRIMARY KEY (ID)
);


CREATE TABLE OSOBA_SPRAWOZDANIE
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	TYP varchar(50),
	CONSTRAINT CONSTRAINT_9B PRIMARY KEY (ID)
);


CREATE TABLE OSOBA_SPRAWOZDANIE_WARTOSC
(
	ID IDENTITY NOT NULL,
	OSOBA_SPRAWOZDANIE_ID bigint NOT NULL,
	WARTOSC_S varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_9E7 PRIMARY KEY (ID)
);


CREATE TABLE PARAMETR_SYSTEMOWY
(
	ID IDENTITY NOT NULL,
	SLOWO_ID bigint,
	TYP varchar(50) NOT NULL,
	DATA_OD date,
	DATA_DO date,
	WARTOSC_B boolean,
	WARTOSC_D decimal(10,2),
	WARTOSC_I int,
	WARTOSC_S varchar(100),
	UKRYTY boolean NOT NULL,
	KOLEJNOSC int,
	CONSTRAINT CONSTRAINT_F PRIMARY KEY (ID)
);


CREATE TABLE PLAN_WSPARCIA_CZYNNOSC
(
	CZYNNOSC_ID bigint NOT NULL,
	PLAN_ID bigint NOT NULL,
	CONSTRAINT PLAN_WSPARCIA_CZYNNOSC_PK PRIMARY KEY (CZYNNOSC_ID, PLAN_ID)
);


CREATE TABLE PLAN_WSPARCIA_DIAGNOZA_PODSTAWA
(
	PLAN_WSPARCIA_ID bigint NOT NULL,
	DIAGNOZA_REALIZACJA_ID bigint NOT NULL,
	CONSTRAINT PLAN_WSPARCIA_DIAGNOZA_PODSTAWA_PK PRIMARY KEY (PLAN_WSPARCIA_ID, DIAGNOZA_REALIZACJA_ID)
);


CREATE TABLE PLAN_WSPARCIA_MIESZKANCA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	PLAN_AKTUALIZOWANY_ID bigint,
	PRACOWNIK_PK_ID bigint,
	DATA_OD date NOT NULL,
	DATA_DO date,
	DATA_WAZNOSCI date,
	NR varchar(50),
	OPIS longvarchar,
	CONSTRAINT CONSTRAINT_79 PRIMARY KEY (ID)
);


CREATE TABLE PLAN_WSPARCIA_REALIZACJA
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	DATA_REALIZACJI date NOT NULL,
	CONSTRAINT CONSTRAINT_BF PRIMARY KEY (ID)
);


CREATE TABLE PLIK_CSV
(
	ID IDENTITY NOT NULL,
	FORMAT_CSV_ID bigint NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	NAZWA varchar(50) NOT NULL,
	MD5SUM varchar(32) NOT NULL,
	DATA date NOT NULL,
	CONSTRAINT CONSTRAINT_AB PRIMARY KEY (ID)
);


CREATE TABLE POBIERANE_SWIADCZENIE
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	SWIADCZENIE_ZMIENIONE_ID bigint,
	DATA_OD date,
	DATA_DO date,
	DATA_ZMIANY date,
	KWOTA decimal(10,2) NOT NULL,
	NR varchar(50),
	RODZAJ_ODBIORU varchar(50),
	INSTYTUCJA_DOPLACAJACA_ID bigint,
	TERMIN_WYPLATY_ID bigint,
	KOD_SWIADCZENIA_ID bigint NOT NULL,
	CONSTRAINT CONSTRAINT_BA PRIMARY KEY (ID)
);


CREATE TABLE POLE_CSV
(
	FORMAT_CSV_ID bigint NOT NULL,
	NAZWA varchar(50) NOT NULL,
	KOLEJNOSC int NOT NULL,
	CONSTRAINT POLE_CSV_PK PRIMARY KEY (FORMAT_CSV_ID, NAZWA)
);


CREATE TABLE POLE_DATA
(
	ID bigint NOT NULL,
	WARTOSC date NOT NULL,
	CONSTRAINT POLE_DATA_PK PRIMARY KEY (ID)
);


CREATE TABLE POLE_LICZBA_D
(
	ID bigint NOT NULL,
	WARTOSC decimal(10,2) NOT NULL,
	CONSTRAINT POLE_LICZBA_D_PK PRIMARY KEY (ID)
);


CREATE TABLE POLE_LICZBA_I
(
	ID bigint NOT NULL,
	WARTOSC int NOT NULL,
	CONSTRAINT POLE_LICZBA_I_PK PRIMARY KEY (ID)
);


CREATE TABLE POLE_PORA_DNIA
(
	ID bigint NOT NULL,
	WARTOSC bigint NOT NULL,
	LICZBA_I int,
	CONSTRAINT POLE_PORA_DNIA_PK PRIMARY KEY (ID, WARTOSC)
);


CREATE TABLE POLE_PRACOWNIK
(
	ID bigint NOT NULL,
	WARTOSC bigint NOT NULL,
	LICZBA_I int,
	CONSTRAINT POLE_PRACOWNIK_PK PRIMARY KEY (ID, WARTOSC)
);


CREATE TABLE POLE_SLOWNIK
(
	ID bigint NOT NULL,
	WARTOSC bigint NOT NULL,
	LICZBA_I int,
	CONSTRAINT POLE_SLOWNIK_PK PRIMARY KEY (ID, WARTOSC)
);


CREATE TABLE POLE_TEKST_DLUGI
(
	ID bigint NOT NULL,
	WARTOSC longvarchar NOT NULL,
	CONSTRAINT POLE_TEKST_DLUGI_PK PRIMARY KEY (ID)
);


CREATE TABLE POLE_TEKST_KROTKI
(
	ID bigint NOT NULL,
	WARTOSC varchar(100) NOT NULL,
	CONSTRAINT POLE_TEKST_KROTKI_PK PRIMARY KEY (ID)
);


CREATE TABLE POLE_WARTOSC_LOGICZNA
(
	ID bigint NOT NULL,
	WARTOSC boolean,
	CONSTRAINT POLE_WARTOSC_LOGICZNA_PK PRIMARY KEY (ID)
);


CREATE TABLE POLITYKA_BEZPIECZENSTWA
(
	ID IDENTITY NOT NULL,
	DL_HISTORII_HASLA int NOT NULL,
	MIN_DL_HASLA int NOT NULL,
	MAX_DL_HASLA int,
	PROB_N_LOGOWAN int NOT NULL,
	PROB_CZAS_BLOKADY int NOT NULL,
	L_DNI_OBOWIAZYWANIA_HASLA int NOT NULL,
	L_DNI_ZMIANA_HASLA int NOT NULL,
	ZASTOSUJ boolean,
	CONSTRAINT CONSTRAINT_3 PRIMARY KEY (ID)
);


CREATE TABLE PORA_DNIA
(
	ID IDENTITY NOT NULL,
	CZY_AKTUALNA boolean,
	GODZINA int,
	KOLEJNOSC int,
	NAZWA varchar(50) NOT NULL,
	SKROT varchar(10) NOT NULL,
	WRP boolean,
	CONSTRAINT CONSTRAINT_C9 PRIMARY KEY (ID)
);


CREATE TABLE POSTANOWIENIE_SADU
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	RODZAJ_POSTANOWIENIA_ID bigint NOT NULL,
	DATA_POSTANOWIENIA date NOT NULL,
	NR varchar(30) NOT NULL,
	SAD_ID bigint,
	ZAKRES_ID bigint,
	DATA_OD date,
	UWAGI longvarchar,
	OPIEKUN_ID bigint,
	DATA_DO date,
	CONSTRAINT CONSTRAINT_C5 PRIMARY KEY (ID)
);


CREATE TABLE PRACOWNIK
(
	ID IDENTITY NOT NULL,
	GRUPA_ID bigint NOT NULL,
	CZY_PRACUJE smallint NOT NULL,
	DATA_OSTATNIEGO_LOGOWANIA timestamp(3),
	DATA_ZMIANY_HASLA date NOT NULL,
	E_MAIL varchar(200),
	LOGIN varchar(20) NOT NULL,
	HASLO varchar(90) NOT NULL,
	IMIE varchar(60) NOT NULL,
	LICZBA_N_LOGOWAN int,
	NAZWISKO varchar(70) NOT NULL,
	TELEFON varchar(20),
	ZABLOKOWANE boolean,
	CONSTRAINT CONSTRAINT_8 PRIMARY KEY (ID)
);


CREATE TABLE PRACOWNIK_HISTORIA_HASLA
(
	PRACOWNIK_ID bigint NOT NULL,
	NR_PORZADKOWY int NOT NULL,
	HASLO varchar(90) NOT NULL,
	CONSTRAINT PRACOWNIK_HISTORIA_HASLA_PK PRIMARY KEY (PRACOWNIK_ID, NR_PORZADKOWY)
);


CREATE TABLE PRACOWNIK_PARAMETR
(
	ID IDENTITY NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	TYP varchar(50) NOT NULL,
	WARTOSC_S varchar(50),
	CONSTRAINT CONSTRAINT_A PRIMARY KEY (ID)
);


CREATE TABLE PRZELEW_DRUK
(
	ID IDENTITY NOT NULL,
	DATA_GENEROWANIA timestamp(3) NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	TYTULEM varchar(100) NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	CONSTRAINT CONSTRAINT_A3 PRIMARY KEY (ID)
);


CREATE TABLE PRZYPOMNIENIE_KONFIGURACJA
(
	JOB_NAME varchar(200) NOT NULL,
	JOB_GROUP varchar(200) NOT NULL,
	TYP_DANYCH varchar(50) NOT NULL,
	WARTOSC varchar(100),
	CONSTRAINT PRZYPOMNIENIE_KONFIGURACJA_PK PRIMARY KEY (JOB_NAME, JOB_GROUP, TYP_DANYCH)
);


CREATE TABLE QRTZ_BLOB_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	BLOB_DATA blob
);


CREATE TABLE QRTZ_CALENDARS
(
	SCHED_NAME varchar(120) NOT NULL,
	CALENDAR_NAME varchar(200) NOT NULL,
	CALENDAR blob NOT NULL,
	CONSTRAINT PK_QRTZ_CALENDARS PRIMARY KEY (SCHED_NAME, CALENDAR_NAME)
);


CREATE TABLE QRTZ_CRON_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	CRON_EXPRESSION varchar(120) NOT NULL,
	TIME_ZONE_ID varchar(80),
	CONSTRAINT PK_QRTZ_CRON_TRIGGERS PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);


CREATE TABLE QRTZ_FIRED_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	ENTRY_ID varchar(95) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	INSTANCE_NAME varchar(200) NOT NULL,
	FIRED_TIME bigint NOT NULL,
	PRIORITY int NOT NULL,
	STATE varchar(16) NOT NULL,
	JOB_NAME varchar(200),
	JOB_GROUP varchar(200),
	IS_NONCONCURRENT boolean,
	REQUESTS_RECOVERY boolean,
	CONSTRAINT PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY (SCHED_NAME, ENTRY_ID)
);


CREATE TABLE QRTZ_JOB_DETAILS
(
	SCHED_NAME varchar(120) NOT NULL,
	JOB_NAME varchar(200) NOT NULL,
	JOB_GROUP varchar(200) NOT NULL,
	DESCRIPTION varchar(250),
	JOB_CLASS_NAME varchar(250) NOT NULL,
	IS_DURABLE boolean NOT NULL,
	IS_NONCONCURRENT boolean NOT NULL,
	IS_UPDATE_DATA boolean NOT NULL,
	REQUESTS_RECOVERY boolean NOT NULL,
	JOB_DATA blob,
	HIDDEN boolean,
	CONSTRAINT PK_QRTZ_JOB_DETAILS PRIMARY KEY (SCHED_NAME, JOB_NAME, JOB_GROUP)
);


CREATE TABLE QRTZ_LOCKS
(
	SCHED_NAME varchar(120) NOT NULL,
	LOCK_NAME varchar(40) NOT NULL,
	CONSTRAINT PK_QRTZ_LOCKS PRIMARY KEY (SCHED_NAME, LOCK_NAME)
);


CREATE TABLE QRTZ_PAUSED_TRIGGER_GRPS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	CONSTRAINT PK_QRTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY (SCHED_NAME, TRIGGER_GROUP)
);


CREATE TABLE QRTZ_SCHEDULER_STATE
(
	SCHED_NAME varchar(120) NOT NULL,
	INSTANCE_NAME varchar(200) NOT NULL,
	LAST_CHECKIN_TIME bigint NOT NULL,
	CHECKIN_INTERVAL bigint NOT NULL,
	CONSTRAINT PK_QRTZ_SCHEDULER_STATE PRIMARY KEY (SCHED_NAME, INSTANCE_NAME)
);


CREATE TABLE QRTZ_SIMPLE_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	REPEAT_COUNT bigint NOT NULL,
	REPEAT_INTERVAL bigint NOT NULL,
	TIMES_TRIGGERED bigint NOT NULL,
	CONSTRAINT PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);


CREATE TABLE QRTZ_SIMPROP_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	STR_PROP_1 varchar(512),
	STR_PROP_2 varchar(512),
	STR_PROP_3 varchar(512),
	INT_PROP_1 int,
	INT_PROP_2 int,
	LONG_PROP_1 bigint,
	LONG_PROP_2 bigint,
	DEC_PROP_1 decimal(13,4),
	DEC_PROP_2 decimal(13,4),
	BOOL_PROP_1 boolean,
	BOOL_PROP_2 boolean,
	CONSTRAINT PK_QRTZ_SIMPROP_TRIGGERS PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);


CREATE TABLE QRTZ_TRIGGERS
(
	SCHED_NAME varchar(120) NOT NULL,
	TRIGGER_NAME varchar(200) NOT NULL,
	TRIGGER_GROUP varchar(200) NOT NULL,
	JOB_NAME varchar(200) NOT NULL,
	JOB_GROUP varchar(200) NOT NULL,
	DESCRIPTION varchar(250),
	NEXT_FIRE_TIME bigint,
	PREV_FIRE_TIME bigint,
	PRIORITY int,
	TRIGGER_STATE varchar(16) NOT NULL,
	TRIGGER_TYPE varchar(8) NOT NULL,
	START_TIME bigint NOT NULL,
	END_TIME bigint,
	CALENDAR_NAME varchar(200),
	MISFIRE_INSTR smallint,
	JOB_DATA blob,
	CONSTRAINT PK_QRTZ_TRIGGERS PRIMARY KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
);


CREATE TABLE REALIZACJA_DAROWIZNA
(
	OPERACJA_ID bigint NOT NULL,
	PODMIOT_ID bigint NOT NULL,
	CONSTRAINT REALIZACJA_DAROWIZNA_PK PRIMARY KEY (OPERACJA_ID)
);


CREATE TABLE REALIZACJA_RECEPTA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_DPS_ID bigint,
	FAKTURA_ID bigint,
	OSOBA_ID bigint,
	DATA date,
	RODZAJ varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_10 PRIMARY KEY (ID)
);


CREATE TABLE REALIZACJA_RECEPTA_MAGAZYN
(
	REALIZACJA_ID bigint NOT NULL,
	OPERACJA_ID bigint NOT NULL,
	CONSTRAINT REALIZACJA_RECEPTA_MAGAZYN_PK PRIMARY KEY (REALIZACJA_ID, OPERACJA_ID)
);


CREATE TABLE REALIZACJA_WRP
(
	OPERACJA_ID bigint NOT NULL,
	PORA_DNIA_ID bigint NOT NULL,
	CONSTRAINT REALIZACJA_WRP_PK PRIMARY KEY (OPERACJA_ID)
);


CREATE TABLE RECEPTA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_DPS_ID bigint NOT NULL,
	LEKARZ_WYSTAWIL_ID bigint,
	CHOROBY_PRZEWLEKLE varchar(50) NOT NULL,
	DATA_WYSTAWIENIA date NOT NULL,
	ODDZIAL_NFZ varchar(50) NOT NULL,
	UPRAWNIENIE varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_6B PRIMARY KEY (ID)
);


CREATE TABLE RECEPTA_LEK
(
	RECEPTA_ID bigint NOT NULL,
	LEK_ID bigint NOT NULL,
	CONSTRAINT RECEPTA_LEK_PK PRIMARY KEY (RECEPTA_ID, LEK_ID)
);


CREATE TABLE RODZAJ_POB_SWIADCZENIA
(
	ID IDENTITY NOT NULL,
	ODLICZENIE_POBYT_DZIEN_ZGONU varchar(50) NOT NULL,
	ODLICZENIE_POBYT_PO_ZGON varchar(50) NOT NULL,
	ODLICZENIE_POBYT_PRZED_ZGON varchar(50) NOT NULL,
	ZWROT_WYPLATA_DZIEN_ZGONU varchar(50) NOT NULL,
	ZWROT_WYPLATA_PO_ZGON varchar(50) NOT NULL,
	ZWROT_WYPLATA_PRZED_ZGON varchar(50) NOT NULL,
	KOD varchar(15) NOT NULL,
	TEKST varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_56 PRIMARY KEY (ID)
);


CREATE TABLE RODZINA
(
	ID IDENTITY NOT NULL,
	CONSTRAINT CONSTRAINT_7 PRIMARY KEY (ID)
);


CREATE TABLE ROZLICZENIE
(
	ID IDENTITY NOT NULL,
	MIESZKANIEC_ID bigint NOT NULL,
	PRACOWNIK_WYKONAL_ID bigint NOT NULL,
	DATA date NOT NULL,
	DATA_WYKONANIA date NOT NULL,
	CONSTRAINT CONSTRAINT_97 PRIMARY KEY (ID)
);


CREATE TABLE ROZLICZENIE_SWIADCZENIE
(
	ROZLICZENIE_ID bigint NOT NULL,
	SWIADCZENIE_ID bigint NOT NULL,
	ILOSC decimal(10,2) NOT NULL,
	ILOSC_PELNOPLATNE decimal(10,2) NOT NULL,
	ILOSC_ZREZYGNOWANO decimal(10,2) NOT NULL,
	KWOTA_M decimal(10,2) NOT NULL,
	KWOTA_DOM decimal(10,2) NOT NULL,
	KWOTA_PELNOPLATNE decimal(10,2) NOT NULL,
	CONSTRAINT ROZLICZENIE_SWIADCZENIE_PK PRIMARY KEY (ROZLICZENIE_ID, SWIADCZENIE_ID)
);


CREATE TABLE SAD
(
	ID IDENTITY NOT NULL,
	ADRES_ID bigint,
	NAZWA varchar(200) NOT NULL,
	CONSTRAINT CONSTRAINT_1 PRIMARY KEY (ID)
);


CREATE TABLE SKALA_KRYTERIUM_OCENY
(
	SKALA_ID bigint NOT NULL,
	KRYTERIUM_ID bigint NOT NULL,
	CONSTRAINT SKALA_KRYTERIUM_OCENY_PK PRIMARY KEY (SKALA_ID, KRYTERIUM_ID)
);


CREATE TABLE SKALA_OCENY_OSOBY
(
	ID IDENTITY NOT NULL,
	NAZWA varchar(100) NOT NULL,
	OPIS longvarchar,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_F0 PRIMARY KEY (ID)
);


CREATE TABLE SLOWNIK
(
	ID IDENTITY NOT NULL,
	NAZWA varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_AC PRIMARY KEY (ID)
);


CREATE TABLE SLOWO
(
	ID IDENTITY NOT NULL,
	SLOWNIK_ID bigint NOT NULL,
	KOD varchar(15) NOT NULL,
	WART_STRING varchar(500),
	WART_INT int,
	WAZNOSC_OD date,
	WAZNOSC_DO date,
	KOLEJNOSC int,
	CONSTRAINT CONSTRAINT_4B PRIMARY KEY (ID)
);


CREATE TABLE SPRAWOZDANIE
(
	ID IDENTITY NOT NULL,
	DATA_WYGENEROWANIA timestamp(3) NOT NULL,
	KWARTAL int,
	NAZWA_PLIKU varchar(200) NOT NULL,
	NUMER bigint NOT NULL,
	TYP varchar(50) NOT NULL,
	ROK int NOT NULL,
	CONSTRAINT CONSTRAINT_28F PRIMARY KEY (ID)
);


CREATE TABLE SPRAWOZDANIE_PODPOWIEDZ
(
	ID IDENTITY NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_82 PRIMARY KEY (ID)
);


CREATE TABLE SPRAWOZDANIE_PODPOWIEDZ_WARTOSC
(
	ID IDENTITY NOT NULL,
	SPRAWOZDANIE_PODPOWIEDZ_ID bigint NOT NULL,
	WARTOSC_S varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_64 PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE
(
	ID IDENTITY NOT NULL,
	GRUPA_ID bigint NOT NULL,
	ROZLICZAJ_W_RAMACH_ID bigint,
	NAZWA varchar(100) NOT NULL,
	JEDNOSTKA varchar(50) NOT NULL,
	KOLEJNOSC_WYDRUK int NOT NULL,
	SKROT_WYDRUK varchar(10),
	CONSTRAINT CONSTRAINT_77 PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE_DODATEK
(
	ID IDENTITY NOT NULL,
	POBIERANE_SWIADCZENIE_ID bigint NOT NULL,
	KOD_DODATKU_ID bigint NOT NULL,
	EKWIWALENT decimal(10,2),
	WARTOSC decimal(10,2) NOT NULL,
	JEDNOSTKA varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_CC PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE_DZIEN_WOLNY
(
	SWIADCZENIE_ID bigint NOT NULL,
	DATA date NOT NULL,
	CONSTRAINT SWIADCZENIE_DZIEN_WOLNY_PK PRIMARY KEY (SWIADCZENIE_ID, DATA)
);


CREATE TABLE SWIADCZENIE_GRUPA
(
	ID IDENTITY NOT NULL,
	KOLEJNOSC_WYDRUK int NOT NULL,
	NAZWA varchar(100) NOT NULL,
	CONSTRAINT CONSTRAINT_B4E PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE_ODPLATNOSC
(
	ID IDENTITY NOT NULL,
	SWIADCZENIE_ID bigint NOT NULL,
	DATA date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT CONSTRAINT_8F PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE_REALIZACJA
(
	SWIADCZENIE_ID bigint NOT NULL,
	DATA date NOT NULL,
	MIESZKANIEC_ID bigint NOT NULL,
	ILOSC decimal(10,2),
	ILOSC_REZYGNACJA decimal(10,2),
	ILOSC_PELNOPLATNE decimal(10,2),
	CONSTRAINT SWIADCZENIE_REALIZACJA_PK PRIMARY KEY (SWIADCZENIE_ID, DATA, MIESZKANIEC_ID)
);


CREATE TABLE SWIADCZENIE_WPLATA
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	ROK int NOT NULL,
	MIESIAC int NOT NULL,
	TERMIN_WYPLATY_ID bigint NOT NULL,
	CONSTRAINT CONSTRAINT_79A PRIMARY KEY (ID)
);


CREATE TABLE SWIADCZENIE_WPLATA_POZYCJA
(
	WPLATA_ID bigint NOT NULL,
	SWIADCZENIE_WPLATA_ID bigint NOT NULL,
	CONSTRAINT SWIADCZENIE_WPLATA_POZYCJA_PK PRIMARY KEY (WPLATA_ID, SWIADCZENIE_WPLATA_ID)
);


CREATE TABLE SWIADCZENIE_ZWROT
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ZGON_ID bigint NOT NULL,
	INSTYTUCJA_ID bigint NOT NULL,
	SWIADCZENIE_ID bigint NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	ZWROT_ID bigint,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT CONSTRAINT_C5C PRIMARY KEY (ID)
);


CREATE TABLE SZABLON_BLOK_FTL
(
	ID IDENTITY NOT NULL,
	SZABLON_WYDRUKU_ID bigint NOT NULL,
	BLOK varchar(6000) NOT NULL,
	NUMER_PORZADKOWY int NOT NULL,
	CONSTRAINT CONSTRAINT_47 PRIMARY KEY (ID)
);


CREATE TABLE SZABLON_WYDRUKU
(
	ID IDENTITY NOT NULL,
	NAZWA varchar(200) NOT NULL,
	TYP_WZORCA varchar(50) NOT NULL,
	TYP_SZABLONU varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_FB PRIMARY KEY (ID)
);


CREATE TABLE SZABLON_WYDRUKU_PLIK
(
	ID bigint NOT NULL,
	NAZWA varchar(50) NOT NULL,
	CONSTRAINT SZABLON_WYDRUKU_PLIK_PK PRIMARY KEY (ID)
);


CREATE TABLE SZABLON_WYDRUKU_TRESC
(
	ID bigint NOT NULL,
	TRESC longvarchar NOT NULL,
	CONSTRAINT SZABLON_WYDRUKU_TRESC_PK PRIMARY KEY (ID)
);


CREATE TABLE TERMIN_WYPLATY
(
	ID IDENTITY NOT NULL,
	DZIEN int NOT NULL,
	TEKST varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_9E PRIMARY KEY (ID)
);


CREATE TABLE UMOWA
(
	ID bigint NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	ZLECENIODAWCA_ID bigint NOT NULL,
	DATA_DO date,
	CONSTRAINT UMOWA_PK PRIMARY KEY (ID)
);


CREATE TABLE UMOWA_APTEKA
(
	ID IDENTITY NOT NULL,
	DATA_OD date NOT NULL,
	DATA_DO date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	NR varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_91 PRIMARY KEY (ID)
);


CREATE TABLE UMOWA_KWOTA
(
	ID IDENTITY NOT NULL,
	SLOWO_ID bigint NOT NULL,
	UMOWA_ID bigint NOT NULL,
	KWOTA decimal(10,2),
	CONSTRAINT CONSTRAINT_D8 PRIMARY KEY (ID)
);


CREATE TABLE UMOWA_PARAMETR
(
	TYP varchar(50) NOT NULL,
	UMOWA_ID bigint NOT NULL,
	RODZAJ varchar(50) NOT NULL,
	WARTOSC_I int,
	WARTOSC_D decimal(10,2),
	CONSTRAINT UMOWA_PARAMETR_PK PRIMARY KEY (TYP, UMOWA_ID)
);


CREATE TABLE UWAGI_REALIZACJA_PLANU
(
	ID IDENTITY NOT NULL,
	PLAN_WSPARCIA_REALIZACJA_ID bigint NOT NULL,
	UWAGI longvarchar NOT NULL,
	CONSTRAINT CONSTRAINT_E5 PRIMARY KEY (ID)
);


CREATE TABLE WERSJA
(
	WERSJA varchar(50) NOT NULL,
	DATA date NOT NULL,
	CONSTRAINT WERSJA_PK PRIMARY KEY (WERSJA)
);


CREATE TABLE WPLATA
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint,
	OSOBA_ID bigint,
	DATA_WPLATY date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	KWOTA_ZWROT decimal(10,2) NOT NULL,
	DATA_KSIEGOWANIA date,
	SWIADCZENIE_ID bigint,
	CONSTRAINT CONSTRAINT_99 PRIMARY KEY (ID)
);


CREATE TABLE WPLATA_PLIK_POZYCJA
(
	POZYCJA_ID bigint NOT NULL,
	PLIK_CSV_ID bigint NOT NULL,
	WIERSZ int NOT NULL,
	TRESC longvarchar NOT NULL,
	CONSTRAINT WPLATA_PLIK_POZYCJA_PK PRIMARY KEY (POZYCJA_ID)
);


CREATE TABLE WPLATA_SKLADNIK
(
	WPLATA_ID bigint NOT NULL,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	FAKTURA_ID bigint,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT WPLATA_SKLADNIK_PK PRIMARY KEY (WPLATA_ID, ZADLUZENIE_POZYCJA_ID)
);


CREATE TABLE WYROWNANIE_WPLATA
(
	WPLATA_ID bigint NOT NULL,
	WYROWNANIE_ID bigint NOT NULL,
	CONSTRAINT WYROWNANIE_WPLATA_PK PRIMARY KEY (WPLATA_ID, WYROWNANIE_ID)
);


CREATE TABLE ZADLUZENIE
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint NOT NULL,
	MIESIAC int NOT NULL,
	ROK int NOT NULL,
	AKTUALNOSC varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_69 PRIMARY KEY (ID)
);


CREATE TABLE ZADLUZENIE_POZYCJA
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint,
	OSOBA_ID bigint,
	ZADLUZENIE_ID bigint NOT NULL,
	AKTUALNOSC varchar(50) NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	RODZAJ varchar(50) NOT NULL,
	STATUS varchar(50) NOT NULL,
	DATA_AKTUALIZACJI date,
	CONSTRAINT CONSTRAINT_B7 PRIMARY KEY (ID)
);


CREATE TABLE ZADLUZENIE_START
(
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT ZADLUZENIE_START_PK PRIMARY KEY (ZADLUZENIE_POZYCJA_ID)
);


CREATE TABLE ZADLUZENIE_WYROWNANIE
(
	ID IDENTITY NOT NULL,
	FAKTURA_ID bigint,
	NOTA_POZYCJA_ID bigint NOT NULL,
	ODPIS_ID bigint,
	ZADLUZENIE_POZYCJA_ID bigint NOT NULL,
	ZWROT_ID bigint,
	KWOTA decimal(10,2) NOT NULL,
	STATUS varchar(50) NOT NULL,
	KWOTA_ODPISU decimal(10,2),
	CONSTRAINT CONSTRAINT_73 PRIMARY KEY (ID)
);


CREATE TABLE ZAPOMOGA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_ID bigint NOT NULL,
	RODZAJ_ZAPOMOGI_ID bigint NOT NULL,
	DATA_UDZIELENIA date NOT NULL,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT CONSTRAINT_80 PRIMARY KEY (ID)
);


CREATE TABLE ZEBRANIE_ZTO
(
	ID IDENTITY NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	DATA date,
	DATA_PLAN date,
	GODZINA_PLAN varchar(5),
	MIEJSCE_PLAN varchar(200),
	CONSTRAINT CONSTRAINT_4D PRIMARY KEY (ID)
);


CREATE TABLE ZEBRANIE_ZTO_PLAN
(
	EWIDENCJA_ID bigint NOT NULL,
	ZEBRANIE_ZTO_ID bigint NOT NULL,
	CONSTRAINT ZEBRANIE_ZTO_PLAN_PK PRIMARY KEY (EWIDENCJA_ID, ZEBRANIE_ZTO_ID)
);


CREATE TABLE ZEBRANIE_ZTO_PRACOWNIK
(
	ZEBRANIE_ZTO_ID bigint NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT ZEBRANIE_ZTO_PRACOWNIK_PK PRIMARY KEY (ZEBRANIE_ZTO_ID, PRACOWNIK_ID, TYP)
);


CREATE TABLE ZEBRANIE_ZTO_WYKONANO
(
	PLAN_WSPARCIA_ID bigint NOT NULL,
	ZEBRANIE_ZTO_ID bigint NOT NULL,
	CONSTRAINT ZEBRANIE_ZTO_WYKONANO_PK PRIMARY KEY (PLAN_WSPARCIA_ID, ZEBRANIE_ZTO_ID)
);


CREATE TABLE ZESTAWIENIE_WINIEN_MA
(
	ID IDENTITY NOT NULL,
	PRACOWNIK_ID bigint NOT NULL,
	SZABLON_WYDRUKU_ID bigint,
	DATA_GENEROWANIA date NOT NULL,
	ROK int NOT NULL,
	MIESIAC int NOT NULL,
	CONSTRAINT CONSTRAINT_F6 PRIMARY KEY (ID)
);


CREATE TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
(
	ID IDENTITY NOT NULL,
	INSTYTUCJA_ID bigint,
	OSOBA_ID bigint,
	MIESZKANIEC_ID bigint NOT NULL,
	POPRZEDNIA_POZYCJA_ID bigint,
	ZESTAWIENIE_ID bigint NOT NULL,
	DATA_GENEROWANIA date NOT NULL,
	KWOTA_WINIEN_SK decimal(10,2) NOT NULL,
	KWOTA_MA_SK decimal(10,2) NOT NULL,
	KWOTA_ODPISY decimal(10,2) NOT NULL,
	KWOTA_PRZYPISY decimal(10,2) NOT NULL,
	KWOTA_WPLATY decimal(10,2) NOT NULL,
	KWOTA_ZWROTY decimal(10,2) NOT NULL,
	CONSTRAINT CONSTRAINT_AA PRIMARY KEY (ID)
);


CREATE TABLE ZLECENIE_PRZEDMIOT
(
	ZLECENIE_ID bigint NOT NULL,
	INFO_DOBOR longvarchar,
	KOD varchar(8) NOT NULL,
	LICZBA_SZTUK int NOT NULL,
	NAZWA varchar(250) NOT NULL,
	CONSTRAINT ZLECENIE_PRZEDMIOT_PK PRIMARY KEY (ZLECENIE_ID)
);


CREATE TABLE ZLECENIE_SOCZEWKA
(
	ZLECENIE_ID bigint NOT NULL,
	RODZAJ varchar(50) NOT NULL,
	OL_SFERA decimal(10,2),
	OL_CYLINDER decimal(10,2),
	OL_OS decimal(10,2),
	OL_PRYZMA decimal(10,2),
	OP_SFERA decimal(10,2),
	OP_CYLINDER decimal(10,2),
	OP_OS decimal(10,2),
	OP_PRYZMA decimal(10,2),
	ODL_ZRENIC int NOT NULL,
	CONSTRAINT ZLECENIE_SOCZEWKA_PK PRIMARY KEY (ZLECENIE_ID)
);


CREATE TABLE ZLECENIE_UPRAWNIENIA
(
	ZLECENIE_ID bigint NOT NULL,
	KOD_TYTULU_UPR varchar(10) NOT NULL,
	KOD_TYTULU_UPR_DOD varchar(10),
	DATA_OD date NOT NULL,
	DATA_DO date NOT NULL,
	KOD varchar(8) NOT NULL,
	KOD_ZAM_1 varchar(8),
	KOD_ZAM_2 varchar(8),
	KOD_ZAM_3 varchar(8),
	CONSTRAINT ZLECENIE_UPRAWNIENIA_PK PRIMARY KEY (ZLECENIE_ID)
);


CREATE TABLE ZLECENIE_WYDANIA_WYROB_MIESIAC
(
	MIESIAC int NOT NULL,
	ZLECENIE_ID bigint NOT NULL,
	CONSTRAINT ZLECENIE_WYDANIA_WYROB_MIESIAC_PK PRIMARY KEY (MIESIAC, ZLECENIE_ID)
);


CREATE TABLE ZLECENIE_WYDANIE_WYROB
(
	ZLECENIE_ID bigint NOT NULL,
	DANE_WM varchar(300) NOT NULL,
	DATA_ODBIORU date NOT NULL,
	KWOTA_NFZ decimal(10,2) NOT NULL,
	KWOTA_SWIADCZENIOBIORCA decimal(10,2) NOT NULL,
	NR_UMOWY varchar(50) NOT NULL,
	LICZBA_SZTUK int NOT NULL,
	CONSTRAINT ZLECENIE_WYDANIE_WYROB_PK PRIMARY KEY (ZLECENIE_ID)
);


CREATE TABLE ZLECENIE_WYROB_MEDYCZNY
(
	ID IDENTITY NOT NULL,
	ADRES_OSOBY_ID bigint NOT NULL,
	OSOBA_ID bigint NOT NULL,
	ZLECENIE_NADRZEDNE_ID bigint,
	DATA_WYSTAWIENIA date,
	DYSFUNKCJA varchar(50),
	ICD10 varchar(3),
	NAZWA_DOKUMENTU varchar(100),
	NR_DOKUMENTU varchar(50),
	NR_EWIDENCYJNY varchar(50),
	RODZAJ varchar(50) NOT NULL,
	ZAOPATRZENIE_PO_SP varchar(50),
	CONSTRAINT CONSTRAINT_93 PRIMARY KEY (ID)
);


CREATE TABLE MAGAZYN
(
	TYP varchar(50) NOT NULL,
	CONSTRAINT MAGAZYN_PK PRIMARY KEY (TYP)
);


CREATE TABLE DEPOZYT_P_NOTA
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	CONSTRAINT DEPOZYT_P_NOTA_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_ODSETKI
(
	ID IDENTITY NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	KWOTA decimal(10,2) NOT NULL,
	CONSTRAINT DEPOZYT_P_ODSETKI_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_KONTO
(
	ID IDENTITY NOT NULL,
	KONTO_BANKOWE_ID bigint NOT NULL,
	OSOBA_ID bigint NOT NULL,
	ZAMKNIETE boolean,
	CONSTRAINT DEPOZYT_P_KONTO_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_FAKTURA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	FAKTURA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	WPLATA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_FAKTURA_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_SW_WPLATA
(
	ID IDENTITY NOT NULL,
	TERMIN_WYPLATY_ID bigint NOT NULL,
	DATA date NOT NULL,
	DATA_KSIEGOWANIA date,
	MIESIAC int NOT NULL,
	ROK int NOT NULL,
	CONSTRAINT DEPOZYT_P_SW_WPLATA_PK PRIMARY KEY (ID)
);


CREATE TABLE FAKTURA
(
	ID IDENTITY NOT NULL,
	OSOBA_ID bigint,
	PRACOWNIK_WPROWADZIL bigint NOT NULL,
	UMOWA_APTEKA_KWOTA_ID bigint,
	DATA_WYSTAWIENIA date NOT NULL,
	DATA_WPROWADZENIA date NOT NULL,
	KWOTA_DOM decimal(10,2) NOT NULL,
	KWOTA_M decimal(10,2) NOT NULL,
	NR varchar(50) NOT NULL,
	STATUS varchar(50) NOT NULL,
	NR_WEW varchar(50),
	CONSTRAINT CONSTRAINT_EA PRIMARY KEY (ID)
);


CREATE TABLE MAGAZYN_OPERACJA
(
	ID IDENTITY NOT NULL,
	EWIDENCJA_DPS_ID bigint,
	MAGAZYN_ID varchar(50) NOT NULL,
	SLOWO_ID bigint,
	OBIEKT_ID bigint,
	DATA date NOT NULL,
	ILOSC decimal(10,2) NOT NULL,
	TYP varchar(50) NOT NULL,
	CONSTRAINT CONSTRAINT_D9 PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_SW_WPL_POZYCJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	SWIADCZENIE_WPLATA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_SW_WPL_POZYCJA_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_NOTA_OPERACJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	DP_NOTA_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	ZADLUZENIE_WYROWNANIE_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_NOTA_OPERACJA_PK PRIMARY KEY (ID)
);


CREATE TABLE DEPOZYT_P_ODSETKI_POZYCJA
(
	ID IDENTITY NOT NULL,
	DP_KONTO_ID bigint NOT NULL,
	DP_ODSETKI_ID bigint NOT NULL,
	M_OPERACJA_ID bigint NOT NULL,
	CONSTRAINT DEPOZYT_P_ODSETKI_POZYCJA_PK PRIMARY KEY (ID)
);



/* Create Foreign Keys */

ALTER TABLE ADRESAT_SPRAWOZDANIA
	ADD CONSTRAINT ADRES_ADRESAT_SPRAWOZDANIA_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DPS_JEDNOSTKA
	ADD CONSTRAINT ADRES_DPS_JEDNOSTKA_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_DOPLACAJACA
	ADD CONSTRAINT ADRES_INSTYTUCJA_DOPLACAJACA_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE MIEJSCE_POBYTU
	ADD CONSTRAINT ADRES_MIEJSCE_POBYTU_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_ADRES
	ADD CONSTRAINT ADRES_OSOBA_ADRES_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SAD
	ADD CONSTRAINT ADRES_SAD_FK FOREIGN KEY (ADRES_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZLECENIE_WYROB_MEDYCZNY
	ADD CONSTRAINT ADRES_ZLECENIE_WYROB_MEDYCZNY_FK FOREIGN KEY (ADRES_OSOBY_ID)
	REFERENCES ADRES (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DAWKA_LEK
	ADD CONSTRAINT DAWKOWANIE_DAWKA_LEK_FK FOREIGN KEY (DAWKOWANIE_ID)
	REFERENCES DAWKOWANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DAWKA_PODANIE
	ADD CONSTRAINT DAWKOWANIE_DAWKA_PODANIE_FK FOREIGN KEY (DAWKOWANIE_ID)
	REFERENCES DAWKOWANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DAWKOWANIE
	ADD CONSTRAINT DAWKOWANIE_DAWKOWANIE_FK FOREIGN KEY (POPRZEDNIE_DAWKOWANIE_ID)
	REFERENCES DAWKOWANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_SWIADCZENIE
	ADD CONSTRAINT DECYZJA_DZ_O_ODPLATNOSCI_DECYZJA_SWIADCZENIE_FK FOREIGN KEY (DECYZJA_ID)
	REFERENCES DECYZJA_DZ_O_ODPLATNOSCI (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ODPLATNOSC
	ADD CONSTRAINT DECYZJA_KIERUJACA_ODPLATNOSC_FK FOREIGN KEY (DECYZJA_KIERUJACA_ID)
	REFERENCES DECYZJA_KIERUJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UMOWA
	ADD CONSTRAINT DECYZJA_KIERUJACA_UMOWA_FK FOREIGN KEY (ID)
	REFERENCES DECYZJA_KIERUJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_DECYZJA_SKLADNIK
	ADD CONSTRAINT DECYZJA_O_ODPLATNOSCI_ODPLATNOSC_DECYZJA_SKLADNIK_FK FOREIGN KEY (DECYZJA_O_ODPLATNOSCI_ID)
	REFERENCES DECYZJA_O_ODPLATNOSCI (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT DEPOZYT_K_DEPOZYT_FAKTURA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_KONTO_DP_NOTA_OPERACJA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT DP_KONTO_DP_ODSETKI_OPERACJA_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT KONTO_W_SWIADCZNIE_POZ_FK FOREIGN KEY (DP_KONTO_ID)
	REFERENCES DEPOZYT_P_KONTO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_P_NOTA_DP_NOTA_OPERACJA_FK FOREIGN KEY (DP_NOTA_ID)
	REFERENCES DEPOZYT_P_NOTA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT DP_OSETKI_DP_ODSETKI_POZYCJA_FK FOREIGN KEY (DP_ODSETKI_ID)
	REFERENCES DEPOZYT_P_ODSETKI (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT DP_SWIADCZENIE_W_W_POZYCJA_FK FOREIGN KEY (SWIADCZENIE_WPLATA_ID)
	REFERENCES DEPOZYT_P_SW_WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_INFORMACJA_DODATKOWA
	ADD CONSTRAINT DIAGNOZA_DIAGNOZA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (DIAGNOZA_ID)
	REFERENCES DIAGNOZA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REALIZACJA
	ADD CONSTRAINT DIAGNOZA_DIAGNOZA_REALIZACJA_FK FOREIGN KEY (DIAGNOZA_ID)
	REFERENCES DIAGNOZA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA_SKALA_OCENY
	ADD CONSTRAINT DIAGNOZA_DIAGNOZA_SKALA_OCENY_FK FOREIGN KEY (DIAGNOZA_ID)
	REFERENCES DIAGNOZA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA
	ADD CONSTRAINT KAT_USL_GRUPA_OSOB_KAT_USL_GR_OS_PLAN_WSPARCIA_FK FOREIGN KEY (GRUPA_OSOB_ID)
	REFERENCES DIAGNOZA_GRUPA_OSOB (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REAL_INFORMACJA
	ADD CONSTRAINT DIAGNOZA_REALIZACJA_DIAGNOZA_REAL_INFORMACJA_FK FOREIGN KEY (DIAGNOZA_REAL_ID)
	REFERENCES DIAGNOZA_REALIZACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REAL_OCENA
	ADD CONSTRAINT DIAGNOZA_REALIZACJA_DIAGNOZA_REAL_OCENA_FK FOREIGN KEY (DIAGNOZA_REAL_ID)
	REFERENCES DIAGNOZA_REALIZACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PLAN_WSPARCIA_DIAGNOZA_PODSTAWA
	ADD CONSTRAINT DIAGNOZA_REALIZACJA_PLAN_WSPARCIA_DIAGNOZA_PODSTAWA_FK FOREIGN KEY (DIAGNOZA_REALIZACJA_ID)
	REFERENCES DIAGNOZA_REALIZACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_O_ODPLATNOSCI
	ADD CONSTRAINT DOCHOD_DECYZJA_O_ODPLATNOSCI_FK FOREIGN KEY (DOCHOD_ID)
	REFERENCES DOCHOD (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DOCHOD_SWIADCZENIE_SKLADNIK
	ADD CONSTRAINT DOCHOD_DOCHOD_SWIADCZENIE_SKLADNIK_FK FOREIGN KEY (DOCHOD_ID)
	REFERENCES DOCHOD (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DPS_JEDNOSTKA_DANE
	ADD CONSTRAINT DPS_JEDNOSTKA_DPS_JEDNOSTKA_DANE_FK FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DPS_JEDNOSTKA_KONTO_BANKOWE
	ADD CONSTRAINT DPS_JEDNOSTKA_DPS_JEDNOSTKA_KONTO_BANKOWE_FK FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DPS_JEDNOSTKA_POKOJ
	ADD CONSTRAINT DPS_JEDNOSTKA_EWIDENCJA_POKOJE_FK FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DPS_JEDNOSTKA_PROFIL
	ADD CONSTRAINT DPS_JEDNOSTKA_PROFIL_DZIALANOSCI_FK FOREIGN KEY (DPS_JEDNOSTKA_ID)
	REFERENCES DPS_JEDNOSTKA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE EWIDENCJA_POKOJE
	ADD CONSTRAINT DPS_JEDNOSTKA_POKOJE_EWIDENCJA_POKOJE_FK FOREIGN KEY (DPS_POKOJ_ID)
	REFERENCES DPS_JEDNOSTKA_POKOJ (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DECYZJA_UCHYLAJACA
	ADD CONSTRAINT EWIDENCJA_DPS_DECYZJA_UCHYLAJACA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_UMIESZCZAJACA
	ADD CONSTRAINT EWIDENCJA_DPS_DECYZJA_UMIESZCZAJACA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA_REALIZACJA
	ADD CONSTRAINT EWIDENCJA_DPS_DIAGNOZA_REALIZACJA_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS
	ADD CONSTRAINT EWIDENCJA_DPS_EWIDENCJA_DPS_FK FOREIGN KEY (EWID_POPRZEDNI_WPIS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS_ZGON
	ADD CONSTRAINT EWIDENCJA_DPS_EWIDENCJA_DPS_ZGON_FK FOREIGN KEY (ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE EWIDENCJA_POKOJE
	ADD CONSTRAINT EWIDENCJA_DPS_EWIDENCJA_POKOJE_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE MAGAZYN_OPERACJA
	ADD CONSTRAINT EWIDENCJA_DPS_MAGAZYN_OPERACJA_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE MELDUNEK
	ADD CONSTRAINT EWIDENCJA_DPS_MELDUNEK_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC
	ADD CONSTRAINT EWIDENCJA_DPS_NIEOBECNOSC_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT EWIDENCJA_DPS_NIEOBECNOSC_INFORMACJA_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_INFORMACJA_DODATKOWA
	ADD CONSTRAINT EWIDENCJA_DPS_OSOBA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLAN_WSPARCIA_MIESZKANCA
	ADD CONSTRAINT EWIDENCJA_DPS_PLAN_WSPARCIA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE REALIZACJA_RECEPTA
	ADD CONSTRAINT EWIDENCJA_DPS_REALIZACJA_RECEPTA_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UMOWA
	ADD CONSTRAINT EWIDENCJA_DPS_UMOWA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZAPOMOGA
	ADD CONSTRAINT EWIDENCJA_DPS_ZAPOMOGA_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZEBRANIE_ZTO_PLAN
	ADD CONSTRAINT EWIDENCJA_DPS_ZEBRANIE_ZTO_PLAN_FK FOREIGN KEY (EWIDENCJA_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DAWKOWANIE
	ADD CONSTRAINT OSOBA_DAWKOWANIE_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE RECEPTA
	ADD CONSTRAINT OSOBA_RECEPTA_FK FOREIGN KEY (EWIDENCJA_DPS_ID)
	REFERENCES EWIDENCJA_DPS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC
	ADD CONSTRAINT EWIDENCJA_DPS_ZGON_ODPLATNOSC_FK FOREIGN KEY (EWIDENCJA_ZGON_ID)
	REFERENCES EWIDENCJA_DPS_ZGON (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SWIADCZENIE_ZWROT
	ADD CONSTRAINT EWIDENCJA_DPS_ZGON_SWIADCZENIE_ZWROT_FK FOREIGN KEY (EWIDENCJA_ZGON_ID)
	REFERENCES EWIDENCJA_DPS_ZGON (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_POKOJE
	ADD CONSTRAINT EWIDENCJA_POKOJE_EWIDENCJA_POKOJE_FK FOREIGN KEY (POPRZEDNI_POKOJ_ID)
	REFERENCES EWIDENCJA_POKOJE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT FAKTURA_DP_OPERACJA_FK FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE REALIZACJA_RECEPTA
	ADD CONSTRAINT FAKTURA_REALIZACJA_RECEPTA_FK FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA_SKLADNIK
	ADD CONSTRAINT FAKTURA_WPLATA_SKLADNIK_FK FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_WYROWNANIE
	ADD CONSTRAINT FAKTURA_ZADLUZENIE_WYROWNANIE_FK FOREIGN KEY (FAKTURA_ID)
	REFERENCES FAKTURA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLIK_CSV
	ADD CONSTRAINT CSV_FORMAT_PLIK_CSV_FK FOREIGN KEY (FORMAT_CSV_ID)
	REFERENCES FORMAT_CSV (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POLE_CSV
	ADD CONSTRAINT FORMAT_CSV_POLE_CSV_FK FOREIGN KEY (FORMAT_CSV_ID)
	REFERENCES FORMAT_CSV (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE GRUPA_UPRAWNIENIE
	ADD CONSTRAINT GRUPA_GRUPA_UPRAWNIENIE_FK FOREIGN KEY (GRUPA_ID)
	REFERENCES GRUPA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE GRUPA_UPRAWNIENIE_KAT_USLUG
	ADD CONSTRAINT GRUPA_GRUPA_UPRAWNIENIE_KAT_USLUG_FK FOREIGN KEY (GRUPA_ID)
	REFERENCES GRUPA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PRACOWNIK
	ADD CONSTRAINT GRUPA_PRACOWNIK_FK FOREIGN KEY (GRUPA_ID)
	REFERENCES GRUPA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA_INFORMACJA_DODATKOWA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_DIAGNOZA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (INFORMACJA_ID)
	REFERENCES INFORMACJA_DODATKOWA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE
	ADD CONSTRAINT INFORMACJA_DODATKOWA_INFORMACJA_DODATKOWA_ROZSZERZENIE_FK FOREIGN KEY (INFORMACJA_DODATKOWA_ID)
	REFERENCES INFORMACJA_DODATKOWA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE INFORMACJA_DODATKOWA_POLE
	ADD CONSTRAINT INFORMACJA_DODATKOWA_INFORMACJA_POLE_FK FOREIGN KEY (INFORMACJA_DODATKOWA_ID)
	REFERENCES INFORMACJA_DODATKOWA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE INFORMACJA_DODATKOWA_WPIS
	ADD CONSTRAINT INFORMACJA_DODATKOWA_OSOBA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (INFORMACJA_DODATKOWA_ID)
	REFERENCES INFORMACJA_DODATKOWA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INFORMACJA_DODATKOWA_POLE_WPIS
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_INFORMACJA_DODATKOWA_POLE_WPIS_FK FOREIGN KEY (POLE_ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POLE_DATA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_DATA_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_LICZBA_D
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_LICZBA_D_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_LICZBA_I
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_LICZBA_I_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_PORA_DNIA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_PORA_DNIA_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_PRACOWNIK
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_PRACOWNIK_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_SLOWNIK
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_SLOWNIK_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_TEKST_DLUGI
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_TEKST_DLUGI_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_TEKST_KROTKI
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_TEKST_KROTKI_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POLE_WARTOSC_LOGICZNA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_POLE_WPIS_POLE_WARTOSC_LOGICZNA_FK FOREIGN KEY (ID)
	REFERENCES INFORMACJA_DODATKOWA_POLE_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REAL_INFORMACJA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_DIAGNOZA_REAL_INFORMACJA_FK FOREIGN KEY (INFORMACJA_ID)
	REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE INFORMACJA_DODATKOWA_POLE_WPIS
	ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_INFORMACJA_DODATKOWA_POLE_WPIS_FK FOREIGN KEY (INFORMACJA_WPIS_ID)
	REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE OSOBA_INFORMACJA_DODATKOWA
	ADD CONSTRAINT INFORMACJA_DODATKOWA_WPIS_OSOBA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (INFORMACJA_DODATKOWA_WPIS_ID)
	REFERENCES INFORMACJA_DODATKOWA_WPIS (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_WPLATA
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_INSTYTUCJA_WPLATA_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NOTA_ODPLATNOSC
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_NOTA_ODPLATNOSC_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_SKLADNIK
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_ODPLATNOSC_SKLADNIK_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_POZYCJA
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_OSOBA_ZADLUZENIE_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POBIERANE_SWIADCZENIE
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_POBIERANE_SWIADCZENIE_FK FOREIGN KEY (INSTYTUCJA_DOPLACAJACA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_ZWROT
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_SWIADCZENIE_ZWROT_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_WPLATA_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
	ADD CONSTRAINT INSTYTUCJA_DOPLACAJACA_ZESTAWIENIE_WINIEN_MA_POZYCJA_FK FOREIGN KEY (INSTYTUCJA_ID)
	REFERENCES INSTYTUCJA_DOPLACAJACA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_WPLATA_POZYCJA
	ADD CONSTRAINT INSTYTUCJA_WPLATA_INSTYTUCJA_WPLATA_POZYCJA_FK FOREIGN KEY (INSTYTUCJA_WPLATA_ID)
	REFERENCES INSTYTUCJA_WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE CZYNNOSC_REALIZACJA
	ADD CONSTRAINT KAT_USL_CZYNNOSC_CZYNNOSC_REALIZACJA_FK FOREIGN KEY (CZYNNOSC_ID)
	REFERENCES KAT_USL_CZYNNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE GRUPA_UPRAWNIENIE_KAT_USLUG
	ADD CONSTRAINT KAT_USL_CZYNNOSC_GRUPA_UPRAWNIENIE_KAT_USLUG_FK FOREIGN KEY (CZYNNOSC_ID)
	REFERENCES KAT_USL_CZYNNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_GR_OS_PLAN_WSPARCIA
	ADD CONSTRAINT KAT_USL_CZYNNOSC_KAT_USL_GR_OS_PLAN_WSPARCIA_FK FOREIGN KEY (CZYNNOSC_ID)
	REFERENCES KAT_USL_CZYNNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLAN_WSPARCIA_CZYNNOSC
	ADD CONSTRAINT KAT_USL_CZYNNOSC_PLAN_WSPARCIA_CZYNNOSC_FK FOREIGN KEY (CZYNNOSC_ID)
	REFERENCES KAT_USL_CZYNNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE KAT_USL_CZYNNOSC
	ADD CONSTRAINT KAT_USL_KATEGORIA_KAT_USL_CZYNNOSC_FK FOREIGN KEY (KATEGORIA_ID)
	REFERENCES KAT_USL_KATEGORIA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE KAT_USL_KATEGORIA
	ADD CONSTRAINT KAT_USL_KATEGORIA_KAT_USL_KATEGORIA_FK FOREIGN KEY (NADKATEGORIA_ID)
	REFERENCES KAT_USL_KATEGORIA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_KONTO
	ADD CONSTRAINT KONTO_BANKOWE_DEPOZYT_FK FOREIGN KEY (KONTO_BANKOWE_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DPS_JEDNOSTKA_KONTO_BANKOWE
	ADD CONSTRAINT KONTO_BANKOWE_DPS_JEDNOSTKA_KONTO_BANKOWE_FK FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE
	ADD CONSTRAINT KONTO_BANKOWE_INSTYTUCJA_DOPLACAJACA_KONTO_BANKOWE_FK FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NOTA_ODPLATNOSC_POZYCJA
	ADD CONSTRAINT KONTO_BANKOWE_NOTA_ODPLATNOSC_POZYCJA_FK FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_KONTO_BANKOWE
	ADD CONSTRAINT KONTO_BANKOWE_OSOBA_KONTO_BANKOWE_FK FOREIGN KEY (KONTO_ID)
	REFERENCES KONTO_BANKOWE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE KRYTERIUM_OPCJA
	ADD CONSTRAINT KRYTERIUM_OCENY_KRYTERIUM_OPCJA_FK FOREIGN KEY (KRYTERIUM_OCENY_ID)
	REFERENCES KRYTERIUM_OCENY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SKALA_KRYTERIUM_OCENY
	ADD CONSTRAINT MIESZKANIEC_KRYTERIUM_SKALA_KRYTERIUM_OCENY_FK FOREIGN KEY (KRYTERIUM_ID)
	REFERENCES KRYTERIUM_OCENY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OCENA_KRYTERIUM
	ADD CONSTRAINT KRYTERIUM_OPCJA_OCENA_KRYTERIUM_FK FOREIGN KEY (KRYTERIUM_OPCJA_ID)
	REFERENCES KRYTERIUM_OPCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE KWALIFIKACJA_OS_WYMAGA
	ADD CONSTRAINT KWALIFIKACJA_PIELEGNIARSKA_KWALIFIKACJA_OS_WYMAGA_FK FOREIGN KEY (KWALIFIKACJA_ID)
	REFERENCES KWALIFIKACJA_PIELEGNIARSKA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DAWKA_LEK
	ADD CONSTRAINT LEK_DAWKA_LEK_FK FOREIGN KEY (LEK_ID)
	REFERENCES LEK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DAWKA_PODANIE
	ADD CONSTRAINT LEK_DAWKA_PODANIE_FK FOREIGN KEY (LEK_ID)
	REFERENCES LEK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE LEK_POSTAC
	ADD CONSTRAINT LEK_LEK_POSTAC_FK FOREIGN KEY (LEK_ID)
	REFERENCES LEK (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE RECEPTA_LEK
	ADD CONSTRAINT LEK_RECEPTA_LEK_FK FOREIGN KEY (LEK_ID)
	REFERENCES LEK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE LEK_REALIZACJA
	ADD CONSTRAINT LEK_POSTAC_LEK_REALIZACJA_FK FOREIGN KEY (KOD_BAZYL)
	REFERENCES LEK_POSTAC (KOD_BAZYL)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE MAGAZYN_OPERACJA
	ADD CONSTRAINT MAGAZYN_MAGAZYN_OPERACJA_FK FOREIGN KEY (MAGAZYN_ID)
	REFERENCES MAGAZYN (TYP)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE REALIZACJA_DAROWIZNA
	ADD CONSTRAINT MAGAZYN_OPERACJA_REALIZACJA_DAROWIZNA_FK FOREIGN KEY (OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE REALIZACJA_RECEPTA_MAGAZYN
	ADD CONSTRAINT MAGAZYN_OPERACJA_REALIZACJA_MAGAZYN_FK FOREIGN KEY (OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE REALIZACJA_WRP
	ADD CONSTRAINT MAGAZYN_OPERACJA_REALIZACJA_WRP_FK FOREIGN KEY (OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT M_OPERACJA_DP_NOTA_OPERACJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_ODSETKI_POZYCJA
	ADD CONSTRAINT M_OPERACJA_DP_ODSETKI_POZYCJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT M_OPERACJA_DP_OPERACJA_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DEPOZYT_P_SW_WPL_POZYCJA
	ADD CONSTRAINT M_OPERACJA_W_DP_SWIADCZENIE_FK FOREIGN KEY (M_OPERACJA_ID)
	REFERENCES MAGAZYN_OPERACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT MIEJSCE_POBYTU_NIEOBECNOSC_INFORMACJA_FK FOREIGN KEY (MIEJSCE_ID)
	REFERENCES MIEJSCE_POBYTU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPIS_ZWROT
	ADD CONSTRAINT NIEOBECNOSC_ODPIS_ZWROT_FK FOREIGN KEY (NIEOBECNOSC_ID)
	REFERENCES NIEOBECNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC
	ADD CONSTRAINT NIEOBECNOSC_INFORMACJA_NIEOBECNOSC_FK FOREIGN KEY (NIEOBECNOSC_INFORMACJA_ID)
	REFERENCES NIEOBECNOSC_INFORMACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NOTA_ODPLATNOSC_POZYCJA
	ADD CONSTRAINT NOTA_ODPLATNOSC_NOTA_ODPLATNOSC_POZYCJA_FK FOREIGN KEY (NOTA_ID)
	REFERENCES NOTA_ODPLATNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZADLUZENIE_WYROWNANIE
	ADD CONSTRAINT NOTA_ODPLATNOSC_POZYCJA_ZADLUZENIE_WYROWNANIE_FK FOREIGN KEY (NOTA_POZYCJA_ID)
	REFERENCES NOTA_ODPLATNOSC_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE OCENA_KRYTERIUM
	ADD CONSTRAINT OCENA_OSOBA_SKALA_OCENA_KRYTERIUM_FK FOREIGN KEY (OCENA_OSOBA_SKALA_ID)
	REFERENCES OCENA_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REAL_OCENA
	ADD CONSTRAINT OCENA_OSOBY_DIAGNOZA_REAL_OCENA_FK FOREIGN KEY (OCENA_OSOBY_ID)
	REFERENCES OCENA_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE KWALIFIKACJA_PIELEGNIARSKA
	ADD CONSTRAINT OCENA_OSOBY_KWALIFIKACJA_PIELEGNIARSKA_FK FOREIGN KEY (OCENA_ID)
	REFERENCES OCENA_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_WYROWNANIE
	ADD CONSTRAINT ODPIS_ZADLUZENIE_WYROWNANIE_FK FOREIGN KEY (ODPIS_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_ZWROT
	ADD CONSTRAINT ODPIS_ZWROT_SWIADCZENIE_DO_ZWROTU_FK FOREIGN KEY (ZWROT_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPIS_ZWROT
	ADD CONSTRAINT ODPIS_ZWROT_ZA_ODPIS_FK FOREIGN KEY (ODPIS_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZADLUZENIE_WYROWNANIE
	ADD CONSTRAINT ZWROT_ZADLUZENIE_WYROWNANIE_FK FOREIGN KEY (ZWROT_ID)
	REFERENCES ODPIS_ZWROT (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_DECYZJA_SKLADNIK
	ADD CONSTRAINT ODPLATNOSC_ODPLATNOSC_DECYZJA_SKLADNIK_FK FOREIGN KEY (ODPLATNOSC_ID)
	REFERENCES ODPLATNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ODPLATNOSC_SKLADNIK
	ADD CONSTRAINT ODPLATNOSC_ODPLATNOSC_SKLADNIK_FK FOREIGN KEY (ODPLATNOSC_ID)
	REFERENCES ODPLATNOSC (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE NALICZENIE_POBYT
	ADD CONSTRAINT ODPLATNOSC_DOLICZENIE_POBYT_NALICZENIE_POBYT_FK FOREIGN KEY (DOLICZENIE_ID)
	REFERENCES ODPLATNOSC_DOLICZENIE_POBYT (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DECYZJA_O_ODPLATNOSCI
	ADD CONSTRAINT DOTYCZY_CZLONKA_RODZINY FOREIGN KEY (CZLONEK_RODZ_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_O_ODPLATNOSCI
	ADD CONSTRAINT DOTYCZY_MIESZKANCA FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
	ADD CONSTRAINT MIESZKANIEC_ZESTAWIENIE_WINIEN_MA_POZYCJA_FK FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POSTANOWIENIE_SADU
	ADD CONSTRAINT OPIEKUN_POSTANOWIENIE_SADU_FK FOREIGN KEY (OPIEKUN_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_DZ_O_ODPLATNOSCI
	ADD CONSTRAINT OSOBA_DECYZJA_DZ_O_ODPLATNOSCI_FK FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_KIERUJACA
	ADD CONSTRAINT OSOBA_DECYZJA_KIERUJACA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_WYGASZAJACA
	ADD CONSTRAINT OSOBA_DECYZJA_WYGASZAJACA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DOPLATA_LIMIT
	ADD CONSTRAINT OSOBA_DOPLATA_LIMIT_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DOWOD_OSOBISTY
	ADD CONSTRAINT OSOBA_DOWOD_OSOBISTY_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE FAKTURA
	ADD CONSTRAINT OSOBA_FAKTURA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INSTYTUCJA_WPLATA_POZYCJA
	ADD CONSTRAINT OSOBA_INSTYTUCJA_WPLATA_POZYCJA_FK FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_KONTO
	ADD CONSTRAINT OSOBA_KONTO_DEPOZYT_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OCENA_OSOBY
	ADD CONSTRAINT OSOBA_OCENA_OSOBA_SKALA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_AKTUALIZACJA
	ADD CONSTRAINT OSOBA_ODPLATNOSC_AKTUALIZACJA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_SKLADNIK
	ADD CONSTRAINT OSOBA_ODPLATNOSC_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ORZECZ_O_NIEPELNOSPRAW
	ADD CONSTRAINT OSOBA_ORZECZ_O_NIEPELNOSPRAW_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_ADRES
	ADD CONSTRAINT OSOBA_OSOBA_ADRES_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_INFORMACJA_DODATKOWA
	ADD CONSTRAINT OSOBA_OSOBA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_KONTO_BANKOWE
	ADD CONSTRAINT OSOBA_OSOBA_KONTO_BANKOWE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_PARAMETR
	ADD CONSTRAINT OSOBA_OSOBA_PARAMETR_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE OSOBA_PRACOWNIK
	ADD CONSTRAINT OSOBA_OSOBA_PRACOWNIK_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_RODZINA
	ADD CONSTRAINT OSOBA_OSOBA_RODZINA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_SPRAWOZDANIE
	ADD CONSTRAINT OSOBA_OSOBA_SPRAWOZDANIE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_POZYCJA
	ADD CONSTRAINT OSOBA_OSOBA_ZADLUZENIE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLAN_WSPARCIA_REALIZACJA
	ADD CONSTRAINT OSOBA_PLAN_WSPARCIA_REALIZACJA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POBIERANE_SWIADCZENIE
	ADD CONSTRAINT OSOBA_POBIERANE_SWIADCZENIE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS
	ADD CONSTRAINT OSOBA_POBYT_DPS_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POSTANOWIENIE_SADU
	ADD CONSTRAINT OSOBA_POSTANOWIENIE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE REALIZACJA_RECEPTA
	ADD CONSTRAINT OSOBA_REALIZACJA_RECEPTA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ROZLICZENIE
	ADD CONSTRAINT OSOBA_ROZLICZENIE_FK FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_REALIZACJA
	ADD CONSTRAINT OSOBA_SWIADCZENIE_REALIZACJA_FK FOREIGN KEY (MIESZKANIEC_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA
	ADD CONSTRAINT OSOBA_WPLATA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE
	ADD CONSTRAINT OSOBA_ZADLUZENIE_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
	ADD CONSTRAINT OSOBA_ZESTAWIENIE_WINIEN_MA_POZYCJA_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZLECENIE_WYROB_MEDYCZNY
	ADD CONSTRAINT OSOBA_ZLECENIE_WYROB_MEDYCZNY_FK FOREIGN KEY (OSOBA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UMOWA
	ADD CONSTRAINT ZLECENIODAWCA_UMOWA_FK FOREIGN KEY (ZLECENIODAWCA_ID)
	REFERENCES OSOBA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_SPRAWOZDANIE_WARTOSC
	ADD CONSTRAINT OSOBA_SPRAWOZDANIE_OSOBA_SPRAWOZDANIE_WARTOSC_FK FOREIGN KEY (OSOBA_SPRAWOZDANIE_ID)
	REFERENCES OSOBA_SPRAWOZDANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PLAN_WSPARCIA_CZYNNOSC
	ADD CONSTRAINT PLAN_WSPARCIA_MIESZKANCA_PLAN_WSPARCIA_CZYNNOSC_FK FOREIGN KEY (PLAN_ID)
	REFERENCES PLAN_WSPARCIA_MIESZKANCA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PLAN_WSPARCIA_DIAGNOZA_PODSTAWA
	ADD CONSTRAINT PLAN_WSPARCIA_MIESZKANCA_PLAN_WSPARCIA_DIAGNOZA_PODSTAWA_FK FOREIGN KEY (PLAN_WSPARCIA_ID)
	REFERENCES PLAN_WSPARCIA_MIESZKANCA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PLAN_WSPARCIA_MIESZKANCA
	ADD CONSTRAINT PLAN_WSPARCIA_MIESZKANCA_PLAN_WSPARCIA_MIESZKANCA_FK FOREIGN KEY (PLAN_AKTUALIZOWANY_ID)
	REFERENCES PLAN_WSPARCIA_MIESZKANCA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZEBRANIE_ZTO_WYKONANO
	ADD CONSTRAINT PLAN_WSPARCIA_MIESZKANCA_ZEBRANIE_ZTO_WYKONANO_FK FOREIGN KEY (PLAN_WSPARCIA_ID)
	REFERENCES PLAN_WSPARCIA_MIESZKANCA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE CZYNNOSC_REALIZACJA
	ADD CONSTRAINT PLAN_WSPARCIA_REALIZACJA_CZYNNOSC_REALIZACJA_FK FOREIGN KEY (PLAN_WSPARCIA_REALIZACJA_ID)
	REFERENCES PLAN_WSPARCIA_REALIZACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UWAGI_REALIZACJA_PLANU
	ADD CONSTRAINT PLAN_WSPARCIA_REALIZACJA_REALIZACJA_UWAGI_FK FOREIGN KEY (PLAN_WSPARCIA_REALIZACJA_ID)
	REFERENCES PLAN_WSPARCIA_REALIZACJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA_PLIK_POZYCJA
	ADD CONSTRAINT PLIK_CSV_WPLATA_PLIK_POZYCJA_FK FOREIGN KEY (PLIK_CSV_ID)
	REFERENCES PLIK_CSV (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DOCHOD_SWIADCZENIE_SKLADNIK
	ADD CONSTRAINT POBIERANE_SWIADCZENIE_OPDLATNOSC_SWIADCZENIE_SKLADNIK_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POBIERANE_SWIADCZENIE
	ADD CONSTRAINT POBIERANE_SWIADCZENIE_POBIERANE_SWIADCZENIE_FK FOREIGN KEY (SWIADCZENIE_ZMIENIONE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_DODATEK
	ADD CONSTRAINT POBIERANE_SWIADCZENIE_SWIADCZENIE_DODATEK_FK FOREIGN KEY (POBIERANE_SWIADCZENIE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SWIADCZENIE_ZWROT
	ADD CONSTRAINT POBIERANE_SWIADCZENIE_SWIADCZENIE_ZWROT_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA
	ADD CONSTRAINT POBIERANE_SWIADCZENIE_WPLATA_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES POBIERANE_SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE GRUPA_ZNAKOW
	ADD CONSTRAINT POLITYKA_BEZPIECZENSTWA_GRUPA_ZNAKOW_FK FOREIGN KEY (POLITYKA_ID)
	REFERENCES POLITYKA_BEZPIECZENSTWA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DAWKA_LEK
	ADD CONSTRAINT PORA_DNIA_DAWKA_LEK_FK FOREIGN KEY (PORA_ID)
	REFERENCES PORA_DNIA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DAWKA_PODANIE
	ADD CONSTRAINT PORA_DNIA_DAWKA_PODANIE_FK FOREIGN KEY (PORA_ID)
	REFERENCES PORA_DNIA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POLE_PORA_DNIA
	ADD CONSTRAINT PORA_DNIA_POLE_PORA_DNIA_FK FOREIGN KEY (WARTOSC)
	REFERENCES PORA_DNIA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE REALIZACJA_WRP
	ADD CONSTRAINT PORA_DNIA_REALIZACJA_WRP_FK FOREIGN KEY (PORA_DNIA_ID)
	REFERENCES PORA_DNIA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_KIERUJACA
	ADD CONSTRAINT POSTANOWIENIE_SADU_DECYZJA_KIERUJACA_FK FOREIGN KEY (POSTANOWIENIE_SADU_ID)
	REFERENCES POSTANOWIENIE_SADU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ARCHIWIZACJA_BAZY
	ADD CONSTRAINT PRACOWNIK_ARCHIWIZACJA_BAZY_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DIAGNOZA_REALIZACJA
	ADD CONSTRAINT PRACOWNIK_DIAGNOZA_REALIZACJA_FK FOREIGN KEY (PRACOWNIK_WYKONAL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE FAKTURA
	ADD CONSTRAINT PRACOWNIK_FAKTURA_FK FOREIGN KEY (PRACOWNIK_WPROWADZIL)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NOTA_ODPLATNOSC
	ADD CONSTRAINT PRACOWNIK_NOTA_ODPLATNOSC_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INFORMACJA_DODATKOWA_WPIS
	ADD CONSTRAINT PRACOWNIK_OSOBA_INFORMACJA_DODATKOWA_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_PRACOWNIK
	ADD CONSTRAINT PRACOWNIK_OSOBA_PRZYPISANY_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_PRACOWNIK
	ADD CONSTRAINT PRACOWNIK_OSOBA_PRZYPISUJACY_FK FOREIGN KEY (PRACOWNIK_PRZYPISAL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_PRACOWNIK
	ADD CONSTRAINT PRACOWNIK_OSOBA_ZMIENIL_FK FOREIGN KEY (PRACOWNIK_ZMIENIL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLAN_WSPARCIA_REALIZACJA
	ADD CONSTRAINT PRACOWNIK_PLAN_WSPARCIA_REALIZACJA_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLIK_CSV
	ADD CONSTRAINT PRACOWNIK_PLIK_CSV_IMPORT_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POLE_PRACOWNIK
	ADD CONSTRAINT PRACOWNIK_POLE_PRACOWNIK_FK FOREIGN KEY (WARTOSC)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PRACOWNIK_HISTORIA_HASLA
	ADD CONSTRAINT PRACOWNIK_PRACOWNIK_HISTORIA_HASLA_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PRACOWNIK_PARAMETR
	ADD CONSTRAINT PRACOWNIK_PRACOWNIK_PARAMETR_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT PRACOWNIK_PRZYJAL_INFORMACJA_FK FOREIGN KEY (PRACOWNIK_PRZYJAL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ROZLICZENIE
	ADD CONSTRAINT PRACOWNIK_ROZLICZENIE_FK FOREIGN KEY (PRACOWNIK_WYKONAL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT PRACOWNIK_SKIEROWAL_INFORMACJA_FK FOREIGN KEY (PRACOWNIK_SKIEROWAL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT PRACOWNIK_WPROWADZIL_INFORMACJA_FK FOREIGN KEY (PRACOWNIK_WPROWADZIL_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZEBRANIE_ZTO_PRACOWNIK
	ADD CONSTRAINT PRACOWNIK_ZEBRANIE_ZTO_PRACOWNIK_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA
	ADD CONSTRAINT PRACOWNIK_ZESTAWIENIE_WINIEN_MA_FK FOREIGN KEY (PRACOWNIK_ID)
	REFERENCES PRACOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE QRTZ_TRIGGERS
	ADD CONSTRAINT FK_QRTZ_TRIGGERS_QRTZ_JOB_DETAILS FOREIGN KEY (SCHED_NAME, JOB_NAME, JOB_GROUP)
	REFERENCES QRTZ_JOB_DETAILS (SCHED_NAME, JOB_NAME, JOB_GROUP)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE QRTZ_CRON_TRIGGERS
	ADD CONSTRAINT FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	REFERENCES QRTZ_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE QRTZ_SIMPLE_TRIGGERS
	ADD CONSTRAINT FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	REFERENCES QRTZ_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE QRTZ_SIMPROP_TRIGGERS
	ADD CONSTRAINT FK_QRTZ_SIMPROP_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	REFERENCES QRTZ_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE LEK_REALIZACJA
	ADD CONSTRAINT REALIZACJA_RECEPTA_LEK_REALIZACJA_FK FOREIGN KEY (REALIZACJA_RECEPTA_ID)
	REFERENCES REALIZACJA_RECEPTA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE REALIZACJA_RECEPTA_MAGAZYN
	ADD CONSTRAINT REALIZACJA_RECEPTA_REALIZACJA_MAGAZYN_FK FOREIGN KEY (REALIZACJA_ID)
	REFERENCES REALIZACJA_RECEPTA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE RECEPTA_LEK
	ADD CONSTRAINT RECEPTA_RECEPTA_LEK_FK FOREIGN KEY (RECEPTA_ID)
	REFERENCES RECEPTA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POBIERANE_SWIADCZENIE
	ADD CONSTRAINT RODZAJ_POB_SWIADCZENIA_POBIERANE_SWIADCZENIE_FK FOREIGN KEY (KOD_SWIADCZENIA_ID)
	REFERENCES RODZAJ_POB_SWIADCZENIA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA_RODZINA
	ADD CONSTRAINT RODZINA_OSOBA_RODZINA_FK FOREIGN KEY (RODZINA_ID)
	REFERENCES RODZINA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ROZLICZENIE_SWIADCZENIE
	ADD CONSTRAINT ROZLICZENIE_ROZLICZENIE_SWIADCZENIE_FK FOREIGN KEY (ROZLICZENIE_ID)
	REFERENCES ROZLICZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE POSTANOWIENIE_SADU
	ADD CONSTRAINT SAD_POSTANOWIENIE_SADU_FK FOREIGN KEY (SAD_ID)
	REFERENCES SAD (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA_SKALA_OCENY
	ADD CONSTRAINT SKALA_OCENY_OSOBY_DIAGNOZA_SKALA_OCENY_FK FOREIGN KEY (SKALA_OCENY_ID)
	REFERENCES SKALA_OCENY_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA_GRUPA_OSOB
	ADD CONSTRAINT SKALA_OCENY_OSOBY_KAT_USL_GRUPA_OSOB_FK FOREIGN KEY (SKALA_OCENY_ID)
	REFERENCES SKALA_OCENY_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE OCENA_OSOBY
	ADD CONSTRAINT SKALA_OCENY_OSOBY_OCENA_OSOBA_SKALA_FK FOREIGN KEY (SKALA_OCENY_ID)
	REFERENCES SKALA_OCENY_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SKALA_KRYTERIUM_OCENY
	ADD CONSTRAINT SKALA_PUNKTOWA_SKALA_KRYTERIUM_OCENY_FK FOREIGN KEY (SKALA_ID)
	REFERENCES SKALA_OCENY_OSOBY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SLOWO
	ADD CONSTRAINT SLOWNIK_SLOWO_FK FOREIGN KEY (SLOWNIK_ID)
	REFERENCES SLOWNIK (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_DZ_O_ODPLATNOSCI
	ADD CONSTRAINT SLOWO_DECYZJA_DZ_O_ODPLATNOSCI_FK FOREIGN KEY (KTO_WYDAL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_KIERUJACA
	ADD CONSTRAINT SLOWO_DECYZJA_KIERUJACA_FK FOREIGN KEY (KTO_WYDAL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_O_ODPLATNOSCI
	ADD CONSTRAINT SLOWO_DECYZJA_O_ODPLATNOSCI_FK FOREIGN KEY (KTO_WYDAL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DIAGNOZA
	ADD CONSTRAINT SLOWO_DIAGNOZA_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DOWOD_OSOBISTY
	ADD CONSTRAINT SLOWO_DOWOD_OSOBISTY_FK FOREIGN KEY (WYDANY_PRZEZ_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS
	ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_FK FOREIGN KEY (DOKAD_ODSZEDL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS_ZGON
	ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_MIEJSCE_FK FOREIGN KEY (MIEJSCE_ZGONU_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS_ZGON
	ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_ODP_POGRZEB_FK FOREIGN KEY (ODPOWIEDZIALNY_ZA_POGRZEB_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS_ZGON
	ADD CONSTRAINT SLOWO_EWIDENCJA_DPS_ZGON_USC_FK FOREIGN KEY (USC_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE INFORMACJA_DODATKOWA_ROZSZERZENIE
	ADD CONSTRAINT SLOWO_INFORMACJA_DODATKOWA_ROZSZERZENIE_WARTOSCTR_FK FOREIGN KEY (WARTOSC_TR)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_UMIESZCZAJACA
	ADD CONSTRAINT SLOWO_KTO_WYDAL_DECYZJA_UMIESZCZAJACA_FK FOREIGN KEY (KTO_WYDAL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE KWALIFIKACJA_OS_WYMAGA
	ADD CONSTRAINT SLOWO_KWALIFIKACJA_OS_WYMAGA_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE RECEPTA
	ADD CONSTRAINT SLOWO_LEKARZ_RECEPTA_FK FOREIGN KEY (LEKARZ_WYSTAWIL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE LEK_REALIZACJA
	ADD CONSTRAINT SLOWO_LEK_REALIZACJA_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE MAGAZYN_OPERACJA
	ADD CONSTRAINT SLOWO_MAGAZYN_OPERACJA_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT SLOWO_NIEOBECNOSC_INFORMACJA_DYZUR_POWROT_FK FOREIGN KEY (DYZUR_POWROT_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC_INFORMACJA
	ADD CONSTRAINT SLOWO_NIEOBECNOSC_INFORMACJA_DYZUR_WYJAZD_FK FOREIGN KEY (DYZUR_WYJAZD_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODBIOR_ODPADOW
	ADD CONSTRAINT SLOWO_ODBIOR_ODPADOW_FK FOREIGN KEY (ODBIERAJACY_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODBIOR_ODPADOW
	ADD CONSTRAINT SLOWO_ODBIOR_RODZAJ_MATERIALU_FK FOREIGN KEY (RODZAJ_MATERIALU_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ORZECZ_O_NIEPELNOSPRAW
	ADD CONSTRAINT SLOWO_ORZECZ_O_NIEPELNOSPRAW_FK FOREIGN KEY (WYDANE_PRZEZ_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA
	ADD CONSTRAINT SLOWO_OSOBA_FK FOREIGN KEY (STAN_CYWILNY_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PARAMETR_SYSTEMOWY
	ADD CONSTRAINT SLOWO_PARAMETR_SYSTEMOWY_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE PLAN_WSPARCIA_MIESZKANCA
	ADD CONSTRAINT SLOWO_PLAN_WSPARCIA_MIESZKANCA_FK FOREIGN KEY (PRACOWNIK_PK_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POLE_SLOWNIK
	ADD CONSTRAINT SLOWO_POLE_SLOWNIK_FK FOREIGN KEY (WARTOSC)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POSTANOWIENIE_SADU
	ADD CONSTRAINT SLOWO_POSTANOWIENIE_SADU_FK FOREIGN KEY (RODZAJ_POSTANOWIENIA_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE REALIZACJA_DAROWIZNA
	ADD CONSTRAINT SLOWO_REALIZACJA_DAROWIZNA_FK FOREIGN KEY (PODMIOT_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC
	ADD CONSTRAINT SLOWO_RODZAJ_NIEOBECNOSCI_FK FOREIGN KEY (RODZAJ_NIEOBECNOSCI_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS
	ADD CONSTRAINT SLOWO_SKAD_PRZYSZEDL_EWIDENCJA_DPS_FK FOREIGN KEY (SKAD_PRZYSZEDL_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_DODATEK
	ADD CONSTRAINT SLOWO_SWIADCZENIE_DODATEK_FK FOREIGN KEY (KOD_DODATKU_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UMOWA_KWOTA
	ADD CONSTRAINT SLOWO_UMOWA_KWOTA_FK FOREIGN KEY (SLOWO_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POSTANOWIENIE_SADU
	ADD CONSTRAINT SLOWO_ZAKRES_POSTANOWIENIE_SADU_FK FOREIGN KEY (ZAKRES_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZAPOMOGA
	ADD CONSTRAINT SLOWO_ZAPOMOGA_FK FOREIGN KEY (RODZAJ_ZAPOMOGI_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA
	ADD CONSTRAINT WYKSZTALCENIE_OSOBA_FK FOREIGN KEY (WYKSZTALCENIE_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE OSOBA
	ADD CONSTRAINT WYZNANIE_OSOBA_FK FOREIGN KEY (WYZNANIE_ID)
	REFERENCES SLOWO (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SPRAWOZDANIE_PODPOWIEDZ_WARTOSC
	ADD CONSTRAINT SPRAWOZDANIE_PODPOWIEDZ_SPRAWOZDANIE_PODPOWIEDZ_WARTOSC_FK FOREIGN KEY (SPRAWOZDANIE_PODPOWIEDZ_ID)
	REFERENCES SPRAWOZDANIE_PODPOWIEDZ (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE DECYZJA_SWIADCZENIE
	ADD CONSTRAINT SWIADCZENIE_DECYZJA_SWIADCZENIE_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ROZLICZENIE_SWIADCZENIE
	ADD CONSTRAINT SWIADCZENIE_ROZLICZENIE_SWIADCZENIE_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_DZIEN_WOLNY
	ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_DZIEN_WOLNY_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE
	ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_FK FOREIGN KEY (ROZLICZAJ_W_RAMACH_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_ODPLATNOSC
	ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_ODPLATNOSC_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SWIADCZENIE_REALIZACJA
	ADD CONSTRAINT SWIADCZENIE_SWIADCZENIE_REALIZACJA_FK FOREIGN KEY (SWIADCZENIE_ID)
	REFERENCES SWIADCZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE
	ADD CONSTRAINT SWIADCZENIE_GRUPA_SWIADCZENIE_FK FOREIGN KEY (GRUPA_ID)
	REFERENCES SWIADCZENIE_GRUPA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_WPLATA_POZYCJA
	ADD CONSTRAINT SWIADCZENIE_WPLATA_SWIADCZENIE_WPLATA_POZYCJA_FK FOREIGN KEY (SWIADCZENIE_WPLATA_ID)
	REFERENCES SWIADCZENIE_WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE NOTA_ODPLATNOSC
	ADD CONSTRAINT SZABLON_WYDRUKU_2_NOTA_ODPLATNOSC_FK FOREIGN KEY (SZABLON_WYDRUKU_2_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_O_ODPLATNOSCI
	ADD CONSTRAINT SZABLON_WYDRUKU_DECYZJA_O_ODPLATNOSCI_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_UCHYLAJACA
	ADD CONSTRAINT SZABLON_WYDRUKU_DECYZJA_UCHYLAJACA_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DECYZJA_WYGASZAJACA
	ADD CONSTRAINT SZABLON_WYDRUKU_DECYZJA_WYGASZAJACA_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS
	ADD CONSTRAINT SZABLON_WYDRUKU_EWIDENCJA_DPS_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE EWIDENCJA_DPS_ZGON
	ADD CONSTRAINT SZABLON_WYDRUKU_EWIDENCJA_DPS_ZGON_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NIEOBECNOSC
	ADD CONSTRAINT SZABLON_WYDRUKU_NIEOBECNOSC_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE NOTA_ODPLATNOSC
	ADD CONSTRAINT SZABLON_WYDRUKU_NOTA_ODPLATNOSC_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SZABLON_BLOK_FTL
	ADD CONSTRAINT SZABLON_WYDRUKU_SZABLON_BLOK_FTL_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SZABLON_WYDRUKU_PLIK
	ADD CONSTRAINT SZABLON_WYDRUKU_SZABLON_WYDRUKU_PLIK_FK FOREIGN KEY (ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE SZABLON_WYDRUKU_TRESC
	ADD CONSTRAINT SZABLON_WYDRUKU_SZABLON_WYDRUKU_TRESC_FK FOREIGN KEY (ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZEBRANIE_ZTO
	ADD CONSTRAINT SZABLON_WYDRUKU_ZEBRANIE_ZTO_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA
	ADD CONSTRAINT SZABLON_WYDRUKU_ZESTAWIENIE_WINIEN_MA_FK FOREIGN KEY (SZABLON_WYDRUKU_ID)
	REFERENCES SZABLON_WYDRUKU (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE POBIERANE_SWIADCZENIE
	ADD CONSTRAINT TERMIN_WYPLATY_POBIERANE_SWIADCZENIE_FK FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_WPLATA
	ADD CONSTRAINT TERMIN_WYPLATY_WPLATA_SWIADCZENIE_FK FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_SW_WPLATA
	ADD CONSTRAINT TERMIN_WYPL_DP_WPLATA_FK FOREIGN KEY (TERMIN_WYPLATY_ID)
	REFERENCES TERMIN_WYPLATY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE UMOWA_PARAMETR
	ADD CONSTRAINT UMOWA_UMOWA_PARAMETR_FK FOREIGN KEY (UMOWA_ID)
	REFERENCES UMOWA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE UMOWA_KWOTA
	ADD CONSTRAINT UMOWA_APTEKA_UMOWA_KWOTA_FK FOREIGN KEY (UMOWA_ID)
	REFERENCES UMOWA_APTEKA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE FAKTURA
	ADD CONSTRAINT UMOWA_KWOTA_FAKTURA_FK FOREIGN KEY (UMOWA_APTEKA_KWOTA_ID)
	REFERENCES UMOWA_KWOTA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_FAKTURA
	ADD CONSTRAINT WPLATA_DP_FAKTURA_OPERACJA_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE INSTYTUCJA_WPLATA_POZYCJA
	ADD CONSTRAINT WPLATA_INSTYTUCJA_WPLATA_POZYCJA_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_WPLATA_POZYCJA
	ADD CONSTRAINT WPLATA_SWIADCZENIE_WPLATA_POZYCJA_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA_PLIK_POZYCJA
	ADD CONSTRAINT WPLATA_WPLATA_PLIK_POZYCJA_FK FOREIGN KEY (POZYCJA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE WPLATA_SKLADNIK
	ADD CONSTRAINT WPLATA_WPLATA_SKLADNIK_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE WYROWNANIE_WPLATA
	ADD CONSTRAINT WPLATA_WYROWNANIE_WPLATA_FK FOREIGN KEY (WPLATA_ID)
	REFERENCES WPLATA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_POZYCJA
	ADD CONSTRAINT ZADLUZENIE_OSOBA_ZADLUZENIE_FK FOREIGN KEY (ZADLUZENIE_ID)
	REFERENCES ZADLUZENIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE NALICZENIE_POBYT
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_NALICZENIE_POBYT_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ODPIS_ZWROT
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_ODPIS_ZWROT_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ODPLATNOSC_DOLICZENIE_POBYT
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_ODPLATNOSC_DOLICZENIE_POBYT_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE PRZELEW_DRUK
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_PRZELEW_DRUK_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE SWIADCZENIE_ZWROT
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_SWIADCZENIE_ZWROT_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WPLATA_SKLADNIK
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_WPLATA_SKLADNIK_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZADLUZENIE_START
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_ZADLUZENIE_START_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZADLUZENIE_WYROWNANIE
	ADD CONSTRAINT ZADLUZENIE_POZYCJA_ZADLUZENIE_WYROWNANIE_FK FOREIGN KEY (ZADLUZENIE_POZYCJA_ID)
	REFERENCES ZADLUZENIE_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE DEPOZYT_P_NOTA_OPERACJA
	ADD CONSTRAINT DP_NOTA_OPERACJA_ZW_POZYCJA_FK FOREIGN KEY (ZADLUZENIE_WYROWNANIE_ID)
	REFERENCES ZADLUZENIE_WYROWNANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE WYROWNANIE_WPLATA
	ADD CONSTRAINT ZADLUZENIE_WYROWNANIE_WYROWNANIE_WPLATA_FK FOREIGN KEY (WYROWNANIE_ID)
	REFERENCES ZADLUZENIE_WYROWNANIE (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZEBRANIE_ZTO_PLAN
	ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_PLAN_FK FOREIGN KEY (ZEBRANIE_ZTO_ID)
	REFERENCES ZEBRANIE_ZTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZEBRANIE_ZTO_PRACOWNIK
	ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_PRACOWNIK_FK FOREIGN KEY (ZEBRANIE_ZTO_ID)
	REFERENCES ZEBRANIE_ZTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZEBRANIE_ZTO_WYKONANO
	ADD CONSTRAINT ZEBRANIE_ZTO_ZEBRANIE_ZTO_WYKONANO_FK FOREIGN KEY (ZEBRANIE_ZTO_ID)
	REFERENCES ZEBRANIE_ZTO (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
	ADD CONSTRAINT ZADLUZENIE_WINIEN_MA_ZADLUZENIE_WINIEN_MA_POZYCJA_FK FOREIGN KEY (ZESTAWIENIE_ID)
	REFERENCES ZESTAWIENIE_WINIEN_MA (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZESTAWIENIE_WINIEN_MA_POZYCJA
	ADD CONSTRAINT ZESTAWIENIE_WINIEN_MA_POZYCJA_ZESTAWIENIE_WINIEN_MA_POZYCJA_FK FOREIGN KEY (POPRZEDNIA_POZYCJA_ID)
	REFERENCES ZESTAWIENIE_WINIEN_MA_POZYCJA (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


ALTER TABLE ZLECENIE_WYDANIA_WYROB_MIESIAC
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_MIESIAC_DOTYCZY_FK FOREIGN KEY (ZLECENIE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZLECENIE_PRZEDMIOT
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_PRZEDMIOT_FK FOREIGN KEY (ZLECENIE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZLECENIE_SOCZEWKA
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_SOCZEWKI_FK FOREIGN KEY (ZLECENIE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZLECENIE_UPRAWNIENIA
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_UPRAWNIENIA_FK FOREIGN KEY (ZLECENIE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZLECENIE_WYDANIE_WYROB
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_WYDANIA_FK FOREIGN KEY (ZLECENIE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE CASCADE
;


ALTER TABLE ZLECENIE_WYROB_MEDYCZNY
	ADD CONSTRAINT ZLECENIE_WYROB_MEDYCZNY_ZLECENIE_WYROB_MEDYCZNY_FK FOREIGN KEY (ZLECENIE_NADRZEDNE_ID)
	REFERENCES ZLECENIE_WYROB_MEDYCZNY (ID)
	ON UPDATE NO ACTION
	ON DELETE NO ACTION
;


