package pl.topteam.dps.db.model.bazmed;

import static pl.topteam.dps.db.generator.SQLExecutor.executeSql;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;

import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.Test;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;

import pl.topteam.dps.db.model.AbstractGeneratorTest;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;

public class GenerateModelTest extends AbstractGeneratorTest {

	@Test
	public void generate() throws IOException, XMLParserException,
			InvalidConfigurationException, SQLException, InterruptedException {
		// create main database in-memory creation
		String bazmedJdbcURL = "jdbc:h2:mem:test_bazmed";
		JdbcConnectionPool jdbccpMain = JdbcConnectionPool.create(bazmedJdbcURL, "sysdba", "masterkey");
		try (Connection conn = jdbccpMain.getConnection()) {
			for (Path[] s : pl.topteam.dps.db.generator.bazmed.CreateDatabaseTest.schemaScripts()) {
				executeSql(conn, s.toString(), CharStreams.toString(new InputStreamReader(getClass().getResourceAsStream("/" + s[0]), Charsets.UTF_8)));
			}
		}

		// temporary generation dir
		File tempGeneratedDir = tmpWorkingDir.newFolder("_mybatis-generator");

		// generator parameter
		ImmutableMap<String, Object> properties = new ImmutableMap.Builder<String, Object>()
				.put("_mybatis_generator_tmp", tempGeneratedDir.getAbsolutePath())

				.put("bazmed_jdbcDriver", "org.h2.Driver")
				.put("bazmed_jdbcUserId", "sysdba")
				.put("bazmed_jdbcPassword", "masterkey")
				.put("bazmed_jdbcURL", bazmedJdbcURL)

				.build();

		// generator parser and final configuration
		ConfigurationParser cp = new ConfigurationParser(warnings);
		Configuration config =
				cp.parseConfiguration(
						new StringReader(
								processConfig(
										new InputStreamReader(
												getClass().getResourceAsStream("/mybatis-BAZMED-config.xml"), Charsets.UTF_8), properties)));

		// check table synchronization
		Set<String> tablesFromConfiguration = Sets.newHashSet();
		for(Context c : config.getContexts()) {
			switch(c.getId()) {
				case "bazmedDpsModel":
					tablesFromConfiguration.addAll(
							FluentIterable
								.from(c.getTableConfigurations())
								.transform(new Function<TableConfiguration, String>() {
									@Override
									public String apply(TableConfiguration t) {
										return t.getTableName();
									}
								}).toList());
					break;
			}
		}
		try (Connection conn = jdbccpMain.getConnection()) {
			checkGeneratorConfiguration(conn, tablesFromConfiguration);
		}

		// GENERATE yeah :)
		generateModel(config);
	}
}
