package pl.topteam.dps.db.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.log4j.Logger;

import com.google.common.collect.Lists;

public class SchemaUtils {
	private static final Logger log = Logger.getLogger(SchemaUtils.class);

	/**
	 * Pobiera nazwy tabel z bazy danych do ktorej jest polaczenie con;
	 *
	 * @param con
	 *            polaczenie z baza danych
	 * @return lista nazw tabel
	 * @throws SQLException
	 * @throws Exception
	 */
	public static List<String> getTableNames(Connection con) throws SQLException {
		List<String> tableNames = Lists.newArrayList();
		DatabaseMetaData dmd = con.getMetaData();

		try (ResultSet set = dmd.getTables(null, "%", "%", new String[] { "TABLE" })) {
			while (set.next()) {
				tableNames.add(set.getString("TABLE_NAME").trim().toUpperCase());
			}
		} catch (SQLException e) {
			log.error(e.getMessage(), e);

			throw e;
		}

		return tableNames;
	}
}
