/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.model.bazmed;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.Test;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import pl.topteam.dps.db.generator.SQLExecutor;
import pl.topteam.dps.db.generator.bazmed.CreateDatabaseTest;
import pl.topteam.dps.db.model.AbstractGeneratorTest;

public class GenerateModelTest
extends AbstractGeneratorTest {
    @Test
    public void generate() throws IOException, XMLParserException, InvalidConfigurationException, SQLException, InterruptedException {
        String bazmedJdbcURL = "jdbc:h2:mem:test_bazmed";
        JdbcConnectionPool jdbccpMain = JdbcConnectionPool.create((String)bazmedJdbcURL, (String)"sysdba", (String)"masterkey");
        try (Connection conn = jdbccpMain.getConnection();){
            for (Path[] s : CreateDatabaseTest.schemaScripts()) {
                SQLExecutor.executeSql((Connection)conn, (String)s.toString(), (String)CharStreams.toString((Readable)new InputStreamReader(this.getClass().getResourceAsStream("/" + s[0]), Charsets.UTF_8)));
            }
        }
        File tempGeneratedDir = this.tmpWorkingDir.newFolder("_mybatis-generator");
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"_mybatis_generator_tmp", (Object)tempGeneratedDir.getAbsolutePath()).put((Object)"bazmed_jdbcDriver", (Object)"org.h2.Driver").put((Object)"bazmed_jdbcUserId", (Object)"sysdba").put((Object)"bazmed_jdbcPassword", (Object)"masterkey").put((Object)"bazmed_jdbcURL", (Object)bazmedJdbcURL).build();
        ConfigurationParser cp = new ConfigurationParser(this.warnings);
        Configuration config = cp.parseConfiguration((Reader)new StringReader(this.processConfig(new InputStreamReader(this.getClass().getResourceAsStream("/mybatis-BAZMED-config.xml"), Charsets.UTF_8), (Map<String, Object>)properties)));
        HashSet tablesFromConfiguration = Sets.newHashSet();
        for (Context c : config.getContexts()) {
            switch (c.getId()) {
                case "bazmedDpsModel": {
                    tablesFromConfiguration.addAll(FluentIterable.from((Iterable)c.getTableConfigurations()).transform((Function)new Function<TableConfiguration, String>(){

                        public String apply(TableConfiguration t) {
                            return t.getTableName();
                        }
                    }).toList());
                }
            }
        }
        try (Connection conn = jdbccpMain.getConnection();){
            this.checkGeneratorConfiguration(conn, tablesFromConfiguration);
        }
        this.generateModel(config);
    }
}

