/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.model.main;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import org.h2.jdbcx.JdbcConnectionPool;
import org.junit.Test;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import pl.topteam.dps.db.generator.SQLExecutor;
import pl.topteam.dps.db.generator.main.CreateDatabaseTest;
import pl.topteam.dps.db.model.AbstractGeneratorTest;

public class GenerateModelTest
extends AbstractGeneratorTest {
    @Test
    public void generate() throws IOException, XMLParserException, InvalidConfigurationException, SQLException, InterruptedException {
        Object s2;
        String mainJdbcURL = "jdbc:h2:mem:test_main";
        JdbcConnectionPool jdbccpMain = JdbcConnectionPool.create((String)mainJdbcURL, (String)"sysdba", (String)"masterkey");
        try (Connection conn = jdbccpMain.getConnection();){
            for (Object s2 : CreateDatabaseTest.schemaScripts()) {
                SQLExecutor.executeSql((Connection)conn, (String)s2[0].toString(), (String)CharStreams.toString((Readable)new InputStreamReader(this.getClass().getResourceAsStream("/" + s2[0]), Charsets.UTF_8)));
            }
        }
        String dziennikJdbcURL = "jdbc:h2:mem:test_dziennik";
        JdbcConnectionPool jdbccpDziennik = JdbcConnectionPool.create((String)dziennikJdbcURL, (String)"sysdba", (String)"masterkey");
        Connection conn = jdbccpDziennik.getConnection();
        s2 = null;
        try {
            for (Path[] s3 : pl.topteam.dps.db.generator.dziennik.CreateDatabaseTest.schemaScripts()) {
                SQLExecutor.executeSql((Connection)conn, (String)s3[0].toString(), (String)CharStreams.toString((Readable)new InputStreamReader(this.getClass().getResourceAsStream("/" + s3[0]), Charsets.UTF_8)));
            }
        }
        catch (Throwable x2) {
            s2 = x2;
            throw x2;
        }
        finally {
            if (conn != null) {
                if (s2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable x2) {
                        ((Throwable)s2).addSuppressed(x2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        File tempGeneratedDir = this.tmpWorkingDir.newFolder("_mybatis-generator");
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"_mybatis_generator_tmp", (Object)tempGeneratedDir.getAbsolutePath()).put((Object)"main_jdbcDriver", (Object)"org.h2.Driver").put((Object)"main_jdbcUserId", (Object)"sysdba").put((Object)"main_jdbcPassword", (Object)"masterkey").put((Object)"main_jdbcURL", (Object)mainJdbcURL).put((Object)"dziennik_jdbcDriver", (Object)"org.h2.Driver").put((Object)"dziennik_jdbcUserId", (Object)"sysdba").put((Object)"dziennik_jdbcPassword", (Object)"masterkey").put((Object)"dziennik_jdbcURL", (Object)dziennikJdbcURL).build();
        ConfigurationParser cp = new ConfigurationParser(this.warnings);
        Configuration config = cp.parseConfiguration((Reader)new StringReader(this.processConfig(new InputStreamReader(this.getClass().getResourceAsStream("/mybatis-DPS-config.xml"), Charsets.UTF_8), (Map<String, Object>)properties)));
        HashSet tablesFromConfiguration = Sets.newHashSet();
        for (Context c : config.getContexts()) {
            switch (c.getId()) {
                case "mainDpsModel": 
                case "mainDpsPracownikModel": 
                case "mainDpsChangelogModel": {
                    tablesFromConfiguration.addAll(FluentIterable.from((Iterable)c.getTableConfigurations()).transform((Function)new Function<TableConfiguration, String>(){

                        public String apply(TableConfiguration t) {
                            return t.getTableName();
                        }
                    }).toList());
                }
            }
        }
        try (Connection conn2 = jdbccpMain.getConnection();){
            this.checkGeneratorConfiguration(conn2, tablesFromConfiguration);
        }
        this.generateModel(config);
    }
}

