/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.db.util;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class SchemaUtils {
    private static final Logger log = Logger.getLogger(SchemaUtils.class);

    public static List<String> getTableNames(Connection con) throws SQLException {
        ArrayList tableNames = Lists.newArrayList();
        DatabaseMetaData dmd = con.getMetaData();
        try (ResultSet set = dmd.getTables(null, "%", "%", new String[]{"TABLE"});){
            while (set.next()) {
                tableNames.add(set.getString("TABLE_NAME").trim().toUpperCase());
            }
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return tableNames;
    }
}

