/*
 * Decompiled with CFR 0.152.
 */
package org.h2.function;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.h2.api.AggregateFunction;
import org.h2.util.NullLastComparator;
import org.h2.util.StringComparator;

public class NotNullGroupFunction
implements AggregateFunction {
    private List<Object> notNullObj = new ArrayList<Object>();

    public void init(Connection conn) throws SQLException {
    }

    public int getType(int[] inputTypes) throws SQLException {
        return 2003;
    }

    public void add(Object value) throws SQLException {
        if (value != null) {
            if (value instanceof Object[]) {
                for (Object v : (Object[])value) {
                    if (v == null || this.notNullObj.contains(v)) continue;
                    this.notNullObj.add(v);
                }
            } else if (!this.notNullObj.contains(value)) {
                this.notNullObj.add(value);
            }
        }
    }

    public Object getResult() throws SQLException {
        Collections.sort(this.notNullObj, new ObjectToStringComparator());
        return this.notNullObj.toArray();
    }

    private static class ObjectToStringComparator
    implements Comparator<Object> {
        private NullLastComparator nullLastComparator = new NullLastComparator();
        private StringComparator stringComparator = new StringComparator();

        ObjectToStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            int wynik = this.nullLastComparator.compare(o1, o2);
            if (wynik != 0) {
                return wynik;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            return this.stringComparator.compare(o1.toString(), o2.toString());
        }
    }
}

