/*
 * Decompiled with CFR 0.152.
 */
package pl.topteam.dps.h2.trigger.kontoBankowe;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.TriggerAdapter;
import pl.topteam.dps.h2.trigger.kontoBankowe.KontoBankoweColumn;

abstract class AbstractAfterPowKontoBankowe
extends TriggerAdapter
implements KontoBankoweColumn {
    private static String FK_KONTO_ID_KEY_COLUMN = "KONTO_ID";
    private static String UPDATE_INCREMENT_LICZNIK_PRZYPISAN_KONTO_BANKOWE = "UPDATE KONTO_BANKOWE kb SET kb.LICZNIK_PRZYPISAN = (kb.LICZNIK_PRZYPISAN + 1) WHERE kb.ID = ?";
    private static String UPDATE_DECREMENT_LICZNIK_PRZYPISAN_KONTO_BANKOWE = "UPDATE KONTO_BANKOWE kb SET kb.LICZNIK_PRZYPISAN = (kb.LICZNIK_PRZYPISAN - 1) WHERE kb.ID = ?";
    private static String UPDATE_INCREMENT_LICZNIK_UZYCIE_KONTO_BANKOWE = "UPDATE KONTO_BANKOWE kb SET kb.LICZNIK_UZYCIE = (kb.LICZNIK_UZYCIE + 1) WHERE kb.ID = ?";
    private static String UPDATE_DECREMENT_LICZNIK_UZYCIE_KONTO_BANKOWE = "UPDATE KONTO_BANKOWE kb SET kb.LICZNIK_UZYCIE = (kb.LICZNIK_UZYCIE - 1) WHERE kb.ID = ?";
    private static final String SELECT_KONTO_BANKOWE = "SELECT * FROM KONTO_BANKOWE WHERE ID = ?";
    private static final String DELETE_KONTO_BANKOWE = "DELETE FROM KONTO_BANKOWE WHERE ID = ?";

    AbstractAfterPowKontoBankowe() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void usunKontoBezPowiazan(Connection conn, Long idKonta) throws SQLException {
        PreparedStatement psSelect = null;
        Statement psDelete = null;
        try {
            psSelect = conn.prepareStatement(SELECT_KONTO_BANKOWE);
            psSelect.setLong(1, idKonta);
            ResultSet rs = psSelect.executeQuery();
            rs.next();
            if (rs.getInt("LICZNIK_PRZYPISAN") < 1) {
                psDelete = conn.prepareStatement(DELETE_KONTO_BANKOWE);
                psDelete.setLong(1, idKonta);
                if (psDelete.executeUpdate() == 0) {
                    throw new SQLException("Nie uda\u0142o si\u0119 usun\u0105\u0107 konta o id: " + idKonta);
                }
            }
        }
        finally {
            if (psSelect != null) {
                psSelect.close();
            }
            if (psDelete != null) {
                psDelete.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementLicznikUzycie(Connection conn, ResultSet row) throws SQLException {
        PreparedStatement ps = null;
        Long idKonta = row.getLong(FK_KONTO_ID_KEY_COLUMN);
        if (idKonta != 0L) {
            try {
                ps = conn.prepareStatement(UPDATE_DECREMENT_LICZNIK_UZYCIE_KONTO_BANKOWE);
                ps.setLong(1, idKonta);
                if (ps.executeUpdate() == 0) {
                    throw new SQLException("Nie zmieniono liczby przypisa\u0144 dla konta bankowego o ID: " + idKonta);
                }
                this.usunKontoBezPowiazan(conn, idKonta);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLicznikUzycie(Connection conn, ResultSet row) throws SQLException {
        PreparedStatement ps = null;
        Long idKonta = row.getLong(FK_KONTO_ID_KEY_COLUMN);
        if (idKonta != 0L) {
            try {
                ps = conn.prepareStatement(UPDATE_INCREMENT_LICZNIK_UZYCIE_KONTO_BANKOWE);
                ps.setLong(1, idKonta);
                if (ps.executeUpdate() == 0) {
                    throw new SQLException("Nie zmieniono liczby przypisa\u0144 dla konta bankowego o ID: " + idKonta);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decrementLicznikPrzypisan(Connection conn, ResultSet row) throws SQLException {
        PreparedStatement ps = null;
        Long idKonta = row.getLong(FK_KONTO_ID_KEY_COLUMN);
        if (idKonta != 0L) {
            try {
                ps = conn.prepareStatement(UPDATE_DECREMENT_LICZNIK_PRZYPISAN_KONTO_BANKOWE);
                ps.setLong(1, idKonta);
                if (ps.executeUpdate() == 0) {
                    throw new SQLException("Nie zmieniono liczby przypisa\u0144 dla konta bankowego o ID: " + idKonta);
                }
                this.usunKontoBezPowiazan(conn, idKonta);
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementLicznikPrzypisan(Connection conn, ResultSet row) throws SQLException {
        PreparedStatement ps = null;
        Long idKonta = row.getLong(FK_KONTO_ID_KEY_COLUMN);
        if (idKonta != 0L) {
            try {
                ps = conn.prepareStatement(UPDATE_INCREMENT_LICZNIK_PRZYPISAN_KONTO_BANKOWE);
                ps.setLong(1, idKonta);
                if (ps.executeUpdate() == 0) {
                    throw new SQLException("Nie zmieniono liczby przypisa\u0144 dla konta bankowego o ID: " + idKonta);
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

