<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://piu.mpips.gov.pl/rd/SW-1/1/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  
  <xsl:template match="/">
    <html>
      <head>
	  	  
        <title>SW-1 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<style>
		ul.adnotacja 
		{
			display			: table;
			font-size		: 12px;
			line-height		: 1.05em;
			list-style		: outside none none;
			margin			: 0;
			padding			: 0 40px;
			text-align		: justify;
		}

		.adnotacja li::before 
		{
			content			: "-";
			display			: table-cell;
			padding-right	: 8px;
		}
		
		.adnotacja > li 
		{
			display: table;
		}
		
		</style>
      </head>
      <body style="text-align: center; font-family: Arial; ">

		<!-- Pierwsza część, statyczna formularza + pierwsze dziecko -->		
		<xsl:call-template name="poczatkowaStatycznaCzescSW">
		</xsl:call-template>		
		
		<!-- Sekcja dynamiczna - kolejne dzieci -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaKolejnego">

			<xsl:call-template name="dynamicznaSekcjaDzieciSW">
				<xsl:with-param name="BiezaceDziecko" select="position()"/>
			</xsl:call-template>
			
		</xsl:for-each>		
		
		<!-- Środkowa część, statyczna formularza -->		
		<xsl:call-template name="srodkowaStatycznaCzescSW">
		</xsl:call-template>		
		
		<!-- Sekcja dynamiczna - członkowie rodziny -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:DaneCzlonkowRodzinyOsobyUbiegajacejSie/wnio:DaneOsoby">

			<xsl:call-template name="dynamicznaSekcjaCzlonekRodzinySW">
				<xsl:with-param name="BiezacyCzlonekRodziny" select="position()"/>
			</xsl:call-template>

		</xsl:for-each>		
		
		<!-- Ostatnia statyczna część formularza -->
		<xsl:call-template name="ostatniaStatycznaCzescSW">
		</xsl:call-template>
						
		<!-- Załącznik nr 1 -->
		<xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody">
			<xsl:call-template name="Zalacznik1SW">
			</xsl:call-template>				
		</xsl:if>		

		<!-- Załącznik_2nr 2 -->
		<xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy">
			<xsl:call-template name="Zalacznik2SW">
			</xsl:call-template>				
		</xsl:if>

		<!-- Załącznik nr 3 -->
		<xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne">
			<xsl:call-template name="Zalacznik3SW">
			</xsl:call-template>				
		</xsl:if>	  

		<!-- Stopka prawna Inna Instytucja -->		
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc != 'ZUS'">
			<xsl:call-template name="notaPrawnaInnaInstytucjaSW">
			</xsl:call-template>
		</xsl:if>

		<!-- Stopka prawna - ZUS -->				
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc = 'ZUS'">
			<xsl:call-template name="notaPrawnaZusSW">
			</xsl:call-template>
		</xsl:if>		  
		  
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Część implementacyjna formularza -->
  
  <xsl:template name="poczatkowaStatycznaCzescSW">
  
		<!-- Początkowa część statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1220px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SW-1</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page" />
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 225px; ">
            <div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">NAZWA ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="position: absolute; height: 68px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; height: 54px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                      <xsl:with-param name="wysokosc" select="54" />
                      <xsl:with-param name="szerokosc" select="865" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="wysokoscLini" select="20" />
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 233px; width: 880px; left: 0px; top: 325px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="position: absolute; height: 200px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 27px; text-align: left; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 4px; top: 183px; " class="SofLabel">(1) Wójt, burmistrz lub prezydent miasta właściwy ze względu na miejsce zamieszkania osoby uprawnionej.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 577px; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 597px; " class="SofLabel justified14Bold">1. Dane osoby ubiegającej się o ustalenie prawa do świadczenia wychowawczego, zwanej dalej „osobą ubiegającą się”</div>
          <div style="position: absolute; height: 293px; width: 880px; left: 0px; top: 617px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE</div>
              <div style="position: absolute; height: 260px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 230px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 244px; " class="SofLabel">(2) Należy wpisać: panna, kawaler, zamężna, żonaty, rozwiedziona, rozwiedziony, w separacji, wdowa, wdowiec.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 315px; top: 6px; " class="SofLabel">02. Seria i numer dokumentu tożsamości (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 315px; border: 1px solid black; top: 19px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Obywatelstwo</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofComboBox dictionary">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">06. Stan cywilny (2)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofComboBox dictionary">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:StanCywilny" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 293px; width: 880px; left: 0px; top: 909px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA</div>
              <div style="position: absolute; height: 260px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="673" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 126px; font-size: 12px; left: 411px; top: 137px; " class="SofLabel">07. Numer telefonu (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 241px; font-size: 18px; background-color: white; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerTelefonu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">08. Adres poczty elektronicznej — e-mail (2)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:AdresPocztyElektronicznej" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 230px; " class="SofLabel">(1) Podanie numeru telefonu nie jest obowiązkowe.</div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 244px; " class="SofLabel">(2) Podanie adresu e-mail jest obowiązkowe w przypadku składania wniosku drogą elektroniczną za wyjątkiem wniosku składanego przy użyciu ePUAP.</div>
              </div>
            </div>
          </div>

          <div style="position: absolute; height: 80px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 100px; " class="SofLabel formTitle">
            WNIOSEK
            <br />
            O &#xa0;USTALENIE &#xa0;PRAWA &#xa0;DO &#xa0;ŚWIADCZENIA &#xa0;WYCHOWAWCZEGO
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 910px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 35px; " class="SofLabel global14Bold">2. &#xa0;Ustalenie prawa do świadczenia wychowawczego na pierwsze dziecko.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 65px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Świadczenie wychowawcze przysługuje na pierwsze dziecko jeżeli dochód rodziny w przeliczeniu na osobę nie przekracza kwoty 800,00 zł. Jeżeli członkiem rodziny jest dziecko niepełnosprawne, świadczenie wychowawcze na pierwsze dziecko przysługuje jeżeli dochód rodziny w przeliczeniu na osobę nie przekracza kwoty 1 200,00 zł.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 119px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Pierwsze dziecko oznacza jedyne lub najstarsze dziecko w rodzinie w wieku do ukończenia 18. roku życia; w przypadku dzieci urodzonych tego samego dnia, miesiąca i roku, będących najstarszymi dziećmi w rodzinie w wieku do ukończenia 18. roku życia (czyli w przypadku wieloraczków) pierwsze dziecko oznacza jedno z tych dzieci wskazane przez osobę ubiegającą się.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 173px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Niepełnosprawne dziecko oznacza dziecko legitymujące się orzeczeniem o niepełnosprawności określonym w przepisach o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych albo orzeczeniem o umiarkowanym lub znacznym stopniu niepełnosprawności.</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 14px; top: 237px; " class="SofLabel"></div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 829px; font-size: 14px; left: 47px; top: 257px; " class="SofLabel justified14">Wnoszę o ustalenie prawa do świadczenia wychowawczego na pierwsze dziecko zamieszkujące ze mną oraz pozostające na moim utrzymaniu (w przypadku zaznaczenia – wypełnić tabelę A oraz tabelę B w przypadku ubiegania się o świadczenie wychowawcze również na kolejne dzieci).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 258px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:SwiadczenieWychowawczeNaPierwszeDziecko/wnio:Wnosze='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 829px; font-size: 14px; left: 47px; top: 321px; " class="SofLabel justified14">Nie wnoszę o ustalenie prawa do świadczenia wychowawczego na pierwsze dziecko zamieszkujące ze mną oraz pozostające na moim utrzymaniu (w przypadku zaznaczenia – wypełnić tabelę B).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 322px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:SwiadczenieWychowawczeNaPierwszeDziecko/wnio:NieWnosze='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 16px; text-align: left; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 378px; " class="SofLabel global14Bold">A. Pierwsze dziecko</div>
          <div style="position: absolute; height: 295px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 398px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 1</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 200px; " class="SofLabel">Stan cywilny: (2)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 213px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:StanCywilny" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Nazwisko" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Imie" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:PESEL" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Seria i numer dokumentu tożsamości: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 398px; top: 200px; " class="SofLabel">Płeć (3)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 48px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 398px; border: 1px solid black; top: 213px; " class="SofDropDownList">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Plec" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 247px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 275px; " class="SofLabel">(3) Należy wpisać: K - kobieta, M - mężczyzna.</div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 261px; " class="SofLabel">(2) Należy wpisać: panna, kawaler, zamężna, żonaty, rozwiedziona, rozwiedziony, w separacji, wdowa, wdowiec.</div>
          </div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 712px; " class="SofLabel textKoreanBoldJustified">Osoba ubiegająca się o świadczenie wychowawcze na pierwsze dziecko dołącza do wniosku odpowiednie załączniki (oświadczenia) dotyczące osiągniętych dochodów wypełnione przez członków rodziny.</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 769px; " class="SofLabel textKoreanBoldJustified">3. Ustalenie prawa do świadczenia wychowawczego na kolejne dziecko/dzieci w wieku poniżej 18. roku życia, inne niż pierwsze dziecko.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 816px; " class="SofLabel justified14">Wnoszę o ustalenie prawa do świadczenia wychowawczego na następujące dzieci/dziecko zamieszkujące ze mną oraz pozostające na moim utrzymaniu (świadczenie wychowawcze na drugie i kolejne dziecko przysługuje do dnia ukończenia przez dziecko 18. roku życia i przysługuje niezależnie od osiągniętego dochodu):</div>
          <div style="position: absolute; height: 16px; text-align: left; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 880px; " class="SofLabel global14Bold">B. Kolejne dziecko/dzieci (poniższa lista nie obejmuje pierwszego dziecka).</div>

        </div>
  </xsl:template>		
    
	
  <xsl:template name="dynamicznaSekcjaDzieciSW">
		<xsl:param name="BiezaceDziecko"></xsl:param>
		  		
		<!-- Strona dynamiczna formularza (dzieci) -->		
        <div style="position: relative; margin-right: auto; height: 295px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; height: 295px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - <xsl:value-of select="$BiezaceDziecko"/></div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 200px; " class="SofLabel">Stan cywilny: (2)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 213px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:StanCywilny" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Nazwisko" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Imie" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:PESEL" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Seria i numer dokumentu tożsamości: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 398px; top: 200px; " class="SofLabel">Płeć (3)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 48px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 398px; border: 1px solid black; top: 213px; " class="SofDropDownList">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Plec" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 247px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 275px; " class="SofLabel">(3) Należy wpisać: K - kobieta, M - mężczyzna.</div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 261px; " class="SofLabel">(2) Należy wpisać: panna, kawaler, zamężna, żonaty, rozwiedziona, rozwiedziony, w separacji, wdowa, wdowiec.</div>
          </div>
 
        </div>
  </xsl:template> 
  
  
  <xsl:template name="srodkowaStatycznaCzescSW">
		
		<!-- Środkowa część, statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 300px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">4. Dane członków rodziny.</div>
          <div style="position: absolute; height: 136px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 35px; " class="SofLabel justified14">Rodzina oznacza odpowiednio: małżonków, rodziców dzieci, opiekuna faktycznego dziecka (opiekun faktyczny dziecka to osoba faktycznie opiekującą się dzieckiem, jeżeli wystąpiła z wnioskiem do sądu opiekuńczego o przysposobienie dziecka) oraz zamieszkujące wspólnie z tymi osobami, pozostające na ich utrzymaniu dzieci w wieku do ukończenia 25. roku życia, a także dzieci, które ukończyły 25. rok życia, legitymujące się orzeczeniem o znacznym stopniu niepełnosprawności, jeżeli w związku z tą niepełnosprawnością przysługuje świadczenie pielęgnacyjne lub specjalny zasiłek opiekuńczy albo zasiłek dla opiekuna, o którym mowa w ustawie z dnia 4 kwietnia 2014 r. o ustaleniu i wypłacie zasiłków dla opiekunów (Dz. U. z 2016 r. poz. 162). Do członków rodziny nie zalicza się dziecka pozostającego pod opieką opiekuna prawnego, dziecka pozostającego w związku małżeńskim, a także pełnoletniego dziecka posiadającego własne dziecko.</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 156px; " class="SofLabel justified14">W przypadku gdy dziecko, zgodnie z orzeczeniem sądu, jest pod opieką naprzemienną obydwojga rodziców rozwiedzionych, żyjących w separacji lub żyjących w rozłączeniu, dziecko zalicza się jednocześnie do członków rodzin obydwojga rodziców.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 193px; " class="SofLabel justified14">Osoba samotnie wychowująca dziecko (oznacza to pannę, kawalera, wdowę, wdowca, osobę pozostającą w separacji orzeczonej prawomocnym wyrokiem sądu, osobę rozwiedzioną, chyba że wychowuje wspólnie co najmniej jedno dziecko z jego rodzicem) nie wpisuje do składu rodziny drugiego z rodziców dziecka.</div>
          <div style="position: absolute; height: 36px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 257px; " class="SofLabel textKoreanBoldJustified">W skład mojej rodziny zgodnie z ww. definicją wchodzą (zgodnie z ww. definicją należy wpisać wszystkich członków rodziny osoby ubiegającej się o świadczenie wychowawcze, w tym dzieci wskazane w tabeli A i B):</div>

        </div>	
  </xsl:template>		

  
  <xsl:template name="dynamicznaSekcjaCzlonekRodzinySW">
		<xsl:param name="BiezacyCzlonekRodziny"></xsl:param>
			
		<!-- Strona dynamiczna formularza (członkowie rodziny) -->		
        <div style="position: relative; margin-right: auto; height: 286px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; height: 286px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE OSOBY - <xsl:value-of select="$BiezacyCzlonekRodziny"/>, WCHODZĄCEJ W SKŁAD RODZINY</div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:PESEL" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 113px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 126px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Nazwisko" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 157px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 170px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:Imie" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Seria i numer dokumentu tożsamości: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="wnio:SeriaNumerDokumentu" />
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Pokrewieństwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 864px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Pokrewienstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="770" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 201px; " class="SofLabel">Nazwa i adres urzędu skarbowego: (2)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 214px; " class="SofDictionaryBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:NazwaAdresUrzeduSkarbowego" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; height: 32px; color: #000000; width: 123px; font-size: 12px; left: 757px; top: 157px; " class="SofLabel">
              Orzeczenie o niepeł-
              <br />
              &#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;nosprawności
            </div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 757px; border: 1px solid black; top: 170px; " class="SofCheckBox">
              <xsl:if test="wnio:Niepelnosprawnosc='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 252px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 266px; " class="SofLabel">(2) Wypełnić tylko w przypadku ubiegania się o świadczenie wychowawcze na pierwsze dziecko.</div>
          </div>

        </div>	
  </xsl:template> 
				
  
  <xsl:template name="ostatniaStatycznaCzescSW">
		
		<!-- Końcowa część statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1210px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 35px; " class="SofLabel textKoreanBoldJustified">5. Oświadczam, że orzeczeniem o niepełnosprawności lub orzeczeniem o umiarkowanym lub znacznym stopniu niepełnosprawności legitymuje się następujące dziecko wchodzące w skład rodziny:</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 72px; " class="SofLabel justified14">(wypełnić tylko w przypadku ubiegania się o świadczenie wychowawcze na pierwsze dziecko jeśli członkiem rodziny jest dziecko legitymujące się ww. orzeczeniem)</div>
          <div style="position: absolute; height: 240px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 109px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE DZIECI - ORZECZENIE O NIEPEŁNOSPRAWNOŚCI</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię i nazwisko dziecka:</div>
            <div style="position: absolute; height: 193px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OrzeczenieNiepelnosprawnosc/wnio:DaneDzieci/wnio:ImieNazwisko" />
                  <xsl:with-param name="wysokosc" select="193" />
                  <xsl:with-param name="szerokosc" select="865" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OrzeczenieNiepelnosprawnosc/wnio:DaneDzieci/wnio:ImieNazwisko" />
                </xsl:call-template>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 378px; " class="SofLabel textKoreanBoldJustified">6. Organ, do którego są opłacane składki na ubezpieczenie zdrowotne, o których mowa w art. 3 pkt 1 lit. a ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz. U. z 2015 r. poz. 114, z późn. zm.):</div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 415px; " class="SofLabel justified14">(wypełnić tylko w przypadku ubiegania się o świadczenie wychowawcze na pierwsze dziecko)</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 6px; top: 445px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 47px; font-family: arial; font-weight: normal; top: 451px; " class="SofLabel global14Normal">Zakład Ubezpieczeń Społecznych</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 444px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:ZUS='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 36px; color: #000000; width: 229px; font-size: 14px; left: 359px; font-family: arial; font-weight: normal; top: 444px; " class="SofLabel global14Normal">Kasa Rolniczego Ubezpieczenia Społecznego</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 325px; border: 1px solid black; top: 444px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:KRUS='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 656px; font-family: arial; font-weight: normal; top: 451px; " class="SofLabel global14Normal">Wojskowe Biuro Emerytalne</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 622px; border: 1px solid black; top: 444px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:WojskoweBiuroEmerytalne='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 47px; font-family: arial; font-weight: normal; top: 497px; " class="SofLabel global14Normal">Zakład Emerytalno-Rentowy Ministerstwa Spraw Wewnętrznych</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 490px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:ZakladEmerytalnoRentowyMSW='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; width: 192px; font-size: 14px; left: 656px; font-family: arial; font-weight: normal; top: 490px; " class="SofLabel global14Normal">Biuro Emerytalne Służby Więziennej</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 622px; border: 1px solid black; top: 490px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:BiuroEmerytalneSluzbyWieziennej='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 47px; font-family: arial; font-weight: normal; top: 543px; " class="SofLabel global14Normal">Jednostka organizacyjna wymiaru sprawiedliwości</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 536px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:JednostkaOrganizacyjnaWymiaruSprawiedliwosci='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 656px; font-family: arial; font-weight: normal; top: 543px; " class="SofLabel global14Normal">Inny</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 622px; border: 1px solid black; top: 536px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:Inny='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 567px; " class="SofLabel">Nazwa i adres właściwej jednostki:</div>
          <div style="position: absolute; height: 75px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 580px; " class="SofTextArea dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="formatTextArea">
                    <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:OddzialInspektoratWlasciwejJednostki" />
                    <xsl:with-param name="wysokosc" select="75" />
                    <xsl:with-param name="szerokosc" select="865" />
                    <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                    <xsl:with-param name="wysokoscLini" select="20" />
                    <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                    <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:OddzialInspektoratWlasciwejJednostki" />
                </xsl:call-template>			  
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 669px; " class="SofLabel global14Bold">7. Inne dane:</div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 689px; " class="SofLabel justified14">(wypełnić tylko w przypadku ubiegania się o świadczenie wychowawcze na pierwsze dziecko)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 729px; " class="SofLabel global14Normal">7.1 Łączna kwota alimentów świadczonych na rzecz innych osób spoza rodziny wyniosła w roku:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 623px; top: 708px; " class="SofLabel">Rok kalendarzowy (1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 623px; border: 1px solid black; top: 721px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="//wnio:TrescDokumentu/wnio:InneDane/wnio:AlimentyNaRzeczInnychOsob/wnio:Rok" />
            </span>
          </div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; font-size: 14px; left: 31px; top: 770px; " class="SofLabel justified14">wyniosła:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 96px; top: 749px; " class="SofLabel">Kwota alimentów</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 96px; border: 1px solid black; top: 762px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:InneDane/wnio:AlimentyNaRzeczInnychOsob/wnio:KwotaAlimentow,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; text-align: justify; color: #000000; font-size: 14px; left: 298px; top: 770px; " class="SofLabel justified14">zł.</div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 864px; font-size: 12px; left: 6px; top: 1089px; " class="SofLabel justified">(1) Wpisać rok kalendarzowy, z którego dochód stanowi podstawę ustalenia dochodu rodziny (w przypadku ubiegania się o świadczenie wychowawcze na okres trwający od 1 kwietnia 2016 r. do 30 września 2017 r., należy wpisać rok 2014).</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; top: 807px; " class="SofLabel justified14">7.2 W roku kalendarzowym(1) poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego, członkowie rodziny osiągnęli dochody:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 142px; top: 825px; " class="SofLabel"></div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 854px; " class="SofLabel justified14">niepodlegające opodatkowaniu podatkiem dochodowym od osób fizycznych na zasadach określonych w art. 27, art. 30b, art. 30c, art. 30e i art. 30f ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2012 r. poz. 361, z późn. zm.) – wskazane w pouczeniu do Załącznika nr 1,</div>
          <div style="position: absolute; height: 32px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 903px; " class="SofLabel justified14">(w przypadku zaznaczenia dodatkowo należy dołączyć wypełnione oświadczenie członka/członków rodziny stanowiące Załącznik nr 1 do wniosku),</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 854px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieInneDochody='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 945px; " class="SofLabel justified14">z działalności podlegającej opodatkowaniu na podstawie przepisów o zryczałtowanym podatku dochodowym od niektórych przychodów osiąganych przez osoby fizyczne (ryczałt ewidencjonowany lub karta podatkowa), pomniejszony o należny zryczałtowany podatek dochodowy i składki na ubezpieczenia społeczne i zdrowotne,</div>
          <div style="position: absolute; height: 32px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 994px; " class="SofLabel justified14">(w przypadku zaznaczenia dodatkowo należy dołączyć wypełnione oświadczenie członka/członków rodziny stanowiące Załącznik nr 2 do wniosku),</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 945px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieZryczaltowanyPodatekDochodowy='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 1036px; " class="SofLabel justified14">uzyskane z gospodarstwa rolnego,</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 799px; font-size: 14px; left: 71px; top: 1051px; " class="SofLabel justified14">(w przypadku zaznaczenia dodatkowo należy dołączyć oświadczenie członka/członków rodziny stanowiące wypełnione Załącznik nr 2 lub Załącznik nr 3 do wniosku).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 1036px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieGospodarstwoRolne='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 88px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 1122px; " class="SofLabel textKoreanBoldJustified">Ponadto dochodem rodziny osoby ubiegającej się o świadczenie wychowawcze na pierwsze dziecko są przychody podlegające opodatkowaniu na zasadach określonych w art. 27, art. 30b, art. 30c, art. 30e i art. 30f ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych, pomniejszone o koszty uzyskania przychodu, należny podatek dochodowy od osób fizycznych, składki na ubezpieczenia społeczne niezaliczone do kosztów uzyskania przychodu oraz składki na ubezpieczenie zdrowotne – dane o tych dochodach organ uzyskuje samodzielnie.</div>

        </div>
        <div style="position: relative; margin-right: auto; height: 1230px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; top: 35px; " class="SofLabel justified14">7.3 Informacja na temat sytuacji związanych z uzyskaniem lub utratą dochodu:</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; top: 55px; " class="SofLabel justified14">(wypełnić tylko w przypadku ubiegania się o świadczenie wychowawcze na pierwsze dziecko)</div>
          <div style="position: absolute; height: 345px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 75px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 37px; font-family: arial; font-weight: normal; top: 86px; " class="SofLabel global14Normal">W roku kalendarzowym poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego, lub po tym roku:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 37px; top: 105px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 134px; " class="SofLabel global14Normal">nastąpiła utrata przez członka rodziny dochodu (2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 126px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UtrataDochoduWRokuPoprzedzajacym/wnio:Nastapila='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 503px; font-family: arial; font-weight: normal; top: 134px; " class="SofLabel global14Normal">nie nastąpiła utrata przez członka rodziny dochodu. (2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 469px; border: 1px solid black; top: 126px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UtrataDochoduWRokuPoprzedzajacym/wnio:NieNastapila='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 250px; color: #000000; width: 839px; font-size: 12px; line-height:1em; left: 37px; top: 162px; " class="SofLabel">
            <div style="line-height: 120%; margin-top: 0px; margin-bottom: 0px;" class="adnotacja">
              <div style="text-align: justify; margin-top: 0px; margin-bottom: 0px; clear: both;">
                <span style="display: inline-block; width: 40px;">
                  <span>
                    <span style="display: inline-block; width: 33px;" />
                  </span>
                </span>
                <span>(2) Utrata dochodu, zgodnie z art. 2 pkt 19 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci (Dz. U. poz. 195),</span>
              </div>
			  <ul class="adnotacja">oznacza utratę dochodu spowodowaną:
				  <li>uzyskaniem prawa do urlopu wychowawczego,</li>
				  <li>utratą prawa do zasiłku lub stypendium dla bezrobotnych,</li>
				  <li>utratą zatrudnienia lub innej pracy zarobkowej,</li>
				  <li>utratą zasiłku przedemerytalnego lub świadczenia przedemerytalnego, nauczycielskiego świadczenia kompensacyjnego, a także emerytury lub renty,</li>
				  <li>renty rodzinnej lub renty socjalnej,</li>
				  <li>wyrejestrowaniem pozarolniczej działalności gospodarczej lub zawieszeniem jej wykonywania w rozumieniu art. 14a ust. 1d ustawy z dnia 2 lipca</li>
				  <li>2004 r. o swobodzie działalności gospodarczej (Dz. U. z 2015 r. poz. 584, z późn. zm.),</li>
				  <li>utratą zasiłku chorobowego, świadczenia rehabilitacyjnego lub zasiłku macierzyńskiego, przysługujących po utracie zatrudnienia lub innej pracy zarobkowej,</li>
				  <li>utratą zasądzonych świadczeń alimentacyjnych w związku ze śmiercią osoby zobowiązanej do tych świadczeń lub utratą świadczeń pieniężnych
				  wypłacanych w przypadku bezskuteczności egzekucji alimentów w związku ze śmiercią osoby zobowiązanej do świadczeń alimentacyjnych,</li>
				  <li>utratą świadczenia rodzicielskiego,</li>
				  <li>utratą zasiłku macierzyńskiego, o którym mowa w przepisach o ubezpieczeniu społecznym rolników,</li>
				  <li>utratą stypendium doktoranckiego określonego w art. 200 ust. 1 ustawy z dnia 27 lipca 2005 r. – Prawo o szkolnictwie wyższym (Dz. U. z 2012 r. poz.
				  572, z późn. zm.).</li>
              </ul>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 37px; font-family: arial; font-weight: normal; top: 429px; " class="SofLabel global14Normal">W roku kalendarzowym poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego, lub po tym roku:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 38px; top: 448px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 477px; " class="SofLabel global14Normal">nastąpiło uzyskanie przez członka rodziny dochodu (3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 469px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UzyskanieDochoduWRokuPoprzedzajacym/wnio:Nastapilo='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 503px; font-family: arial; font-weight: normal; top: 477px; " class="SofLabel global14Normal">nie nastąpiło uzyskanie przez członka rodziny dochodu. (3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 469px; border: 1px solid black; top: 469px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UzyskanieDochoduWRokuPoprzedzajacym/wnio:NieNastapilo='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 230px; color: #000000; width: 839px; font-size: 12px; line-height:1em; left: 37px; top: 505px; " class="SofLabel">
            <div style="line-height: 120%; margin-top: 0px; margin-bottom: 0px;" class="adnotacja">
              <div style="text-align: justify; margin-top: 0px; margin-bottom: 0px; clear: both;">
                <span style="display: inline-block; width: 40px;">
                  <span>
                    <span style="display: inline-block; width: 33px;" />
                  </span>
                </span>
                <span>(3) Uzyskanie dochodu, zgodnie z art. 2 pkt 20 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu, oznacza uzyskanie</span>
              </div>
              <ul class="adnotacja">dochodu spowodowane:
				<li>zakończeniem urlopu wychowawczego,</li>
				<li>uzyskaniem prawa do zasiłku lub stypendium dla bezrobotnych,</li>
                <li>uzyskaniem zatrudnienia lub innej pracy zarobkowej,</li>
                <li>uzyskaniem zasiłku przedemerytalnego lub świadczenia przedemerytalnego, nauczycielskiego świadczenia kompensacyjnego, a także emerytury lub
				renty, renty rodzinnej lub renty socjalnej,</li>
				<li>rozpoczęciem pozarolniczej działalności gospodarczej lub wznowieniem jej wykonywania po okresie zawieszenia w rozumieniu art. 14a ust. 1d ustawy
				z dnia 2 lipca 2004 r. o swobodzie działalności gospodarczej,</li>
				<li>uzyskaniem zasiłku chorobowego, świadczenia rehabilitacyjnego lub zasiłku macierzyńskiego, przysługujących po utracie zatrudnienia lub innej pracy zarobkowej,</li>
				<li>uzyskaniem świadczenia rodzicielskiego,</li>
				<li>uzyskaniem zasiłku macierzyńskiego, o którym mowa w przepisach o ubezpieczeniu społecznym rolników,</li>
				<li>uzyskaniem stypendium doktoranckiego określonego w art. 200 ust. 1 ustawy z dnia 27 lipca 2005 r. – Prawo o szkolnictwie wyższym (Dz. U. z 2012 r. poz. 572, z późn. zm.).</li>
			  </ul>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 743px; " class="SofLabel global14Bold">CZĘŚĆ II</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 763px; " class="SofLabel global14Bold">1. Oświadczenie dotyczące ustalenia prawa do świadczenia wychowawczego na dziecko</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 793px; " class="SofLabel global14Normal">Oświadczam, że:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 813px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 813px; " class="SofLabel global14Normal">powyższe dane są prawdziwe,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 833px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 833px; " class="SofLabel global14Normal">zapoznałam/zapoznałem się z warunkami uprawniającymi do świadczenia wychowawczego,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 853px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 853px; " class="SofLabel justified14">na dziecko/dzieci, na które ubiegam się o świadczenie&#xa0;&#xa0;wychowawcze, nie jest pobierane w tej lub innej&#xa0;instytucji świadczenie wychowawcze,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 888px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 888px; " class="SofLabel justified14">pełnoletnie dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze, nie jest/nie są uprawnione do świadczenia wychowawczego na własne dziecko,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 925px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; height: 68px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 925px; " class="SofLabel justified14">dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze nie pozostaje/nie pozostają w związku małżeńskim ani nie zostało/nie zostały umieszczone w pieczy zastępczej, instytucji zapewniającej całodobowe utrzymanie, tj. domu pomocy społecznej, młodzieżowym ośrodku wychowawczym, schronisku dla nieletnich, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, a także szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatne pełne utrzymanie,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 996px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; height: 65px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 996px; " class="SofLabel justified14">członkowi rodziny nie przysługuje na dziecko świadczenie wychowawcze lub świadczenie o charakterze podobnym do świadczenia wychowawczego za granicą lub przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią, że przysługujące za granicą świadczenie nie wyłącza prawa do takiego świadczenia na podstawie ustawy,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 1066px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 26px; top: 1067px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 1094px; " class="SofLabel global14Normal">przebywam</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 1086px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:Przebywam='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 1094px; " class="SofLabel global14Normal">nie przebywam</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 1086px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:NiePrzebywam='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 37px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 1122px; " class="SofLabel justified14">poza granicami Rzeczypospolitej Polskiej(4) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(5),</div>
          <div style="position: absolute; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 1164px; " class="SofLabel left">(4) Nie dotyczy wyjazdu lub pobytu turystycznego, leczniczego lub związanego z podjęciem przez dziecko kształcenia poza granicami Rzeczypospolitej Polskiej.</div>
          <div style="position: absolute; height: 44px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 1178px; " class="SofLabel justified">(5) Przepisy o koordynacji systemów zabezpieczenia społecznego mają zastosowanie na terenie: Austrii, Belgii, Chorwacji, Danii, Finlandii, Francji, Grecji, Hiszpanii, Holandii, Irlandii, Luksemburga, Niemiec, Portugalii, Szwecji, Włoch, Wielkiej Brytanii, Cypru, Czech, Estonii, Litwy, Łotwy, Malty, Polski, Słowacji, Słowenii, Węgier, Bułgarii, Rumunii, Norwegii, Islandii, Liechtensteinu, Szwajcarii.</div>

        </div>
        <div style="position: relative; margin-right: auto; height: 1165px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 35px; " class="SofLabel global14Normal">—</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 35px; " class="SofLabel justified14">członek mojej rodziny, w rozumieniu art. 2 pkt 16 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 26px; top: 55px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 82px; " class="SofLabel global14Normal">przebywa</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 74px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonekRodzinyPozaRzeczypospolita/wnio:Przebywa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 82px; " class="SofLabel global14Normal">nie przebywa</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 74px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonekRodzinyPozaRzeczypospolita/wnio:NiePrzebywa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 110px; " class="SofLabel justified14">poza granicami Rzeczypospolitej Polskiej(4) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(5).</div>
          <div style="position: absolute; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 167px; " class="SofLabel left">(4) Nie dotyczy wyjazdu lub pobytu turystycznego, leczniczego lub związanego z podjęciem przez dziecko kształcenia poza granicami Rzeczypospolitej Polskiej.</div>
          <div style="position: absolute; height: 44px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 181px; " class="SofLabel justified">(5) Przepisy o koordynacji systemów zabezpieczenia społecznego mają zastosowanie na terenie: Austrii, Belgii, Chorwacji, Danii, Finlandii, Francji, Grecji, Hiszpanii, Holandii, Irlandii, Luksemburga, Niemiec, Portugalii, Szwecji, Włoch, Wielkiej Brytanii, Cypru, Czech, Estonii, Litwy, Łotwy, Malty, Polski, Słowacji, Słowenii, Węgier, Bułgarii, Rumunii, Norwegii, Islandii, Liechtensteinu, Szwajcarii.</div>
          <div style="position: absolute; height: 86px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 239px; " class="SofLabel justified14Bold">W przypadku zmian mających wpływ na prawo do świadczenia wychowawczego, w szczególności zaistnienia okoliczności wymienionych w oświadczeniu, uzyskania dochodu lub wystąpienia innych okoliczności mających wpływ na prawo do świadczenia wychowawczego, w tym związanych z koniecznością ponownego ustalenia prawa do tego świadczenia na podstawie art. 7 ust. 1-4 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci, osoba ubiegająca się jest obowiązana niezwłocznie powiadomić o tych zmianach podmiot realizujący świadczenie wychowawcze.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 325px; " class="SofLabel justified14Bold">Niepoinformowanie organu właściwego prowadzącego postępowanie w sprawie świadczenia wychowawczego o zmianach, o których mowa powyżej, może skutkować powstaniem nienależnie pobranego świadczenia wychowawczego, a w konsekwencji - koniecznością jego zwrotu wraz z odsetkami ustawowymi za opóźnienie.</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 378px; " class="SofLabel justified14Bold">Obowiązek informowania o zmianach w sytuacji dochodowej rodziny, w szczególności uzyskania dochodu, dotyczy wyłącznie osób ubiegających się/otrzymujących świadczenie wychowawcze na pierwsze dziecko.</div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; font-size: 14px; left: 6px; font-weight: bold; top: 435px; " class="SofLabel justified14Bold">Proszę o wpłatę świadczenia wychowawczego na następujący nr rachunku bankowego (6):</div>
          <div style="position: absolute; color: #000000; width: 833px; font-size: 12px; left: 37px; top: 552px; " class="SofLabel left">(6) Wypełnić w przypadku, gdy świadczenie wychowawcze ma być wpłacane na rachunek bankowy.</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 625px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 465px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:NrRachunkuBankowego" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="625" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 37px; font-family: arial; font-weight: normal; top: 501px; " class="SofLabel global14Normal">w banku (nazwa banku):</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 516px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:NazwaBanku" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 18px; color: #000000; width: 864px; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 591px; " class="SofLabel global14Normal">Do wniosku dołączam następujące dokumenty (oświadczenia są także dokumentami):</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 627px; " class="SofLabel global14Normal">1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 621px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 663px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 657px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 699px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 693px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 735px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 729px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="841" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 440px; color: #000000; width: 870px; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 777px; " class="SofLabel global14Normal">
            <font style="font-family: verdana; font-size: 13px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:Informacja1" />
              <span />
            </font>
          </div>

        </div>
        <div style="position: relative; margin-right: auto; height: 670px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 335px; color: #000000; width: 870px; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 35px; " class="SofLabel global14Normal">
            <font style="font-family: verdana; font-size: 13px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:Informacja2" />
              <span />
            </font>
          </div>
          <div style="position: absolute; height: 50px; width: 870px; background-color: #ffffff; left: 8px; top: 424px; " class="SofBorderContainer">
            <div style="position: absolute; height: 41px; color: #000000; width: 272px; font-size: 14px; left: 39px; font-family: arial; font-weight: normal; top: 10px; " class="SofLabel global14Normal">oświadczam, że zapoznałam/zapoznałem się z treścią powyższego pouczenia.</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 5px; border: 1px solid black; top: 11px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:Oswiadczenie1/wnio:PotwierdzenieZapoznaniaSieZPouczeniem='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 3px; " class="SofDateField dotted">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Oswiadczenie1/wnio:Data" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 35px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 20px; " class="SofLabel paragraph14Normal"></div>
            <div style="position: absolute; height: 30px; text-align: center; color: #000000; width: 183px; font-size: 12px; left: 678px; top: 35px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 521px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 591px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>

        </div>	
  </xsl:template>		

  
  <xsl:template name="Zalacznik1SW">
		
		<!-- Załącznik nr 1 -  statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1230px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 188px; width: 880px; left: 0px; top: 328px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE CZŁONKA RODZINY UBIEGAJĄCEGO SIĘ O ŚWIADCZENIE WYCHOWAWCZE</div>
              <div style="position: absolute; height: 155px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 137px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 5px; " class="SofLabel">02. Seria i numer dokumentu tożsamości: (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 83px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 633px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 761px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 853px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 567px; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym (2):</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 303px; top: 546px; " class="SofLabel">Rok (rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 303px; border: 1px solid black; top: 559px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:Rok" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 603px; " class="SofLabel global14Normal">uzyskałam/uzyskałem dochód w wysokości:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 505px; font-family: arial; font-weight: normal; top: 603px; " class="SofLabel global14Normal">zł&#xa0;&#xa0;z tytułu:</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 303px; border: 1px solid black; top: 595px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:WysokoscDochodu,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 651px; " class="SofLabel global14Normal">1. gospodarstwa rolnego (3):</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 29px; font-family: arial; font-weight: normal; top: 687px; " class="SofLabel global14Normal">(powierzchnia gospodarstwa w ha przeliczeniowych:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 574px; font-family: arial; font-weight: normal; top: 687px; " class="SofLabel global14Normal">)</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 192px; font-size: 18px; background-color: white; display: block; left: 373px; border: 1px solid black; top: 679px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:PowierzchniaGospodarstwa,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 205px; border: 1px solid black; top: 643px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:GospodarstwoRolne,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 407px; font-family: arial; font-weight: normal; top: 651px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 733px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 725px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod2" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 725px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu2,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 733px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 779px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 771px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod3" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 771px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu3,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 779px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 825px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 817px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod4" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 817px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu4,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 825px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 871px; " class="SofLabel global14Normal">5)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 863px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod5" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 863px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu5,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 871px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 917px; " class="SofLabel global14Normal">6)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 909px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod6" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 909px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu6,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 917px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 995px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 1068px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 1161px; " class="SofLabel justified">(2) Wpisać rok kalendarzowy, z którego dochód stanowi podstawę ustalenia dochodu rodziny w przypadku ubiegania się o świadczenie wychowawcze (w przypadku ubiegania się o świadczenie wychowawcze na okres trwający od 1 kwietnia 2016 r. do 30 września 2017 r., należy wpisać rok 2014).</div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 1190px; " class="SofLabel justified">(3) 12 x przeciętna liczba ha przeliczeniowych w roku kalendarzowym poprzedzającym okres, na który ustalane jest prawo do świadczenia wychowawczego x kwota miesięcznego dochodu z 1 ha przeliczeniowego ogłaszana w drodze obwieszczenia przez Prezesa Głównego Urzędu Statystycznego.</div>
          <div style="position: absolute; height: 26px; text-align: right; color: #000000; width: 860px; font-size: 16px; left: 10px; font-weight: bold; top: 35px; " class="SofLabel formTitle">Załącznik nr 1</div>
          <div style="position: absolute; height: 140px; text-align: center; color: #000000; width: 880px; font-size: 16px; left: 0px; font-weight: bold; top: 120px; " class="SofLabel formTitle">
            OŚWIADCZENIE
            <br />
            CZŁONKA RODZINY O DOCHODACH OSIĄGNIĘTYCH W ROKU KALENDARZOWYM
            <br />
            POPRZEDZAJĄCYM OKRES, NA KTÓRY USTALANE JEST PRAWO DO ŚWIADCZENIA WYCHOWAWCZEGO,
            <br />
            INNYCH NIŻ DOCHODY PODLEGAJĄCE OPODATKOWANIU PODATKIEM DOCHODOWYM
            <br />
            OD OSÓB FIZYCZNYCH NA ZASADACH OKREŚLONYCH
            <br />
            W ART. 27, ART. 30B, ART. 30C, ART. 30E I ART. 30F USTAWY Z DNIA 26 LIPCA 1991 R.
            <br />
            O PODATKU DOCHODOWYM OD OSÓB FIZYCZNYCH (DZ. U. Z 2012 R. POZ. 361, Z PÓŹN. ZM.)
          </div>
          <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 870px; font-size: 14px; left: 5px; top: 262px; " class="SofLabel justified14">(Oświadczenie wypełnia i podpisuje każdy członek rodziny, który osiągnął ww. dochód.)</div>

        </div>
        <div style="position: relative; margin-right: auto; height: 1160px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 1180px; color: #000000; width: 870px; font-size: 13px; left: 8px; font-family: verdana; font-weight: normal; top: 35px; " class="SofLabel paragraph13Normal">
            <font style="font-family: verdana; font-size: 13px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Informacja3" />
              <span />
            </font>
          </div>

        </div>
        <div style="position: relative; margin-right: auto; height: 1145px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 990px; color: #000000; width: 870px; font-size: 13px; left: 8px; font-family: verdana; font-weight: normal; top: 35px; " class="SofLabel paragraph13Normal">
            <font style="font-family: verdana; font-size: 13px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Informacja4" />
              <span />
            </font>
          </div>
          <div style="position: absolute; height: 50px; width: 869px; background-color: #ffffff; left: 8px; top: 1070px; " class="SofBorderContainer">
            <div style="position: absolute; height: 35px; color: #000000; width: 272px; font-size: 14px; left: 39px; font-family: arial; font-weight: normal; top: 10px; " class="SofLabel global14Normal">oświadczam, że zapoznałam/zapoznałem się z powyższym pouczeniem.</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 5px; border: 1px solid black; top: 11px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Oswiadczenie/wnio:PotwierdzenieZapoznaniaSieZPouczeniem='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 3px; " class="SofDateField dotted">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody/wnio:Oswiadczenie/wnio:Data" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 35px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 20px; " class="SofLabel paragraph14Normal"></div>
            <div style="position: absolute; height: 30px; text-align: center; color: #000000; width: 183px; font-size: 12px; left: 678px; top: 35px; " class="SofLabel"></div>
          </div>

        </div>		
  </xsl:template>		

  
  <xsl:template name="Zalacznik2SW">
		
		<!-- Załącznik_2nr 2 -  statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1230px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 188px; width: 880px; left: 0px; top: 328px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE CZŁONKA RODZINY UBIEGAJĄCEGO SIĘ O ŚWIADCZENIE WYCHOWAWCZE</div>
              <div style="position: absolute; height: 155px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 137px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 5px; " class="SofLabel">02. Seria i numer dokumentu tożsamości: (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 709px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; height: 47px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 801px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 567px; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym (2):</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 299px; top: 546px; " class="SofLabel">Rok (rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 299px; border: 1px solid black; top: 559px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:RokPodatkowy" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 405px; font-family: arial; font-weight: normal; top: 567px; " class="SofLabel global14Normal">uzyskałam/uzyskałem dochód z działalności</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 597px; " class="SofLabel global14Normal">opodatkowanej w formie:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 189px; top: 598px; " class="SofLabel"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 635px; " class="SofLabel global14Normal">ryczałtu ewidencjonowanego,</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 627px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:FormaOpodatkowania/wnio:RyczaltEwidencjonowany='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 671px; " class="SofLabel global14Normal">karty podatkowej.</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 663px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:FormaOpodatkowania/wnio:KartaPodatkowa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 727px; " class="SofLabel global14Normal">1. Dochód po odliczeniu kwot z pozycji 2-4 wyniósł:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 727px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 719px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscDochodu,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 773px; " class="SofLabel global14Normal">2. Należne składki na ubezpieczenia społeczne wyniosły:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 773px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 765px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscSkladekNaUbezpieczenieSpoleczne,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 819px; " class="SofLabel global14Normal">3. Należne składki na ubezpieczenie zdrowotne wyniosły:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 819px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 811px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscSkladkiNaUbezpieczenieZdrowotne,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 865px; " class="SofLabel global14Normal">4. Należny zryczałtowany podatek dochodowy wyniósł:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 599px; font-family: arial; font-weight: normal; top: 865px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 397px; border: 1px solid black; top: 857px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscZryczaltowanegoPodatkuDochodowego,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 953px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 1036px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 1190px; " class="SofLabel justified">(2) Wpisać rok kalendarzowy, z którego dochód stanowi podstawę ustalenia dochodu rodziny w przypadku ubiegania się o świadczenie wychowawcze (w przypadku ubiegania się o świadczenie wychowawcze na okres trwający od 1 kwietnia 2016 r. do 30 września 2017 r., należy wpisać rok 2014).</div>
          <div style="position: absolute; height: 26px; text-align: right; color: #000000; width: 860px; font-size: 16px; left: 10px; font-weight: bold; top: 35px; " class="SofLabel formTitle">Załącznik nr 2</div>
          <div style="position: absolute; height: 140px; text-align: center; color: #000000; width: 880px; font-size: 16px; left: 0px; font-weight: bold; top: 120px; " class="SofLabel formTitle">
            OŚWIADCZENIE
            <br />
            CZŁONKA RODZINY ROZLICZAJĄCEGO SIĘ NA PODSTAWIE PRZEPISÓW
            <br />
            O ZRYCZAŁTOWANYM PODATKU DOCHODOWYM OD NIEKTÓRYCH PRZYCHODÓW OSIĄGANYCH
            <br />
            PRZEZ OSOBY FIZYCZNE O DOCHODZIE OSIĄGNIĘTYM W ROKU KALENDARZOWYM
            <br />
            POPRZEDZAJĄCYM OKRES, NA KTÓRY USTALANE JEST PRAWO
            <br />
            DO ŚWIADCZENIA WYCHOWAWCZEGO
          </div>
          <div style="position: absolute; text-align: center; color: #000000; width: 870px; font-size: 14px; left: 5px; top: 252px; " class="SofLabel justified14">(Oświadczenie wypełnia i podpisuje każdy członek rodziny, który osiągnął ww. dochód.)</div>

        </div>		
  </xsl:template>		
  

  <xsl:template name="Zalacznik3SW">
		
		<!-- Załącznik nr 3 -  statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 960px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-before: always; ">

          <div style="position: absolute; height: 188px; width: 880px; left: 0px; top: 328px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE CZŁONKA RODZINY UBIEGAJĄCEGO SIĘ O ŚWIADCZENIE WYCHOWAWCZE</div>
              <div style="position: absolute; height: 155px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 137px; " class="SofLabel">(1) W przypadku, gdy nie nadano numeru PESEL, należy podać serię i numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 5px; " class="SofLabel">02. Seria i numer dokumentu tożsamości: (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 566px; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym (2):</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 300px; top: 545px; " class="SofLabel">Rok (rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 300px; border: 1px solid black; top: 558px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:OswiadczeniePowierzchniaGospodarstwa/wnio:Rok" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 407px; font-family: arial; font-weight: normal; top: 566px; " class="SofLabel global14Normal">powierzchnia gospodarstwa rolnego wyżej wymienionego członka rodziny</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 602px; " class="SofLabel global14Normal">w ha &#xa0;przeliczeniowych ogólnej &#xa0;powierzchni &#xa0;wynosiła:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 571px; font-family: arial; font-weight: normal; top: 602px; " class="SofLabel global14Normal">.</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 192px; font-size: 18px; background-color: white; display: block; left: 372px; border: 1px solid black; top: 594px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:OswiadczeniePowierzchniaGospodarstwa/wnio:PowierzchniaGospodarstwaRolnego,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 690px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 763px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
          <div style="position: absolute; height: 26px; text-align: right; color: #000000; width: 860px; font-size: 16px; left: 10px; font-weight: bold; top: 35px; " class="SofLabel formTitle">Załącznik nr 3</div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 920px; " class="SofLabel justified">(2) Wpisać rok kalendarzowy, z którego dochód stanowi podstawę ustalenia dochodu rodziny w przypadku ubiegania się o świadczenie wychowawcze (w przypadku ubiegania się o świadczenie wychowawcze na okres trwający od 1 kwietnia 2016 r. do 30 września 2017 r., należy wpisać rok 2014).</div>
          <div style="position: absolute; height: 140px; text-align: center; color: #000000; width: 880px; font-size: 16px; left: 0px; font-weight: bold; top: 120px; " class="SofLabel formTitle">
            OŚWIADCZENIE
            <br />
            CZŁONKA RODZINY O WIELKOŚCI GOSPODARSTWA ROLNEGO WYRAŻONEJ
            <br />
            W HEKTARACH PRZELICZENIOWYCH OGÓLNEJ POWIERZCHNI
            <br />
            W ROKU KALENDARZOWYM POPRZEDZAJĄCYM OKRES,
            <br />
            NA KTÓRY USTALANE JEST PRAWO
            <br />
            DO ŚWIADCZENIA WYCHOWAWCZEGO
          </div>
          <div style="position: absolute; text-align: center; color: #000000; width: 870px; font-size: 14px; left: 5px; top: 252px; " class="SofLabel justified14">(Oświadczenie wypełnia i podpisuje każdy członek rodziny, który osiągnął ww. dochód.)</div>

        </div>
  </xsl:template>	

  <xsl:template name="notaPrawnaInnaInstytucjaSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4, składane w postaci elektronicznej za pomocą systemów, o których mowa w ust. 5 pkt 3, podpisane przy użyciu danych obejmujących imię, nazwisko oraz numer PESEL, są równoważne pod względem skutków prawnych dokumentowi opatrzonemu podpisem własnoręcznym.</div>

        </div>
		
  </xsl:template>	
  
  <xsl:template name="notaPrawnaZusSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4 składane w postaci elektronicznej za pomocą systemów teleinformatycznych, o których mowa w ust. 5 pkt 1, 2 i 4, podpisuje się przy użyciu mechanizmów określonych w art. 20a ust. 1 lub 2 ustawy z dnia 17 lutego 2005 r. o informatyzacji działalności podmiotów realizujących zadania publiczne (Dz. U. z 2014 r. poz. 1114).</div>

        </div>
		
  </xsl:template>	  
  
</xsl:stylesheet>
