<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://piu.mpips.pl/rd/SR_7/1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>SR-7 - Ministerstwo Rodziny Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
      </head>
      <body style="text-align: center; font-family: Arial; ">
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SR-7</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 272px; ">
            <div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">NAZWA ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZEŃ RODZINNYCH (1)</div>
              <div style="position: absolute; height: 68px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; height: 54px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie"/>
                      <xsl:with-param name="wysokosc" select="54"/>
                      <xsl:with-param name="szerokosc" select="865"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="wysokoscLini" select="20"/>
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"/>
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie"/>
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 233px; width: 880px; left: 0px; top: 372px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZEŃ RODZINNYCH (1)</div>
              <div style="position: absolute; height: 200px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)"/>
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)"/>
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 27px; text-align: left; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 4px; top: 183px; " class="SofLabel">(1) Wójt, burmistrz lub prezydent miasta właściwy ze względu na miejsce zamieszkania osoby uprawnionej.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 624px; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 644px; " class="SofLabel justified14Bold">1. Dane osoby ubiegającej się o ustalenie prawa do świadczenia rodzicielskiego, zwanej dalej „osobą ubiegającą się”</div>
          <div style="position: absolute; height: 278px; width: 880px; left: 0px; top: 664px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE</div>
              <div style="position: absolute; height: 245px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 228px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 5px; " class="SofLabel">02. Numer dokumentu (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:NumerDokumentu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">03. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Obywatelstwo</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofComboBox dictionary">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">06. Stan cywilny (należy wpisać: panna, kawaler, zamężna, żonaty, rozwiedziona, rozwiedziony, w separacji, wdowa, wdowiec)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 288px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofComboBox dictionary">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:StanCywilny"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="288"/>
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 233px; width: 880px; left: 0px; top: 941px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA</div>
              <div style="position: absolute; height: 200px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 1, 2)"/>
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 3, 4)"/>
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 673px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Miejscowosc"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="673"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:GminaDzielnica"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Ulica"/>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerDomu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerLokalu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 126px; font-size: 12px; left: 411px; top: 137px; " class="SofLabel">07. Numer telefonu (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 241px; font-size: 18px; background-color: white; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerTelefonu"/>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 183px; " class="SofLabel">(1) Podanie numeru telefonu nie jest obowiązkowe.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: SR-7(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 1/5</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; height: 80px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 110px; " class="SofLabel formTitle">
            WNIOSEK
            <br/>
            O  USTALENIE  PRAWA  DO  ŚWIADCZENIA  RODZICIELSKIEGO
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SR-7</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 115px; " class="SofLabel global14Bold">2. Wnoszę o ustalenie prawa do świadczenia rodzicielskiego na następujące dzieci:</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 130px; " class="SofLabel justified">(Jeżeli liczba dzieci, na które ustala się prawo do świadczenia rodzicielskiego jest większa, należy dodatkowo wypełnić i dołączyć do niniejszego formularza załącznik SR-7Z)</div>
          <div style="position: absolute; height: 220px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 164px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 1</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:Nazwisko"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:Imie"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:PESEL"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:NumerDokumentu"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:DataUrodzenia"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka1/wnio:Obywatelstwo"/>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"/>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 200px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="position: absolute; height: 220px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 403px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 2</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:Nazwisko"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:Imie"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:PESEL"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:NumerDokumentu"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:DataUrodzenia"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka2/wnio:Obywatelstwo"/>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"/>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 200px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="position: absolute; height: 220px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 642px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 3</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:Nazwisko"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:Imie"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:PESEL"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:NumerDokumentu"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:DataUrodzenia"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka3/wnio:Obywatelstwo"/>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"/>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 200px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="position: absolute; height: 220px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 881px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE DZIECKA - 4</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:Nazwisko"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:Imie"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Numer PESEL: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:PESEL"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 24px; " class="SofLabel">Numer dokumentu: (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 37px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                <xsl:value-of select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:NumerDokumentu"/>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 24px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 37px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:DataUrodzenia"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dictionary">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SwiadczenieRodzicielskie/wnio:DaneDziecka4/wnio:Obywatelstwo"/>
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552"/>
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 200px; " class="SofLabel">(1) W przypadku gdy nie nadano numeru PESEL należy podać numer dokumentu potwierdzającego tożsamość.</div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: SR-7(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 2/5</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span/>
            </div>
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SR-7</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 35px; " class="SofLabel global14Bold">CZĘŚĆ II</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 55px; " class="SofLabel justified14Bold">Oświadczenie służące ustaleniu prawa do świadczenia rodzicielskiego</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 85px; " class="SofLabel global14Normal">Oświadczam, że:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 105px; " class="SofLabel global14Normal">a)</div>
          <div style="position: absolute; height: 18px; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 105px; " class="SofLabel global14Normal">powyższe dane są prawdziwe,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 125px; " class="SofLabel global14Normal">b)</div>
          <div style="position: absolute; height: 18px; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 125px; " class="SofLabel global14Normal">zapoznałam/zapoznałem się z warunkami uprawniającymi do świadczenia rodzicielskiego,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 145px; " class="SofLabel global14Normal">c)</div>
          <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 145px; " class="SofLabel justified14">nie otrzymuję zasiłku macierzyńskiego lub uposażenia za okres ustalony przepisami Kodeksu pracy jako okres urlopu macierzyńskiego, okres urlopu na warunkach urlopu macierzyńskiego lub okres urlopu rodzicielskiego,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 182px; " class="SofLabel global14Normal">d)</div>
          <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 182px; " class="SofLabel justified14">drugi z rodziców nie otrzymuje zasiłku macierzyńskiego lub uposażenia za okres ustalony przepisami Kodeksu pracy jako okres urlopu macierzyńskiego, okres urlopu na warunkach urlopu macierzyńskiego lub okres urlopu rodzicielskiego,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 219px; " class="SofLabel global14Normal">e)</div>
          <div style="position: absolute; height: 54px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 219px; " class="SofLabel justified14">osoba będąca rodziną zastępczą lub opiekunem faktycznym dziecka nie otrzymuje zasiłku macierzyńskiego lub uposażenia za okres ustalony przepisami Kodeksu pracy jako okres urlopu macierzyńskiego, okres urlopu na warunkach urlopu macierzyńskiego lub okres urlopu rodzicielskiego(1);</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 273px; " class="SofLabel global14Normal">f)</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 273px; " class="SofLabel justified14">dziecko nie zostało umieszczone w pieczy zastępczej,(2)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 293px; " class="SofLabel global14Normal">g)</div>
          <div style="position: absolute; height: 70px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 293px; " class="SofLabel justified14">w związku z wychowywaniem tego samego dziecka lub w związku z opieką nad tym samym dzieckiem nie ma ustalonego prawa do świadczenia rodzicielskiego, dodatku do zasiłku rodzinnego, z tytułu opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego, świadczenia pielęgnacyjnego, specjalnego zasiłku opiekuńczego lub zasiłku dla opiekuna, o którym mowa w ustawie z dnia 4 kwietnia 2014 r. o ustaleniu i wypłacie zasiłków dla opiekunów,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 364px; " class="SofLabel global14Normal">h)</div>
          <div style="position: absolute; height: 70px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 364px; " class="SofLabel justified14">nie przysługuje mi za granicą świadczenie o podobnym charakterze do świadczenia rodzicielskiego chyba, że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy o zabezpieczeniu społecznym stanowią, że przysługujące za granicą świadczenie  o  podobnym  charakterze  do świadczenia  rodzicielskiego  nie wyłącza  prawa do takiego  świadczenia  na podstawie ustawy</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 435px; " class="SofLabel global14Normal">i)</div>
          <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 435px; " class="SofLabel justified14">nie podjęłam/nie podjąłem ani nie kontynuuję zatrudnienia lub innej pracy zarobkowej, która uniemożliwia mi sprawowanie osobistej opieki nad dzieckiem,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 472px; " class="SofLabel global14Normal">j)</div>
          <div style="position: absolute; height: 54px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 472px; " class="SofLabel justified14">nie mam ustalonego prawa do świadczenia pielęgnacyjnego, specjalnego zasiłku opiekuńczego, dodatku do zasiłku rodzinnego, z tytułu opieki nad dzieckiem w okresie korzystania z urlopu wychowawczego lub zasiłku dla opiekuna, o którym mowa w ustawie z dnia 4 kwietnia 2014 r. o ustaleniu i wypłacie zasiłków dla opiekunów,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 526px; " class="SofLabel global14Normal">k)</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 120px; font-size: 14px; left: 26px; top: 526px; " class="SofLabel justified14">matka dziecka:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 150px; top: 527px; " class="SofLabel">(należy zaznaczyć właściwy kwadrat)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 554px; " class="SofLabel global14Normal">urodziła dziecko,</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 546px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:MatkaDziecka/wnio:UrodzilaDziecko='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 554px; " class="SofLabel global14Normal">nie urodziła dziecka,</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 546px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:MatkaDziecka/wnio:NieUrodzilaDziecka='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 54px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 582px; " class="SofLabel justified14">którego dotyczy wniosek w okresie pobierania zasiłku dla bezrobotnych lub w ciągu miesiąca po jego zakończeniu, lub w okresie przedłużenia pobierania zasiłku dla bezrobotnych na podstawie art. 73 ust. 3 ustawy z dnia 20 kwietnia 2004 r. o promocji zatrudnienia i instytucjach rynku pracy (Dz. U. z 2015 r. poz. 149, z późn. zm.)(3)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 635px; " class="SofLabel global14Normal">l)</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 26px; top: 636px; " class="SofLabel">(należy zaznaczyć właściwy kwadrat)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 663px; " class="SofLabel global14Normal">przebywam</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 655px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:Przebywam='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 663px; " class="SofLabel global14Normal">nie przebywam</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 655px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:NiePrzebywam='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 691px; " class="SofLabel justified14">w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(5),</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 711px; " class="SofLabel global14Normal">ł)</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 711px; " class="SofLabel justified14">członek mojej rodziny, w rozumieniu art. 3 pkt 16 ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 26px; top: 731px; " class="SofLabel">(należy zaznaczyć właściwy kwadrat)</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 758px; " class="SofLabel global14Normal">przebywa</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 750px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonekRodzinyPozaRzeczypospolita/wnio:Przebywa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 383px; font-family: arial; font-weight: normal; top: 758px; " class="SofLabel global14Normal">nie przebywa</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 750px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonekRodzinyPozaRzeczypospolita/wnio:NiePrzebywa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 786px; " class="SofLabel justified14">poza granicami Rzeczypospolitej Polskiej(4) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(5).</div>
          <div style="position: absolute; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 843px; " class="SofLabel left">(1) Dotyczy osób, o których mowa w art. 17c ust. 1 pkt 2 i 3 ustawy (opiekuna faktycznego dziecka i rodziny zastępczej).</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 857px; " class="SofLabel justified">(2) Nie dotyczy osób, o których mowa w art. 17c ust. 1 pkt 2 i 3 ustawy (opiekuna faktycznego dziecka i rodziny zastępczej).</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 871px; " class="SofLabel justified">(3) Nie dotyczy osób, o których mowa w art. 17c ust. 1 pkt 2- 4 ustawy (opiekuna faktycznego dziecka, rodziny zastępczej, osoby, która przysposobiła dziecko).</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 885px; " class="SofLabel justified">
            (4) Nie dotyczy wyjazdu lub pobytu turystycznego, leczniczego lub związanego z podjęciem przez dziecko kształcenia poza granicami Rzeczypospolitej
            <br/>
            Polskiej.
          </div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 913px; " class="SofLabel justified">(5) Przepisy o koordynacji systemów zabezpieczenia społecznego mają zastosowanie na terenie: Austrii, Belgii, Danii, Finlandii, Francji, Grecji, Hiszpanii, Holandii, Irlandii, Luksemburga, Niemiec, Portugalii, Szwecji, Włoch, Wielkiej Brytanii, Cypru, Czech, Estonii, Litwy, Łotwy, Malty, Polski, Słowacji, Słowenii, Węgier, Bułgarii, Rumunii. Norwegii, Islandii, Liechtensteinu, Szwajcarii oraz od 1 lipca 2013 r. Chorwacji.</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 971px; " class="SofLabel justified14Bold">W przypadku zmian mających wpływ na prawo do świadczenia rodzicielskiego, w szczególności zaistnienia okoliczności wymienionych powyżej, w tym również w przypadku wyjazdu osoby uprawnionej lub członka rodziny tej osoby poza granicę Rzeczypospolitej Polskiej osoba ubiegająca się jest obowiązana niezwłocznie powiadomić o tych zmianach podmiot realizujący świadczenia rodzinne.</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 1042px; " class="SofLabel justified14Bold">Niepoinformowanie organu właściwego prowadzącego postępowanie w sprawie świadczeń rodzinnych o zmianach, o których mowa powyżej, może skutkować powstaniem nienależnie pobranych świadczeń rodzinnych, a w konsekwencji ? koniecznością ich zwrotu wraz z odsetkami ustawowymi za opóźnienie.</div>
          <div style="position: absolute; height: 50px; width: 870px; background-color: #ffffff; left: 8px; top: 1169px; " class="SofBorderContainer ">
            <div style="position: absolute; height: 40px; color: #000000; width: 407px; font-size: 14px; left: 39px; font-family: arial; font-weight: normal; top: 10px; " class="SofLabel global14Normal">potwierdzam dane zawarte w oświadczeniu powyżej oraz, że zapoznałam/zapoznałem się z treścią powyższego pouczenia</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 5px; border: 1px solid black; top: 11px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:Oswiadczenie1/wnio:PotwierdzenieZapoznaniaSieZPouczeniem='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 3px; " class="SofDateField dotted">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Oswiadczenie1/wnio:Data"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 35px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 20px; " class="SofLabel paragraph14Normal">......................................</div>
            <div style="position: absolute; text-align: center; color: #000000; width: 183px; font-size: 12px; left: 678px; top: 35px; " class="SofLabel">(Podpis osoby ubiegającej się)</div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: SR-7(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 3/5</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span/>
            </div>
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SR-7</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 35px; " class="SofLabel global14Normal">Do wniosku dołączam następujące dokumenty:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 62px; " class="SofLabel global14Normal">1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 55px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1"/>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 97px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 90px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2"/>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 132px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3"/>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 167px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 160px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4"/>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"/>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"/>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 209px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 309px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc"/>
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data"/>
                  </xsl:call-template>
                </span>
                <span/>
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal">......................................</div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel">(Podpis osoby ubiegającej się składającej oświadczenie)</div>
            </div>
          </div>
          <div style="position: absolute; height: 745px; color: #000000; width: 870px; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 470px; " class="SofLabel global14Normal">
            <font style="font-family: verdana; font-size: 14px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:Informacja1"/>
              <span/>
            </font>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: SR-7(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 4/5</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span/>
            </div>
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SR-7</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
          <div style="position: absolute; height: 990px; color: #000000; width: 870px; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 35px; " class="SofLabel global14Normal">
            <font style="font-family: verdana; font-size: 14px;">
              <xsl:apply-templates select="//wnio:TrescDokumentu/wnio:Informacja2"/>
              <span/>
            </font>
          </div>
          <div style="position: absolute; height: 50px; width: 870px; background-color: #ffffff; left: 8px; top: 1084px; " class="SofBorderContainer">
            <div style="position: absolute; height: 41px; color: #000000; width: 272px; font-size: 14px; left: 39px; font-family: arial; font-weight: normal; top: 10px; " class="SofLabel global14Normal">oświadczam, że zapoznałam/zapoznałem się z treścią powyższego pouczenia.</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 5px; border: 1px solid black; top: 11px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:Oswiadczenie2/wnio:PotwierdzenieZapoznaniaSieZPouczeniem='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 3px; " class="SofDateField dotted">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Oswiadczenie2/wnio:Data"/>
                </xsl:call-template>
              </span>
              <span/>
            </div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 35px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 20px; " class="SofLabel paragraph14Normal">......................................</div>
            <div style="position: absolute; height: 30px; text-align: center; color: #000000; width: 183px; font-size: 12px; left: 678px; top: 35px; " class="SofLabel">(Podpis osoby składającej oświadczenie)</div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: SR-7(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 5/5</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span/>
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates/>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="."/>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="dlugoscPolaWPikselach"/>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))"/>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')"/>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)"/>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst"/>
    <xsl:param name="wysokosc"/>
    <xsl:param name="szerokosc"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="wysokoscLini"/>
    <xsl:param name="liczbaPrzejscDoNowychLini"/>
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"/>
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)"/>
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)"/>
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0"/>
    <xsl:param name="try" select="1"/>
    <xsl:param name="iter" select="1"/>
    <xsl:param name="maxiter" select="10"/>
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number"/>
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))"/>
          <xsl:with-param name="iter" select="$iter + 1"/>
          <xsl:with-param name="maxiter" select="$maxiter"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>