package pl.topteam.empatia_formularze.utils;

import com.google.common.collect.ImmutableSet;

import java.util.Set;

public enum TypFormularza {
    /**
     * Wniosek o ustalenie prawa do świadczeń z funduszu alimentacyjnego
     */
    FA_1(1),
    /**
     * Wniosek o ustalenie prawa do świadczeń z funduszu alimentacyjnego - załącznik
     */
    FA1_Z(2),
    /**
     * Wniosek o podjęcie działań wobec dłużnika alimentacyjnego
     */
    FA_2(3),
    /**
     * Oświadczenie o dochodzie członka rodziny podlegającym opodatkowaniu podatkiem dochodowym od osób fizycznych na zasadach określonych w art. 27, 30b,
     * 30c, i 30e ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (dz. u. z 2012 r. poz. 361, z późn. zm.), osiągniętym w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_01(21),
    /**
     * Oświadczenie o dochodzie członka rodziny rozliczającego się na podstawie przepisów o zryczałtowanym podatku
     * dochodowym od niektórych przychodów osiągniętych przez osoby fizyczne osiągniętym w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_02(22),
    /**
     * Oświadczenie o dochodzie członka rodziny niepodlegającym opodatkowaniu podatkiem dochodowym od osób fizycznych,
     * osiągniętym w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_03(23),
    /**
     * Oświadczenie o wysokości składek na ubezpieczenie zdrowotne
     * w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_04(24),
    /**
     * Oświadczenie o wielkości gospodarstwa rolnego członka rodziny wyrażonej
     * w hektarach przeliczeniowych ogólnej powierzchni w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_05(25),
    /**
     * Oświadczenie o bezskuteczności egzekucji alimentów
     */
    ZFA_06(26),
    /**
     * Oświadczenie o dacie utraty dochodu członka rodziny oraz o tytule, z którego dochód ten został utracony
     */
    ZFA_07(27),
    /**
     * Oświadczenie o wysokość dochodu uzyskanego przez członka rodziny oraz o liczbie miesięcy,
     * w których dochód był osiągany - w przypadku uzyskania dochodu w roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_08(28),
    /**
     * Oświadczenie o wysokość dochodu uzyskanego przez członka rodziny z miesiąca następującego po miesiącu, w którym dochód został osiągnięty - w przypadku uzyskania dochodu po roku kalendarzowym poprzedzającym okres świadczeniowy
     */
    ZFA_09(29),

    /**
     * Wniosek o ustalenie prawa do zasiłku rodzinnego i dodatków do zasiłku rodzinnego
     */
    SR_1_ZAS_RODZ(11),
    /**
     * Wniosek o ustalenie prawa do zasiłku rodzinnego i dodatków do zasiłku rodzinnego - załącznik
     */
    SR_1_Z_ZAS_RODZ(12),
    /**
     * Wniosek o ustalenie prawa do jednorazowej zapomogi z tytułu urodzenia się dziecka
     */
    SR_2_BECIKOWE(13),
    /**
     * Wniosek o ustalenie prawa do jednorazowej zapomogi z tytułu urodzenia się dziecka - załącznik
     */
    SR_2_Z_BECIKOWE(14),
    /**
     * Wniosek o ustalenie prawa do zasiłku pielęgnacyjnego
     */
    SR_3_ZAS_PIEL(15),
    /**
     * Wniosek o ustalenie prawa do specjalnego zasiłku opiekuńczego
     */
    SR_4_SPEC_ZAS_OPIEK(16),
    /**
     * Wniosek o ustalenie prawa do specjalnego zasiłku opiekuńczego - załącznik
     */
    SR_4_Z_SPEC_ZAS_OPIEK(17),
    /**
     * Wniosek o ustalenie prawa do świadczenia pielęgnacyjnego
     */
    SR_5_SWIAD_PIEL(18),
    /**
     * Wniosek o ustalenie prawa do dodatku z tytułu samotnego wychowywania dziecka dla osób, które otrzymywały do dnia 1 maja 2004 r. ustalone na siebie świadczenie na podstawie ustawy z dnia 18 lipca 1974 r. o funduszu alimentacyjnym (dz. u. z 1991 r. nr 45, poz. 200, z późn. zm.
     */
    SR_6_SAMOTNE_WYCH(19),
    /**
     * Wniosek o ustalenie prawa do dodatku z tytułu samotnego wychowywania dziecka dla osób, które otrzymywały do dnia 1 maja 2004 r. ustalone na siebie świadczenie na podstawie ustawy z dnia 18 lipca 1974 r. o funduszu alimentacyjnym (dz. u. z 1991 r. nr 45, poz. 200, z późn. zm.) - załącznik
     */
    SR_6_Z_SAMOTNE_WYCH(20),
    /**
     * 	Wniosek o ustalenie prawa do świadczenia rodzicielskiego
     */
    SR_7_SWIAD_RODZICIELSKIE(65),
    /**
     * Wniosek o ustalenie prawa do świadczenia rodzicielskiego - załącznik
     */
    SR_7_Z_SWIAD_RODZICIELSKIE(66),
    /**
     * Wniosek o ustalenie prawa do jednorazowego świadczenia z tytułu urodzenia się dziecka, u którego zdiagnozowano ciężkie i nieodwracalne upośledzenie albo nieuleczalną chorobę zagrażającą życiu
     */
    SR_8_ZA_ZYCIEM(72),
    /**
     * Wniosek o ustalenie prawa do Świadczenia Wychowawczego
     */
    SW_1_SWIAD_WYCHOWAWCZE(67),
    /**
     * Załącznik do wniosku o ustalenie prawa do Świadczenia Wychowawczego
     */
    SW_1_Z_SWIAD_WYCHOWAWCZE(68),

    /**
     * Oświadczenie o uczęszczaniu dziecka do szkoły
     */
    ZSR_01(37),
    /**
     * Oświadczenie o uczęszczaniu dziecka do szkoły wyższej
     */
    ZSR_02(38),
    /**
     * Oświadczenie o dochodzie członka rodziny podlegającym opodatkowaniu podatkiem dochodowym od osób fizycznych na zasadach określonych w art. 27, 30b, 30c, i 30e ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (dz. u. z 2012 r. poz. 361, z późn. zm.), osiągniętym w roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_03(39),
    /**
     * Oświadczenie o dochodzie członka rodziny rozliczającego się na podstawie przepisów o zryczałtowanym podatku dochodowym od niektórych przychodów osiągniętych przez osoby fizyczne osiągniętym w roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_04(40),
    /**
     * Oświadczenie o dochodzie członka rodziny niepodlegającym opodatkowaniu podatkiem dochodowym od osób fizycznych, osiągniętym w roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_05(41),
    /**
     * Oświadczenie o wysokości składek na ubezpieczenie zdrowotne w roku  kalendarzowym  poprzedzającym okres zasiłkowy
     */
    ZSR_06(42),
    /**
     * Oświadczenie o wielkości gospodarstwa rolnego członka rodziny wyrażonej w hektarach przeliczeniowych ogólnej powierzchni w roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_07(43),
    /**
     * Oświadczenie o terminie i okresie, na jaki został udzielony urlop wychowawczy, oraz o co najmniej sześciomiesięcznym okresie pozostawania w stosunku pracy bezpośrednio przed uzyskaniem prawa do urlopu wychowawczego
     */
    ZSR_08(44),
    /**
     * Oświadczenie o zgłoszeniu do ubezpieczeń społecznych
     */
    ZSR_09(45),
    /**
     * Oświadczenie o niekorzystaniu przez więcej niż 5 dni w tygodniu z całodobowej opieki nad dzieckiem umieszczonym w placówce zapewniającej całodobową opiekę, w tym w specjalnym ośrodku szkolno-wychowawczym
     */
    ZSR_10(46),
    /**
     * Oświadczenie o uczęszczaniu dziecka do szkoły poza miejscem zamieszkania
     */
    ZSR_11(47),
    /**
     * Oświadczenie potwierdzające tymczasowe zameldowanie ucznia poza miejscem zamieszkania
     */
    ZSR_12(48),
    /**
     * Oświadczenie o dacie utraty dochodu członka rodziny oraz o tytule, z którego dochód ten został utracony
     */
    ZSR_13(49),
    /**
     * Oświadczenie o wysokość dochodu uzyskanego przez członka rodziny oraz o liczbie miesięcy, w których dochód był osiągany - w przypadku uzyskania dochodu w roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_14(50),
    /**
     * oświadczenie o wysokość dochodu uzyskanego przez członka rodziny z miesiąca następującego po miesiącu, w którym dochód został osiągnięty - w przypadku uzyskania dochodu po roku kalendarzowym poprzedzającym okres zasiłkowy
     */
    ZSR_15(51),
    /**
     * Oświadczenie o posiadaniu rachunku w banku / spółdzielczej kasie oszczędnościowo-kredytowej
     */
    ZSR_16(53),

    /**
     * Wniosek o wydanie zaświadczenia w/s udzielonej pomocy
     */
    ZS_1(30),
    /**
     * Wniosek o umorzenie należności (w części lub w całości), rozłożenia na raty spłaty należności, odroczenie terminu płatności, zwolnienie lub zmniejszenie odpłatności
     */
    ZS_2(31),
    /**
     * Zgłoszenie nieprawidłowości do jednostki terenowej
     */
    ZS_3(32),
    /**
     * Wniosek o zmianę decyzji lub postanowienia
     */
    ZS_4(33),
    /**
     * Odwołanie od decyzji organu właściwego
     */
    ZS_5(34),
    /**
     * Korespondencja w sprawie do JT
     */
    ZS_6(35),

    /**
     * Pismo ogólne
     */
    PISMO_OGOLNE(63),
    /**
     * Inne wnioski, formularze
     */
    INNE_PISMO(52),
    /**
     * Plik załącznika do poczty - jpg, pdf itp
     */
    PLIK_ZALACZNIKA(0);


    private final long kod;

    TypFormularza(long kod) {
        this.kod = kod;
    }

    public long getKod() {
        return kod;
    }

    public static TypFormularza dajTypFormularzaZKodu(long kod){
        for (TypFormularza typ: TypFormularza.values()){
            if (typ.getKod() == kod){
                return typ;
            }
        }
        return null;
    }

    public static final Set<TypFormularza> RODZAJE_DOKUMENTOW_WNIOSKI_SR =
            ImmutableSet.of(SR_1_ZAS_RODZ, SR_2_BECIKOWE, SR_3_ZAS_PIEL, SR_4_SPEC_ZAS_OPIEK, SR_5_SWIAD_PIEL, SR_6_SAMOTNE_WYCH,
                    SR_7_SWIAD_RODZICIELSKIE, SR_8_ZA_ZYCIEM, SW_1_SWIAD_WYCHOWAWCZE);
    public static final Set<TypFormularza> RODZAJE_DOKUMENTOW_INNE = ImmutableSet.of(ZS_1, ZS_2, ZS_3, ZS_4, ZS_5, ZS_6, PISMO_OGOLNE, INNE_PISMO);

    public static boolean czyRodzajDokumentuWniosekSR(long kod){
        return RODZAJE_DOKUMENTOW_WNIOSKI_SR.contains(dajTypFormularzaZKodu(kod));
    }

    public static boolean czyRodzajDokumentuInny(long kod){
        return RODZAJE_DOKUMENTOW_INNE.contains(dajTypFormularzaZKodu(kod));
    }

}
