<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/ZFA_06/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>ZFA-06 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
      </head>
      <body style="text-align: center; font-family: Arial; ">
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZFA-06</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page" />
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 194px; width: 880px; left: 0px; top: 249px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #ebd7ff; border-color: #ebd7ff; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer violetAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="position: absolute; height: 161px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">03. Numer PESEL</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 3px; top: 143px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 93px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 291px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 88px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 463px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">WPISZ ORGAN PROWADZĄCY EGZEKUCJĘ ALIMENTÓW</div>
            <div style="position: absolute; height: 56px; width: 869px; background-color: #E7E5E6; border-color: #E7E5E6; left: 10px; top: 28px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; height: 54px; color: #000000; overflow: hidden; width: 850px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 1px; " class="SofTextArea dotted">
                <div style="padding-left:5px ; padding-top:2px; display: block;">
                  <xsl:call-template name="formatTextArea">
                    <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje" />
                    <xsl:with-param name="wysokosc" select="54" />
                    <xsl:with-param name="szerokosc" select="850" />
                    <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                    <xsl:with-param name="wysokoscLini" select="20" />
                    <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                    <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuProwadzacegoEgzekucje" />
                  </xsl:call-template>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 196px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 560px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE ADRESOWE ORGANU PROWADZĄCEGO EGZEKUCJĘ ALIMENTÓW</div>
            <div style="position: absolute; height: 162px; color: #000000; overflow: hidden; width: 850px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 28px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje" />
                  <xsl:with-param name="wysokosc" select="162" />
                  <xsl:with-param name="szerokosc" select="850" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:AdresOrganuProwadzacegoEgzekucje" />
                </xsl:call-template>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 226px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 895px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE ZOBOWIĄZANEGO DO ALIMENTÓW</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Data urodzenia (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 169px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyZobowiazanej/wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 205px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 803px; " class="SofLabel global14Normal">Data wszczęcia egzekucji:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 204px; top: 782px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 204px; border: 1px solid black; top: 795px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataWszczeciaEgzekucji" />
              </xsl:call-template>
            </span>
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: bold; top: 861px; " class="SofLabel global14Bold">Oświadczam, że w okresie ostatnich dwóch miesięcy egzekucja alimentów należnych od:</div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: ZFA-06(2)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 1/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 70px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 70px; " class="SofLabel formTitle">
            OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O BEZSKUTECZNOŚCI EGZEKUCJI ALIMENTÓW
          </div>
          </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZFA-06</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page" />
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="position: absolute; height: 270px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 30px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA ZOBOWIĄZANEGO (jeżeli jest znany)</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 69px; " class="SofLabel">Kod pocztowy</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 82px; " class="SofTextInput">
              <span style="padding-left:5px ;line-height:25px;display: block;">
                <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy!= ''">
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 1, 2)" />
                  -
                  <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:KodPocztowy, 3, 4)" />
                </xsl:if>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 181px; top: 69px; " class="SofLabel">Miejscowość</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 697px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 181px; border: 1px solid black; top: 82px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Miejscowosc" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Gmina / Dzielnica</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:GminaDzielnica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 113px; " class="SofLabel">Ulica</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 126px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:Ulica" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 157px; " class="SofLabel">Numer domu</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 170px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerDomu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="169" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 205px; top: 157px; " class="SofLabel">Numer mieszkania</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 205px; border: 1px solid black; top: 170px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NumerLokalu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="169" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 189px; font-size: 12px; left: 13px; top: 201px; " class="SofLabel">Zagraniczny kod pocztowy</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 289px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 214px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:ZagranicznyKodPocztowy" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="289" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 325px; top: 201px; " class="SofLabel">Nazwa państwa</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 553px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 325px; border: 1px solid black; top: 214px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaZobowiazanego/wnio:NazwaPanstwa" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="553" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 13px; top: 251px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: bold; top: 321px; " class="SofLabel global14Bold">przyznanych dla:</div>
          <div style="position: absolute; height: 181px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 355px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE OSOBY, KTÓREJ PRZYZNANO ALIMENTY</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Data urodzenia (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneOsobyKtorejPrzyznanoAlimenty/wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 13px; top: 162px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 570px; " class="SofLabel global14Normal">tytułem wykonawczym (np. wyrok sądu) z dnia:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 324px; top: 549px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 324px; border: 1px solid black; top: 562px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataOrzeczeniaSadu" />
              </xsl:call-template>
            </span>
            <span />
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 531px; font-family: arial; font-weight: normal; top: 570px; " class="SofLabel global14Normal">sygnatura akt:</div>
          <div style="position: absolute; height: 27px; color: #000000; overflow: hidden; width: 251px; font-size: 18px; background-color: white; display: block; left: 628px; border: 1px solid black; top: 562px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:27px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SygnaturaAkt" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="251" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 606px; " class="SofLabel global14Normal">w wysokości miesięcznie:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 382px; font-family: arial; font-weight: normal; top: 606px; " class="SofLabel global14Normal">zł.</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 13px; font-family: arial; font-weight: bold; top: 644px; " class="SofLabel global14Bold">EGZEKUCJA&#xa0;&#xa0;ALIMENÓW - OKAZAŁA SIĘ BEZSKUTECZNA(1).</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 180px; border: 1px solid black; top: 598px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:WysokoscAlimentow,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 30px; font-family: arial; font-weight: normal; top: 823px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 923px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
          <div style="position: absolute; height: 100px; text-align: justify; color: #000000; width: 860px; font-size: 12px; left: 13px; top: 668px; " class="SofLabel justified">(1) Za bezskuteczną uważa się egzekucję (art. 2 pkt 2 ustawy z dnia 7 września 2007 r. o pomocy osobom uprawnionym do alimentów (Dz. U. z 2017 r. poz. 489) w wyniku której w okresie ostatnich dwóch miesięcy &#xa0;nie wyegzekwowano pełnej należności z tytułu zaległych i bieżących zobowiązań alimentacyjnych. Za bezskuteczną egzekucję uważa się również niemożność wszczęcia lub prowadzenia egzekucji alimentów przeciwko dłużnikowi alimentacyjnemu przebywającemu poza granicami Rzeczpospolitej Polskiej, w szczególności z powodu: braku podstawy prawnej do podjęcia czynności zmierzających do wykonania tytułu wykonawczego w miejscu zamieszania dłużnika, braku możliwości wskazania przez osobę uprawnioną miejsca zamieszkania dłużnika alimentacyjnego za granicą.</div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 3px; " class="SofLabel footnote">wersja: ZFA-06(2)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 3px; " class="SofLabel footnote">strona: 2/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="." />
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates />
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates />
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates />
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="." />
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates />
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="dlugoscPolaWPikselach" />
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.6 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.6 * string-length($tekst))" />
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')" />
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 6, 2)" />
      /
      <xsl:value-of select="substring($wartosc, 1, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc" />
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)" />
      -
      <xsl:value-of select="substring($wartosc, 3, 4)" />
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst" />
    <xsl:param name="wysokosc" />
    <xsl:param name="szerokosc" />
    <xsl:param name="bazowyRozmiarCzcionki" />
    <xsl:param name="wysokoscLini" />
    <xsl:param name="liczbaPrzejscDoNowychLini" />
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini" />
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)" />
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem" />
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)" />
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')" />
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'" />
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst" />
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0" />
    <xsl:param name="try" select="1" />
    <xsl:param name="iter" select="1" />
    <xsl:param name="maxiter" select="10" />
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number" />
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))" />
          <xsl:with-param name="iter" select="$iter + 1" />
          <xsl:with-param name="maxiter" select="$maxiter" />
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
