<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/SW_1/2/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>SW-1 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
      </head>
      <body style="text-align: center; font-family: Arial; ">

		<!-- Pierwsza część, statyczna formularza + pierwsze dziecko -->		
		<xsl:call-template name="poczatkowaStatycznaCzescSW">
		</xsl:call-template>		
		
		<!-- Sekcja dynamiczna - kolejne dzieci -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaKolejnego">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="dynamicznaSekcjaDzieciSW">
					<xsl:with-param name="BiezaceDziecko" select="position()"/>
				</xsl:call-template>
			</xsl:if>
			
		</xsl:for-each>		
		
		<!-- Środkowa część, statyczna formularza -->		
		<xsl:call-template name="srodkowaStatycznaCzescSW">
		</xsl:call-template>		
		
		<!-- Sekcja dynamiczna - członkowie rodziny -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:DaneCzlonkowRodzinyOsobyUbiegajacejSie/wnio:DaneOsoby">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="dynamicznaSekcjaCzlonekRodzinySW">
					<xsl:with-param name="BiezacyCzlonekRodziny" select="position()"/>
				</xsl:call-template>
			</xsl:if>

		</xsl:for-each>		
		
		<!-- Ostatnia statyczna część formularza -->
		<xsl:call-template name="ostatniaStatycznaCzescSW">
		</xsl:call-template>		

		<!-- Załącznik nr 1 -->
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:OswiadczenieInneDochody">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="Zalacznik1SW"/>
			</xsl:if>

		</xsl:for-each>		

		<!-- Załącznik nr 2 -->
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:OswiadczenieZryczaltowanyPodatekDochodowy">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="Zalacznik2SW"/>
			</xsl:if>

		</xsl:for-each>		

		<!-- Załącznik nr 3 -->
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:OswiadczenieGospodarstwoRolne">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="Zalacznik3SW"/>
			</xsl:if>

		</xsl:for-each>		
		
		<!-- Załącznik nr 4 -->
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:OswiadczenieUbezpieczenieZdrowotne">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="Zalacznik4SW"/>
			</xsl:if>

		</xsl:for-each>			
		
		<!-- Stopka prawna Inna Instytucja -->		
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc != 'ZUS'">
			<xsl:call-template name="notaPrawnaInnaInstytucjaSW">
			</xsl:call-template>
		</xsl:if>

		<!-- Stopka prawna - ZUS -->				
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc = 'ZUS'">
			<xsl:call-template name="notaPrawnaZusSW">
			</xsl:call-template>
		</xsl:if>		  
		  
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."/>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates/>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="."/>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="dlugoscPolaWPikselach"/>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.7 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.7 * string-length($tekst))"/>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')"/>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)"/>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst"/>
    <xsl:param name="wysokosc"/>
    <xsl:param name="szerokosc"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="wysokoscLini"/>
    <xsl:param name="liczbaPrzejscDoNowychLini"/>
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"/>
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)"/>
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)"/>
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0"/>
    <xsl:param name="try" select="1"/>
    <xsl:param name="iter" select="1"/>
    <xsl:param name="maxiter" select="10"/>
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number"/>
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))"/>
          <xsl:with-param name="iter" select="$iter + 1"/>
          <xsl:with-param name="maxiter" select="$maxiter"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Część implementacyjna formularza -->
  
  <xsl:template name="poczatkowaStatycznaCzescSW">
  
		<!-- Początkowa część statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1220px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always;">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">SW-1</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
		  
          <div style="position: absolute; color: #000000; font-size: 12px; left: 12px; font-family: arial; font-weight: bold; top: 200px; " class="SofLabel global12Bold">Wniosek dotyczy okresu na jaki ustala się prawo do świadczenia wychowawczego (1):</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; display: block; left: 518px; border: 1px solid black; top: 185px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OkresSwiadczeniowy" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="191" />
              </xsl:call-template>
            </span>
          </div>	  
		  
          <div style="position: absolute; height: 19px; color: #000000; font-size: 12px; left: 518px; font-family: arial; font-weight: bold; top: 195px; " class="SofLabel global12Bold"></div>
          <div style="position: absolute; height: 24px; color: #000000; width: 836px; font-size: 12px; left: 13px; top: 219px; " class="SofLabel">(1) Okres na jaki ustalane jest prawo do &#xa0;świadczenia wychowawczego trwa od 1 października do 30 września następnego roku kalendarzowego.</div>
          <div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 240px; ">
            <div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">NAZWA ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="position: absolute; height: 68px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; height: 54px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                      <xsl:with-param name="wysokosc" select="54" />
                      <xsl:with-param name="szerokosc" select="840" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="wysokoscLini" select="20" />
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 233px; width: 880px; left: 0px; top: 340px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="position: absolute; height: 200px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 27px; text-align: left; color: #000000; overflow: hidden; width: 697px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer mieszkania</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="position: absolute; height: 26px; color: #000000; width: 867px; font-size: 12px; left: 3px; top: 183px; " class="SofLabel">(1) Przez organ właściwy rozumie się wójta, burmistrza lub prezydenta miasta właściwego ze względu na miejsce zamieszkania osoby składającej wniosek.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 584px; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 604px; " class="SofLabel justified14Bold">1. Dane osoby składającej wniosek o ustalenie prawa do świadczenia wychowawczego, zwanej dalej „wnioskodawcą".</div>
          <div style="position: absolute; height: 307px; width: 880px; left: 0px; top: 624px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="position: absolute; height: 274px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">03. Numer PESEL</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 291px; top: 93px; " class="SofLabel">04. Data urodzenia: (dd / mm / rrrr)</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 291px; border: 1px solid black; top: 106px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 230px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 244px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 507px; top: 93px; " class="SofLabel">05. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 507px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">06. Obywatelstwo</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">07. Stan cywilny</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #000000; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofDropDownList dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:StanCywilny" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 293px; width: 880px; left: 0px; top: 930px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #DCE6FA; border-color: #DCE6FA; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer blueAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 8px; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA</div>
              <div style="position: absolute; height: 260px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 49px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 49px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 697px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 5px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 93px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 137px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 137px; " class="SofLabel">06. Numer mieszkania</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 126px; font-size: 12px; left: 411px; top: 137px; " class="SofLabel">07. Numer telefonu</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 241px; font-size: 18px; background-color: white; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerTelefonu" />
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 181px; " class="SofLabel">08. Adres poczty elektronicznej — e-mail</div>
                <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:AdresPocztyElektronicznej" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 230px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 244px; " class="SofLabel"></div>
              </div>
            </div>
          </div>

           <div style="position: absolute; height: 70px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 35px; " class="SofLabel formTitle">
            WNIOSEK
            <br />
            O &#xa0;USTALENIE &#xa0;PRAWA &#xa0;DO &#xa0;ŚWIADCZENIA &#xa0;WYCHOWAWCZEGO
          </div>
		  
		   </div>
        <div style="position: relative; margin-right: auto; height: 850px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; page-break-inside: avoid;">
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 7px; " class="SofLabel global14Bold">2. &#xa0;Ustalenie prawa do świadczenia wychowawczego na pierwsze dziecko.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 28px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Świadczenie wychowawcze na pierwsze dziecko jest uzależnione od spełnienia kryterium dochodowego i przysługuje jeżeli dochód rodziny w przeliczeniu na osobę nie przekracza kwoty 800,00 zł. Jeżeli członkiem rodziny jest dziecko niepełnosprawne, świadczenie wychowawcze na pierwsze dziecko przysługuje jeżeli dochód rodziny w przeliczeniu na osobę nie przekracza kwoty 1 200,00 zł.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 82px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Pierwsze dziecko oznacza jedyne lub najstarsze dziecko w rodzinie w wieku do ukończenia 18. roku życia; w przypadku dzieci urodzonych tego samego dnia, miesiąca i roku, będących najstarszymi dziećmi w rodzinie w wieku do ukończenia 18. roku życia (czyli w przypadku wieloraczków) pierwsze dziecko oznacza jedno z tych dzieci wskazane przez osobę ubiegającą się.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 136px; " class="SofLabel justified14">&#xa0;&#xa0;&#xa0;&#xa0;&#xa0;Niepełnosprawne dziecko oznacza dziecko legitymujące się orzeczeniem o niepełnosprawności określonym w przepisach o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych albo orzeczeniem o umiarkowanym lub znacznym stopniu niepełnosprawności.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 829px; font-size: 14px; left: 47px; top: 200px; " class="SofLabel justified14">Składam wniosek o świadczenie wychowawcze na pierwsze dziecko zamieszkujące ze mną oraz pozostające na moim utrzymaniu.</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 201px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:SwiadczenieWychowawczeNaPierwszeDziecko/wnio:Wnosze='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 829px; font-size: 14px; left: 47px; top: 264px; " class="SofLabel justified14">Nie składam wniosku o świadczenie wychowawcze na pierwsze dziecko zamieszkujące ze mną oraz pozostające na moim utrzymaniu.</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 265px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:SwiadczenieWychowawczeNaPierwszeDziecko/wnio:NieWnosze='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 32px; text-align: left; color: #000000; width: 875px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 316px; " class="SofLabel global14Bold">A. DANE PIERWSZEGO DZIECKA:</div>
          <div style="position: absolute; height: 295px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 352px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE DZIECKA - 1</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 200px; " class="SofLabel">Stan cywilny:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #000000; display: block; left: 13px; border: 1px solid black; top: 213px; " class="SofDropDownList dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:StanCywilny" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 398px; top: 200px; " class="SofLabel">Płeć:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 48px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 398px; border: 1px solid black; top: 213px; " class="SofDropDownList">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaPierwszego/wnio:Plec" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 13px; top: 247px; " class="SofLabel"></div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 13px; top: 261px; " class="SofLabel"></div>
          </div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 667px; " class="SofLabel textKoreanBoldJustified">Wnioskodawca ubiegający się o świadczenie wychowawcze na pierwsze dziecko w dalszej części wniosku będzie musiał podać informacje na temat dochodów członków swojej rodziny.</div>
          <div style="position: absolute; height: 42px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 720px; " class="SofLabel textKoreanBoldJustified">3. Ustalenie prawa do świadczenia wychowawczego na kolejne dziecko/dzieci w wieku poniżej 18. roku życia, inne niż pierwsze dziecko.</div>
          <div style="position: absolute; height: 56px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 756px; " class="SofLabel justified14">Składam wniosek o świadczenie wychowawcze na następujące drugie i kolejne dziecko/dzieci zamieszkujące ze mną oraz pozostające na moim utrzymaniu (świadczenie wychowawcze na drugie i kolejne dziecko przysługuje do dnia ukończenia przez dziecko 18. roku życia i przysługuje niezależnie od osiągniętego dochodu):</div>
          <div style="position: absolute; height: 16px; text-align: left; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 823px; " class="SofLabel global14Bold">B. Kolejne dziecko/dzieci.</div>

        </div>
  </xsl:template>		
    
	
  <xsl:template name="dynamicznaSekcjaDzieciSW">
		<xsl:param name="BiezaceDziecko"/>
		  		
		<!-- Strona dynamiczna formularza (dzieci) -->		
        <div style="position: relative; margin-right: auto; height: 295px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; height: 295px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE DZIECKA - <xsl:value-of select="$BiezaceDziecko"/></div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 200px; " class="SofLabel">Stan cywilny:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 312px; font-size: 18px; background-color: white; border-color: #000000; display: block; left: 13px; border: 1px solid black; top: 213px; " class="SofDropDownList dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:StanCywilny" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Obywatelstwo:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 14px; border: 1px solid black; top: 169px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 398px; top: 200px; " class="SofLabel">Płeć:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 48px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 398px; border: 1px solid black; top: 213px; " class="SofDropDownList">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Plec" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 247px; " class="SofLabel"></div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 14px; top: 261px; " class="SofLabel"></div>
          </div>
 
        </div>
  </xsl:template> 
  
  
  <xsl:template name="srodkowaStatycznaCzescSW">
		
		<!-- Środkowa część, statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 540px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 7px; " class="SofLabel global14Bold">4. Dane członków rodziny.</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 25px; " class="SofLabel justified14">Wpisz tutaj wszystkich członków swojej rodziny, czyli odpowiednio:</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 45px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 45px; " class="SofLabel justified14">wnioskodawcę (siebie),</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 66px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 66px; " class="SofLabel justified14">dane dzieci, na które wnioskujesz o świadczenie wychowawcze,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 87px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 87px; " class="SofLabel justified14">tutaj musisz podać również dane pierwszego dziecka – nawet jeśli nie składasz na to dziecko wniosku &#xa0;o świadczenie wychowawcze,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 108px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 108px; " class="SofLabel justified14">pozostałe dzieci w wieku do ukończenia 25 r. życia, na które nie składasz wniosku o świadczenie wychowawcze, ale które zamieszkują z Tobą i pozostają na Twoim utrzymaniu,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 146px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 44px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 146px; " class="SofLabel justified14">dziecko, które ukończyło 25. rok życia, legitymujące się orzeczeniem o znacznym stopniu niepełnosprawności, jeżeli w związku z tą niepełnosprawnością przysługuje świadczenie pielęgnacyjne, specjalny zasiłek opiekuńczy lub zasiłek dla opiekuna,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 184px; " class="SofLabel justified14">-</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 25px; top: 184px; " class="SofLabel justified14">dane Twojego małżonka/drugiego rodzica z którym wspólnie wychowujesz dzieci.</div>
          <div style="position: absolute; height: 136px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 207px; " class="SofLabel justified14">Definicja rodziny: zgodnie z art. 2 pkt 16 ustawy o pomocy w państwa w wychowywaniu dzieci rodzina oznacza odpowiednio: małżonków, rodziców dzieci, opiekuna faktycznego dziecka (opiekun faktyczny dziecka to osoba faktycznie opiekującą się dzieckiem, jeżeli wystąpiła z wnioskiem do sądu opiekuńczego o przysposobienie dziecka) oraz zamieszkujące wspólnie z tymi osobami, pozostające na ich utrzymaniu dzieci w wieku do ukończenia 25. roku życia, a także dzieci, które ukończyły 25. rok życia, legitymujące się orzeczeniem o znacznym stopniu niepełnosprawności, jeżeli w związku z tą niepełnosprawnością przysługuje świadczenie pielęgnacyjne lub specjalny zasiłek opiekuńczy albo zasiłek dla opiekuna, o którym mowa w ustawie z dnia 4 kwietnia 2014 r. o ustaleniu i wypłacie zasiłków dla opiekunów (Dz. U. z 2016 r. poz. 162 i 972).</div>
          <div style="position: absolute; height: 136px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 338px; " class="SofLabel justified14">Do członków rodziny nie zalicza się:</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 358px; " class="SofLabel justified14">- dziecka pozostającego pod opieką opiekuna prawnego,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 378px; " class="SofLabel justified14">- dziecka pozostającego w związku małżeńskim,</div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 398px; " class="SofLabel justified14">- pełnoletniego dziecka posiadającego własne dziecko.</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 421px; " class="SofLabel justified14">W przypadku gdy dziecko, zgodnie z orzeczeniem sądu, jest pod opieką naprzemienną obojga rodziców rozwiedzionych lub żyjących w separacji lub żyjących w rozłączeniu sprawowaną w porównywalnych i powtarzających się okresach, dziecko zalicza się jednocześnie do członków rodzin obydwojga rodziców.</div>
          
          <div style="position: absolute; height: 36px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 490px; " class="SofLabel textKoreanBoldJustified">W skład mojej rodziny zgodnie z ww. definicją wchodzą (poniżej wpisz wszystkich członków rodziny osoby ubiegającej się o świadczenie wychowawcze, w tym dzieci wskazane w tabeli A i B):</div>

        </div>	
  </xsl:template>		

  
  <xsl:template name="dynamicznaSekcjaCzlonekRodzinySW">
		<xsl:param name="BiezacyCzlonekRodziny"/>
			
		<!-- Strona dynamiczna formularza (członkowie rodziny) -->		
        <div style="position: relative; margin-right: auto; height: 224px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid; ">

          <div style="position: absolute; height: 224px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 0px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE OSOBY - <xsl:value-of select="$BiezacyCzlonekRodziny"/>, WCHODZĄCEJ W SKŁAD RODZINY</div>
            <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 13px; top: 112px; " class="SofLabel">Numer PESEL:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 125px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 301px; top: 112px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 301px; border: 1px solid black; top: 125px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 68px; " class="SofLabel">Nazwisko:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 81px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 517px; top: 112px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość:</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 517px; border: 1px solid black; top: 125px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 156px; " class="SofLabel">Pokrewieństwo: (relacja do wnioskodawcy)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 649px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 13px; border: 1px solid black; top: 169px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Pokrewienstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="649" />
                </xsl:call-template>
              </span>
            </div>
            <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 13px; top: 206px; " class="SofLabel"></div>
          </div>

        </div>	
  </xsl:template> 
				
  
  <xsl:template name="ostatniaStatycznaCzescSW">
		
		<!-- Końcowa część statyczna formularza -->
        <div style="position: relative; margin-right: auto; height: 1170px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 7px; " class="SofLabel textKoreanBoldJustified">5. Oświadczam, że orzeczeniem o niepełnosprawności lub orzeczeniem o umiarkowanym lub znacznym stopniu niepełnosprawności legitymuje się następujące dziecko wchodzące w skład mojej rodziny:</div>
          <div style="position: absolute; height: 32px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 41px; " class="SofLabel justified"></div>
          <div style="position: absolute; height: 240px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 73px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE DZIECI - ORZECZENIE O NIEPEŁNOSPRAWNOŚCI</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Imię i nazwisko dziecka:</div>
            <div style="position: absolute; height: 193px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 37px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OrzeczenieNiepelnosprawnosc/wnio:DaneDzieci/wnio:ImieNazwisko" />
                  <xsl:with-param name="wysokosc" select="193" />
                  <xsl:with-param name="szerokosc" select="840" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OrzeczenieNiepelnosprawnosc/wnio:DaneDzieci/wnio:ImieNazwisko" />
                </xsl:call-template>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 334px; " class="SofLabel textKoreanBoldJustified">6. Zaznacz organ, do którego są opłacane składki na ubezpieczenie zdrowotne za Ciebie i członków Twojej rodziny.</div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 352px; " class="SofLabel justified"></div>
          
		  <div style="position: absolute; color: #000000; width: 166px; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 374px; " class="SofLabel global14Normal">Zakład Ubezpieczeń Społecznych</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 374px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:ZUS='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; width: 214px; font-size: 14px; left: 357px; font-family: arial; font-weight: normal; top: 375px; " class="SofLabel global14Normal">Kasa Rolniczego Ubezpieczenia Społecznego</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 323px; border: 1px solid black; top: 374px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:KRUS='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 656px; font-family: arial; font-weight: normal; top: 382px; " class="SofLabel global14Normal">Brak</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 622px; border: 1px solid black; top: 374px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:Brak='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 427px; " class="SofLabel global14Normal">Inny</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 420px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:Inny='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 37px; top: 457px; " class="SofLabel">Nazwa i adres właściwej jednostki:</div>
          <div style="position: absolute; height: 54px; color: #000000; overflow: hidden; width: 813px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 475px; " class="SofTextArea dotted">
            <div style="padding-left:5px ; padding-top:2px; display: block;">
              <xsl:call-template name="formatTextArea">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:OddzialInspektoratWlasciwejJednostki" />
                <xsl:with-param name="wysokosc" select="54" />
                <xsl:with-param name="szerokosc" select="813" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="wysokoscLini" select="20" />
                <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OrganOdprowadzajacySkladkeZdrowotna/wnio:OddzialInspektoratWlasciwejJednostki" />
              </xsl:call-template>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 539px; " class="SofLabel"></div>
		  
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 571px; " class="SofLabel global14Bold">7. Dane dotyczące dochodów członków rodziny:</div>
          <div style="position: absolute; height: 16px; text-align: justify; color: #000000; width: 870px; font-size: 12px; left: 6px; top: 589px; " class="SofLabel justified"></div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 631px; " class="SofLabel global14Normal">7.1 Łączna kwota alimentów świadczonych na rzecz innych osób spoza rodziny wyniosła w roku:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 623px; top: 610px; " class="SofLabel">Rok kalendarzowy</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 97px; font-size: 18px; background-color: white; display: block; left: 623px; border: 1px solid black; top: 623px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:InneDane/wnio:AlimentyNaRzeczInnychOsob/wnio:Rok" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="97" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 37px; top: 651px; " class="SofLabel">Kwota alimentów</div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 664px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(//wnio:TrescDokumentu/wnio:InneDane/wnio:AlimentyNaRzeczInnychOsob/wnio:KwotaAlimentow,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; text-align: justify; color: #000000; font-size: 14px; left: 239px; top: 672px; " class="SofLabel justified14">zł.</div>
          <div style="position: absolute; height: 30px; text-align: justify; color: #000000; width: 864px; font-size: 12px; left: 13px; top: 1035px; " class="SofLabel justified"></div>
          <div style="position: absolute; height: 36px; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; top: 711px; " class="SofLabel justified14">7.2 W roku kalendarzowym poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego, Ja lub członkowie mojej rodziny (wskazani w punkcie 4 wniosku):</div>
          <div style="position: absolute; height: 70px; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 748px; " class="SofLabel justified14">osiągnęli dochody niepodlegające opodatkowaniu podatkiem dochodowym od osób fizycznych na zasadach określonych w art. 27, art. 30b, a rt. 30c, art. 30e i art. 30f ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych (Dz. U. z 2012 r. poz. 361, z późn. zm.), wskazane w pouczeniu do Załącznika ZSW-01</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 800px; " class="SofLabel justified14">(w przypadku zaznaczenia wypełnij dodatkowo oświadczenie o dochodzie Twoim lub członka/członków rodziny stanowiące Załącznik ZSW-01 do wniosku).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 769px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieInneDochody/wnio:Tak='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 108px; border: 1px solid black; top: 769px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieInneDochody/wnio:Nie='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 842px; " class="SofLabel justified14">osiągnęli dochody z działalności podlegającej opodatkowaniu na podstawie przepisów o zryczałtowanym podatku dochodowym od niektórych przychodów osiąganych przez osoby fizyczne - ryczałt ewidencjonowany lub karta podatkowa</div>
          <div style="position: absolute; height: 32px; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 895px; " class="SofLabel justified14">(w przypadku zaznaczenia dołącz do wniosku zaświadczenie z urzędu skarbowego zawierające dane dotyczące opodatkowania działalności Twojej lub członka/członków Twojej rodziny, podlegającej opodatkowaniu na podstawie przepisów o zryczałtowanym podatku dochodowym od niektórych przychodów osiąganych przez osoby fizyczne - ryczałt ewidencjonowany lub karta podatkowa).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 862px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieZryczaltowanyPodatekDochodowy/wnio:Tak='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 108px; border: 1px solid black; top: 862px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieZryczaltowanyPodatekDochodowy/wnio:Nie='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 974px; " class="SofLabel justified14">osiągnęli dochody uzyskane z gospodarstwa rolnego</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 715px; font-size: 14px; left: 155px; top: 990px; " class="SofLabel justified14">(w przypadku zaznaczenia wypełnij dodatkowo oświadczenie o przeciętnej &#xa0;wielkości Twojego gospodarstwa rolnego lub gospodarstwa członka/członków rodziny stanowiące Załącznik ZSW-03 do wniosku).</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 994px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieGospodarstwoRolne/wnio:Tak='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 108px; border: 1px solid black; top: 994px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:DochodyOsiagnietePrzezCzlonkowRodziny/wnio:ZalacznikOswiadczenieGospodarstwoRolne/wnio:Nie='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; height: 88px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: &quot;Arial&quot;; font-weight: bold; top: 1085px; " class="SofLabel textKoreanBoldJustified">Ponadto dochodem rodziny osoby ubiegającej się o świadczenie wychowawcze na pierwsze dziecko są przychody podlegające opodatkowaniu na zasadach określonych w art. 27, art. 30b, art. 30c, art. 30e i art. 30f ustawy z dnia 26 lipca 1991 r. o podatku dochodowym od osób fizycznych, pomniejszone o koszty uzyskania przychodu, należny podatek dochodowy od osób fizycznych, składki na ubezpieczenia społeczne niezaliczone do kosztów uzyskania przychodu oraz składki na ubezpieczenie zdrowotne – dane o tych dochodach organ uzyskuje samodzielnie.</div>
          
          <div style="position: absolute; color: #000000; width: 25px; font-size: 12px; left: 39px; top: 750px; " class="SofLabel">TAK</div>
          <div style="position: absolute; text-align: center; color: #000000; width: 25px; font-size: 12px; left: 109px; top: 750px; " class="SofLabel">NIE</div>
          <div style="position: absolute; color: #000000; width: 25px; font-size: 12px; left: 39px; top: 844px; " class="SofLabel">TAK</div>
          <div style="position: absolute; text-align: center; color: #000000; width: 25px; font-size: 12px; left: 109px; top: 844px; " class="SofLabel">NIE</div>
          <div style="position: absolute; color: #000000; width: 25px; font-size: 12px; left: 39px; top: 977px; " class="SofLabel">TAK</div>
          <div style="position: absolute; text-align: center; color: #000000; width: 25px; font-size: 12px; left: 109px; top: 977px; " class="SofLabel">NIE</div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1190px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; top: 7px; " class="SofLabel justified14">7.3 Informacja na temat sytuacji związanych z uzyskaniem lub utratą dochodu:</div>
          <div style="position: absolute; height: 18px; text-align: justify; color: #000000; width: 864px; font-size: 12px; left: 6px; top: 25px; " class="SofLabel justified"></div>
          <div style="position: absolute; height: 339px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 44px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 120px; " class="SofLabel justified12">(1) Utrata dochodu, zgodnie z art. 2 pkt 19 ustawy, oznacza utratę dochodu spowodowaną:</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 135px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 135px; " class="SofLabel justified12">uzyskaniem prawa do urlopu wychowawczego,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 149px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 149px; " class="SofLabel justified12">utratą zasiłku lub stypendium dla bezrobotnych,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 163px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 163px; " class="SofLabel justified12">utratą zatrudnienia lub innej pracy zarobkowej,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 177px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 177px; " class="SofLabel justified12">utratą zasiłku przedemerytalnego lub świadczenia przedemerytalnego, nauczycielskiego świadczenia kompensacyjnego, a także emerytury lub renty, renty rodzinnej lub renty socjalnej,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 205px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 205px; " class="SofLabel justified12">wyrejestrowaniem pozarolniczej działalności gospodarczej lub zawieszeniem jej wykonywania w rozumieniu art. 14a ust. 1d ustawy z dnia 2 lipca 2004 r. o swobodzie działalności gospodarczej (Dz. U. z 2015 r. poz. 584, z późn. zm.)</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 234px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 234px; " class="SofLabel justified12">utratą zasiłku chorobowego, świadczenia rehabilitacyjnego lub zasiłku macierzyńskiego, przysługujących po utracie zatrudnienia lub innej pracy zarobkowej,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 249px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 249px; " class="SofLabel justified12">utratą zasądzonych świadczeń alimentacyjnych w związku ze śmiercią osoby zobowiązanej do tych świadczeń lub utratą świadczeń pieniężnych wypłacanych w przypadku bezskuteczności egzekucji alimentów w związku ze śmiercią osoby zobowiązanej do świadczeń alimentacyjnych,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 278px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 278px; " class="SofLabel justified12">utratą świadczenia rodzicielskiego,</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 293px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 293px; " class="SofLabel justified12">utratą zasiłku macierzyńskiego, o którym mowa w przepisach o ubezpieczeniu społecznym rolników.</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 308px; " class="SofLabel justified12">-</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 308px; " class="SofLabel justified12">utratą stypendium doktoranckiego określonego w art. 200 ust. 1 ustawy z dnia 27 lipca 2005 r. - Prawo o szkolnictwie wyższym (Dz. U. z 2012 r. poz. 572, z późn. zm.).</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 51px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UtrataDochoduWRokuPoprzedzajacym/wnio:Nastapila='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 59px; " class="SofLabel global14Normal">nastąpiła utrata przez członka Twojej rodziny dochodu. (1)</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 83px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UtrataDochoduWRokuPoprzedzajacym/wnio:NieNastapila='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 91px; " class="SofLabel global14Normal">nie nastąpiła utrata przez członka Twojej rodziny dochodu. (1)</div>
          </div>
          <div style="position: absolute; color: #000000; width: 857px; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 58px; " class="SofLabel global14Normal">Zaznacz jeśli w roku kalendarzowym poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego lub po tym roku:</div>
          <div style="position: absolute; color: #000000; width: 857px; font-size: 14px; left: 13px; font-family: arial; font-weight: normal; top: 397px; " class="SofLabel global14Normal">Zaznacz jeśli w roku kalendarzowym poprzedzającym okres, na który jest ustalane prawo do świadczenia wychowawczego lub po tym roku:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 442px; " class="SofLabel global14Normal">nastąpiło uzyskanie przez członka Twojej rodziny dochodu. (1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 434px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UzyskanieDochoduWRokuPoprzedzajacym/wnio:Nastapilo='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 71px; font-family: arial; font-weight: normal; top: 474px; " class="SofLabel global14Normal">nie nastąpiło uzyskanie przez członka Twojej rodziny dochodu. (1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 466px; " class="SofCheckBox">
            <xsl:if test="//wnio:TrescDokumentu/wnio:InneDane/wnio:UzyskanieDochoduWRokuPoprzedzajacym/wnio:NieNastapilo='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 503px; " class="SofLabel justified12">(1) Uzyskanie dochodu, zgodnie z art. 2 pkt 20 ustawy, oznacza uzyskanie dochodu spowodowane:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 519px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 519px; " class="SofLabel justified12">zakończeniem urlopu wychowawczego,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 534px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 534px; " class="SofLabel justified12">uzyskaniem zasiłku lub stypendium dla bezrobotnych,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 548px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 548px; " class="SofLabel justified12">uzyskaniem zatrudnienia lub innej pracy zarobkowej,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 563px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 563px; " class="SofLabel justified12">uzyskaniem zasiłku przedemerytalnego lub świadczenia przedemerytalnego, nauczycielskiego świadczenia kompensacyjnego, a także emerytury lub renty, renty rodzinnej lub renty socjalnej,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 591px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 591px; " class="SofLabel justified12">rozpoczęciem pozarolniczej działalności gospodarczej lub wznowieniem jej wykonywania po okresie zawieszenia w rozumieniu art. 14a ust. 1d ustawy z dnia 2 lipca 2004 r. o swobodzie działalności gospodarczej,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 620px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 620px; " class="SofLabel justified12">uzyskaniem zasiłku chorobowego, świadczenia rehabilitacyjnego lub zasiłku macierzyńskiego, przysługujących po utracie zatrudnienia lub innej pracy zarobkowej,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 647px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 647px; " class="SofLabel justified12">uzyskaniem świadczenia rodzicielskiego,</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 661px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 661px; " class="SofLabel justified12">uzyskaniem zasiłku macierzyńskiego, o którym mowa w przepisach o ubezpieczeniu społecznym rolników.</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 18px; top: 675px; " class="SofLabel justified12">-</div>
          <div style="position: absolute; color: #000000; width: 850px; font-size: 12px; left: 28px; top: 675px; " class="SofLabel justified12">uzyskanie stypendium doktoranckiego określonego w art. 200 ust. 1 ustawy z dnia 27 lipca 2005 r. - Prawo o szkolnictwie wyższym (Dz. U. z 2012 r. poz. 572, z późn. zm.).</div>
		  <div style="position: absolute; height: 102px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 13px; font-weight: bold; top: 710px; " class="SofLabel justified14Bold">Przepisów o utracie i uzyskaniu dochodu nie stosuje się do dochodu z tytułu zatrudnienia lub innej pracy zarobkowej i dochodu z tytułu wyrejestrowania lub rozpoczęcia pozarolniczej działalności gospodarczej, jeżeli członek rodziny lub dziecko pozostające pod opieką opiekuna prawnego utracili dochód z tych tytułów i w okresie 3 miesięcy licząc od dnia utraty dochodu uzyskali dochód u tego samego pracodawcy lub zleceniodawcy lub zamawiającego dzieło lub ponownie rozpoczęli pozarolniczą działalność gospodarczą.</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 807px; " class="SofLabel global14Bold">CZĘŚĆ II POUCZENIA I OŚWIADCZENIA</div>
          <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 827px; " class="SofLabel justified14Bold">1. POUCZENIE</div>
          <div style="position: absolute; height: 427px; width: 880px; background-color: #ffffff; left: 0px; top: 851px; " class="SofBorderContainer">
            <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 0px; " class="SofLabel justified14">1.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 0px; " class="SofLabel justified14">Na podstawie art. 4 ust. 2 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci (Dz. U. poz. 195 z późn. zm.) świadczenie wychowawcze przysługuje: matce, ojcu, opiekunowi faktycznemu dziecka (opiekun faktyczny dziecka to osoba faktycznie opiekującą się dzieckiem, jeżeli wystąpiła z wnioskiem do sądu opiekuńczego o przysposobienie dziecka) albo opiekunowi prawnemu dziecka.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 71px; " class="SofLabel justified14">2.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 30px; top: 71px; " class="SofLabel justified14">Świadczenie wychowawcze przysługuje:</div>
            <div style="position: absolute; height: 27px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 30px; top: 90px; " class="SofLabel justified14">1)</div>
            <div style="position: absolute; height: 27px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 55px; top: 90px; " class="SofLabel justified14">obywatelom polskim,</div>
            <div style="position: absolute; height: 29px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 30px; top: 107px; " class="SofLabel justified14">2)</div>
            <div style="position: absolute; height: 29px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 55px; top: 107px; " class="SofLabel justified14">cudzoziemcom:</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 55px; top: 125px; " class="SofLabel justified14">a)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 75px; top: 125px; " class="SofLabel justified14">do których stosuje się przepisy o koordynacji systemów zabezpieczenia społecznego,</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 55px; top: 144px; " class="SofLabel justified14">b)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 75px; top: 144px; " class="SofLabel justified14">jeżeli wynika to z wiążących Rzeczpospolitą Polską dwustronnych umów międzynarodowych o zabezpieczeniu społecznym,</div>
            <div style="position: absolute; height: 22px; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 55px; top: 163px; " class="SofLabel justified14">c)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 75px; top: 163px; " class="SofLabel justified14">przebywającym na terytorium Rzeczypospolitej Polskiej na podstawie zezwolenia na pobyt czasowy udzielonego w związku z okolicznościami, o których mowa w art. 127 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach (Dz. U. poz. 1650, z późn. zm.), jeżeli zamieszkują z członkami rodzin na terytorium Rzeczypospolitej Polskiej,</div>
            <div style="position: absolute; height: 24px; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 55px; top: 214px; " class="SofLabel justified14">d)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 800px; font-size: 14px; left: 75px; top: 214px; " class="SofLabel justified14">posiadającym kartę pobytu z adnotacją „dostęp do rynku pracy”, jeżeli zamieszkują z członkami rodzin na terytorium Rzeczypospolitej Polskiej, z wyłączeniem obywateli państw trzecich, którzy uzyskali zezwolenie na pracę na terytorium państwa członkowskiego na okres nieprzekraczający sześciu miesięcy, obywateli państw trzecich przyjętych w celu podjęcia studiów oraz obywateli państw trzecich, którzy mają prawo do wykonywania pracy na podstawie wizy.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 285px; " class="SofLabel justified14">Prawo do świadczenia wychowawczego przysługuje ww. osobom, jeżeli zamieszkują na terytorium Rzeczypospolitej Polskiej przez okres, w którym mają otrzymywać świadczenie wychowawcze, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej.</div>
          </div>

        </div>
        <div style="position: relative; margin-right: auto; height: 1070px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-inside: avoid;">

          <div style="position: absolute; height: 387px; width: 880px; background-color: #ffffff; left: 0px; top: 7px; " class="SofBorderContainer">
		  
			<div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 0px; " class="SofLabel justified14">3.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 0px; " class="SofLabel justified14">Świadczenie wychowawcze przysługuje do dnia ukończenia przez dziecko 18. roku życia (art. 4 ust. 3 ustawy).</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 20px; " class="SofLabel justified14">4.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 20px; " class="SofLabel justified14">Świadczenia wychowawcze na pierwsze dziecko przysługuje, jeżeli dochód rodziny w przeliczeniu na osobę w rodzinie nie przekracza 800 zł lub 1200 zł, jeśli członkiem rodziny jest niepełnosprawne dziecko (art. 5 ust. 3 i ust. 4 ustawy).</div>
		  
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 53px; " class="SofLabel justified14">5.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 53px; " class="SofLabel justified14">Pierwszym dzieckiem jest jedyne lub najstarsze dziecko w rodzinie w wieku do ukończenia 18. roku życia; w przypadku dzieci urodzonych tego samego dnia, miesiąca i roku, będących najstarszymi dziećmi w rodzinie w wieku do ukończenia 18. roku życia, pierwsze dziecko oznacza jedno z tych dzieci wskazane przez wnioskodawcę (art. 2 pkt 14 ustawy).</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 107px; " class="SofLabel justified14">6.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 107px; " class="SofLabel justified14">Niepełnosprawne dziecko oznacza dziecko legitymujące się orzeczeniem o niepełnosprawności określonym w przepisach o rehabilitacji zawodowej i społecznej oraz zatrudnianiu osób niepełnosprawnych albo orzeczeniem o umiarkowanym lub znacznym stopniu niepełnosprawności (art. 2 pkt 9 ustawy).</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 10px; top: 162px; " class="SofLabel justified14">7.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 845px; font-size: 14px; left: 30px; top: 162px; " class="SofLabel justified14">Świadczenie wychowawcze przysługuje w wysokości 500 zł miesięcznie na dziecko (art. 5 ust. 1 ustawy).</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 10px; top: 182px; " class="SofLabel justified14">8.</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 30px; top: 182px; " class="SofLabel justified14">Świadczenie wychowawcze nie przysługuje, jeżeli:</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 30px; top: 203px; " class="SofLabel justified14">1)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 203px; " class="SofLabel justified14">dziecko pozostaje w związku małżeńskim (art. 8 ust. 1 pkt 1 ustawy);</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 30px; top: 225px; " class="SofLabel justified14">2)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 225px; " class="SofLabel justified14">dziecko zostało umieszczone w instytucji zapewniającej całodobowe utrzymanie, tj. domu pomocy społecznej, schronisku dla nieletnich, młodzieżowym ośrodku wychowawczym, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, a także szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatnie pełne utrzymanie, albo w pieczy zastępczej (art. 8 ust. 1 pkt 2 ustawy);</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 30px; top: 297px; " class="SofLabel justified14">3)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 297px; " class="SofLabel justified14">pełnoletnie dziecko ma ustalone prawo do świadczenia wychowawczego na własne dziecko (art. 8 ust. 1 pkt 3 ustawy);</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 20px; font-size: 14px; left: 30px; top: 319px; " class="SofLabel justified14">4)</div>
            <div style="position: absolute; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 319px; " class="SofLabel justified14">członkowi rodziny, przysługuje za granicą świadczenie wychowawcze lub świadczenie o charakterze podobnym do świadczenia wychowawczego, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej (art. 8 ust. 1 pkt 4 ustawy);</div>
			 <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 379px; " class="SofLabel justified14">Świadczenie wychowawcze na dane dziecko nie przysługuje, jeżeli osobie samotnie wychowującej dziecko nie zostało ustalone, na rzecz tego dziecka od jego rodzica, świadczenie alimentacyjne na podstawie tytułu wykonawczego pochodzącego lub zatwierdzonego przez sąd, chyba że:</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 434px; " class="SofLabel justified14">1)</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 434px; " class="SofLabel justified14">drugi z rodziców dziecka nie żyje;</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 455px; " class="SofLabel justified14">2)</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 455px; " class="SofLabel justified14">ojciec dziecka jest nieznany;</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 477px; " class="SofLabel justified14">3)</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 477px; " class="SofLabel justified14">powództwo o ustalenie świadczenia alimentacyjnego od drugiego z rodziców zostało oddalone;</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 497px; " class="SofLabel justified14">4)</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 497px; " class="SofLabel justified14">sąd zobowiązał jednego z rodziców do ponoszenia całkowitych kosztów utrzymania dziecka i nie zobowiązał drugiego z rodziców do świadczenia alimentacyjnego na rzecz tego dziecka;</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 30px; top: 533px; " class="SofLabel justified14">5)</div>
            <div style="position: absolute; height: 55px; text-align: justify; color: #000000; width: 820px; font-size: 14px; left: 55px; top: 533px; " class="SofLabel justified14">dziecko, zgodnie z orzeczeniem sądu, jest pod opieką naprzemienną obojga rodziców sprawowaną w porównywalnych i powtarzających się okresach (art. 8 ust. 2 ustawy).</div>
          </div>
          <div style="position: absolute; height: 466px; width: 880px; background-color: #ffffff; left: 0px; top: 590px; " class="SofBorderContainer">
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 0px; " class="SofLabel global14Bold">2. Oświadczenia dotyczące ustalenia prawa do świadczenia wychowawczego na dziecko</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 30px; " class="SofLabel global14Normal">Oświadczam, że:</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 50px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 50px; " class="SofLabel global14Normal">powyższe dane są prawdziwe,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 70px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; color: #000000; width: 850px; font-size: 14px; left: 26px; font-family: arial; font-weight: normal; top: 70px; " class="SofLabel global14Normal">zapoznałam/zapoznałem się z warunkami uprawniającymi do świadczenia wychowawczego,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 90px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 90px; " class="SofLabel justified14">na dziecko/dzieci, na które ubiegam się o świadczenie&#xa0;&#xa0;wychowawcze, nie jest pobierane w tej lub innej&#xa0;instytucji świadczenie wychowawcze,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 125px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 125px; " class="SofLabel justified14">pełnoletnie dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze, nie jest/nie są uprawnione do świadczenia wychowawczego na własne dziecko,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 162px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 68px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 162px; " class="SofLabel justified14">dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze nie pozostaje/nie pozostają w związku małżeńskim ani nie zostało/nie zostały umieszczone w pieczy zastępczej, instytucji zapewniającej całodobowe utrzymanie, tj. domu pomocy społecznej, młodzieżowym ośrodku wychowawczym, schronisku dla nieletnich, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, a także szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatne pełne utrzymanie,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 233px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 65px; text-align: justify; color: #000000; width: 850px; font-size: 14px; left: 26px; top: 233px; " class="SofLabel justified14">członkowi rodziny nie przysługuje na dziecko świadczenie wychowawcze lub świadczenie o charakterze podobnym do świadczenia wychowawczego za granicą lub przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią, że przysługujące za granicą świadczenie nie wyłącza prawa do takiego świadczenia na podstawie ustawy,</div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 309px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 303px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:NiePrzebywamNiePrzebywa='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 348px; " class="SofLabel global14Normal">—</div>
            <div style="position: absolute; height: 37px; text-align: justify; color: #000000; width: 805px; font-size: 14px; left: 71px; top: 303px; " class="SofLabel justified14">nie przebywam ani członek mojej rodziny nie przebywa poza granicami Rzeczypospolitej Polskiej(1) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(2),</div>
            <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 25px; font-size: 14px; background-color: white; display: block; left: 37px; border: 1px solid black; top: 342px; " class="SofCheckBox">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:PrzebywamPrzebywa='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="position: absolute; height: 35px; text-align: justify; color: #000000; width: 805px; font-size: 14px; left: 71px; top: 342px; " class="SofLabel justified14">przebywam lub członek mojej rodziny przebywa poza granicami Rzeczypospolitej Polskiej(1) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego(2).</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 71px; top: 377px; " class="SofLabel">(w przypadku zaznaczenia wypełnij sekcję DANE CZŁONKÓW TWOJEJ RODZINY PRZEBYWAJĄCYCH ZA GRANICĄ):</div>
            <div style="position: absolute; color: #000000; width: 865px; font-size: 12px; left: 13px; top: 399px; " class="SofLabel left">(1) Nie dotyczy wyjazdu lub pobytu turystycznego, leczniczego lub związanego z podjęciem przez dziecko kształcenia poza granicami Rzeczypospolitej Polskiej.</div>
            <div style="position: absolute; height: 44px; text-align: justify; color: #000000; width: 865px; font-size: 12px; left: 13px; top: 415px; " class="SofLabel justified">(2) Przepisy o koordynacji systemów zabezpieczenia społecznego mają zastosowanie na terenie: Austrii, Belgii, Chorwacji, Danii, Finlandii, Francji, Grecji, Hiszpanii, Holandii, Irlandii, Luksemburga, Niemiec, Portugalii, Szwecji, Włoch, Wielkiej Brytanii, Cypru, Czech, Estonii, Litwy, Łotwy, Malty, Polski, Słowacji, Słowenii, Węgier, Bułgarii, Rumunii, Norwegii, Islandii, Liechtensteinu, Szwajcarii.</div>
          </div>
          

        </div>
        <div style="position: relative; margin-right: auto; height: 1047px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; page-break-inside: avoid;">

		  <div style="position: absolute; height: 240px; width: 880px; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 1px; top: 10px; " class="SofBorderContainer lightGrayAll">
            <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 7px; " class="SofLabel sectionHeader">DANE CZŁONKÓW TWOJEJ RODZINY PRZEBYWAJĄCYCH ZA GRANICĄ</div>
            <div style="position: absolute; color: #000000; font-size: 12px; left: 13px; top: 24px; " class="SofLabel">Podaj: imię, nazwisko, numer PESEL, kraj przebywania członka/członków rodziny za granicą wraz z adresem zamieszkania poza granicami RP, nazwę i adres pracodawcy lub miejsce &#xa0;prowadzenia działalności gospodarczej poza granicami RP:</div>
            <div style="position: absolute; height: 169px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 61px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonkowieRodzinyPrzebywajacyZaGranica/wnio:ImieNazwisko" />
                  <xsl:with-param name="wysokosc" select="193" />
                  <xsl:with-param name="szerokosc" select="840" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonkowieRodzinyPrzebywajacyZaGranica/wnio:ImieNazwisko" />
                </xsl:call-template>
              </div>
            </div>
          </div>
		
          <div style="position: absolute; height: 86px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 280px; " class="SofLabel justified14Bold">W przypadku zmian mających wpływ na prawo do świadczenia wychowawczego, w szczególności zaistnienia okoliczności dotyczących uzyskania dochodu lub wystąpienia innych okoliczności mających wpływ na prawo do świadczenia wychowawczego, w tym związanych z koniecznością ponownego ustalenia prawa do tego świadczenia na podstawie art. 7 ust. 1-4 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci, osoba ubiegająca się jest obowiązana niezwłocznie powiadomić o tych zmianach gminny organ właściwy realizujący świadczenie wychowawcze.</div>
          <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 369px; " class="SofLabel justified14Bold">Niepoinformowanie gminnego organu właściwego prowadzącego postępowanie w sprawie świadczenia wychowawczego o zmianach o których mowa powyżej, może skutkować powstaniem nienależnie pobranego świadczenia wychowawczego, a w konsekwencji - koniecznością jego zwrotu wraz z odsetkami ustawowymi za opóźnienie.</div>
          <div style="position: absolute; height: 34px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 426px; " class="SofLabel justified14Bold">Obowiązek informowania o zmianach w sytuacji dochodowej rodziny, w szczególności uzyskania dochodu, dotyczy wyłącznie osób ubiegających się/otrzymujących świadczenie wychowawcze na pierwsze dziecko.</div>
          <div style="position: absolute; height: 37px; text-align: justify; color: #000000; width: 864px; font-size: 14px; left: 6px; font-weight: bold; top: 476px; " class="SofLabel justified14Bold">Proszę o wpłatę świadczenia wychowawczego na następujący nr rachunku bankowego / w spółdzielczej kasie oszczędnościowo-kredytowej:</div>
          <div style="position: absolute; color: #000000; width: 833px; font-size: 12px; left: 13px; top: 549px; " class="SofLabel left"></div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 625px; font-size: 18px; background-color: white; display: block; left: 13px; border: 1px solid black; top: 512px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:NrRachunkuBankowego" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="625" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 18px; color: #000000; width: 864px; font-size: 14px; left: 3px; font-family: arial; font-weight: normal; top: 611px; " class="SofLabel global14Normal">Do wniosku dołączam następujące dokumenty (oświadczenia są także dokumentami):</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 3px; font-family: arial; font-weight: normal; top: 647px; " class="SofLabel global14Normal">1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 641px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 683px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 677px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 719px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 713px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 755px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 840px; font-size: 18px; background-color: white; display: block; left: 30px; border: 1px solid black; top: 749px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-style: italic; font-size: 14px; left: 30px; font-family: arial; font-weight: normal; top: 844px; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="position: absolute; height: 52px; width: 869px; left: 5px; top: 944px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 174px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 469px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 455px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="position: absolute; height: 18px; text-align: center; color: #000000; width: 202px; font-size: 14px; left: 668px; font-family: verdana; font-weight: normal; top: 22px; " class="SofLabel paragraph14Normal"></div>
              <div style="position: absolute; height: 59px; text-align: center; color: #000000; width: 182px; font-size: 12px; left: 679px; top: 41px; " class="SofLabel"></div>
            </div>
          </div>
		  
        </div>	
  </xsl:template>		

  <xsl:template name="Zalacznik1SW">
		
		<!-- Załącznik nr 1 -  statyczna formularza -->
         <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="top: 282px; left: 0px; width: 880px; position: absolute; height: 188px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 155px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
						</xsl:call-template>
					</span>				  
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 4px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 479px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE CZŁONKA RODZINY, KTÓREGO DOTYCZY OŚWIADCZENIE </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 361px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 14px; " class="SofLabel"></div>
          </div>
          
          <div style="background-color: #E7E5E6; top: 831px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 47px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="background-color: #E7E5E6; top: 923px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 47px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="color: #000000; top: 717px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">Oświadczam, że Ja albo wyżej wymieniony członek rodziny w roku kalendarzowym:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 696px; left: 557px; " class="SofLabel">Rok (rrrr)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 709px; left: 557px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:Rok" />
            </span>
          </div>
          <div style="color: #000000; top: 753px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">uzyskał dochód w wysokości:</div>
          <div style="color: #000000; top: 753px; left: 407px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł&#xa0;&#xa0;z tytułu:</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 745px; left: 205px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:WysokoscDochodu,'.',',')" />
            </span>
          </div>
        
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 803px; " class="SofLabel global14Normal">1)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 795px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod2" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 795px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu2,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 803px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 849px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 841px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod3" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 841px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu3,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 849px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 895px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 887px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod4" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 887px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu4,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 895px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 941px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 933px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod5" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 933px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu5,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 941px; " class="SofLabel global14Normal">zł,</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 14px; font-family: arial; font-weight: normal; top: 987px; " class="SofLabel global14Normal">5)</div>
          <div style="position: absolute; height: 25px; color: #000000; overflow: hidden; width: 601px; font-size: 18px; background-color: white; display: block; left: 31px; border: 1px solid black; top: 979px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:InnyDochod6" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="601" />
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 25px; text-align: right; color: #000000; overflow: hidden; width: 193px; font-size: 18px; background-color: white; display: block; left: 661px; border: 1px solid black; top: 979px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskanymDochodzie/wnio:UzyskanieDochoduZTytulu/wnio:WysokoscDochodu6,'.',',')" />
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 861px; font-family: arial; font-weight: normal; top: 987px; " class="SofLabel global14Normal">zł.</div>
          <div style="color: #000000; top: 1190px; left: 6px; width: 870px; font-size: 12px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified"></div>
		  
		  <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZSW-01</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
		  
		  <div style="position: absolute; height: 140px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 55px; " class="SofLabel formTitle">
            OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O DOCHODACH SWOICH ALBO CZŁONKA RODZINY OSIĄGNIĘTYCH W ROKU KALENDARZOWYM
            <br />
            POPRZEDZAJĄCYM OKRES NA KTÓRY USTALANE JEST PRAWO DO ŚWIADCZENIA WYCHOWAWCZEGO,
            <br />
            INNYCH NIŻ DOCHODY PODLEGAJĄCE OPODATKOWANIU PODATKIEM DOCHODOWYM
            <br />
            OD OSÓB FIZYCZNYCH NA ZASADACH OKREŚLONYCH
            <br />
            W ART. 27, ART. 30B, ART. 30C, ART. 30E I ART. 30F USTAWY Z DNIA 26 LIPCA 1991 R.
            <br />
            O PODATKU DOCHODOWYM OD OSÓB FIZYCZNYCH (DZ. U. Z 2012 R. POZ. 361, Z PÓŹN. ZM.)
          </div>
		  </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="position: absolute; height: 1133px; width: 880px; background-color: #ffffff; left: 0px; top: 20px; " class="SofBorderContainer">
            <div style="position: absolute; height: 25px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; font-weight: bold; top: 0px; " class="SofLabel justified14Bold">POUCZENIE</div>
            <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 870px; font-size: 14px; left: 6px; top: 22px; " class="SofLabel justified14">W oświadczeniu należy wpisać następujące rodzaje dochodów niepodlegających opodatkowaniu na podstawie przepisów o podatku dochodowym od osób fizycznych (art. 3 pkt 1 lit. c ustawy z dnia 28 listopada 2003 r. o świadczeniach rodzinnych (Dz. U. z 2016 r. poz. 1518, z późn. zm.)):</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 92px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 92px; " class="SofLabel justified14">renty określone w przepisach o zaopatrzeniu inwalidów wojennych i wojskowych oraz ich rodzin,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 127px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 127px; " class="SofLabel justified14">renty wypłacone osobom represjonowanym i członkom ich rodzin przyznane na zasadach określonych w przepisach o zaopatrzeniu inwalidów wojennych i wojskowych oraz ich rodzin,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 178px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 52px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 178px; " class="SofLabel justified14">świadczenia pieniężne oraz ryczałt energetyczny określone w przepisach o świadczeniu pieniężnym i uprawnieniach przysługujących żołnierzom zastępczej służby wojskowej przymusowo zatrudnianym w kopalniach węgla, kamieniołomach, zakładach rud uranu i batalionach budowlanych,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 245px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 245px; " class="SofLabel justified14">dodatek kombatancki, ryczałt energetyczny i dodatek kompensacyjny określone w przepisach o kombatantach oraz niektórych osobach będących ofiarami represji wojennych i okresu powojennego,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 296px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 296px; " class="SofLabel justified14">świadczenie pieniężne określone w przepisach o świadczeniu pieniężnym przysługującym osobom deportowanym do pracy przymusowej oraz osadzonym w obozach pracy przez III Rzeszę Niemiecką lub Związek Socjalistycznych Republik Radzieckich,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 347px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 347px; " class="SofLabel justified14">emerytury i renty otrzymywane przez osoby, które utraciły wzrok w wyniku działań w latach 1939-1945 lub eksplozji pozostałych po tej wojnie niewypałów i niewybuchów,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 398px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 62px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 398px; " class="SofLabel justified14">			renty inwalidzkie z tytułu inwalidztwa wojennego, kwoty zaopatrzenia otrzymywane przez ofiary wojny oraz członków ich rodzin, renty wypadkowe osób, których inwalidztwo powstało w związku z przymusowym pobytem na robotach w III Rzeszy Niemieckiej w latach 1939-1945, otrzymywane z zagranicy,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 465px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 465px; " class="SofLabel justified14">zasiłki chorobowe określone w przepisach o ubezpieczeniu społecznym rolników oraz w przepisach o systemie ubezpieczeń społecznych,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 500px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 91px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 500px; " class="SofLabel justified14">środki bezzwrotnej pomocy zagranicznej otrzymywane od rządów państw obcych, organizacji międzynarodowych lub międzynarodowych instytucji finansowych pochodzące ze środków bezzwrotnej pomocy przyznanych na podstawie jednostronnej deklaracji lub umów zawartych z tymi państwami, organizacjami lub instytucjami przez Radę Ministrów, właściwego ministra lub agencje rządowe, w tym również w przypadkach, gdy przekazanie tych środków jest dokonywane za pośrednictwem podmiotu upoważnionego do rozdzielania środków bezzwrotnej pomocy zagranicznej na rzecz podmiotów, którym ma służyć ta pomoc,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 599px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 75px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 599px; " class="SofLabel justified14">należności ze stosunku pracy lub z tytułu stypendium osób fizycznych mających miejsce zamieszkania na terytorium Rzeczypospolitej Polskiej, przebywających czasowo za granicą - w wysokości odpowiadającej równowartości diet z tytułu podróży służbowej poza granicami kraju ustalonych dla pracowników zatrudnionych w państwowych lub samorządowych jednostkach sfery budżetowej na podstawie ustawy z dnia 26 czerwca 1974 r. – Kodeks pracy (Dz. U. z 2014 r. poz. 1502, z późn. zm.),</div>
            <div style="position: absolute; height: 75px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 682px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 75px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 682px; " class="SofLabel justified14">należności pieniężne wypłacone policjantom, żołnierzom, celnikom i pracownikom jednostek wojskowych i jednostek policyjnych użytych poza granicami państwa w celu udziału w konflikcie zbrojnym lub wzmocnienia sił państwa albo państw sojuszniczych, misji pokojowej, akcji zapobieżenia aktom terroryzmu lub ich skutkom, a także należności pieniężne wypłacone żołnierzom, policjantom, celnikom i pracownikom pełniącym funkcje obserwatorów w misjach pokojowych organizacji międzynarodowych i sił wielonarodowych,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 765px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 765px; " class="SofLabel justified14">należności pieniężne ze stosunku służbowego otrzymywane w czasie służby kandydackiej przez funkcjonariuszy Policji, Państwowej Straży Pożarnej, Straży Granicznej, Biura Ochrony Rządu, obliczone za okres, w którym osoby te uzyskały dochód,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 816px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 816px; " class="SofLabel justified14">dochody członków rolniczych spółdzielni produkcyjnych z tytułu członkostwa w rolniczej spółdzielni produkcyjnej, pomniejszone o składki na ubezpieczenia społeczne,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 862px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 862px; " class="SofLabel justified14">alimenty na rzecz dzieci,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 892px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 104px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 892px; " class="SofLabel justified14">stypendia doktoranckie i habilitacyjne przyznane na podstawie ustawy z dnia 14 marca 2003 r. o stopniach naukowych i tytule naukowym oraz o stopniach i tytule w zakresie sztuki (Dz. U. z 2014 r. poz. 1852 oraz z 2015 r. poz. 249), stypendia doktoranckie określone w art. 200 ustawy z dnia 27 lipca 2005 r. – Prawo o szkolnictwie wyższym (Dz. U. z 2012 r. poz. 572, z późn. zm.), stypendia sportowe przyznane na podstawie ustawy z dnia 25 czerwca 2010 r. o sporcie (Dz. U. z 2014 r. poz. 715, z późn. zm.) oraz inne stypendia o charakterze socjalnym przyznane uczniom lub studentom,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 991px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 991px; " class="SofLabel justified14">kwoty diet nieopodatkowane podatkiem dochodowym od osób fizycznych, otrzymywane przez osoby wykonujące czynności związane z pełnieniem obowiązków społecznych i obywatelskich,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 1042px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 1042px; " class="SofLabel justified14">należności pieniężne otrzymywane z tytułu wynajmu pokoi gościnnych w budynkach mieszkalnych położonych na terenach wiejskich w gospodarstwie rolnym osobom przebywającym na wypoczynku oraz uzyskane z tytułu wyżywienia tych osób,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 1093px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 1093px; " class="SofLabel justified14">dodatki za tajne nauczanie określone w ustawie z dnia 26 stycznia 1982 r. – Karta Nauczyciela (Dz. U. z 2014 r. poz. 191, z późn. zm.),</div>
          </div>         
        </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="position: absolute; height: 1133px; width: 880px; background-color: #ffffff; left: 0px; top: 20px; " class="SofBorderContainer">
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 0px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 0px; " class="SofLabel justified14">dochody uzyskane z działalności gospodarczej prowadzonej na podstawie zezwolenia na terenie specjalnej strefy ekonomicznej określonej w przepisach o specjalnych strefach ekonomicznych,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 51px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 51px; " class="SofLabel justified14">ekwiwalenty pieniężne za deputaty węglowe określone w przepisach o komercjalizacji, restrukturyzacji i prywatyzacji przedsiębiorstwa państwowego „Polskie Koleje Państwowe”,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 102px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 102px; " class="SofLabel justified14">ekwiwalenty z tytułu prawa do bezpłatnego węgla określone w przepisach o restrukturyzacji górnictwa węgla kamiennego w latach 2003-2006,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 153px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 153px; " class="SofLabel justified14">świadczenia określone w przepisach o wykonywaniu mandatu posła i senatora,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 188px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 188px; " class="SofLabel justified14">dochody uzyskiwane za granicą Rzeczypospolitej Polskiej, pomniejszone odpowiednio o zapłacone za granicą Rzeczypospolitej Polskiej: podatek dochodowy oraz składki na obowiązkowe ubezpieczenia społeczne i obowiązkowe ubezpieczenie zdrowotne,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 239px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 54px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 239px; " class="SofLabel justified14">renty określone w przepisach o wspieraniu rozwoju obszarów wiejskich ze środków pochodzących z Sekcji Gwarancji Europejskiego Funduszu Orientacji i Gwarancji Rolnej oraz w przepisach o wspieraniu rozwoju obszarów wiejskich z udziałem środków Europejskiego Funduszu Rolnego na rzecz Rozwoju Obszarów Wiejskich,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 306px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 306px; " class="SofLabel justified14">zaliczkę alimentacyjną określoną w przepisach o postępowaniu wobec dłużników alimentacyjnych oraz zaliczce alimentacyjnej,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 341px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 341px; " class="SofLabel justified14">świadczenia pieniężne wypłacane w przypadku bezskuteczności egzekucji alimentów,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 376px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 51px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 376px; " class="SofLabel justified14">pomoc materialną o charakterze socjalnym określoną w art. 90c ust. 2 ustawy z dnia 7 września 1991 r. o systemie oświaty (Dz. U. z 2004 r. Nr 256, poz. 2572, z późn. zm.) oraz pomoc materialną określoną w art. 173 ust. 1 pkt 1, 2 i 8, art. 173a, art. 199 ust. 1 pkt 1, 2 i 4 i art. 199a ustawy z dnia 27 lipca 2005 r. - Prawo o szkolnictwie wyższym,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 443px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 443px; " class="SofLabel justified14">świadczenie pieniężne i pomoc pieniężną określone w ustawie z dnia 20 marca 2015 r. o działaczach opozycji antykomunistycznej oraz osobach represjonowanych z powodów politycznych (Dz. U. poz. 693, z późn. zm.),</div>
			<div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 494px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 494px; " class="SofLabel justified14">świadczenie rodzicielskie,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 529px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 529px; " class="SofLabel justified14">zasiłek macierzyński, o którym mowa w przepisach o ubezpieczeniu społecznym rolników,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 6px; top: 564px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 15px; top: 564px; " class="SofLabel justified14">stypendia dla bezrobotnych finansowane ze środków Unii Europejskiej.</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 6px; top: 599px; " class="SofLabel justified14">Stypendia, o których mowa w pouczeniu, które powinny być wykazane jako dochód niepodlegający opodatkowaniu, to m.in.:</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 10px; top: 635px; " class="SofLabel justified14">1)</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 840px; font-size: 14px; left: 35px; top: 635px; " class="SofLabel justified14">stypendia doktoranckie i habilitacyjne przyznane na podstawie ustawy z dnia 14 marca 2003 r. o stopniach naukowych i tytule naukowym oraz o stopniach i tytule w zakresie sztuki;</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 10px; top: 675px; " class="SofLabel justified14">2)</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 840px; font-size: 14px; left: 35px; top: 675px; " class="SofLabel justified14">przyznane na podstawie ustawy z dnia 27 lipca 2005 r. - Prawo o szkolnictwie wyższym,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 35px; top: 703px; " class="SofLabel justified14">a)</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 55px; top: 703px; " class="SofLabel justified14">stypendia doktoranckie, określone w art. 200 ww. ustawy,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 35px; top: 725px; " class="SofLabel justified14">b)</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 860px; font-size: 14px; left: 55px; top: 725px; " class="SofLabel justified14">stypendia o charakterze socjalnym i zapomogi, takie jak:</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 55px; top: 747px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 805px; font-size: 14px; left: 70px; top: 747px; " class="SofLabel justified14">stypendia dotyczące studentów, określone w art. 173 ust. 1 pkt 1, 2 i 8 ww. ustawy,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 55px; top: 769px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 805px; font-size: 14px; left: 70px; top: 769px; " class="SofLabel justified14">stypendia dotyczące doktorantów, określone w art. 199 ust. 1 pkt 1, 2 i 4 ww. ustawy,</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 55px; top: 790px; " class="SofLabel justified14">-</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 805px; font-size: 14px; left: 70px; top: 790px; " class="SofLabel justified14">pomoc materialna dla doktorantów przyznawana zgodnie z art. 199a ww. ustawy przez jednostki samorządu terytorialnego na zasadach określonych w art. 173a ww. ustawy;</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 10px; top: 830px; " class="SofLabel justified14">3)</div>
            <div style="position: absolute; height: 40px; text-align: justify; color: #000000; width: 840px; font-size: 14px; left: 35px; top: 830px; " class="SofLabel justified14">stypendia sportowe przyznane na podstawie ustawy z dnia 25 czerwca 2010 r. o sporcie;</div>
            <div style="position: absolute; height: 20px; text-align: justify; color: #000000; width: 40px; font-size: 14px; left: 10px; top: 860px; " class="SofLabel justified14">4)</div>
            <div style="position: absolute; height: 41px; text-align: justify; color: #000000; width: 840px; font-size: 14px; left: 35px; top: 860px; " class="SofLabel justified14">stypendium szkolne oraz zasiłek szkolny, tj. stypendia materialne o charakterze socjalnym, wynikające z ustawy z dnia 7 września 1991 r. o systemie oświaty.</div>
          </div>
          <div style="color: #000000; top: 995px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 1100px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:Miejscowosc" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="457" />
					</xsl:call-template>
				</span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
        </div>
		
  </xsl:template>		

  
  <xsl:template name="Zalacznik2SW">
		
		<!-- Załącznik nr 2 -  statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="top: 242px; left: 0px; width: 880px; position: absolute; height: 188px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 155px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
						</xsl:call-template>
					</span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 4px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 439px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE CZŁONKA RODZINY, KTÓREGO DOTYCZY OŚWIADCZENIE</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 361px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 14px; " class="SofLabel"></div>
          </div>
          <div style="background-color: #E7E5E6; top: 786px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 47px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="background-color: #E7E5E6; top: 878px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 47px; " class="SofBorderContainer lightGrayAll">
            <span />
          </div>
          <div style="color: #000000; top: 654px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">Oświadczam, że Ja albo wyżej wymieniony członek rodziny w roku kalendarzowym:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 633px; left: 557px; " class="SofLabel">Rok (rrrr)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 646px; left: 557px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="wnio:OswiadczenieOUzyskaniuDochodu/wnio:Rok" />
            </span>
          </div>
          <div style="color: #000000; top: 654px; left: 664px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">uzyskał dochód z działalności</div>
          <div style="color: #000000; top: 675px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">opodatkowanej w formie:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 675px; left: 191px; " class="SofLabel"></div>
          <div style="color: #000000; top: 712px; left: 71px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">ryczałtu ewidencjonowanego,</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 704px; left: 37px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
            <xsl:if test="wnio:OswiadczenieOUzyskaniuDochodu/wnio:FormaOpodatkowania/wnio:RyczaltEwidencjonowany='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="color: #000000; top: 748px; left: 71px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">karty podatkowej.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 740px; left: 37px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox">
            <xsl:if test="wnio:OswiadczenieOUzyskaniuDochodu/wnio:FormaOpodatkowania/wnio:KartaPodatkowa='true'">
              <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
            </xsl:if>
          </div>
          <div style="color: #000000; top: 804px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">1. Dochód po odliczeniu kwot z pozycji 2-4 wyniósł:</div>
          <div style="color: #000000; top: 804px; left: 599px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 796px; left: 397px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscDochodu,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 850px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">2. Należne składki na ubezpieczenia społeczne wyniosły:</div>
          <div style="color: #000000; top: 850px; left: 599px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 842px; left: 397px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscSkladekNaUbezpieczenieSpoleczne,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 896px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">3. Należne składki na ubezpieczenie zdrowotne wyniosły:</div>
          <div style="color: #000000; top: 896px; left: 599px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 888px; left: 397px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscSkladkiNaUbezpieczenieZdrowotne,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 942px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">4. Należny zryczałtowany podatek dochodowy wyniósł:</div>
          <div style="color: #000000; top: 942px; left: 599px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 934px; left: 397px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieOUzyskaniuDochodu/wnio:WysokoscZryczaltowanegoPodatkuDochodowego,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 1030px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 1093px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:Miejscowosc" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="457" />
					</xsl:call-template>
				</span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
          <div style="color: #000000; top: 1190px; left: 6px; width: 870px; font-size: 12px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified"></div>
		  
		  <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZSW-02</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
		  
         <div style="position: absolute; height: 140px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 45px; " class="SofLabel formTitle">
			OŚWIADCZENIE WNIOSKODAWCY O DOCHODZIE SWOIM ALBO
            <br />
            CZŁONKA RODZINY ROZLICZAJĄCEGO SIĘ NA PODSTAWIE PRZEPISÓW
            <br />
            O ZRYCZAŁTOWANYM PODATKU DOCHODOWYM OD NIEKTÓRYCH PRZYCHODÓW OSIĄGNIĘTYCH
            <br />
            PRZEZ OSOBY FIZYCZNE OSIĄGNIĘTYM W ROKU KALENDARZOWYM
            <br />
            POPRZEDZAJĄCYM OKRES, NA KTÓRY USTALANE JEST PRAWO
            <br />
            DO ŚWIADCZENIA WYCHOWAWCZEGO
          </div>
		  </div>
		
  </xsl:template>		
  

  <xsl:template name="Zalacznik3SW">
		
		<!-- Załącznik nr 3 -  statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="top: 242px; left: 0px; width: 880px; position: absolute; height: 188px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 155px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
						</xsl:call-template>
					</span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 4px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 439px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE CZŁONKA RODZINY, KTÓREGO DOTYCZY OŚWIADCZENIE</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 361px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 14px; " class="SofLabel"></div>
          </div>
          <div style="color: #000000; top: 654px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 633px; left: 301px; " class="SofLabel">Rok (rrrr)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 646px; left: 301px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="wnio:OswiadczeniePowierzchniaGospodarstwa/wnio:Rok" />
            </span>
          </div>
          <div style="color: #000000; top: 654px; left: 408px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">powierzchnia mojego gospodarstwa rolnego albo gospodarstwa wyżej</div>
          <div style="color: #000000; top: 690px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">wymienionego członka rodziny w ha przeliczeniowych ogólnej powierzchni wynosiła:</div>
          <div style="color: #000000; top: 690px; left: 742px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 682px; left: 543px; display: block; width: 192px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="translate(wnio:OswiadczeniePowierzchniaGospodarstwa/wnio:PowierzchniaGospodarstwaRolnego,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 777px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 877px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:Miejscowosc" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
          <div style="color: #000000; top: 1190px; left: 6px; width: 870px; font-size: 12px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified"></div>
		  
		  <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZSW-03</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
		  
          <div style="position: absolute; height: 125px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 40px; " class="SofLabel formTitle">		
			OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O WIELKOŚCI JEGO GOSPODARSTWA ROLNEGO ALBO GOSPODARSTWA CZŁONKA RODZINY WYRAŻONEJ
            <br />
            W HEKTARACH PRZELICZENIOWYCH OGÓLNEJ POWIERZCHNI
            <br />
            W ROKU KALENDARZOWYM POPRZEDZAJĄCYM OKRES,
            <br />
            NA KTÓRY USTALANE JEST PRAWO DO ŚWIADCZENIA WYCHOWAWCZEGO
          </div>
		  </div>
		
  </xsl:template>  

  <xsl:template name="Zalacznik4SW">
		
		<!-- Załącznik nr 4 -  statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1230px; margin-right: auto; text-align: left; page-break-after: always; page-break-inside: avoid;">
          <div style="top: 242px; left: 0px; width: 880px; position: absolute; height: 188px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 155px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:PESEL" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
						</xsl:call-template>
					</span>
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 4px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:SeriaNumerDokumentu" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="361" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Nazwisko" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
					<span style="padding-left: 5px;display: block;line-height:25px;">
						<xsl:call-template name="redukcjaCzcionki">
							<xsl:with-param name="tekst" select="wnio:DaneOsobyUbiegajacejSie/wnio:Imie" />
							<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
							<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
						</xsl:call-template>
					</span>
                </div>
              </div>
            </div>
          </div>
          <div style="background-color: #E7E5E6; top: 439px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 175px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE CZŁONKA RODZINY, KTÓREGO DOTYCZY OŚWIADCZENIE</div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Nazwisko" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:Imie" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:PESEL" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="265" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 361px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
				<span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:DaneIdentyfikacyjneCzlonkaRodziny/wnio:SeriaNumerDokumentu" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="865" />
					</xsl:call-template>
				</span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 14px; " class="SofLabel"></div>
          </div>
          <div style="color: #000000; top: 654px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">Oświadczam, że w roku kalendarzowym:</div>
          <div style="font-size: 12px; position: absolute; color: #000000; top: 633px; left: 301px; " class="SofLabel">Rok (rrrr)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 646px; left: 301px; display: block; width: 97px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
              <xsl:value-of select="wnio:OswiadczenieSkladkaNaUbezpieczenie/wnio:Rok" />
            </span>
          </div>
          <div style="color: #000000; top: 654px; left: 408px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">wysokość moich składek na ubezpieczenie zdrowotne albo składek wyżej</div>
          <div style="color: #000000; top: 690px; left: 14px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">wymienionego członka rodziny wyniosła:</div>
          <div style="color: #000000; top: 690px; left: 483px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">zł.</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 682px; left: 281px; display: block; width: 193px; font-size: 18px; position: absolute; height: 25px; text-align: right; " class="SofTextInput">
            <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display:block;">
              <xsl:value-of select="translate(wnio:OswiadczenieSkladkaNaUbezpieczenie/wnio:WysokoscSkladkiNaUbezpieczenieZdrowotne,'.',',')" />
            </span>
          </div>
          <div style="color: #000000; top: 779px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 879px; left: 8px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left: 5px;display: block;line-height:25px;">
					<xsl:call-template name="redukcjaCzcionki">
						<xsl:with-param name="tekst" select="wnio:Miejscowosc" />
						<xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
						<xsl:with-param name="dlugoscPolaWPikselach" select="457" />
					</xsl:call-template>
				</span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
          <div style="color: #000000; top: 1190px; left: 6px; width: 870px; font-size: 12px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified"></div>

		  <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZSW-04</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 8px; " class="SofLabel page"/>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 2px solid black; top: 25px; " class="SofHRule">
              <span/>
            </div>
          </div>
		  
          <div style="position: absolute; height: 100px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 55px; " class="SofLabel formTitle">
            OŚWIADCZENIE WNIOSKODAWCY
            <br />
            O WYSOKOŚCI JEGO SKŁADEK NA UBEZPIECZENIE ZDROWOTNE ALBO SKŁADEK
            <br />
            CZŁONKA RODZINY W ROKU KALENDARZOWYM POPRZEDZAJĄCYM OKRES NA JAKI USTALANE JEST
			<br />
			PRAWO DO ŚWIADCZENIA WYCHOWAWCZEGO
          </div>
		  </div>		

  </xsl:template>  
  
  <xsl:template name="notaPrawnaInnaInstytucjaSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4, składane w postaci elektronicznej za pomocą systemów, o których mowa w ust. 5 pkt 3, podpisane przy użyciu danych obejmujących imię, nazwisko oraz numer PESEL, są równoważne pod względem skutków prawnych dokumentowi opatrzonemu podpisem własnoręcznym.</div>

        </div>
		
  </xsl:template>	
  
  <xsl:template name="notaPrawnaZusSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4 składane w postaci elektronicznej za pomocą systemów teleinformatycznych, o których mowa w ust. 5 pkt 1, 2 i 4, podpisuje się przy użyciu mechanizmów określonych w art. 20a ust. 1 lub 2 ustawy z dnia 17 lutego 2005 r. o informatyzacji działalności podmiotów realizujących zadania publiczne (Dz. U. z 2014 r. poz. 1114).</div>

        </div>
		
  </xsl:template>	  
  
</xsl:stylesheet>