<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:adr="http://crd.gov.pl/xml/schematy/adres/2009/11/09/" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:inst="http://crd.gov.pl/xml/schematy/instytucja/2009/11/16/" xmlns:meta="http://crd.gov.pl/xml/schematy/meta/2009/11/16/" xmlns:oso="http://crd.gov.pl/xml/schematy/osoba/2009/11/16/" xmlns:str="http://crd.gov.pl/xml/schematy/struktura/2009/11/16/" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:wnio="http://piu.mpips.pl/rd/SW_1/4/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.1" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>SW-1 - Ministerstwo Rodziny, Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
      </head>
      <body style="text-align: center; font-family: Arial; ">

		<!-- Pierwsza część, statyczna formularza + pierwsze dziecko -->		
		<xsl:call-template name="poczatkowaStatycznaCzescSW">
		</xsl:call-template>		
		
		<!-- Sekcja dynamiczna - kolejne dzieci -->			  
		<xsl:for-each select="//wnio:TrescDokumentu/wnio:WniosekOUstalenieSwiadczeniaWychowawczego/wnio:DaneIdentyfikacyjneDzieckaDzieci">

			<xsl:if test="position() &gt; 0">
				<xsl:call-template name="dynamicznaSekcjaDzieciSW">
					<xsl:with-param name="BiezaceDziecko" select="position()"/>
				</xsl:call-template>
			</xsl:if>
			
		</xsl:for-each>		
		
		<!-- Ostatnia statyczna część formularza -->
		<xsl:call-template name="ostatniaStatycznaCzescSW">
		</xsl:call-template>		
		<!-- Stopka prawna Inna Instytucja -->		
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc != 'ZUS'">
			<xsl:call-template name="notaPrawnaInnaInstytucjaSW">
			</xsl:call-template>
		</xsl:if>

		<!-- Stopka prawna - ZUS -->				
		<xsl:if test="//wnio:DaneDokumentu/str:Naglowek/meta:Identyfikator[@typIdentyfikatora = 'kodInstytucjiNadawcy']/meta:Wartosc = 'ZUS'">
			<xsl:call-template name="notaPrawnaZusSW">
			</xsl:call-template>
		</xsl:if>		  
		  
      </body>
    </html>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates/>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="."/>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="dlugoscPolaWPikselach"/>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <!-- (0.7 * wielkosc czcionki w pikselach) średnia szerokość litery (mniej więcej) -->
      <xsl:value-of select="$dlugoscPolaWPikselach div (0.7 * string-length($tekst))"/>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="ceiling($czcionkaPokrywajacaPole)"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'px')"/>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"/>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc"/>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)"/>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"/>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst"/>
    <xsl:param name="wysokosc"/>
    <xsl:param name="szerokosc"/>
    <xsl:param name="bazowyRozmiarCzcionki"/>
    <xsl:param name="wysokoscLini"/>
    <xsl:param name="liczbaPrzejscDoNowychLini"/>
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"/>
    <xsl:variable name="liczbaPodPierwiastkiem">
      <xsl:value-of select="($szerokosc * $wysokosc) div string-length($tekst)"/>
    </xsl:variable>
    <xsl:variable name="pierwiastek">
      <xsl:call-template name="sqrt">
        <xsl:with-param name="number" select="$liczbaPodPierwiastkiem"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="czcionkaPokrywajacaPole">
      <xsl:value-of select="ceiling($pierwiastek)"/>
    </xsl:variable>
    <xsl:variable name="rozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$czcionkaPokrywajacaPole &lt; $bazowyRozmiarCzcionki">
          <xsl:choose>
            <xsl:when test="$czcionkaPokrywajacaPole &lt; 6">6</xsl:when>
            <!--6 minimalny rozmiar czcionki -->
            <xsl:otherwise>
              <xsl:value-of select="$czcionkaPokrywajacaPole"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$bazowyRozmiarCzcionki"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:choose>
          <xsl:when test="($szerokosc * $wysokosc) &lt; (string-length($tekst) * $bazowyRozmiarCzcionki * $bazowyRozmiarCzcionki)">
            <xsl:value-of select="concat('font-size:', $rozmiarCzcionki, 'px; word-wrap : break-word;')"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="'word-wrap : break-word;'"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:attribute>
      <xsl:value-of select="$tekst"/>
    </div>
  </xsl:template>
  <xsl:template name="sqrt">
    <xsl:param name="number" select="0"/>
    <xsl:param name="try" select="1"/>
    <xsl:param name="iter" select="1"/>
    <xsl:param name="maxiter" select="10"/>
    <xsl:choose>
      <xsl:when test="$try * $try = $number or $iter &gt; $maxiter">
        <xsl:value-of select="$try"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="sqrt">
          <xsl:with-param name="number" select="$number"/>
          <xsl:with-param name="try" select="$try - (($try * $try - $number) div (2 * $try))"/>
          <xsl:with-param name="iter" select="$iter + 1"/>
          <xsl:with-param name="maxiter" select="$maxiter"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <!-- Część implementacyjna formularza -->
  
  <xsl:template name="poczatkowaStatycznaCzescSW">
  
		<!-- Początkowa część statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1220px; margin-right: auto; text-align: left; ">
          <div style="top: 0px; left: 0px; width: 880px; position: absolute; height: 26px; ">
            <div style="color: #000000; top: 0px; left: 322px; font-weight: bold; width: 545px; font-size: 20px; position: absolute; height: 24px; text-align: right; " class="SofLabel formName">SW-1</div>
            <span style="color: #000000; top: 8px; left: 5px; font-weight: normal; width: 300px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel page" />
            <div style="border-top: 2px solid black; top: 25px; left: 0px; width: 100%; position: absolute; height: 1px; " class="SofHRule">
              <span />
            </div>
          </div>
          <div style="color: #000000; top: 200px; left: 12px; font-weight: bold; font-size: 12px; font-family: arial; position: absolute; " class="SofLabel global12Bold">Wniosek dotyczy okresu na jaki ustala się prawo do świadczenia wychowawczego:</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 193px; left: 518px; display: block; width: 191px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OkresSwiadczeniowy" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="191" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 195px; left: 518px; font-weight: bold; font-size: 12px; font-family: arial; position: absolute; height: 19px; " class="SofLabel global12Bold"></div>
          <div style="top: 230px; left: 0px; width: 880px; position: absolute; height: 111px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 101px; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">NAZWA ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 68px; " class="SofBorderContainer">
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 7px; left: 3px; display: block; width: 840px; font-size: 18px; position: absolute; height: 54px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                      <xsl:with-param name="wysokosc" select="54" />
                      <xsl:with-param name="szerokosc" select="840" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="wysokoscLini" select="20" />
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:NazwaOrganuWlasciwegoProwadzacegoPostepowanie" />
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="top: 326px; left: 0px; width: 880px; position: absolute; height: 233px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ORGANU WŁAŚCIWEGO PROWADZĄCEGO POSTĘPOWANIE W SPRAWIE ŚWIADCZENIA WYCHOWAWCZEGO (1)</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 200px; " class="SofBorderContainer">
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 171px; " class="SofLabel">03. Miejscowość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 171px; display: block; width: 697px; font-size: 18px; position: absolute; height: 27px; text-align: left; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:27px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Miejscowosc" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">04. Ulica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">05. Numer domu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 195px; " class="SofLabel">06. Numer mieszkania</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 195px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresOrganuWlasciwego/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="color: #000000; top: 183px; left: 3px; width: 867px; font-size: 12px; position: absolute; height: 26px; " class="SofLabel">(1) Przez organ właściwy rozumie się wójta, burmistrza lub prezydenta miasta właściwego ze względu na miejsce zamieszkania osoby składającej wniosek.</div>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 570px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">CZĘŚĆ I</div>
          <div style="color: #000000; top: 590px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 18px; " class="SofLabel justified14Bold">1. Dane osoby składającej wniosek o ustalenie prawa do świadczenia wychowawczego, zwanej dalej „wnioskodawcą".</div>
          <div style="top: 610px; left: 0px; width: 880px; position: absolute; height: 307px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE WNIOSKODAWCY</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 274px; " class="SofBorderContainer">
                <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">03. Numer PESEL</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:PESEL" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 291px; " class="SofLabel">04. Data urodzenia: (dd / mm / rrrr)</div>
                <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 106px; left: 291px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
                  <span style="padding-left:5px ; line-height:25px; display: block;">
                    <xsl:call-template name="formatDaty">
                      <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:DataUrodzenia" />
                    </xsl:call-template>
                  </span>
                  <span />
                </div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 230px; left: 4px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 244px; left: 4px; " class="SofLabel"></div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 507px; " class="SofLabel">05. Seria i numer dokumentu potwierdzającego tożsamość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 507px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:SeriaNumerDokumentu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Nazwisko</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Nazwisko" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Imię</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Imie" />
                  </span>
                </div>
                <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">06. Obywatelstwo</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:Obywatelstwo" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 181px; left: 3px; " class="SofLabel">07. Stan cywilny</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 194px; left: 3px; display: block; width: 312px; font-size: 18px; border-color: #000000; position: absolute; height: 25px; " class="SofDropDownList dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjne/wnio:StanCywilny" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="top: 916px; left: 0px; width: 880px; position: absolute; height: 307px; ">
            <div style="background-color: #DCE6FA; top: 0px; left: 0px; width: 100%; border-color: #DCE6FA; border-width: 1px; position: absolute; border-style: solid; height: 100%; " class="SofBorderContainer blueAll">
              <div style="font-size: 12px; position: absolute; color: #000000; top: 8px; left: 11px; font-weight: bold; " class="SofLabel sectionHeader">ADRES ZAMIESZKANIA</div>
              <div style="background-color: #ffffff; width: 870px; position: absolute; top: 23px; left: 10px; height: 274px; " class="SofBorderContainer">
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 3px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 3px; display: block; width: 145px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 1, 2)" />
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:KodPocztowy, 3, 4)" />
                    </xsl:if>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 49px; left: 171px; " class="SofLabel">03. Miejscowość</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 62px; left: 171px; display: block; width: 697px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Miejscowosc" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="697" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 5px; left: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 18px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:GminaDzielnica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 93px; left: 3px; " class="SofLabel">04. Ulica</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 106px; left: 3px; display: block; width: 865px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:Ulica" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 3px; " class="SofLabel">05. Numer domu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 3px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerDomu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 137px; left: 195px; " class="SofLabel">06. Numer mieszkania</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 195px; display: block; width: 169px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerLokalu" />
                  </span>
                </div>
                <div style="width: 126px; font-size: 12px; position: absolute; color: #000000; top: 137px; left: 411px; " class="SofLabel">07. Numer telefonu</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 150px; left: 411px; display: block; width: 241px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:NumerTelefonu" />
                  </span>
                </div>
                <div style="font-size: 12px; position: absolute; color: #000000; top: 181px; left: 3px; " class="SofLabel">08. Adres poczty elektronicznej — e-mail</div>
                <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 194px; left: 3px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkania/wnio:AdresPocztyElektronicznej" />
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                      <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                    </xsl:call-template>
                  </span>
                </div>
                <div style="width: 790px; font-size: 12px; position: absolute; color: #000000; top: 230px; left: 4px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 244px; left: 4px; " class="SofLabel"></div>
                <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 258px; left: 22px; " class="SofLabel"></div>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 55px; left: 0px; font-weight: bold; width: 100%; font-size: 16px; position: absolute; text-align: center; height: 70px; " class="SofLabel formTitle">
            WNIOSEK
            <br />
            O &#xa0;USTALENIE &#xa0;PRAWA &#xa0;DO &#xa0;ŚWIADCZENIA &#xa0;WYCHOWAWCZEGO
          </div>
          </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 90px; margin-right: auto; text-align: left; ">
          <div style="color: #000000; top: 10px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">2. &#xa0;Ustalenie prawa do świadczenia wychowawczego na dziecko/dzieci w wieku poniżej 18. roku życia.</div>
          <div style="color: #000000; top: 30px; left: 6px; width: 872px; font-size: 14px; position: absolute; text-align: justify; height: 52px; " class="SofLabel justified14">Składam wniosek o świadczenie wychowawcze na następujące dziecko/dzieci zamieszkujące ze mną oraz pozostające na moim utrzymaniu (świadczenie wychowawcze na dziecko przysługuje do dnia ukończenia przez dziecko 18. roku życia i przysługuje niezależnie od osiągniętego dochodu):</div>
        </div>
  </xsl:template>		
    
	
  <xsl:template name="dynamicznaSekcjaDzieciSW">
		<xsl:param name="BiezaceDziecko"/>

		<!-- Strona dynamiczna formularza (dzieci) -->		
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 295px; margin-right: auto; text-align: left; page-break-inside: avoid;">
          <div style="background-color: #E7E5E6; top: 0px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 293px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE DZIECKA - <xsl:value-of select="$BiezaceDziecko"/></div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 200px; left: 13px; " class="SofLabel">Stan cywilny:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 213px; left: 13px; display: block; width: 312px; font-size: 18px; border-color: #000000; position: absolute; height: 25px; " class="SofDropDownList dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:StanCywilny" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="312" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 68px; left: 13px; " class="SofLabel">Nazwisko:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 81px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Nazwisko" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 24px; left: 13px; " class="SofLabel">Imię:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 37px; left: 13px; display: block; width: 865px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Imie" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="865" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 123px; font-size: 12px; position: absolute; color: #000000; top: 112px; left: 13px; " class="SofLabel">Numer PESEL:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 13px; display: block; width: 265px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:PESEL" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="265" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 517px; " class="SofLabel">Seria i numer dokumentu potwierdzającego tożsamość:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 125px; left: 517px; display: block; width: 361px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:SeriaNumerDokumentu" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="361" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 112px; left: 301px; " class="SofLabel">Data urodzenia: (dd / mm / rrrr)</div>
            <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 125px; left: 301px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: solid; height: 25px; " class="SofDateField">
              <span style="padding-left:5px ; line-height:25px; display: block;">
                <xsl:call-template name="formatDaty">
                  <xsl:with-param name="wartosc" select="wnio:DataUrodzenia" />
                </xsl:call-template>
              </span>
              <span />
            </div>
            <div style="width: 457px; font-size: 12px; position: absolute; color: #000000; top: 156px; left: 13px; " class="SofLabel">Obywatelstwo:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 169px; left: 14px; display: block; width: 552px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofComboBox dotted">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Obywatelstwo" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="552" />
                </xsl:call-template>
              </span>
            </div>
            <div style="font-size: 12px; position: absolute; color: #000000; top: 200px; left: 398px; " class="SofLabel">Płeć:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 213px; left: 398px; display: block; width: 48px; font-size: 18px; border-color: #696969; position: absolute; height: 25px; " class="SofDropDownList">
              <span style="padding-left: 5px;display: block;line-height:25px;">
                <xsl:call-template name="redukcjaCzcionki">
                  <xsl:with-param name="tekst" select="wnio:Plec" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="dlugoscPolaWPikselach" select="48" />
                </xsl:call-template>
              </span>
            </div>
            <div style="width: 856px; font-size: 12px; position: absolute; color: #000000; top: 247px; left: 13px; " class="SofLabel"></div>
            <div style="color: #000000; top: 261px; left: 13px; width: 856px; font-size: 12px; position: absolute; height: 40px; " class="SofLabel"></div>
          </div>
        </div>
  </xsl:template>		
    
	
  <xsl:template name="ostatniaStatycznaCzescSW">
		<!-- Końcowa część statyczna formularza -->
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; page-break-after: always; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1280px; margin-right: auto; text-align: left;  page-break-before: always;">
          <div style="color: #000000; top: 35px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">CZĘŚĆ II POUCZENIA I OŚWIADCZENIA</div>
          <div style="color: #000000; top: 55px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified14Bold">1. POUCZENIE</div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 75px; left: 0px; height: 323px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 10px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified11">1.</div>
            <div style="color: #000000; top: 0px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified11">Na podstawie art. 4 ust. 2 ustawy z dnia 11 lutego 2016 r. o pomocy państwa w wychowywaniu dzieci (Dz. U. z 2018 r., poz. 2134 z późn. zm.), świadczenie wychowawcze przysługuje:</div>
            <div style="color: #000000; top: 27px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">1)</div>
            <div style="color: #000000; top: 27px; left: 50px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">matce albo ojcu, jeżeli dziecko wspólnie zamieszkuje i pozostaje na utrzymaniu matki albo ojca, albo</div>
            <div style="color: #000000; top: 41px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">2)</div>
            <div style="color: #000000; top: 41px; left: 50px; width: 825px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">opiekunowi faktycznemu dziecka (tj. osobie faktycznie opiekującej się dzieckiem, jeżeli wystąpiła z wnioskiem do sądu opiekuńczego o przysposobienie dziecka), jeżeli dziecko wspólnie zamieszkuje i pozostaje na utrzymaniu opiekuna faktycznego, albo</div>
            <div style="color: #000000; top: 69px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">3)</div>
            <div style="color: #000000; top: 69px; left: 50px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">opiekunowi prawnemu dziecka, albo</div>
            <div style="color: #000000; top: 83px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">4)</div>
            <div style="color: #000000; top: 83px; left: 50px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">dyrektorowi domu pomocy społecznej.</div>
            <div style="color: #000000; top: 101px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; " class="SofLabel justified11">W przypadku gdy dziecko, zgodnie z orzeczeniem sądu, jest pod opieką naprzemienną obydwojga rodziców rozwiedzionych, żyjących w separacji lub żyjących w rozłączeniu sprawowaną w porównywalnych i powtarzających się okresach, kwotę świadczenia wychowawczego ustala się każdemu z rodziców w wysokości połowy kwoty przysługującego za dany miesiąc świadczenia wychowawczego (art. 5 ust. 2a ustawy). W takim wypadku, do wniosku należy dołączyć orzeczenie sądu potwierdzające sprawowanie opieki naprzemiennej przez rodziców nad dzieckiem/dziećmi.</div>
            <div style="color: #000000; top: 159px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 51px; " class="SofLabel justified11">W przypadku dziecka umieszczonego w domu pomocy społecznej świadczenie wychowawcze przysługuje dyrektorowi domu pomocy społecznej, chyba że inne osoby, o których mowa w art. 4 ust. 2 ustawy, uczestniczą w opiece nad dzieckiem i spełniają warunki uprawniające do otrzymania świadczenia wychowawczego (art. 5a ustawy).</div>
            <div style="color: #000000; top: 190px; left: 10px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 17px; " class="SofLabel justified11">2.</div>
            <div style="color: #000000; top: 190px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 28px; " class="SofLabel justified11">Prawo do świadczenia wychowawczego przysługuje:</div>
            <div style="color: #000000; top: 204px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified11">1)</div>
            <div style="color: #000000; top: 204px; left: 50px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 27px; " class="SofLabel justified11">obywatelom polskim;</div>
            <div style="color: #000000; top: 218px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified11">2)</div>
            <div style="color: #000000; top: 218px; left: 50px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 29px; " class="SofLabel justified11">cudzoziemcom:</div>
            <div style="color: #000000; top: 232px; left: 50px; width: 800px; font-size: 11px; position: absolute; text-align: justify; height: 31px; " class="SofLabel justified11">a)</div>
            <div style="color: #000000; top: 232px; left: 70px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified11">do których stosuje się przepisy o koordynacji systemów zabezpieczenia społecznego,</div>
            <div style="color: #000000; top: 246px; left: 50px; width: 800px; font-size: 11px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified11">b)</div>
            <div style="color: #000000; top: 246px; left: 70px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 20px; " class="SofLabel justified11">jeżeli wynika to z wiążących Rzeczpospolitą Polską dwustronnych umów międzynarodowych o zabezpieczeniu społecznym,</div>
            <div style="color: #000000; top: 260px; left: 50px; width: 800px; font-size: 11px; position: absolute; text-align: justify; height: 22px; " class="SofLabel justified11">c)</div>
            <div style="color: #000000; top: 260px; left: 70px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 58px; " class="SofLabel justified11">przebywającym na terytorium Rzeczypospolitej Polskiej na podstawie zezwolenia na pobyt czasowy udzielonego w związku z okolicznościami, o których mowa w art. 127 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach (Dz. U. z 2018 r. poz. 2094 i 2399 oraz z 2019 r. poz. 577 i 622), jeżeli zamieszkują z dziećmi na terytorium Rzeczypospolitej Polskiej,</div>
            <div style="color: #000000; top: 302px; left: 50px; width: 800px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">d)</div>
            <div style="color: #000000; top: 302px; left: 70px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 91px; " class="SofLabel justified11">posiadającym kartę pobytu z adnotacją „dostęp do rynku pracy”, jeżeli zamieszkują z dziećmi na terytorium Rzeczypospolitej Polskiej, z wyłączeniem obywateli państw trzecich, którzy uzyskali zezwolenie na pracę na terytorium państwa członkowskiego na okres nieprzekraczający sześciu miesięcy, obywateli państw trzecich przyjętych w celu podjęcia studiów lub pracy sezonowej oraz obywateli państw trzecich, którzy mają prawo do wykonywania pracy na podstawie wizy,</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 419px; left: 0px; height: 239px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 50px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">e)</div>
            <div style="color: #000000; top: 0px; left: 70px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">przebywającym na terytorium Rzeczypospolitej Polskiej:</div>
            <div style="color: #000000; top: 14px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 14px; left: 100px; width: 775px; font-size: 11px; position: absolute; text-align: justify; height: 43px; " class="SofLabel justified11">na podstawie zezwolenia na pobyt czasowy, o którym mowa w art. 139a ust. 1 lub art. 139o ust. 1 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach, lub</div>
            <div style="color: #000000; top: 28px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 28px; left: 100px; width: 775px; font-size: 11px; position: absolute; text-align: justify; height: 53px; " class="SofLabel justified11">w związku z korzystaniem z mobilności krótkoterminowej pracownika kadry kierowniczej, specjalisty lub pracownika odbywającego staż w ramach przeniesienia wewnątrz przedsiębiorstwa na warunkach określonych w art. 139n ust. 1 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach</div>
            <div style="color: #000000; top: 56px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 56px; left: 90px; width: 785px; font-size: 11px; position: absolute; text-align: justify; height: 64px; " class="SofLabel justified11">jeżeli zamieszkują z dziećmi na terytorium Rzeczypospolitej Polskiej, z wyłączeniem cudzoziemców, którym zezwolono na pobyt i pracę na okres nieprzekraczający dziewięciu miesięcy, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej,</div>
            <div style="color: #000000; top: 98px; left: 50px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">f)</div>
            <div style="color: #000000; top: 98px; left: 70px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">przebywającym na terytorium Rzeczypospolitej Polskiej:</div>
            <div style="color: #000000; top: 112px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 112px; left: 100px; width: 775px; font-size: 11px; position: absolute; text-align: justify; height: 37px; " class="SofLabel justified11">na podstawie zezwolenia na pobyt czasowy, o którym mowa w art. 151 lub art. 151b ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach,</div>
            <div style="color: #000000; top: 126px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 126px; left: 100px; width: 775px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">na podstawie wizy krajowej w celu prowadzenia badań naukowych lub prac rozwojowych,</div>
            <div style="color: #000000; top: 140px; left: 70px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 140px; left: 100px; width: 775px; font-size: 11px; position: absolute; text-align: justify; height: 35px; " class="SofLabel justified11">w związku z korzystaniem z mobilności krótkoterminowej naukowca na warunkach określonych w art. 156b ust. 1 ustawy z dnia 12 grudnia 2013 r. o cudzoziemcach,</div>
            <div style="color: #000000; top: 168px; left: 50px; width: 20px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 168px; left: 70px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 51px; " class="SofLabel justified11">z wyłączeniem cudzoziemców, którym zezwolono na pobyt na terytorium Rzeczypospolitej Polskiej przez okres nieprzekraczający sześciu miesięcy, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej.</div>
            <div style="color: #000000; top: 196px; left: 50px; width: 825px; font-size: 11px; position: absolute; text-align: justify; height: 61px; " class="SofLabel justified11">Prawo do świadczenia wychowawczego przysługuje ww. osobom, jeżeli zamieszkują na terytorium Rzeczypospolitej Polskiej przez okres, w jakim mają otrzymywać świadczenie wychowawcze, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej.</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 655px; left: 0px; height: 204px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 10px; width: 33px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">3.</div>
            <div style="color: #000000; top: 0px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">Świadczenie wychowawcze przysługuje do dnia ukończenia przez dziecko 18. roku życia (art. 4 ust. 3 ustawy).</div>
            <div style="color: #000000; top: 14px; left: 10px; width: 33px; font-size: 11px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified11">4.</div>
            <div style="color: #000000; top: 14px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">Świadczenie wychowawcze przysługuje w wysokości 500 zł miesięcznie na dziecko (art. 5 ust. 1 ustawy).</div>
            <div style="color: #000000; top: 28px; left: 10px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 26px; " class="SofLabel justified11">5.</div>
            <div style="color: #000000; top: 28px; left: 30px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 26px; " class="SofLabel justified11">Świadczenie wychowawcze nie przysługuje, jeżeli:</div>
            <div style="color: #000000; top: 42px; left: 30px; width: 31px; font-size: 11px; position: absolute; text-align: justify; height: 23px; " class="SofLabel justified11">1)</div>
            <div style="color: #000000; top: 42px; left: 55px; width: 820px; font-size: 11px; position: absolute; text-align: justify; height: 23px; " class="SofLabel justified11">dziecko pozostaje w związku małżeńskim (art. 8 ust. 1 pkt 1 ustawy);</div>
            <div style="color: #000000; top: 56px; left: 30px; width: 31px; font-size: 11px; position: absolute; text-align: justify; height: 24px; " class="SofLabel justified11">2)</div>
            <div style="color: #000000; top: 56px; left: 55px; width: 820px; font-size: 11px; position: absolute; text-align: justify; height: 76px; " class="SofLabel justified11">dziecko zostało umieszczone w instytucji zapewniającej całodobowe utrzymanie, tj. schronisku dla nieletnich, młodzieżowym ośrodku wychowawczym, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, a także szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatnie pełne utrzymanie, albo w pieczy zastępczej (art. &#xa0;8 ust. 1 pkt 2 ustawy);</div>
            <div style="color: #000000; top: 98px; left: 30px; width: 31px; font-size: 11px; position: absolute; text-align: justify; height: 23px; " class="SofLabel justified11">3)</div>
            <div style="color: #000000; top: 98px; left: 55px; width: 820px; font-size: 11px; position: absolute; text-align: justify; height: 23px; " class="SofLabel justified11">pełnoletnie dziecko ma ustalone prawo do świadczenia wychowawczego na własne dziecko (art. 8 ust. 1 pkt 3 ustawy);</div>
            <div style="color: #000000; top: 112px; left: 30px; width: 31px; font-size: 11px; position: absolute; text-align: justify; height: 25px; " class="SofLabel justified11">4)</div>
            <div style="color: #000000; top: 112px; left: 55px; width: 820px; font-size: 11px; position: absolute; text-align: justify; height: 55px; " class="SofLabel justified11">członkowi rodziny, przysługuje za granicą świadczenie wychowawcze lub świadczenie o charakterze podobnym do świadczenia wychowawczego, chyba że przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią inaczej (art. 8 ust. 1 pkt 4 ustawy);</div>
            <div style="color: #000000; top: 154px; left: 10px; width: 870px; font-size: 11px; position: absolute; text-align: justify; height: 21px; " class="SofLabel justified11">6.</div>
            <div style="color: #000000; top: 154px; left: 30px; width: 845px; font-size: 11px; position: absolute; text-align: justify; height: 76px; " class="SofLabel justified11">Przyznanie świadczenia wychowawczego nie wymaga wydania decyzji. Informacja o przyznaniu świadczenia wychowawczego zostanie przekazana na wskazany w niniejszym wniosku adres poczty elektronicznej - o ile został wskazany. Jeżeli adres poczty elektronicznej nie został wskazany, informację o przyznaniu świadczenia wychowawczego możesz odebrać osobiście w organie rozpatrującym wniosek. Nieodebranie informacji o przyznaniu świadczenia wychowawczego nie wstrzymuje wypłaty świadczenia.</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 883px; left: 0px; height: 191px; " class="SofBorderContainer">
            <div style="color: #000000; top: 0px; left: 6px; font-weight: bold; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Bold">2. Oświadczenia dotyczące ustalenia prawa do świadczenia wychowawczego na dziecko</div>
            <div style="color: #000000; top: 24px; left: 6px; width: 864px; font-size: 11px; position: absolute; text-align: justify; " class="SofLabel justified11">Oświadczam, że:</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 38px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 38px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; " class="SofLabel justified11">powyższe dane są prawdziwe,</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 52px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 52px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; " class="SofLabel justified11">zapoznałam/zapoznałem się z warunkami uprawniającymi do świadczenia wychowawczego,</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 66px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 66px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; height: 18px; " class="SofLabel justified11">na dziecko/dzieci, na które ubiegam się o świadczenie&#xa0;&#xa0;wychowawcze, nie jest pobierane w tej lub innej&#xa0;instytucji świadczenie wychowawcze,</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 80px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 80px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; height: 34px; " class="SofLabel justified11">pełnoletnie dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze, nie jest/nie są uprawnione do świadczenia wychowawczego na własne dziecko,</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 94px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 94px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; height: 68px; " class="SofLabel justified11">dziecko/dzieci, na które ubiegam się o świadczenie wychowawcze nie pozostaje/nie pozostają w związku małżeńskim ani nie zostało/nie zostały umieszczone w pieczy zastępczej, instytucji zapewniającej całodobowe utrzymanie, tj. młodzieżowym ośrodku wychowawczym, schronisku dla nieletnich, zakładzie poprawczym, areszcie śledczym, zakładzie karnym, a także szkole wojskowej lub innej szkole, jeżeli instytucje te zapewniają nieodpłatne pełne utrzymanie,</div>
          </div>
          <div style="background-color: #ffffff; width: 880px; position: absolute; top: 1019px; left: 0px; height: 199px; " class="SofBorderContainer">
            <div style="font-size: 11px; position: absolute; color: #000000; top: 0px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 0px; left: 26px; width: 850px; font-size: 11px; position: absolute; text-align: justify; height: 77px; " class="SofLabel justified11">członkowi rodziny nie przysługuje na dziecko świadczenie wychowawcze lub świadczenie o charakterze podobnym do świadczenia wychowawczego za granicą lub przepisy o koordynacji systemów zabezpieczenia społecznego lub dwustronne umowy międzynarodowe o zabezpieczeniu społecznym stanowią, że przysługujące za granicą świadczenie nie wyłącza prawa do takiego świadczenia na podstawie ustawy,</div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 52px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 46px; left: 37px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:NiePrzebywamNiePrzebywa='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="font-size: 11px; position: absolute; color: #000000; top: 88px; left: 6px; text-align: justify; " class="SofLabel justified11">—</div>
            <div style="color: #000000; top: 46px; left: 71px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 54px; " class="SofLabel justified11">nie przebywam ani członek mojej rodziny, w tym współmałżonek lub drugi rodzic dziecka/dzieci, nie przebywa poza granicami Rzeczpospolitej Polskiej (1) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego (2),</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 82px; left: 37px; display: block; width: 25px; font-size: 14px; position: absolute; height: 25px; " class="SofCheckBox justified11">
              <xsl:if test="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:PozaRzeczypospolita/wnio:PrzebywamPrzebywa='true'">
                <span style="text-align: center ; line-height: 25px;  display: block; ">X</span>
              </xsl:if>
            </div>
            <div style="color: #000000; top: 82px; left: 71px; width: 805px; font-size: 11px; position: absolute; text-align: justify; height: 67px; " class="SofLabel justified11">przebywam lub członek mojej rodziny, w tym współmałżonek lub drugi rodzic dziecka/dzieci, przebywa poza granicami Rzeczpospolitej Polskiej (1) w państwie, w którym mają zastosowanie przepisy o koordynacji systemów zabezpieczenia społecznego (2).</div>
            <div style="color: #000000; top: 112px; left: 71px; width: 774px; font-size: 11px; position: absolute; text-align: justify; height: 30px; " class="SofLabel justified11">(w przypadku zaznaczenia wypełnij sekcję DANE CZŁONKÓW TWOJEJ RODZINY PRZEBYWAJĄCYCH ZA GRANICĄ):</div>
            <div style="color: #000000; top: 132px; left: 13px; width: 865px; font-size: 11px; position: absolute; text-align: justify; " class="SofLabel justified11">(1) Nie dotyczy wyjazdu lub pobytu turystycznego, leczniczego lub związanego z podjęciem przez dziecko kształcenia poza granicami Rzeczypospolitej Polskiej.</div>
            <div style="color: #000000; top: 146px; left: 13px; width: 865px; font-size: 11px; position: absolute; text-align: justify; height: 44px; " class="SofLabel justified11">(2) Przepisy o koordynacji systemów zabezpieczenia społecznego mają zastosowanie na terenie: Austrii, Belgii, Chorwacji, Danii, Finlandii, Francji, Grecji, Hiszpanii, Holandii, Irlandii, Luksemburga, Niemiec, Portugalii, Szwecji, Włoch, Wielkiej Brytanii, Cypru, Czech, Estonii, Litwy, Łotwy, Malty, Polski, Słowacji, Słowenii, Węgier, Bułgarii, Rumunii, Norwegii, Islandii, Liechtensteinu, Szwajcarii.</div>
          </div>
        </div>
        <div style="background-color: white; border: 1px solid black; margin-left: auto; overflow: hidden; width: 880px; margin-top: 15px; position: relative; margin-bottom: 15px; height: 1030px; margin-right: auto; text-align: left; ">
          <div style="background-color: #E7E5E6; top: 35px; left: 0px; width: 880px; border-color: #E7E5E6; border-width: 1px; position: absolute; border-style: solid; height: 339px; " class="SofBorderContainer lightGrayAll">
            <div style="font-size: 12px; position: absolute; color: #000000; top: 7px; left: 10px; font-weight: bold; " class="SofLabel sectionHeader">DANE CZŁONKÓW TWOJEJ RODZINY PRZEBYWAJĄCYCH ZA GRANICĄ</div>
            <div style="color: #000000; top: 24px; left: 13px; width: 855px; font-size: 12px; position: absolute; height: 40px; " class="SofLabel">Podaj: imię, nazwisko, numer PESEL, kraj przebywania członka/członków rodziny za granicą, w tym współmałżonka lub drugiego rodzica dziecka/dzieci, wraz z adresem zamieszkania poza granicami RP, okres pobytu, nazwę i adres pracodawcy lub miejsce prowadzenia działalności gospodarczej poza granicami RP:</div>
            <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 71px; left: 13px; display: block; width: 840px; font-size: 18px; position: absolute; height: 258px; " class="SofTextArea dotted">
              <div style="padding-left:5px ; padding-top:2px; display: block;">
                <xsl:call-template name="formatTextArea">
                  <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonkowieRodzinyPrzebywajacyZaGranica/wnio:ImieNazwisko" />
                  <xsl:with-param name="wysokosc" select="258" />
                  <xsl:with-param name="szerokosc" select="840" />
                  <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                  <xsl:with-param name="wysokoscLini" select="20" />
                  <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0" />
                  <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:OswiadczenieTresc/wnio:CzlonkowieRodzinyPrzebywajacyZaGranica/wnio:ImieNazwisko" />
                </xsl:call-template>
              </div>
            </div>
          </div>
          <div style="color: #000000; top: 405px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 38px; " class="SofLabel justified14Bold">W przypadku zmian mających wpływ na prawo do świadczenia wychowawczego, osoba ubiegająca się jest obowiązana niezwłocznie powiadomić o tych zmianach gminny organ właściwy realizujący świadczenie wychowawcze.</div>
          <div style="color: #000000; top: 443px; left: 6px; font-weight: bold; width: 870px; font-size: 14px; position: absolute; text-align: justify; height: 52px; " class="SofLabel justified14Bold">Niepoinformowanie gminnego organu właściwego prowadzącego postępowanie w sprawie świadczenia wychowawczego o zmianach o których mowa powyżej, może skutkować powstaniem nienależnie pobranego świadczenia wychowawczego, a w konsekwencji - koniecznością jego zwrotu wraz z odsetkami ustawowymi za opóźnienie.</div>
          <div style="color: #000000; top: 514px; left: 6px; font-weight: bold; width: 864px; font-size: 14px; position: absolute; text-align: justify; height: 37px; " class="SofLabel justified14Bold">Proszę o wpłatę świadczenia wychowawczego na następujący nr rachunku bankowego / w spółdzielczej kasie oszczędnościowo-kredytowej:</div>
          <div style="width: 833px; font-size: 12px; position: absolute; color: #000000; top: 587px; left: 13px; " class="SofLabel left"></div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 550px; left: 13px; display: block; width: 625px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:RachunekBankowy/wnio:NrRachunkuBankowego" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="625" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 649px; left: 6px; font-weight: normal; width: 864px; font-size: 14px; font-family: arial; position: absolute; height: 18px; " class="SofLabel global14Normal">Do wniosku dołączam następujące dokumenty (oświadczenia są także dokumentami):</div>
          <div style="color: #000000; top: 685px; left: 6px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">1)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 679px; left: 30px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 721px; left: 6px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">2)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 715px; left: 30px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 757px; left: 6px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">3)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 751px; left: 30px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 793px; left: 6px; font-weight: normal; font-size: 14px; font-family: arial; position: absolute; " class="SofLabel global14Normal">4)</div>
          <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 787px; left: 30px; display: block; width: 840px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4" />
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18" />
                <xsl:with-param name="dlugoscPolaWPikselach" select="840" />
              </xsl:call-template>
            </span>
          </div>
          <div style="color: #000000; top: 884px; left: 30px; font-weight: normal; font-size: 14px; font-family: arial; font-style: italic; position: absolute; " class="SofLabel global14Italic">Oświadczam, że jestem świadoma/świadomy odpowiedzialności karnej za złożenie fałszywego oświadczenia.</div>
          <div style="top: 954px; left: 5px; width: 869px; position: absolute; height: 52px; ">
            <div style="background-color: #ffffff; width: 100%; position: absolute; top: 0px; left: 0px; height: 52px; " class="SofBorderContainer">
              <div style="color: #000000; top: 38px; left: 174px; width: 84px; font-size: 12px; position: absolute; height: 14px; " class="SofLabel">(Miejscowość)</div>
              <div style="border: 1px solid black; background-color: white; overflow: hidden; color: #000000; top: 6px; left: 3px; display: block; width: 457px; font-size: 18px; position: absolute; height: 25px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc" />
                </span>
              </div>
              <div style="background-color: white; border: 1px solid black; overflow: hidden; color: #000000; top: 6px; left: 469px; display: block; width: 191px; font-size: 18px; position: absolute; border-style: dotted; height: 25px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data" />
                  </xsl:call-template>
                </span>
                <span />
              </div>
              <div style="color: #000000; top: 38px; left: 455px; width: 190px; font-size: 12px; position: absolute; height: 14px; text-align: center; " class="SofLabel">(Data: dd / mm / rrrr)</div>
              <div style="color: #000000; top: 22px; left: 668px; font-weight: normal; width: 202px; font-size: 14px; font-family: verdana; position: absolute; height: 18px; text-align: center; " class="SofLabel paragraph14Normal"></div>
              <div style="color: #000000; top: 41px; left: 679px; width: 182px; font-size: 12px; position: absolute; height: 59px; text-align: center; " class="SofLabel"></div>
            </div>
          </div>
        </div>
  </xsl:template>
  <xsl:template name="notaPrawnaInnaInstytucjaSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4, składane w postaci elektronicznej za pomocą systemów, o których mowa w ust. 5 pkt 3, podpisane przy użyciu danych obejmujących imię, nazwisko oraz numer PESEL, są równoważne pod względem skutków prawnych dokumentowi opatrzonemu podpisem własnoręcznym.</div>

        </div>
		
  </xsl:template>	
  
  <xsl:template name="notaPrawnaZusSW">
		
		<!-- Treść noty prawnej - Inna instytucja (banki) -->
        <div style="position: relative; margin-right: auto; height: 100px; text-align: justify; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid white; ">

          <div style="position: absolute; color: #000000; width: 870px; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 5px; " class="SofLabel global14Bold">Wniosek i załączniki do wniosku określone w ust. 4 składane w postaci elektronicznej za pomocą systemów teleinformatycznych, o których mowa w ust. 5 pkt 1, 2 i 4, podpisuje się przy użyciu mechanizmów określonych w art. 20a ust. 1 lub 2 ustawy z dnia 17 lutego 2005 r. o informatyzacji działalności podmiotów realizujących zadania publiczne (Dz. U. z 2014 r. poz. 1114).</div>

        </div>
		
  </xsl:template>	  
  
</xsl:stylesheet>