package pl.topteam.empatia_formularze.utils;

import javax.xml.bind.annotation.adapters.XmlAdapter;

import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDateAdapter extends XmlAdapter<String, LocalDate> {
	private static final DateTimeFormatter PARSER;

	static {
		DateTimeFormatter dateElement = ISODateTimeFormat.dateElementParser();
		DateTimeParser offsetElement = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 2).toParser();
		PARSER = new DateTimeFormatterBuilder().append(dateElement).appendOptional(offsetElement).toFormatter();
	}

	public LocalDate unmarshal(String value) {
		return PARSER.parseLocalDate(value);
	}

	public String marshal(LocalDate value) {
		return value.toString();
	}
}
